﻿/**
ショートカット用。

History:
	1.020:
		package変更。

	1.00β13:
		moduleをlink -> shortcutに変更。
*/
module nemuxi.negui.file.com.shortcut;

debug import std.stdio: wl = writefln, pl = printf;
debug(shortcut) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.negui.file.file;
import nemuxi.negui.file.find;
import nemuxi.negui.system.base;
import nemuxi.negui.com.com;
import nemuxi.negui.com.ishelllink;
public import nemuxi.negui.com.ipersistfile;
import nemuxi.negui.window.window;
import nemuxi.negui.input.keyboard.keyboard;
import nemuxi.negui.system.type.basic;
import nemuxi.negui.system.type.enumerated;

///
class ShortcutException: ComException {
	mixin MixInNeGuiException;
}


/**
History:
	1.00β13:
		新規作成。
*/
class Shortcut: Com!(IShellLink), IComPersistFile {
	size_t filePathLength = PATH.MAX_PATH;
	size_t optionLength   = INFOTIPSIZE;
	size_t commnetLength  = INFOTIPSIZE;
	
	protected {
		Com!(IPersistFile) PersistFile;
		Window Owner;
	}
	protected override void Kill() {
		delete PersistFile;

		super.Kill();
	}
	this(Window Owner) {
		this.Owner = Owner;
		super(CLSID_ShellLink, IID_IShellLink, null, COM_CONTEXT.INPROC_SERVER, true);
		PersistFile = query!(IPersistFile)(IID_IPersistFile);
	}

	// *.lnk, 実ファイル処理 -----------------
	override {
		bool fileLoad(in Text FilePath, STGM Stgm) {
			if(SUCCEEDED(PersistFile.Load(FilePath.ptr, Stgm))) {
				return Known.Resolve(Owner ? Owner(): GetDesktopWindow(), SLR.ANY_MATCH | SLR.UPDATE) == NOERROR;
			}
			
			return false;
		}
		bool fileSave(in Text FilePath, bool Remember) {
			return PersistFile.Save(FilePath.length ? FilePath.ptr: null, Remember) == S_OK;
		}
		
		//--------------------------------
		bool isDirty() {
			return cast(bool)PersistFile.IsDirty();
		}
	}
	// ---------------------------------------

	/// こいつにポインタを指定してやればなんか入るかも。
	FILEITEM* FileItem;

	/**
	History:
		1.070:
			[P] 読み込み失敗時にassertでは無くException。
	*/
	Text address() {
		auto text=new wchar[filePathLength];
		
		HRESULT Result;
		
		Result = Known.GetPath(text.ptr, text.length, FileItem ? FileItem.ptr: null, SLGP.RAWPATH);
		
		class ShortcutGetPathException: ShortcutException {
			mixin MixInNeGuiException;
		}
		enforce(Result == NOERROR, new ShortcutGetPathException(Text("GetPath == %s", Result)));

		return Text(text.ptr);
	}
	bool address(in Text text)
	in {
		assert(text.length);
	}
	body {
		return Known.SetPath(text.ptr) == NOERROR;
	}

	Text workFolder() {
		auto text=new wchar[filePathLength];

		enforce(
			Known.GetWorkingDirectory(text.ptr, text.length) == S_OK,
			new ShortcutException(ERR.toText)
		);

		return Text(text.ptr);
	}
	bool workFolder(in Text text) {
		return Known.SetWorkingDirectory(text.ptr) == NOERROR;
	}

	Text option() {
		auto text=new wchar[optionLength];

		enforce(
			Known.GetArguments(text.ptr, text.length) == S_OK,
			new ShortcutException(ERR.toText)
		);

		return Text(text.ptr);
	}
	bool option(in Text text) {
		return Known.SetArguments(text.ptr) == S_OK;
	}

	Text getIcon(out int IconIndex) {
		auto text=new wchar[filePathLength];
		
		enforce(
			Known.GetIconLocation(text.ptr, text.length, &IconIndex) == NOERROR,
			new ShortcutException(ERR.toText)
		);

		return Text(text.ptr);
	}

	bool setIcon(in Text text, int IconIndex) {
		return Known.SetIconLocation(text.ptr, IconIndex) == NOERROR;
	}
	
	Text comment() {
		auto text=new wchar[commnetLength];
		
		enforce(Known.GetDescription(text.ptr, text.length) == NOERROR, "aaa");
		
		return Text(text.ptr);
	}
	bool comment(Text text) {
		return Known.SetDescription(text.ptr) == NOERROR;
	}

	HOTKEYVALUE hotKey() {

		WORD KeyInfo;
		enforce(
			Known.GetHotkey(&KeyInfo) == NOERROR,
			new ShortcutException(ERR.toText)
		);

		HOTKEYVALUE HotKeyValue;
		
		HotKeyValue.Key = cast(KEY)LOBYTE(KeyInfo);
		HotKeyValue.Mod = cast(HOTKEY)HIBYTE(KeyInfo);

		return HotKeyValue;
	}

	bool hotKey(HOTKEYVALUE HotKeyValue) {
		return Known.SetHotkey(MAKEWORD(HotKeyValue.Key, HotKeyValue.Mod)) == NOERROR;
	}

	SHOW show() {
		int Show;

		enforce(
			Known.GetShowCmd(&Show) == NOERROR,
			new ShortcutException(ERR.toText)
		);

		return cast(SHOW)Show;
	}
	bool show(SHOW Show) {
		return Known.SetShowCmd(Show) == NOERROR;
	}
}







