﻿/**
やっつけ！
*/
module nemuxi.negui.event.hook;

debug import std.stdio: wl = writefln, pl = printf;

debug(hook) void main() {}

import win32.windows;

//import nemuxi.base;
import nemuxi.negui.system.base;
import nemuxi.negui.system.controller;

class Hook: Raii, IController, IHandle {
	protected HHOOK hHook;
	mixin KillResource!("フック", hHook, UnhookWindowsHookEx, 0);

	static enum TYPE {
		MIN             = WH_MIN,
		MSGFILTER       = WH_MSGFILTER,
		JOURNALRECORD   = WH_JOURNALRECORD,
		JOURNALPLAYBACK = WH_JOURNALPLAYBACK,
		KEYBOARD        = WH_KEYBOARD,
		GETMESSAGE      = WH_GETMESSAGE,
		CALLWNDPROC     = WH_CALLWNDPROC,
		CBT             = WH_CBT,
		SYSMSGFILTER    = WH_SYSMSGFILTER,
		MOUSE           = WH_MOUSE,
		HARDWARE        = WH_HARDWARE,
		DEBUG           = WH_DEBUG,
		SHELL           = WH_SHELL,
		FOREGROUNDIDLE  = WH_FOREGROUNDIDLE,
		CALLWNDPROCRET  = WH_CALLWNDPROCRET,
		KEYBOARD_LL     = WH_KEYBOARD_LL,
		MOUSE_LL        = WH_MOUSE_LL,
		MAX             = WH_MAX,
		MINHOOK         = WH_MINHOOK,
		MAXHOOK         = WH_MAXHOOK,
	}
	protected {
		TYPE Type;
		HOOKPROC HookProc;
		HMODULE hModule;
		DWORD ThreadID;
	}
	this(TYPE Type, HOOKPROC HookProc, HMODULE hModule=null, DWORD ThreadID=0) {
		this.Type     = Type;
		this.HookProc = HookProc;
		this.hModule  = hModule;
		this.ThreadID = ThreadID;

		super(true);
	}

	override bool start() {
		hHook = SetWindowsHookEx(
			Type,
			HookProc,
			hModule,
			ThreadID
		);
		return cast(bool)hHook;
	}
	override bool stop() {
		return kill();
	}
	override const bool isRunning() {
		return cast(bool)hHook;
	}

	/**
	Note:
		win32.winuserでtypedef HANDLE HHOOKされてるけどいいんだろうか。
	*/
	override const HANDLE opCall() {
		return hHook;
	}

	static enum CODE {
		ACTION      = HC_ACTION,
		GETNEXT     = HC_GETNEXT,
		SKIP        = HC_SKIP,
		NOREMOVE    = HC_NOREMOVE,
		NOREM       = HC_NOREM,
		SYSMODALON  = HC_SYSMODALON,
		SYSMODALOFF = HC_SYSMODALOFF,
	}
	LRESULT callNext(CODE Code, WPARAM wParam, LPARAM lParam) {
		return CallNextHookEx(hHook, Code, wParam, lParam);
	}
	
}

