﻿/**
イベントを模したもの。

基本的な定数や構造体のみ。
コントロール特有なものなんかはそのコントロールのmoduleで補完。
*/
module nemuxi.negui.event.event;

debug import std.stdio: wl = writefln, pl = printf;
debug(event) void main() {}

import std.bitmanip;
import std.string;
import std.contracts;

import win32.winuser;
import win32.core;
import win32.shellapi;
import win32.commctrl;

//public import nemuxi.negui.system.type;
public import nemuxi.negui.system.base;
public import nemuxi.negui.layout.layout;
public import nemuxi.negui.draw.canvas;
public import nemuxi.negui.draw.icon;
public import nemuxi.negui.draw.font;
//public import nemuxi.image.icon;
public import nemuxi.negui.event.dropfile;
public import nemuxi.negui.input.keyboard.keyboard;
public import nemuxi.negui.system.type.basic;
public import nemuxi.negui.system.type.enumerated;
public import nemuxi.negui.system.type.record;
public import nemuxi.negui.negui;
public import nemuxi.negui.event.subclass;
public import nemuxi.negui.window.menu.menu;
public import nemuxi.negui.layout.panel.panel;
public import nemuxi.negui.system.meta.basic;


private {
	immutable _NEGUIOBJECT = q{NeGuiObject};
	immutable _HWND        = q{hWnd};
	immutable _MESSAGE     = q{Message};
	immutable _WPARAM      = q{wParam};
	immutable _LPALAM      = q{lParam};
}

/**
History:
	1.00β12:
		OnNonClientMouseXXX追加。
*/
template MixInNeGuiEvent() {
	// いっくよー！
	protected {
		bool HoverFlag;
		
		NEGUIPOINT ClickPos;
		NEGUIPOINT NonClientClickPos;
	}
	protected {
		/// NeWindow作成時
		void OnCreate() {}
		/// OnCreat終了時
		void OnCreated() {}
		/**
		サイズ変更時。パネルのおかげで出番が少なくなりました。

		Return:
			処理した場合はtrue、処理をWindowsに引き継ぐ場合はfalseを返す。

		History:
			1.00β17:
				[P] 処理判定の追加。
		*/
		bool OnSize(SIZE_TYPE, int Width, int Height) { return false;}
		
		//void OnSizing(SIDEFLAG Sides, RECT* Rect) {}
		void OnSizing(SIDEFLAG Sides, ref RECT Rect) {}
		void OnMoving(SIDEFLAG Sides, ref RECT Rect) {}
		void OnWindowPosChanging(WINDOWPOS* WindowPos) {}
		//void OnWindowPosChanged(WINDOWPOS* WindowPos) {}
		void OnWindowPosChanged(ref WINDOWPOS WindowPos) {}
		bool OnMinMax(POINT* MaxSize, POINT* MaxPos, POINT* MaxTrack, POINT* MinTrack) { return false;}
		void OnEnterSizeMove() {}
		void OnExitSizeMove() {}
		/**
		History:
			1.00β17:
				新規作成。
		*/
		void OnShowWindow(bool Show, SHOW_FLAG Flag) {}

		/// 終了時の確認。trueで終了。
		bool OnClose() {
			return true;
		}
		/**
		常にsuper.OnDestroyを最後に呼ぶべし。
	
		History:
			1.00β19:
				[P] Logger削除。
		*/
		void OnDestroy() {}
		void OnMeasureItem(MEASUREITEM* Measure) {}
		/**
		History:
			1.00β17:
				[P] あんまし意味無いけど引数追加。
		*/
		void OnDrawItem(ITEM_ID Id, DRAWITEM* DrawItem) {}
		void OnActive(WINDOW_ACTIVE Active, bool NotSmall, HWND NextWnd) {}
		void OnActiveOther(in bool Active, in HANDLE OtherHandle) {}

		/**
		History:
			1.00β20:
				[P] 引数変更。
		*/
		bool OnInitMenu(Menu menu) { return false;}
		/**
		History:
			1.00β20:
				[S] Idの型をITEM_IDからsize_tに変更。
				[S] Idの名前をPositionに変更。
		*/
		bool OnInitPupUpMenu(size_t Position, bool SystemFlag, Menu menu) { return false;}
		/**
		History:
			1.00β20:
				[P] 引数変更。
		*/
		void OnMenuSelect(ITEM_ID Id, MENU_FLAG MenuFlag, Menu menu) {}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) { return false;}
		bool OnMenuCommand(COMMAND_ID Id) { return false;};
		bool OnAccelerator(COMMAND_ID Id) { return false;};
		
		void OnContexMenu(NeGui CatchItem, int x, int y) {}
		/**
		History:
			1.070:
				[S] 名前変更。
		*/
		HIT_TEST OnNonClientHitTest(HIT_TEST HitFlag, int x, int y) { return HitFlag;}

		/// 処理した場合はtrue、しなければfalse。(あんまし関係ないけど)
		typedef bool delegate(HIT_TEST HitFlag, int x, int y) NonClientMouseEvent;
		/// マウスが非クライアント領域で左ボタンが押された
		bool OnNonClientMouseLeftDown(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseLeftUp(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseLeftClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseLeftDoubleClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightDown(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightUp(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightDoubleClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleDown(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleUp(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleDoubleClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonDown(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonUp(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonDoubleClick(HIT_TEST HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMove(HIT_TEST HitFlag, int x, int y) { return false;}
		
		void OnEnable(bool Enable) {}
		
		void OnEnterFocus(NeGui LostedGui) {}
		void OnExitFocus(NeGui NewGui) {}

		void OnScroll(DIRECTION Direction, SCROLL Scroll, int Position, NeGui Sender) {}
		
		/// オブジェクト内でマウス移動[WM_MOUSEMOVE]
		void OnMouseMove(MOUSE_KEY Keys, int x, int y) {}
		/// マウスがオブジェクト内に入った。
		void OnMouseOver(MOUSE_KEY Keys, int x, int y) {}
		/// マウスがオブジェクト上に留まった。[WM_MOUSEHOVER]
		void OnMouseHover(MOUSE_KEY Keys, int x, int y) {}
		/// マウスがオブジェクトの外に出た。[WM_MOUSELEAVE]
		void OnMouseLeave(MOUSE_KEY Keys, int x, int y) {}
		///
		typedef bool delegate(MOUSE_KEY Keys, int x, int y) MouseEvent;
		/// 左ボタンが押された。[WM_LBUTTONDOWN]
		bool OnMouseLeftDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 左ボタンが上げられた。[WM_LBUTTONUP]
		bool OnMouseLeftUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 左ボタンがクリックされた。[WM_LBUTTONDOWN + WM_LBUTTONUP]
		bool OnMouseLeftClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 左ボタンがダブルクリック[WM_LBUTTONDBLCLK]
		bool OnMouseLeftDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンが押された。[WM_RBUTTONDOWN]
		bool OnMouseRightDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンが上げられた。[WM_RBUTTONUP]
		bool OnMouseRightUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンがクリックされた。[WM_RBUTTONDOWN + WM_RBUTTONUP]
		bool OnMouseRightClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンがダブルクリック[WM_RBUTTONDBLCLK]
		bool OnMouseRightDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが押された。[WM_MBUTTONDOWN]
		bool OnMouseMiddleDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが上げられた。[WM_MBUTTONUP]
		bool OnMouseMiddleUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールがクリックされた。[WM_MBUTTONDOWN + WM_MBUTTONUP]
		bool OnMouseMiddleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールがダブルクリック[WM_MBUTTONDBLCLK]
		bool OnMouseMiddleDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが下に回された。[WM_MOUSEWHELL]
		bool OnMouseWhellDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが上に回された。[WM_MOUSEWHELL]
		bool OnMouseWhellUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// X
		bool OnMouseOtherButtonDown(MOUSE_KEY Keys, int x, int y) { return false;}
		bool OnMouseOtherButtonUp(MOUSE_KEY Keys, int x, int y) { return false;}
		bool OnMouseOtherButtonClick(MOUSE_KEY Keys, int x, int y) { return false;}
		bool OnMouseOtherButtonDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}

		/**

		Return:
			Windowsに処理させる場合はfalseを返す。
		
		History:
			1.00β17:
				新規作成。
		*/
		bool OnChar(KEY Key, KEYDATA KeyData) {
			return false;
		}
		typedef bool delegate(KEY Key, KEYDATA KeyData) KeyEvent;
		/**
		History:
			1.00β16:
				[@] かるーくドキュメント見てて勘違いだったかもしれないKeyData.keyupをassertから除外。
		*/
		bool OnKeyDown(KEY Key, KEYDATA KeyData)
		in {
			assert(!KeyData.prev);
			//assert(!KeyData.keyup);
		}
		body { return false;}
		bool OnKeyPress(KEY Key, KEYDATA KeyData) { return false;}
		/**
		History:
			1.021:
				[@] バグかどうかも怪しいけど修正しといた。
		*/
		bool OnKeyUp(KEY Key, KEYDATA KeyData)
		in {
			assert(!KeyData.context);
			//assert(KeyData.prev);
			//assert(KeyData.keyup);
		}
		body {return false;}
		
		void OnDropFiles(DropFile drop) {};

		bool OnPaint(Canvas canvas, ref const(RECT) Rect, bool BackReDraw) { return false;}
		bool OnPrint(Canvas canvas, PRF Prf) { return false;}
		typedef bool delegate() OnEraseBackGroundDg;
		OnEraseBackGroundDg OnEraseBackGround(Canvas canvas) { return null;}
		
		void OnTimer(in TIMER_ID Id) {}
		void OnHotKey(HOTKEY_ID Id, HOTKEY HotKey, KEY VKey) {}
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) { return 0;}
		bool OnOtherEvent(UINT Message, WPARAM wParam, LPARAM lParam) {return false;}

		void OnDisplayChange(int Bits, int Horizontal, int Vertical) {}

		void OnChildCreate(NeGui ChildGui) {}
		void OnChildDestroy(NeGui ChildGui) {}
		
		typedef void delegate(NeGui ChildGui, ref const(POINT) Point) ChildEvent;
		void OnChildMouseLeftDown(NeGui ChildGui, ref const(POINT) Point) {}
		void OnChildMouseRightDown(NeGui ChildGui, ref const(POINT) Point) {}
		void OnChildMouseMiddleDown(NeGui ChildGui, ref const(POINT) Point) {}
		void OnChildMouseOtherButtonDown(NeGui ChildGui, ref const(POINT) Point) {}

		/**
		History:
			1.021:
				新規作成。
		*/
		bool OnQueryEndSession(bool TaskList, END_SESSION EndSession) { return true;}
		/**
		History:
			1.021:
				新規作成。
		*/
		void OnEndSession(bool ExitSession, END_SESSION EndSession) {}
	}
	final private void OnChild(WPARAM wParam, LPARAM lParam) {
		switch(LOWORD(wParam)) {
			case WM_CREATE:
				if(auto gui=NeGui.getGuiObject(cast(HWND)lParam)) {
					OnChildCreate(gui);
				}
				break;
			
			case WM_DESTROY:
				OnChildDestroy(NeGui.getGuiObject(cast(HWND)lParam));
				break;

			case WM_LBUTTONDOWN, WM_RBUTTONDOWN, WM_MBUTTONDOWN, WM_XBUTTONDOWN:
				POINT Point;
				Point.x = cast(short)LOWORD(lParam);
				Point.y = cast(short)HIWORD(lParam);

				auto gui=child(Point);
				if(this !is gui) {
					ChildEvent OnChildEvent=void;
					switch(LOWORD(wParam)) {
						case WM_LBUTTONDOWN: OnChildEvent=&OnChildMouseLeftDown;        break;
						case WM_RBUTTONDOWN: OnChildEvent=&OnChildMouseRightDown;       break;
						case WM_MBUTTONDOWN: OnChildEvent=&OnChildMouseMiddleDown;      break;
						case WM_XBUTTONDOWN: OnChildEvent=&OnChildMouseOtherButtonDown; break;
						default:             assert(false);
					}
					OnChildEvent(gui, Point);
				}
				break;
			
			default:
				break;
				//assert(false);
		}
	}
}

static struct TUNE {
	alias void delegate(SIZE_TYPE SizeType, int Width, int Height) OnSize;
}

static struct EVENTLOOP {
static:
	typedef pure nothrow string function(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) EventLoopFunc;

	// 長いなぁ
	private {
		pure nothrow string SingleMethod(T...)(in string MethodName, in string NeGuiObject, in T Params) {
			return NeGuiObject ~ "." ~ MethodName ~ "(" ~ (Params.length ? join(", ", Params): string.init) ~ ")";
		}
		private pure nothrow string SingleMethodReturn(T...)(in string ReturnCode, in string MethodName, in string NeGuiObject, in T Params) {
			return `

			` ~ SingleMethod(MethodName, NeGuiObject, Params) ~ `;
			return ` ~ ReturnCode ~ `;

			`;
		}
		private pure nothrow string SingleMethodGotoDefault(T...)(in string MethodName, in string NeGuiObject, in T Params) {
			return `

			` ~ SingleMethod(MethodName, NeGuiObject, Params) ~ `;
			goto default;

			`;
		}
	}

	pure nothrow string WM_TOP(CastType: NeGui)(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		static if(is(CastType: ISubClass)) {
			return `auto ` ~  NeGuiObject ~ ` = cast(` ~ CastType.stringof ~ `)NeGui.getGuiObject(` ~ hWnd ~ `);`;
		} else {
			return `

			auto ` ~  NeGuiObject ~ `= cast(` ~ CastType.stringof ~ `)NeGui.getGuiObject(` ~ hWnd ~ `);
			if(!` ~  NeGuiObject ~ ` && ` ~ Message ~ ` != WM_CREATE) {
				return DefWindowProc(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);
			}
			
			`;
		}
	}
	deprecated alias WM_TOP ProcTop;
	
	deprecated pure nothrow string SubWM_TOP(CastType: NeGui)(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `auto ` ~  NeGuiObject ~ ` = cast(` ~ CastType.stringof ~ `)NeGui.getGuiObject(` ~ hWnd ~ `);`;
	}
	

	/**
	History:
		1.00β19:
			[P] Logger削除。
	*/
	pure nothrow string WM_CREATE(CastType: NeGui)(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		assert(!` ~ NeGuiObject ~ `);
		try {
			` ~ NeGuiObject ~ ` = cast(` ~ CastType.stringof ~ `)
			cast(void*)(cast(CREATESTRUCT*)` ~ lParam ~ `).lpCreateParams;
			//` ~ NeGuiObject ~ `.hItem = ` ~ hWnd ~ `;
			` ~ NeGuiObject ~ `.hWnd = ` ~ hWnd ~ `;
			` ~ NeGuiObject ~ `.guiObject(` ~ NeGuiObject ~ `);
			` ~ NeGuiObject ~ `.layoutManager=new LayoutManager(` ~ NeGuiObject ~ `);
			` ~ NeGuiObject ~ `.OnCreate();
			` ~ NeGuiObject ~ `.OnCreated();
		} catch(Exception e) {
			//Logger.write(e);
			return -1;
		}
		return 0;
		
		`;
	}
	pure nothrow string WM_SIZE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		if(` ~ NeGuiObject ~ `) {
			auto Width  = LOWORD(` ~ lParam ~ `);
			auto Height = HIWORD(` ~ lParam ~ `);
			if(` ~ NeGuiObject ~ `.layoutManager) {
				` ~ NeGuiObject ~ `.layoutManager.onSize(Width, Height);
			}
			if(` ~ NeGuiObject ~ `.OnSize(cast(SIZE_TYPE)` ~ wParam ~ `, Width, Height)) {
				return 0;
			} else {
				goto default;
			}
		} else {
			goto default;
		}
		
		`;
	}

	pure nothrow string WM_SIZING(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnSizing}, NeGuiObject, q{cast(SIDEFLAG)wParam}, q{*cast(RECT*)lParam});
	}

	pure nothrow string WM_MOVING(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnMoving}, NeGuiObject, q{cast(SIDEFLAG)wParam}, q{*cast(RECT*)lParam});
	}

	pure nothrow string WM_ENTERSIZEMOVE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnEnterSizeMove}, NeGuiObject);
	}
	
	pure nothrow string WM_EXITSIZEMOVE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnExitSizeMove}, NeGuiObject);
	}
	
	pure nothrow string WM_SHOWWINDOW(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnShowWindow}, NeGuiObject, q{cast(bool)wParam}, q{cast(SHOW_FLAG)lParam});
	}
	
	pure nothrow string WM_WINDOWPOSCHANGING(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnWindowPosChanging}, NeGuiObject, q{cast(WINDOWPOS*)lParam});
	}
	pure nothrow string WM_WINDOWPOSCHANGED(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnWindowPosChanged}, NeGuiObject, q{*cast(WINDOWPOS*)lParam});
	}

	pure nothrow string WM_GETMINMAXINFO(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		auto info=cast(MINMAXINFO*)` ~ lParam ~ `;
		if(` ~ NeGuiObject ~ ` && ` ~ NeGuiObject ~ `.OnMinMax(&info.ptMaxSize, &info.ptMaxPosition, &info.ptMaxTrackSize, &info.ptMinTrackSize)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}
	
	pure nothrow string WM_CLOSE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		if(` ~ NeGuiObject ~ `.OnClose()) {
			` ~ NeGuiObject ~ `.destroy;
		}
		return 0;
		
		`;
	}
	
	pure nothrow string WM_DESTROY(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnDestroy}, NeGuiObject);
	}
	pure nothrow string WM_ACTIVATE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnActive}, NeGuiObject, `cast(WINDOW_ACTIVE)LOWORD(` ~ wParam ~ `)`, `cast(bool)HIWORD(` ~ wParam ~ `)`, `cast(HWND)` ~ lParam);
	}
	pure nothrow string WM_ACTIVATEAPP(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnActiveOther}, NeGuiObject, wParam ~ ` == TRUE ? true: false`, `cast(HANDLE)` ~ lParam);
	}

	
	pure nothrow string WM_MEASUREITEM(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("1", q{OnMeasureItem}, NeGuiObject, `cast(MEASUREITEM*)` ~ lParam);
	}
	pure nothrow string WM_DRAWITEM(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("1", q{OnDrawItem}, NeGuiObject, `cast(ITEM_ID)` ~ wParam, `cast(DRAWITEM*)` ~ lParam);
	}
	
	pure nothrow string WM_INITMENU(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		if(` ~ NeGuiObject ~ `.OnInitMenu(GetMenuNeGui(cast(HMENU)` ~ wParam ~ `))) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}

	pure nothrow string WM_INITMENUPOPUP(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		if(` ~ NeGuiObject ~ `.OnInitPupUpMenu(LOWORD(` ~ lParam ~ `), cast(bool)HIWORD(` ~ lParam ~ `), GetMenuNeGui(cast(HMENU)` ~ wParam ~ `))) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}

	pure nothrow string WM_MENUSELECT(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnMenuSelect}, NeGuiObject, `cast(ITEM_ID)LOWORD(` ~ wParam ~ `)`, `cast(MENU_FLAG)HIWORD(` ~ wParam ~ `)`, `GetMenuNeGui(cast(HMENU)` ~ lParam ~ `)`);
	}
	
	pure nothrow string WM_COMMAND(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		auto MessageType=cast(MESSAGETYPE)HIWORD(` ~ wParam ~ `);
		auto Id=LOWORD(` ~ wParam ~ `);
		
		if(auto Sender=NeGui.getGuiObject(cast(HWND)` ~ lParam ~ `)) {
			if(` ~ NeGuiObject ~ `.OnCommand(cast(ITEM_ID)Id, MessageType, Sender)) {
				return 0;
			}
		} else {
			bool delegate(COMMAND_ID) OnEvent;
			switch(cast(MESSAGE_TYPE)MessageType) {
				case MESSAGE_TYPE.MENU:        OnEvent = &` ~ NeGuiObject ~ `.OnMenuCommand; break;
				case MESSAGE_TYPE.ACCELERATOR: OnEvent = &` ~ NeGuiObject ~ `.OnAccelerator; break;
				default: goto _default;
			}
			
			if(OnEvent(cast(COMMAND_ID)Id)) {
				return 0;
			}
			_default:;
		}
		goto default;
		`;
	}
	
	pure nothrow string WM_CONTEXTMENU(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnContexMenu}, NeGuiObject, `NeGui.getGuiObject(cast(HWND)` ~ wParam ~ `)`, `LOWORD(` ~ lParam ~ `)`, `HIWORD(` ~ lParam ~ `)`);
	}
	pure nothrow string WM_NCHITTEST(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `return ` ~ NeGuiObject ~ `.OnNonClientHitTest(cast(HIT_TEST)DefWindowProc(` ~ hWnd ~ `, WM_NCHITTEST, ` ~ wParam ~ `, ` ~ lParam ~ `), LOWORD(` ~ wParam ~ `), HIWORD(` ~ lParam ~ `));`;
	}

	alias WM_NCBUTTONDOWN WM_NCLBUTTONDOWN;
	alias WM_NCBUTTONDOWN WM_NCRBUTTONDOWN;
	alias WM_NCBUTTONDOWN WM_NCMBUTTONDOWN;
	alias WM_NCBUTTONDOWN WM_NCXBUTTONDOWN;
	pure nothrow string WM_NCBUTTONDOWN(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouse=void;
		
		switch(` ~ Message ~ `) {
			case WM_NCLBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftDown;
				break;
			case WM_NCRBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseRightDown;
				break;
			case WM_NCMBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleDown;
				break;
			case WM_NCXBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonDown;
				break;
			default:
				assert(false);
		}
		` ~ NeGuiObject ~ `.NonClientClickPos.lParam = ` ~ lParam ~ `;
		
		if(OnMouse(cast(HIT_TEST)` ~ wParam ~ `, ` ~ NeGuiObject ~ `.NonClientClickPos.x, ` ~ NeGuiObject ~ `.NonClientClickPos.y)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}
	alias WM_NCBUTTONUP WM_NCLBUTTONUP;
	alias WM_NCBUTTONUP WM_NCRBUTTONUP;
	alias WM_NCBUTTONUP WM_NCMBUTTONUP;
	alias WM_NCBUTTONUP WM_NCXBUTTONUP;
	pure nothrow string WM_NCBUTTONUP(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouseClick=void;
		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouseUp=void;

		NEGUIPOINT Pos=void;
		Pos.lParam = ` ~ lParam ~ `;

		switch(` ~ Message ~ `) {
			case WM_NCLBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftUp;
				break;
			case WM_NCRBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseRightClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseRightUp;
				break;
			case WM_NCMBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleUp;
			case WM_NCXBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonUp;
				break;
			default:
				assert(false);
		}
		if(` ~ NeGuiObject ~ `.NonClientClickPos == Pos) {
			OnMouseClick(cast(HIT_TEST)` ~ wParam ~ `, Pos.x, Pos.y);
		}
		if(OnMouseUp(cast(HIT_TEST)` ~ wParam ~ `, Pos.x, Pos.y)) {
			` ~ NeGuiObject ~ `.NonClientClickPos = ` ~ NeGuiObject ~ `.NonClientClickPos.init;
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	alias WM_NCBUTTONDBLCLK WM_NCLBUTTONDBLCLK;
	alias WM_NCBUTTONDBLCLK WM_NCRBUTTONDBLCLK;
	alias WM_NCBUTTONDBLCLK WM_NCMBUTTONDBLCLK;
	alias WM_NCBUTTONDBLCLK WM_NCXBUTTONDBLCLK;
	pure nothrow string WM_NCBUTTONDBLCLK(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouse=void;
	
		switch(` ~ Message ~ `) {
			case WM_NCLBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftDoubleClick;
				break;
			case WM_NCRBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseRightDoubleClick;
				break;
			case WM_NCMBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleDoubleClick;
				break;
			case WM_NCXBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonDoubleClick;
				break;
			default:
				assert(false);
		}
		
		if(OnMouse(cast(HIT_TEST)` ~ wParam ~ `, cast(short)LOWORD(` ~ lParam ~ `), cast(short)HIWORD(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	pure nothrow string WM_NCMOUSEMOVE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("false", q{OnNonClientMouseMove}, NeGuiObject, `cast(HIT_TEST)` ~ wParam, `LOWORD(` ~ lParam ~ `)`, `HIWORD(` ~ lParam ~ `)`);
	}

	
	pure nothrow string WM_ENABLE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnEnable}, NeGuiObject, `cast(bool)` ~ wParam);
	}

	pure nothrow string WM_SETFOCUS(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnEnterFocus}, NeGuiObject, `GetGui(cast(HWND)` ~ wParam ~ `)`);
	}
	pure nothrow string WM_KILLFOCUS(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnExitFocus}, NeGuiObject, `GetGui(cast(HWND)` ~ wParam ~ `)`);
	}

	alias WM_SCROLL WM_VSCROLL;
	alias WM_SCROLL WM_HSCROLL;
	pure nothrow string WM_SCROLL(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {

		return `
		
		immutable Direction= ` ~ Message ~ ` == WM_VSCROLL
			? DIRECTION.VERTICAL
			: DIRECTION.HORIZON
		;

		` ~ NeGuiObject ~ `.OnScroll(Direction, cast(SCROLL)LOWORD(` ~ wParam ~ `), HIWORD(` ~ wParam ~ `), GetGui(cast(HWND)` ~ lParam ~ `));

		return 0;
		
		`;
	}
	

	pure nothrow string WM_MOUSEMOVE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		auto MouseKey = `cast(MOUSE_KEY)` ~ wParam;
		
		return `
		
		POINT Pos;
		Pos.x = cast(short)LOWORD(` ~ lParam ~ `);
		Pos.y = cast(short)HIWORD(` ~ lParam ~ `);
		
		if(!` ~ NeGuiObject ~ `.HoverFlag) {
			TRACKMOUSEEVENT TrackEvent;
			TrackEvent.cbSize      = TrackEvent.sizeof;
			TrackEvent.dwFlags     = TME_LEAVE | TME_HOVER;
			TrackEvent.hwndTrack   = ` ~ hWnd ~ `;
			TrackEvent.dwHoverTime = HOVER_DEFAULT;
			
			if(TrackMouseEvent(&TrackEvent) == 0)
				throw new NeGuiException(Text("WM_MOUSEMOVEイベントでミス"));
			
			` ~ NeGuiObject ~ `.HoverFlag = true;
			` ~ NeGuiObject ~ `.OnMouseOver(` ~ MouseKey ~ `, Pos.x, Pos.y);
		}
		` ~ NeGuiObject ~ `.OnMouseMove(` ~ MouseKey ~ `, Pos.x, Pos.y);
		return 0;
		
		`;
	}
	
	pure nothrow string WM_MOUSELEAVE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return
			  NeGuiObject ~ `.HoverFlag = false;`
			~ SingleMethodReturn("0", q{OnMouseLeave}, NeGuiObject, `cast(MOUSE_KEY)` ~ wParam, `cast(short)LOWORD(` ~ lParam ~ `)`, `cast(short)HIWORD(` ~ lParam ~ `)`);
		
	}
	pure nothrow string WM_MOUSEHOVER(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnMouseLeave}, NeGuiObject, `cast(MOUSE_KEY)` ~ wParam, `cast(short)LOWORD(` ~ lParam ~ `)`, `cast(short)HIWORD(` ~ lParam ~ `)`);
	}

	alias WM_BUTTONDOWN WM_LBUTTONDOWN;
	alias WM_BUTTONDOWN WM_RBUTTONDOWN;
	alias WM_BUTTONDOWN WM_MBUTTONDOWN;
	alias WM_BUTTONDOWN WM_XBUTTONDOWN;
	pure nothrow string WM_BUTTONDOWN(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		SetCapture(` ~ hWnd ~ `); // キャプチャはどのタイミングでやんのか分からん。
		
		` ~ NeGuiObject ~ `.MouseEvent OnMouse=void;
		
		switch(` ~ Message ~ `) {
			case WM_LBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseLeftDown;
				break;
			case WM_RBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseRightDown;
				break;
			case WM_MBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseMiddleDown;
				break;
			case WM_XBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseOtherButtonDown;
				break;
			default:
				assert(false);
		}
		` ~ NeGuiObject ~ `.ClickPos.lParam = ` ~ lParam ~ `;
		
		if(OnMouse(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), ` ~ NeGuiObject ~ `.ClickPos.x, ` ~ NeGuiObject ~ `.ClickPos.y)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}

	alias WM_BUTTONUP WM_LBUTTONUP;
	alias WM_BUTTONUP WM_RBUTTONUP;
	alias WM_BUTTONUP WM_MBUTTONUP;
	alias WM_BUTTONUP WM_XBUTTONUP;
	pure nothrow string WM_BUTTONUP(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		scope(exit) ReleaseCapture();
		
		` ~ NeGuiObject ~ `.MouseEvent OnMouseClick=void;
		` ~ NeGuiObject ~ `.MouseEvent OnMouseUp=void;

		NEGUIPOINT Pos=void;
		Pos.lParam = ` ~ lParam ~ `;

		switch(` ~ Message ~ `) {
			case WM_LBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseLeftClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseLeftUp;
				break;
			case WM_RBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseRightClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseRightUp;
				break;
			case WM_MBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseMiddleClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseMiddleUp;
			case WM_XBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseOtherButtonClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseOtherButtonUp;
				break;
			default:
				assert(false);
		}
		if(` ~ NeGuiObject ~ `.ClickPos == Pos) {
			OnMouseClick(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), Pos.x, Pos.y);
		}
		if(OnMouseUp(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), Pos.x, Pos.y)) {
			` ~ NeGuiObject ~ `.ClickPos = ` ~ NeGuiObject ~ `.ClickPos.init;
			return 0;
		} else {
			goto default;
		}

		`;
	}

	alias WM_BUTTONDBLCLK WM_LBUTTONDBLCLK;
	alias WM_BUTTONDBLCLK WM_RBUTTONDBLCLK;
	alias WM_BUTTONDBLCLK WM_MBUTTONDBLCLK;
	alias WM_BUTTONDBLCLK WM_XBUTTONDBLCLK;
	pure nothrow string WM_BUTTONDBLCLK(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		` ~ NeGuiObject ~ `.MouseEvent OnMouse=void;
	
		switch(` ~ Message ~ `) {
			case WM_LBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseLeftDoubleClick;
				break;
			case WM_RBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseRightDoubleClick;
				break;
			case WM_MBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseMiddleDoubleClick;
				break;
			case WM_XBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseOtherButtonDoubleClick;
				break;
			default:
				assert(false);
		}
		
		if(OnMouse(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), cast(short)LOWORD(` ~ lParam ~ `), cast(short)HIWORD(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_MOUSEWHELL(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		` ~ NeGuiObject ~ `.MouseEvent OnMouse=void;

		if(cast(short)HIWORD(` ~ wParam ~ `) > 0) {
			OnMouse = &` ~ NeGuiObject ~ `.OnMouseWhellUp;
		} else {
			OnMouse = &` ~ NeGuiObject ~ `.OnMouseWhellDown;
		}

		if(OnMouse(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), cast(short)LOWORD(` ~ lParam ~ `), cast(short)HIWORD(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}

	pure nothrow string WM_CHAR(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		if(` ~ NeGuiObject ~ `.OnChar(cast(KEY)` ~ wParam ~ `, KEYDATA(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_KEYDOWN(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
		auto KeyData=KEYDATA(` ~ lParam ~ `);
		` ~ NeGuiObject ~ `.KeyEvent OnKey=void;
		if(KeyData.prev) {
			//` ~ NeGuiObject ~ `.OnKeyPress(cast(KEY)` ~ wParam ~ `, KeyData);
			OnKey = &` ~ NeGuiObject ~ `.OnKeyPress;
		} else {
			//` ~ NeGuiObject ~ `.OnKeyDown(cast(KEY)` ~ wParam ~ `, KeyData);
			OnKey = &` ~ NeGuiObject ~ `.OnKeyDown;
		}
		//return 0;
		
		if(OnKey(cast(KEY)` ~ wParam ~ `, KeyData)) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_KEYUP(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		//return SingleMethodReturn("0", q{OnKeyUp}, NeGuiObject, `cast(KEY)` ~ wParam, `cast(KEYDATA)` ~ lParam);
		return `
		
		if(` ~ NeGuiObject ~ `.OnKeyUp(cast(KEY)` ~ wParam ~ `, KEYDATA(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_DROPFILES(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
		
			scope drop=new DropFile(cast(HDROP)` ~ wParam ~ `, true);
			` ~ NeGuiObject ~ `.OnDropFiles(drop);
		
		`;
	}

	pure nothrow string WM_PAINT(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		PAINTSTRUCT Paint;
		scope canvas=` ~ NeGuiObject ~ `.beguinPaint(Paint);
		scope(exit) ` ~ NeGuiObject ~ `.endPaint(Paint);

		if(` ~ NeGuiObject ~ `.OnPaint(canvas, Paint.rcPaint, Paint.fErase == 1 ? true: false)) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_PRINT(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		scope canvas=new Canvas(cast(HDC)` ~ wParam ~ `, false);

		if(` ~ NeGuiObject ~ `.OnPrint(canvas, cast(PRF)` ~ lParam ~ `)) {
			return 0;
		} else {
			goto default;
		}

		`;
	}

	pure nothrow string WM_ERASEBKGND(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		scope canvas=new Canvas(cast(HDC)` ~ wParam ~ `, false);
		auto dg=` ~ NeGuiObject ~ `.OnEraseBackGround(canvas);
		if(dg) {
			return cast(LRESULT)dg();
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_HOTKEY(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnHotKey}, NeGuiObject, `cast(HOTKEY_ID)` ~ wParam, `cast(HOTKEY)LOWORD(` ~ lParam ~ `)`, `cast(KEY)HIWORD(` ~ lParam ~ `)`);
	}
	pure nothrow string WM_TIMER(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodReturn("0", q{OnTimer}, NeGuiObject, `cast(TIMER_ID)` ~ wParam);
	}

	pure nothrow string WM_NOTIFY(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		if(auto NotifyCode=` ~ NeGuiObject ~ `.OnNotify(cast(ITEM_ID)` ~ wParam ~ `, cast(NOTIFY*)` ~ lParam ~ `)) {
			return NotifyCode;
		} else {
			goto default;
		}

		`;
	}

	pure nothrow string WM_PARENTNOTIFY(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnChild}, NeGuiObject, wParam, lParam);
	}

	pure nothrow string WM_DISPLAYCHANGE(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnDisplayChange}, NeGuiObject, wParam, `LOWORD(` ~ lParam ~ `)`, `HIWORD(` ~ lParam ~ `)`);
	}

	pure nothrow string WM_QUERYENDSESSION(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `
	
		return ` ~ NeGuiObject ~ `.OnQueryEndSession(cast(bool)wParam, cast(END_SESSION)lParam);
		
		`;
	}
	pure nothrow string WM_ENDSESSION(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return SingleMethodGotoDefault(q{OnEndSession}, NeGuiObject, `cast(bool)` ~ wParam, `cast(END_SESSION)` ~ lParam);
	}

	pure nothrow string WM_DEFAULT(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `

		if(` ~ NeGuiObject ~ ` && ` ~ NeGuiObject ~ `.OnOtherEvent(` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `)) {
			return 0;
		} else {
			break;
		}
		
		`;
	}
	deprecated pure nothrow string WM_DEFAULT_SUBCLASS(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		return `return ` ~ NeGuiObject ~ `.Subclass.call(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);`;
	}
	pure nothrow string WM_LAST(T: NeGui)(in string NeGuiObject=_NEGUIOBJECT, in string hWnd=_HWND, in string Message=_MESSAGE, in string wParam=_WPARAM, in string lParam=_LPALAM) {
		static if(is(T: ISubClass)) {
			return `return ` ~ NeGuiObject ~ `.call(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);`;
		} else {
			return `return DefWindowProc(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);`;
		}
	}


}

/**
History:
	1.00β12:
		WM_NCLBUTTONDOWN,   WM_NCRBUTTONDOWN,   WM_NCMBUTTONDOWN,   WM_NCXBUTTONDOWN,
		WM_NCLBUTTONUP,     WM_NCRBUTTONUP,     WM_NCMBUTTONUP,     WM_NCXBUTTONUP,
		WM_NCLBUTTONDBLCLK, WM_NCRBUTTONDBLCLK, WM_NCMBUTTONDBLCLK, WM_NCXBUTTONDBLCLKの追加。
		WM_XBUTTONUP, WM_XBUTTONDOWN, WM_XBUTTONDBLCLKを拾ってなかったのでそれを修正。

*/
template MixInNeGuiEventProc(NEGUI: NeGui) {
	private static extern(Windows) LRESULT NeGuiEventProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.WM_TOP!(NEGUI));
		
		switch(Message) {
			case WM_CREATE: {
				mixin(EVENTLOOP.WM_CREATE!(NEGUI));
			}
			
			case WM_SIZE: {
				mixin(EVENTLOOP.WM_SIZE());
			}
			
			case WM_SIZING: {
				mixin(EVENTLOOP.WM_SIZING());
			}
			case WM_MOVING: {
				mixin(EVENTLOOP.WM_MOVING());
			}
			case WM_ENTERSIZEMOVE: {
				mixin(EVENTLOOP.WM_ENTERSIZEMOVE());
			}
			case WM_EXITSIZEMOVE: {
				mixin(EVENTLOOP.WM_EXITSIZEMOVE());
			}
			case WM_SHOWWINDOW: {
				mixin(EVENTLOOP.WM_SHOWWINDOW());
			}
			case WM_WINDOWPOSCHANGING: {
				mixin(EVENTLOOP.WM_WINDOWPOSCHANGING());
			}
			case WM_WINDOWPOSCHANGED: {
				mixin(EVENTLOOP.WM_WINDOWPOSCHANGED());
			}
			case WM_GETMINMAXINFO: {
				mixin(EVENTLOOP.WM_GETMINMAXINFO());
			}
			case WM_CLOSE: {
				mixin(EVENTLOOP.WM_CLOSE());
			}
			case WM_DESTROY: {
				mixin(EVENTLOOP.WM_DESTROY());
			}
			case WM_ACTIVATE: {
				mixin(EVENTLOOP.WM_ACTIVATE());
			}
			case WM_ACTIVATEAPP: {
				mixin(EVENTLOOP.WM_ACTIVATEAPP());
			}
			case WM_MEASUREITEM: {
				mixin(EVENTLOOP.WM_MEASUREITEM());
			}
			case WM_DRAWITEM: {
				mixin(EVENTLOOP.WM_DRAWITEM());
			}
			case WM_INITMENU: {
				mixin(EVENTLOOP.WM_INITMENU());
			}
			case WM_INITMENUPOPUP: {
				mixin(EVENTLOOP.WM_INITMENUPOPUP());
			}
			case WM_MENUSELECT: {
				mixin(EVENTLOOP.WM_MENUSELECT());
			}
			case WM_COMMAND: {
				mixin(EVENTLOOP.WM_COMMAND());
			}
			case WM_CONTEXTMENU: {
				mixin(EVENTLOOP.WM_CONTEXTMENU());
			}
			case WM_NCHITTEST: {
				mixin(EVENTLOOP.WM_NCHITTEST());
			}
			
			case WM_NCLBUTTONDOWN, WM_NCRBUTTONDOWN, WM_NCMBUTTONDOWN, WM_NCXBUTTONDOWN: {
				mixin(EVENTLOOP.WM_NCBUTTONDOWN());
			}
			case WM_NCLBUTTONUP, WM_NCRBUTTONUP, WM_NCMBUTTONUP, WM_NCXBUTTONUP: {
				mixin(EVENTLOOP.WM_NCBUTTONUP());
			}
			case WM_NCLBUTTONDBLCLK, WM_NCRBUTTONDBLCLK, WM_NCMBUTTONDBLCLK, WM_NCXBUTTONDBLCLK: {
				mixin(EVENTLOOP.WM_NCBUTTONDBLCLK());
			}
			case WM_NCMOUSEMOVE: {
				mixin(EVENTLOOP.WM_NCMOUSEMOVE());
			}

			case WM_ENABLE: {
				mixin(EVENTLOOP.WM_ENABLE());
			}
			
			case WM_SETFOCUS: {
				mixin(EVENTLOOP.WM_SETFOCUS());
			}
			case WM_KILLFOCUS: {
				mixin(EVENTLOOP.WM_KILLFOCUS());
			}
			
			case WM_VSCROLL, WM_HSCROLL: {
				mixin(EVENTLOOP.WM_SCROLL());
			}
			
			case WM_MOUSEMOVE: {
				mixin(EVENTLOOP.WM_MOUSEMOVE());
			}
			case WM_MOUSELEAVE: {
				mixin(EVENTLOOP.WM_MOUSELEAVE());
			}
			case WM_MOUSEHOVER: {
				mixin(EVENTLOOP.WM_MOUSEHOVER());
			}

			case WM_LBUTTONDOWN, WM_RBUTTONDOWN, WM_MBUTTONDOWN, WM_XBUTTONDOWN: {
				mixin(EVENTLOOP.WM_BUTTONDOWN());
			}
			case WM_LBUTTONUP, WM_RBUTTONUP, WM_MBUTTONUP, WM_XBUTTONUP: {
				mixin(EVENTLOOP.WM_BUTTONUP());
			}
			case WM_LBUTTONDBLCLK, WM_RBUTTONDBLCLK, WM_MBUTTONDBLCLK, WM_XBUTTONDBLCLK: {
				mixin(EVENTLOOP.WM_BUTTONDBLCLK());
			}
			case WM_MOUSEWHELL: {
				mixin(EVENTLOOP.WM_MOUSEWHELL());
			}
			case WM_CHAR: {
				mixin(EVENTLOOP.WM_CHAR());
			}
			case WM_KEYDOWN: {
				mixin(EVENTLOOP.WM_KEYDOWN());
			}
			case WM_KEYUP: {
				mixin(EVENTLOOP.WM_KEYDOWN());
			}
			case WM_DROPFILES: {
				mixin(EVENTLOOP.WM_DROPFILES());
			}
			case WM_PAINT: {
				mixin(EVENTLOOP.WM_PAINT());
			}
			case WM_PRINT: {
				mixin(EVENTLOOP.WM_PRINT());
			}
			case WM_ERASEBKGND: {
				mixin(EVENTLOOP.WM_ERASEBKGND());
			}
			
			case WM_HOTKEY: {
				mixin(EVENTLOOP.WM_HOTKEY());
			}
			
			case WM_TIMER: {
				mixin(EVENTLOOP.WM_TIMER());
			}

			case WM_NOTIFY: {
				mixin(EVENTLOOP.WM_NOTIFY());
			}
			
			case WM_DISPLAYCHANGE: {
				mixin(EVENTLOOP.WM_DISPLAYCHANGE());
			}
			
			case WM_PARENTNOTIFY: {
				mixin(EVENTLOOP.WM_PARENTNOTIFY());
			}

			case WM_QUERYENDSESSION: {
				mixin(EVENTLOOP.WM_QUERYENDSESSION());
			}
			case WM_ENDSESSION: {
				mixin(EVENTLOOP.WM_ENDSESSION());
			}
			

			default: {
				mixin(EVENTLOOP.WM_DEFAULT());
			}
		}
		mixin(EVENTLOOP.WM_LAST!(NEGUI)());
	}
}

