﻿/**
どらっぐあんどどろっぷ
*/
module nemuxi.negui.event.dropfile;

debug(dropfile) import std.stdio: wl = writefln, pl = printf;
debug(dropfile) void main() {}

import win32.windows;
import std.contracts;

//import nemuxi.base;
import nemuxi.negui.system.base;

///
class DropFileException: NeGuiException {
	mixin MixInNeGuiException;
}

/**
*/
class DropFile: HandleRaii, IRaii {
	protected alias Handle hDrop;
	
	override protected void Kill() {
		if(hDrop) {
			DragFinish(hDrop);
			hDrop = hDrop.init;
		}
	}

	protected {
		///
		Text[] Addresses;
		///
		POINT  Point;
	}
	///
	immutable bool inClient;
	
	/**
	History:
		1.031:
			[B] 取得座標勘違いしてた。
	*/
	this(HDROP hDrop, bool Suicide) {
		super(hDrop, Suicide);

		//enforce(DragQueryPoint(hDrop, &Point), new DropFileException(Text("座標取得失敗")));
		inClient = cast(bool)DragQueryPoint(hDrop, &Point);

		Addresses = new Text[DragQueryFile(hDrop, -1, null, 0)];
		assert(Addresses.length);
		
		foreach(i, ref Address; Addresses) {
			auto FileAddress = new wchar[DragQueryFile(hDrop, i, null, 0) + 1];
			assert(FileAddress.length);
			enforce(FileAddress.length-1 == DragQueryFile(hDrop, i, FileAddress.ptr, FileAddress.length), new DropFileException(Text("D&Dファイル取得失敗")));
			Address = FileAddress[0..$-1];
		}
	}

	const ref const(POINT) point() {
		return Point;
	}

	///
	const size_t length() {
		return Addresses.length;
	}
	///
	const Text opIndex(size_t Index) {
		return cast(Text)Addresses[Index];
	}
	///
	const Text[] opSlice() {
		return cast(Text[])Addresses[];
	}
	///
	const Text[] opSlice(size_t Start, size_t End) {
		return cast(Text[])Addresses[Start..End];
	}
}

