﻿/**
基本システム情報。

*/
module nemuxi.negui.environ.system;

debug import std.stdio: wl = writefln, pl = printf;
debug(system) void main() {}

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.environ.environ;

alias extern(Windows) int function(int) GetSystemFuncType;

T GetSingle(T)(int Value, GetSystemFuncType Func=&GetSystemMetrics) {
	return cast(T)Func(Value);
}
static pure nothrow string SMixInGetSingel(T)(string Method, string Value, string Func=q{GetSystemMetrics})
in {
	assert(Method.length);
	assert(Value.length);
	assert(Func.length);
}
body {
	return `

	static ` ~ T.stringof ~ ` ` ~ Method ~ `() {
		return GetSingle!(` ~ T.stringof ~ `)(` ~ Value  ~ `, &` ~ Func ~ `);
	}
	
	`;
}

static ref SIZE GetSIZE(int Widht, int Height, GetSystemFuncType Func=&GetSystemMetrics)
in {
	assert(Func);
}
body {
	auto Size=new SIZE;

	Size.cx = Func(Widht);
	Size.cy = Func(Height);

	return *Size;
}
static pure nothrow string SMixInGetSIZE(string Method, string Width, string Height, string Func=q{GetSystemMetrics})
in {
	assert(Method.length);
	assert(Width.length);
	assert(Height.length);
	assert(Func.length);
}
body {
	return `

	static ref SIZE ` ~ Method ~ `() {
		return GetSIZE(` ~ Width  ~ `, ` ~ Height ~ `, &` ~ Func ~ `);
	}
	
	`;
}

struct SYSTEM {
	enum BOOT {
		NORMAL = 0,
		SAFE_MODE = 1,
		SAFE_NETWORK = 2,
	}
	mixin(SMixInGetSingel!(BOOT)("boot", q{SM_CLEANBOOT}));
	
	mixin(SMixInGetSingel!(bool)("mouseConnect",   q{SM_MOUSEPRESENT}));
	mixin(SMixInGetSingel!(size_t)("mouseButtons", q{SM_CMOUSEBUTTONS}));

	mixin(SMixInGetSingel!(bool)("network",  q{SM_NETWORK}));
	mixin(SMixInGetSingel!(bool)("security", q{SM_SECURE}));
	
}

debug(system) unittest {
	wl("%s",  SYSTEM.mouse);
}

struct METRIC {
	
	mixin(SMixInGetSIZE("screen", q{SM_CXSCREEN}, q{SM_CYSCREEN}));
	
	mixin(SMixInGetSIZE("frameDialog", q{SM_CXDLGFRAME},  q{SM_CYDLGFRAME}));
	mixin(SMixInGetSIZE("frameBorder", q{SM_CXBORDER},    q{SM_CYBORDER}));
	mixin(SMixInGetSIZE("frameSize",   q{SM_CXSIZEFRAME}, q{SM_CYSIZEFRAME}));
	mixin(SMixInGetSIZE("frameEdge",   q{SM_CXEDGE},      q{SM_CYEDGE}));
	
	mixin(SMixInGetSIZE("windowMaximized", q{SM_CXMAXIMIZED}, q{SM_CYMAXIMIZED}));
	mixin(SMixInGetSIZE("windowMinimized", q{SM_CXMINIMIZED}, q{SM_CYMINIMIZED}));
	mixin(SMixInGetSIZE("windowMin",       q{SM_CXMIN},       q{SM_CYMIN}));
	mixin(SMixInGetSIZE("windowMaxTrac",   q{SM_CXMAXTRACK},  q{SM_CYMAXTRACK}));
	mixin(SMixInGetSIZE("windowMinTrac",   q{SM_CXMINTRACK},  q{SM_CYMINTRACK}));
}



