﻿/**
OS情報。

Windows専用だけど。
*/
module nemuxi.negui.environ.os;

debug import std.stdio: wl = writefln, pl = printf;
debug(os) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.environ.environ;
import nemuxi.negui.file.dll;

///
class OSException: EnvironException {
	mixin MixInNeGuiException;
}

enum {
	SM_SERVERR2 = 89,
	VER_SUITE_WH_SERVER = 0x00008000,
	
	PRODUCT_UNDEFINED                          = 0x00000000, /// An unknown product
	PRODUCT_ULTIMATE                           = 0x00000001, /// Ultimate Edition
	PRODUCT_HOME_BASIC                         = 0x00000002, /// Home Basic Edition
	PRODUCT_HOME_PREMIUM                       = 0x00000003, /// Home Premium Edition
	PRODUCT_ENTERPRISE                         = 0x00000004, /// Enterprise Edition
	PRODUCT_HOME_BASIC_N                       = 0x00000005, /// Home Basic Edition
	PRODUCT_BUSINESS                           = 0x00000006, /// Business Edition
	PRODUCT_STANDARD_SERVER                    = 0x00000007, /// Server Standard Edition
	PRODUCT_DATACENTER_SERVER                  = 0x00000008, /// Server Datacenter Edition
	PRODUCT_SMALLBUSINESS_SERVER               = 0x00000009, /// Small Business Server
	PRODUCT_ENTERPRISE_SERVER                  = 0x0000000A, /// Server Enterprise Edition
	PRODUCT_STARTER                            = 0x0000000B, /// Starter Edition
	PRODUCT_DATACENTER_SERVER_CORE             = 0x0000000C, /// Server Datacenter Edition (core installation)
	PRODUCT_STANDARD_SERVER_CORE               = 0x0000000D, /// Server Standard Edition (core installation)
	PRODUCT_ENTERPRISE_SERVER_CORE             = 0x0000000E, /// Server Enterprise Edition (core installation)
	PRODUCT_ENTERPRISE_SERVER_IA64             = 0x0000000F, /// Server Enterprise Edition for Itanium-based Systems
	PRODUCT_BUSINESS_N                         = 0x00000010, /// Business Edition
	PRODUCT_WEB_SERVER                         = 0x00000011, /// Web Server Edition
	PRODUCT_CLUSTER_SERVER                     = 0x00000012, /// Cluster Server Edition
	PRODUCT_HOME_SERVER                        = 0x00000013, /// Home Server Edition
	PRODUCT_STORAGE_EXPRESS_SERVER             = 0x00000014, /// Storage Server Express Edition
	PRODUCT_STORAGE_STANDARD_SERVER            = 0x00000015, /// Storage Server Standard Edition
	PRODUCT_STORAGE_WORKGROUP_SERVER           = 0x00000016, /// Storage Server Workgroup Edition
	PRODUCT_STORAGE_ENTERPRISE_SERVER          = 0x00000017, /// Storage Server Enterprise Edition
	PRODUCT_SERVER_FOR_SMALLBUSINESS           = 0x00000018, /// Server for Small Business Edition
	PRODUCT_SMALLBUSINESS_SERVER_PREMIUM       = 0x00000019, /// Small Business Server Premium Edition
	PRODUCT_HOME_PREMIUM_N                     = 0x0000001A, /// Home Premium Edition
	PRODUCT_ENTERPRISE_N                       = 0x0000001B, /// Enterprise Edition
	PRODUCT_ULTIMATE_N                         = 0x0000001C, /// Ultimate Edition
	PRODUCT_WEB_SERVER_CORE                    = 0x0000001D, /// Web Server Edition (core installation)
	PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT   = 0x0000001E, /// Windows Essential Business Server Management Server
	PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY     = 0x0000001F, /// Windows Essential Business Server Security Server
	PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING    = 0x00000020, /// Windows Essential Business Server Messaging Server
	PRODUCT_SMALLBUSINESS_SERVER_PRIME         = 0x00000021, /// Server Foundation
	PRODUCT_HOME_PREMIUM_SERVER                = 0x00000022, /// Home Premium Server Edition?
	PRODUCT_SERVER_FOR_SMALLBUSINESS_V         = 0x00000023, /// Server 2008 without Hyper-V for Windows Essential Server Solutions
	PRODUCT_STANDARD_SERVER_V                  = 0x00000024, /// Server Standard Edition without Hyper-V
	PRODUCT_DATACENTER_SERVER_V                = 0x00000025, /// Server Datacenter Edition without Hyper-V
	PRODUCT_ENTERPRISE_SERVER_V                = 0x00000026, /// Server Enterprise Edition without Hyper-V
	PRODUCT_DATACENTER_SERVER_CORE_V           = 0x00000027, /// Server Datacenter Edition without Hyper-V (core installation)
	PRODUCT_STANDARD_SERVER_CORE_V             = 0x00000028, /// Server Standard Edition without Hyper-V (core installation)
	PRODUCT_ENTERPRISE_SERVER_CORE_V           = 0x00000029, /// Server Enterprise Edition without Hyper-V (core installation)
	PRODUCT_HYPERV                             = 0x0000002A, /// Microsoft Hyper-V Server
	PRODUCT_STORAGE_EXPRESS_SERVER_CORE        = 0x0000002B, /// Storage Server Express Edition (core installation)
	PRODUCT_STORAGE_STANDARD_SERVER_CORE       = 0x0000002C, /// Storage Server Standard Edition (core installation)
	PRODUCT_STORAGE_WORKGROUP_SERVER_CORE      = 0x0000002D, /// Storage Server Workgroup Edition (core installation)
	PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE     = 0x0000002E, /// Storage Server Enterprise Edition (core installation)
	PRODUCT_STARTER_N                          = 0x0000002F, /// Starter Edition
	PRODUCT_PROFESSIONAL                       = 0x00000030, /// Professional Edition
	PRODUCT_PROFESSIONAL_N                     = 0x00000031, /// Professional Edition
	PRODUCT_SB_SOLUTION_SERVER                 = 0x00000032, ///
	PRODUCT_SERVER_FOR_SB_SOLUTIONS            = 0x00000033, ///
	PRODUCT_STANDARD_SERVER_SOLUTIONS          = 0x00000034, ///
	PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE     = 0x00000035, /// (core installation)
	PRODUCT_SB_SOLUTION_SERVER_EM              = 0x00000036, ///
	PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM         = 0x00000037, ///
	PRODUCT_SOLUTION_EMBEDDEDSERVER            = 0x00000038, ///
	PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE       = 0x00000039, /// (core installation)
	PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE  = 0x0000003F, /// (core installation)
	PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT      = 0x0000003B, ///
	PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL      = 0x0000003C, ///
	PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC   = 0x0000003D, ///
	PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC   = 0x0000003E, ///
	PRODUCT_CLUSTER_SERVER_V                   = 0x00000040, /// Cluster Server Edition without Hyper-V
	PRODUCT_EMBEDDED                           = 0x00000041, ///
	PRODUCT_UNLICENSED                         = 0xABCDABCD, ///
}

/**
Note:
	ClassGetSet使わなくてもClassGetだけでいいんじゃないだろうか。
*/
class OS: IInitialize, IText {
	private {
		OSVERSIONINFOEX OSInfo;
	}

	override void initialize() {
		OSInfo.dwOSVersionInfoSize = OSInfo.sizeof;
		enforce(GetVersionEx(cast(OSVERSIONINFO*)&OSInfo), new OSException(ERR.toText));
	}

	mixin(SMixInClassGetSet!(int)("majorVersion", q{OSInfo.dwMajorVersion}, false));
	mixin(SMixInClassGetSet!(int)("minorVersion", q{OSInfo.dwMinorVersion}, false));
	mixin(SMixInClassGetSet!(int)("buildNumber", q{OSInfo.dwBuildNumber}, false));
	mixin(SMixInClassGetSet!(int)("platformId", q{OSInfo.dwPlatformId}, false));
	Text servicePack() {
		return Text(OSInfo.szCSDVersion.ptr);
	}
	mixin(SMixInClassGetSet!(WORD)("servicePackMajor", q{OSInfo.wServicePackMajor}, false));
	mixin(SMixInClassGetSet!(WORD)("servicePackMinor", q{OSInfo.wServicePackMinor}, false));
	enum SUITES: WORD {
		SMALLBUSINESS            = VER_SUITE_SMALLBUSINESS            , /// Microsoft Small Business Serverがインストールされています。または、かつてインストーすれさていましたが、別のバージョンのWindowsにアップグレードされている可能性があります。
		ENTERPRISE               = VER_SUITE_ENTERPRISE               , /// Windows NT 4.0 Enterprise Edition、Windows 2000 Advanced Server、Windows Server 2003 Enterprise Edition、Windows Server 2008 Enterpriseのいずれかがインストールされています。
		BACKOFFICE               = VER_SUITE_BACKOFFICE               , /// Microsoft BackOfficeコンポーネントがインストールされています。
		TERMINAL                 = VER_SUITE_TERMINAL                 , /// ターミナルサービスがインストールされています。VER_SUITE_TERMINALがセットされていて、かつ、VER_SUITE_SINGLEUSERTSがセットされていない場合には、システムはアプリケーションサーバモードで動作しています。
		SMALLBUSINESS_RESTRICTED = VER_SUITE_SMALLBUSINESS_RESTRICTED , /// Microsoft Small Business Serverが制限クライアントライセンスでインストールされています。
		EMBEDDEDNT               = VER_SUITE_EMBEDDEDNT               , /// Windows XP Embeddedがインストールされています。
		DATACENTER               = VER_SUITE_DATACENTER               , /// Windows 2000 Datacenter Server、Windows Server 2003 Datacenter Edition、Windows Server 2008 Datacenterのいずれかがインストールされています。
		SINGLEUSERTS             = VER_SUITE_SINGLEUSERTS             , /// リモートデスクトップがサポートされていますが、1つの対話型セッションのみがサポートされています。この値はシステムがアプリケーションサーバモードで動作していない場合にはセットされません。
		PERSONAL                 = VER_SUITE_PERSONAL                 , /// Windows XP Home Edition、Windows Vista Home Basic、Windows Vista Home Premiumのいずれかがインストールされています。
		BLADE                    = VER_SUITE_BLADE                    , /// Windows Server 2003 Web Editionがインストールされています。
		STORAGE_SERVER           = VER_SUITE_STORAGE_SERVER           , /// Windows Storage Server 2003またはWindows Storage Server 2003 R2がインストールされています。
		COMPUTE_SERVER           = VER_SUITE_COMPUTE_SERVER           , /// Windows Server 2003 Compute Cluster Editionがインストールされています。
		WH_SERVER                = VER_SUITE_WH_SERVER                , /// Windows Home Serverがインストールされています。
	}
	mixin(SMixInClassGetSet!(SUITES)("suites", q{OSInfo.wSuiteMask}, false));

	//wProductType
	enum PRODUCTTYPE: BYTE {
		WORKSTATION       = VER_NT_WORKSTATION,       /// システムはWindows NT 4.0 Workstation、Windows 2000 Professional、Windows XP Home Edition、Windows XP Professional、Windows Vi
		DOMAIN_CONTROLLER = VER_NT_DOMAIN_CONTROLLER, /// システムはドメインコントローラです。
		SERVER            = VER_NT_SERVER,            /// システムはサーバです。ドメインコントローラでもあるサーバは、VER_NT_SERVERではなくVER_NT_DOMAIN_CONTROLLERとして報告されます。
	}
	mixin(SMixInClassGetSet!(PRODUCTTYPE)("productType", q{OSInfo.wProductType}, false));

	/**
	History:
		1.050:
			新規作成。
	*/
	enum PRODUCT {
		UNDEFINED                          = PRODUCT_UNDEFINED                        , /// 
		ULTIMATE                           = PRODUCT_ULTIMATE                         , /// 
		HOME_BASIC                         = PRODUCT_HOME_BASIC                       , /// 
		HOME_PREMIUM                       = PRODUCT_HOME_PREMIUM                     , /// 
		ENTERPRISE                         = PRODUCT_ENTERPRISE                       , /// 
		HOME_BASIC_N                       = PRODUCT_HOME_BASIC_N                     , /// 
		BUSINESS                           = PRODUCT_BUSINESS                         , /// 
		STANDARD_SERVER                    = PRODUCT_STANDARD_SERVER                  , /// 
		DATACENTER_SERVER                  = PRODUCT_DATACENTER_SERVER                , /// 
		SMALLBUSINESS_SERVER               = PRODUCT_SMALLBUSINESS_SERVER             , /// 
		ENTERPRISE_SERVER                  = PRODUCT_ENTERPRISE_SERVER                , /// 
		STARTER                            = PRODUCT_STARTER                          , /// 
		DATACENTER_SERVER_CORE             = PRODUCT_DATACENTER_SERVER_CORE           , /// 
		STANDARD_SERVER_CORE               = PRODUCT_STANDARD_SERVER_CORE             , /// 
		ENTERPRISE_SERVER_CORE             = PRODUCT_ENTERPRISE_SERVER_CORE           , /// 
		ENTERPRISE_SERVER_IA64             = PRODUCT_ENTERPRISE_SERVER_IA64           , /// 
		BUSINESS_N                         = PRODUCT_BUSINESS_N                       , /// 
		WEB_SERVER                         = PRODUCT_WEB_SERVER                       , /// 
		CLUSTER_SERVER                     = PRODUCT_CLUSTER_SERVER                   , /// 
		HOME_SERVER                        = PRODUCT_HOME_SERVER                      , /// 
		STORAGE_EXPRESS_SERVER             = PRODUCT_STORAGE_EXPRESS_SERVER           , /// 
		STORAGE_STANDARD_SERVER            = PRODUCT_STORAGE_STANDARD_SERVER          , /// 
		STORAGE_WORKGROUP_SERVER           = PRODUCT_STORAGE_WORKGROUP_SERVER         , /// 
		STORAGE_ENTERPRISE_SERVER          = PRODUCT_STORAGE_ENTERPRISE_SERVER        , /// 
		SERVER_FOR_SMALLBUSINESS           = PRODUCT_SERVER_FOR_SMALLBUSINESS         , /// 
		SMALLBUSINESS_SERVER_PREMIUM       = PRODUCT_SMALLBUSINESS_SERVER_PREMIUM     , /// 
		HOME_PREMIUM_N                     = PRODUCT_HOME_PREMIUM_N                   , /// 
		ENTERPRISE_N                       = PRODUCT_ENTERPRISE_N                     , /// 
		ULTIMATE_N                         = PRODUCT_ULTIMATE_N                       , /// 
		WEB_SERVER_CORE                    = PRODUCT_WEB_SERVER_CORE                  , /// 
		MEDIUMBUSINESS_SERVER_MANAGEMENT   = PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT , /// 
		MEDIUMBUSINESS_SERVER_SECURITY     = PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY   , /// 
		MEDIUMBUSINESS_SERVER_MESSAGING    = PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING  , /// 
		SMALLBUSINESS_SERVER_PRIME         = PRODUCT_SMALLBUSINESS_SERVER_PRIME       , /// 
		HOME_PREMIUM_SERVER                = PRODUCT_HOME_PREMIUM_SERVER              , /// 
		SERVER_FOR_SMALLBUSINESS_V         = PRODUCT_SERVER_FOR_SMALLBUSINESS_V       , /// 
		STANDARD_SERVER_V                  = PRODUCT_STANDARD_SERVER_V                , /// 
		DATACENTER_SERVER_V                = PRODUCT_DATACENTER_SERVER_V              , /// 
		ENTERPRISE_SERVER_V                = PRODUCT_ENTERPRISE_SERVER_V              , /// 
		DATACENTER_SERVER_CORE_V           = PRODUCT_DATACENTER_SERVER_CORE_V         , /// 
		STANDARD_SERVER_CORE_V             = PRODUCT_STANDARD_SERVER_CORE_V           , /// 
		ENTERPRISE_SERVER_CORE_V           = PRODUCT_ENTERPRISE_SERVER_CORE_V         , /// 
		HYPERV                             = PRODUCT_HYPERV                           , /// 
		STORAGE_EXPRESS_SERVER_CORE        = PRODUCT_STORAGE_EXPRESS_SERVER_CORE      , /// 
		STORAGE_STANDARD_SERVER_CORE       = PRODUCT_STORAGE_STANDARD_SERVER_CORE     , /// 
		STORAGE_WORKGROUP_SERVER_CORE      = PRODUCT_STORAGE_WORKGROUP_SERVER_CORE    , /// 
		STORAGE_ENTERPRISE_SERVER_CORE     = PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE   , /// 
		STARTER_N                          = PRODUCT_STARTER_N                        , /// 
		PROFESSIONAL                       = PRODUCT_PROFESSIONAL                     , /// 
		PROFESSIONAL_N                     = PRODUCT_PROFESSIONAL_N                   , /// 
		SB_SOLUTION_SERVER                 = PRODUCT_SB_SOLUTION_SERVER               , /// 
		SERVER_FOR_SB_SOLUTIONS            = PRODUCT_SERVER_FOR_SB_SOLUTIONS          , /// 
		STANDARD_SERVER_SOLUTIONS          = PRODUCT_STANDARD_SERVER_SOLUTIONS        , /// 
		STANDARD_SERVER_SOLUTIONS_CORE     = PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE   , /// 
		SB_SOLUTION_SERVER_EM              = PRODUCT_SB_SOLUTION_SERVER_EM            , /// 
		SERVER_FOR_SB_SOLUTIONS_EM         = PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM       , /// 
		SOLUTION_EMBEDDEDSERVER            = PRODUCT_SOLUTION_EMBEDDEDSERVER          , /// 
		SOLUTION_EMBEDDEDSERVER_CORE       = PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE     , /// 
		SMALLBUSINESS_SERVER_PREMIUM_CORE  = PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE, /// 
		ESSENTIALBUSINESS_SERVER_MGMT      = PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT    , /// 
		ESSENTIALBUSINESS_SERVER_ADDL      = PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL    , /// 
		ESSENTIALBUSINESS_SERVER_MGMTSVC   = PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC , /// 
		ESSENTIALBUSINESS_SERVER_ADDLSVC   = PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC , /// 
		CLUSTER_SERVER_V                   = PRODUCT_CLUSTER_SERVER_V                 , /// 
		EMBEDDED                           = PRODUCT_EMBEDDED                         , /// 
		UNLICENSED                         = PRODUCT_UNLICENSED                       , /// 
	}
	/**
	History:
		1.050:
			新規作成。
	*/
	const PRODUCT productInfo(DWORD MajorVersion=majorVersion, DWORD MinorVersion=minorVersion) {
		typedef extern(Windows) BOOL function( DWORD dwOSMajorVersion, DWORD dwOSMinorVersion, DWORD dwSpMajorVersion, DWORD dwSpMinorVersion, PDWORD pdwReturnedProductType ) GetProductInfoType;
		scope kernel=new DLL(Text("kernel32"));
		if(auto GetProductInfo = kernel.address!(GetProductInfoType)(Text("GetProductInfo"))) {
			///
			class OSProductInfoException: EnvironException {
				mixin MixInNeGuiException;
			}
			
			PRODUCT ProductType;
			enforce(GetProductInfo(majorVersion, minorVersion, 0, 0, cast(PDWORD)&ProductType), new OSProductInfoException(ERR.toText()));
			return ProductType;
		}
		return PRODUCT.UNDEFINED;
	}
	/+
	GetProductInfo
	+/

	/**
	何でもいいからだれかmoduleくれ。

	See_Also:
		MSDN Library., http://msdn.microsoft.com/en-us/library/ms724429%28VS.85%29.aspx
	History:
		1.050:
			[F] 2K,XP,2003のエディションの取得。
	*/
	override const Text toText() {
		immutable Major=majorVersion;
		immutable Minor=minorVersion;
		
		const Version=Text("%s.%s", Major, Minor);

		assert(Major >= 5, "2000以上のみってことで。むしろ2000も弾きたい");
		string Name, Edition;
		switch(Major) {
			case 5: // 2k, XP, 2003, 2003 R2
				switch(Minor) {
					case 0: // 2000
						Name = "2000";
						if((suites & SUITES.DATACENTER) == SUITES.DATACENTER) {
							Edition = "Datacenter Server";
						} else if ((suites & SUITES.ENTERPRISE) == SUITES.ENTERPRISE) {
							Edition = "Advanced Server";
						} else {
							Edition = "Server";
						}
						break;
					case 1: // XP
						Name = "XP";
						if((suites & SUITES.PERSONAL) == SUITES.PERSONAL) {
							Edition = "Home Edition";
						} else {
							Edition = "Professional";
						}
						break;
					case 2: // 2003, 2003 R2
						Name = "2003";
						if(GetSystemMetrics(SM_SERVERR2)) {
							Name ~= " R2";
						}
						if((suites & SUITES.DATACENTER) == SUITES.DATACENTER) {
							Edition = " Datacenter Edition";
						} else if((suites & SUITES.ENTERPRISE) == SUITES.ENTERPRISE) {
							Edition = " Enterprise Edition";
						} else if((suites & SUITES.BLADE) == SUITES.BLADE) {
							Edition = " Web Edition";
						} else {
							Edition = " Standard Edition";
						}
						break;
					default:
						Name = "?-1";
				}
				break;
			
			case 6: // Vista ,Server 2008, Server 2008 R2, 7
				switch(Minor) {
					case 0: // Vista, Server 2008
						if(productType == PRODUCTTYPE.WORKSTATION) {
							Name = "Vista";
						} else {
							Name = "Server 2008";
						}
						break;
					case 1: // Server 2008 R2, 7
						if(productType == PRODUCTTYPE.WORKSTATION) {
							Name = "7";
						} else {
							Name = "Server 2008 R2";
						}
						break;
					default:
						Name = "?-2";
				}
				// 共通でエディション取得。
				switch(productInfo(majorVersion, minorVersion)) {
					case PRODUCT.ULTIMATE:
						Edition = "Ultimate Edition";
						break;
					case PRODUCT.HOME_PREMIUM:
						Edition = "Home Premium Edition";
						break;
					case PRODUCT.HOME_BASIC:
						Edition = "Home Basic Edition";
						break;
					case PRODUCT.ENTERPRISE:
						Edition = "Enterprise Edition";
						break;
					case PRODUCT.BUSINESS:
						Edition = "Business Edition";
						break;
					case PRODUCT.STARTER:
						Edition = "Starter Edition";
						break;
					case PRODUCT.CLUSTER_SERVER:
						Edition = "Cluster Server Edition";
						break;
					case PRODUCT.DATACENTER_SERVER:
						Edition = "Datacenter Edition";
						break;
					case PRODUCT.DATACENTER_SERVER_CORE:
						Edition = "Datacenter Edition (core installation)";
						break;
					case PRODUCT.ENTERPRISE_SERVER:
						Edition = "Enterprise Edition";
						break;
					case PRODUCT.ENTERPRISE_SERVER_CORE:
						Edition = "Enterprise Edition (core installation)";
						break;
					case PRODUCT.ENTERPRISE_SERVER_IA64:
						Edition = "Enterprise Edition for Itanium-based Systems";
						break;
					case PRODUCT.SMALLBUSINESS_SERVER:
						Edition = "Small Business Server";
						break;
					case PRODUCT.SMALLBUSINESS_SERVER_PREMIUM:
						Edition = "Small Business Server Premium Edition";
						break;
					case PRODUCT.STANDARD_SERVER:
						Edition = "Standard Edition";
						break;
					case PRODUCT.STANDARD_SERVER_CORE:
						Edition = "Standard Edition (core installation)";
						break;
					case PRODUCT.WEB_SERVER:
						Edition = "Web Server Edition";
						break;
					default:
						break;
				}
				break;
			
			default: // 未来
				Name = "?-3";
		}

		//サービスパック
		Text ServicePack;
		if(servicePackMajor) {
			ServicePack = Text("%s.%s", servicePackMajor, servicePackMinor);
		} else {
			ServicePack = "none";
		}

		// エディションがあればOS名と合体。
		if(Edition.length) {
			Name ~= " " ~ Edition;
		}

		return Text(
			InfoTextLine("Windows", Name),
			Text.newline,
			InfoTextLine("Version", Version),
			Text.newline,
			InfoTextLine("ServicePack", ServicePack),
			Text.newline,
			InfoTextLine("BuildNumber", buildNumber),
			Text.newline,
			Text("Suites: %08X", suites),
			Text.newline,
			InfoTextLine("ProductType", productType)
		);
	}

	override string toString() {
		return toText.text8;
	}
}
debug(os) unittest {
	auto o=new OS;
	o.initialize;
	wl(o.toText.toString);
}

