﻿/**

*/
module nemuxi.negui.environ.name;

debug import std.stdio: wl = writefln, pl = printf;
debug(name) void main() {}

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.environ.environ;

///
class NameException: EnvironException {
	mixin MixInNeGuiException;
}


private alias extern(Windows) BOOL function(LPWSTR, PDWORD) FuncType;
Text GetName(FuncType GetNameFunc, invariant size_t Length, lazy NameException ex) {
	DWORD len=Length;
	auto name=new wchar[len];
	
	if(!GetNameFunc(name.ptr, &len)) {
		throw ex;
	}

	return Text(name.ptr);
}

/**
ユーザー名取得。

-------------------------------------------------------------------------------
assert(UserName() == EnvToPlain(Text("%USERNAME%")));
-------------------------------------------------------------------------------

Return:
	取得したユーザー名。

Exception:
	取得失敗時にNameExceptionを投げる。
*/
Text UserName() {
	invariant UNLEN = 256;

	return GetName(
		cast(FuncType)&GetUserName,
		UNLEN,
		new NameException(Text("UserName:GetUserName"))
	);
}

/**
コンピューター名取得。

-------------------------------------------------------------------------------
assert(ComputerName() == EnvToPlain(Text("%USERDOMAIN%")));
-------------------------------------------------------------------------------

Return:
	取得したコンピューター名。

Exception:
	取得失敗時にNameExceptionを投げる。
*/
Text ComputerName() {
	invariant MAX_COMPUTERNAME_LENGTH = 256;
	
	return GetName(
		cast(FuncType)&GetComputerName,
		MAX_COMPUTERNAME_LENGTH,
		new NameException(Text("ComputerName:GetComputerName"))
	);
}


