﻿/**
モニタ。

History:
	1.061:
		[S] package変更。
*/
module nemuxi.negui.environ.monitor;

debug import std.stdio: wl = writefln, pl = printf;

debug(monitor) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.window.window;

///
class MonitorException: NeGuiException {
	mixin MixInNeGuiException;
}

class Monitor: IHandle {
	private HMONITOR hMonitor;
	override const HANDLE opCall() {
		return hMonitor;
	}

	enum FAILURE {
		NEAR      = MONITOR_DEFAULTTONEAREST, /// 指定したウィンドウに最も近い位置にあるディスプレイモニタのハンドルが返ります。
		PRIMARY   = MONITOR_DEFAULTTOPRIMARY, /// プライマリディスプレイモニタのハンドルが返ります。
		EXCEPTION = MONITOR_DEFAULTTONULL,    /// NULL が返ります。
	}
	this(HMONITOR hMonitor) {
		this.hMonitor = hMonitor;
	}
	this(in Window FromWindow, FAILURE Failure) {
		enforce(FromWindow, new MonitorException(Text("FromWindow is null.")));
		
		auto hMonitor=MonitorFromWindow(FromWindow(), Failure);

		if(Failure == FAILURE.EXCEPTION) {
			enforce(hMonitor, new MonitorException(Text("null.")));
		}

		this(hMonitor);
	}
	this(const ref POINT FromPoint, FAILURE Failure) {
		auto hMonitor=MonitorFromPoint(cast(POINT)FromPoint, Failure);

		if(Failure == FAILURE.EXCEPTION) {
			enforce(hMonitor, new MonitorException(Text("null.")));
		}

		this(hMonitor);
	}
	this(const ref RECT FromRect, FAILURE Failure) {
		auto hMonitor=MonitorFromRect(cast(RECT*)&FromRect, Failure);

		if(Failure == FAILURE.EXCEPTION) {
			enforce(hMonitor, new MonitorException(Text("null.")));
		}

		this(hMonitor);
	}

	/**
	History:
		1.061:
			[P] 失敗時に例外。
	*/
	const ref MONITOR information() {
		auto monitor=new MONITOR;
		monitor.initialize;
		enforce(GetMonitorInfo(hMonitor, monitor.ptr), new MonitorException(ERR.toText));
		return *monitor;
	}
}

struct MONITOR {
	MONITORINFOEX MonitorInfo;
	mixin(SMixInStructHiddenOriginal!(MONITORINFOEX)(q{MonitorInfo}));

	void initialize() {
		MonitorInfo.cbSize = MonitorInfo.sizeof;
	}
	ref RECT desktop() {
		return MonitorInfo.rcMonitor;
	}
	ref RECT work() {
		return MonitorInfo.rcWork;
	}
	enum FLAG {
		NONE = 0,
		PRIMARY = MONITORINFOF_PRIMARY,
	}
	mixin(SMixInStructGetSet!(FLAG)("flag", q{MonitorInfo.dwFlags}));

	const Text device() {
		return Text(cast(wchar*)MonitorInfo.szDevice.ptr);
	}
}






