﻿/**
CPU情報。

ほぼずべてstd.cpu。
*/
module nemuxi.negui.environ.cpu;

debug import std.stdio: wl = writefln, pl = printf;
debug(cpu) void main() {}

import std.contracts;
import std.cpuid;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.environ.environ;

///
class CPUException: EnvironException {
	mixin MixInNeGuiException;
}

class CPU: IText {
	static bool slow() {
		return cast(bool)GetSystemMetrics(SM_SLOWMACHINE);
	}

	static Text vendor() {
		return std.cpuid.vendor.toText;
	}
	static Text processor() {
		return std.cpuid.processor.toText;
	}

	static Text information() {
		return Text(
			InfoTextLine("Vendor",         vendor, true),
			InfoTextLine("Processor",      processor, true),
			InfoTextLine("MMX",            mmx, true),
			InfoTextLine("FXSR",           fxsr, true),
			InfoTextLine("SSE",            sse, true),
			InfoTextLine("SSE2",           sse2, true),
			InfoTextLine("SSE3",           sse3, true),
			InfoTextLine("SSSE3",          ssse3, true),
			InfoTextLine("AMD 3DNOW",      amd3dnow, true),
			InfoTextLine("AMD 3DNOW Ext",  amd3dnowExt, true),
			InfoTextLine("AMD MMX",        amdMmx, true),
			InfoTextLine("IA64",           ia64, true),
			InfoTextLine("AMD64",          amd64, true),
			InfoTextLine("HyperThreading", hyperThreading, true),
			InfoTextLine("Threads/CPU",    threadsPerCPU, true),
			InfoTextLine("Core/CPU",       coresPerCPU, true),
			InfoTextLine("INTEL",          intel, true),
			InfoTextLine("AMD",            amd, true),
			InfoTextLine("Stepping",       stepping, true),
			InfoTextLine("Model",          model, true),
			InfoTextLine("Family",         family, true),
			InfoTextLine("Slow",           slow, false)
		);
	}
	override const Text toText() {
		return information;
	}
	override string toString() {
		return toText.text8;
	}
}

debug(cpu) unittest {
	wl("%s", new CPU);

}

