﻿/**
単位変換とか単位分の何かを取得。

大丈夫なんかいと思いながらもデスクトップのウィンドウハンドルでデバイスコンテキスト。
GetDC(GetDesktopWindow())で検索したら結構出てきたんで大丈夫認定。…大丈夫なんかい。
*/
module nemuxi.negui.draw.unit;

debug import std.stdio: wl = writefln, pl = printf;
debug(unit) void main() {}

import std.math;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.negui;
import nemuxi.negui.draw.font;
import nemuxi.negui.draw.icon;

/**
ポイント→ピクセル変換。
*/
int PointToPixel(int Point) {
	auto hDC=GetDC(GetDesktopWindow());
	scope(exit) if(hDC) DeleteDC(hDC);

	return MulDiv(Point, GetDeviceCaps(hDC, LOGPIXELSY), 72);
}


/**
メニュー一行あたりの高さ。
アイコンの大きさとシステムの規定の高さから背比べ。
*/
int GetMenuHeight(int IconHeight) {
	auto menu=GetSystemMetrics(SM_CYMENU);

	return IconHeight > menu
		? IconHeight
		: menu
	;
}

int GetFontHeightPx(in Font font) {
	return abs(PointToPixel(font.height));
}
/**
History:
	1.021:
		[S] 取得数値の変更。
*/
int GetDefaultControlHeight(in Font font) {
	return GetFontHeightPx(font) + GetControlPadding.cy*2;
}

Font GetSafeFont(NeGui gui) {
	if(auto CtrlFont = gui.font) {
		return CtrlFont;
	} else {
		return new Font(Font.STOCK.SYSTEM);
	}
}

/**
History:
	1.060:
		[P] 戻り値の型変更。

	1.021:
		[P] 戻り値の型変更。
		[S] 処理/値の変更。
*/
ref SIZE GetControlPadding() {
	auto Size=new SIZE;
	
	Size.cx = GetSystemMetrics(SM_CXEDGE);
	Size.cy = GetSystemMetrics(SM_CYEDGE);
	
	return *Size;
}

deprecated void GetIconControlSize(Icon.FIXED IconFixed, ref SIZE Size) {
	auto IconPx=Icon.fixedToSize(IconFixed);
	Size.cx = IconPx + GetSystemMetrics(SM_CXEDGE)*2;
	Size.cy = IconPx + GetSystemMetrics(SM_CYEDGE)*2;
}

/**
History:
	1.060:
		[P] 戻り値の型変更。
	
	1.021:
		新規作成。
*/
ref SIZE GetIconControlPadding() {
	auto Size=new SIZE;
	
	Size.cx = GetSystemMetrics(SM_CXEDGE);
	Size.cy = GetSystemMetrics(SM_CYEDGE);
	
	return *Size;
}

/**
History:
	1.060:
		[B] 空白領域が非対称。
		[P] 戻り値の型変更。
		[P] 処理内容変更。

	1.021:
		新規作成。
*/
ref SIZE GetIconControlSize(const ref SIZE IconSize) {
	auto PaddingSize=GetIconControlPadding;

	PaddingSize.cx *= 2;
	PaddingSize.cy *= 2;

	auto TotalSize=new SIZE;
	
	TotalSize.cx = IconSize.cx + PaddingSize.cx;
	TotalSize.cy = IconSize.cy + PaddingSize.cx;
	
	return *TotalSize;
}
/**
History:
	1.060:
		[P] 戻り値の型変更。
	
	1.021:
		[P] 戻り値の型変更。

	1.00β19:
		[P] 取得方法の変更。
*/
ref SIZE GetIconControlSize(Icon.FIXED IconFixed) {
	return GetIconControlSize(Icon.fixedToSizeEx(IconFixed));
}

