﻿/**

*/
module nemuxi.negui.draw.pen;

debug import std.stdio: wl = writefln, pl = printf;

debug(pen) void main() {}

import win32.windows;

import nemuxi.negui.system.base;

import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.color;

debug(pen) unittest {
	auto a=new Pen(Pen.STOCK.BLACK);
	a.width=0;
}

class Pen: Draw {
	alias Handle hPen;
	mixin KillResource!("ペン", hPen, DeleteObject, 0);

	protected mixin GetImportObject!("ペン", hPen, LOGPEN, CreatePenIndirect);
	
	override this(HPEN hPen, bool Suicide) {
		super(hPen, Suicide);
	}
	
	///
	static enum STYLE {
		SOLID       = PS_SOLID      , /// 実践のペンを作成します。 
		DASH        = PS_DASH       , /// 破線のペンを作成します。このスタイルは、ペンの幅が 1 以下のときにのみ有効です。 
		DOT         = PS_DOT        , /// 点線のペンを作成します。このスタイルは、ペンの幅が 1 以下のときにのみ有効です。 
		DASHDOT     = PS_DASHDOT    , /// 一点鎖線のペンを作成します。このスタイルは、ペンの幅が 1 以下のときにのみ有効です。 
		DASHDOTDOT  = PS_DASHDOTDOT , /// 二点鎖線のペンを作成します。このスタイルは、ペンの幅が 1 以下のときにのみ有効です。 
		NULL        = PS_NULL       , /// 描画を行わない、空のペンを作成します。 
		INSIDEFRAME = PS_INSIDEFRAME, /// 実線のペンを作成します。境界長方形を指定する GDI 描画関数（Rectangle関数や Ellipse関数など）でこのペンを使うと、その長方形に完全に収まるように図形が縮小されます。ジオメトリックペンにのみ有効です。 
	}
	///
	this(STYLE style, int width, COLOR color) {
		this(CreatePen(style, width, color.code), true);
	}

	///
	static enum STOCK {
		BLACK = BLACK_PEN, /// 黒のペン
		NULL  = NULL_PEN,  /// 透明のペン
		WHITE = WHITE_PEN  /// 白のペン
	}
	///
	this(STOCK Stock) {
		this(GetStockObject(Stock), false);
	}

	
	const STYLE style() {
		return cast(STYLE)GetStruct(hPen).lopnStyle;
	}
	bool style(STYLE Style) {
		auto sPen=GetStruct(hPen);
		sPen.lopnStyle = Style;
		return Import(sPen);
	}
	const int width() {
		return GetStruct(hPen).lopnWidth.x;
	}
	bool width(int Width) {
		auto sPen=GetStruct(hPen);
		sPen.lopnWidth.x = Width;
		return Import(sPen);
	}
	const COLOR color() {
		return COLOR(GetStruct(hPen).lopnColor);
	}
	bool color(COLOR cl) {
		auto sPen=GetStruct(hPen);
		sPen.lopnColor = cl.code;
		return Import(sPen);
	}
}

