﻿/**
イメージリスト。

*/
module nemuxi.negui.draw.imagelist;

debug import std.stdio: wl = writefln, pl = printf;

debug(imagelist) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;

import nemuxi.negui.draw.draw;
public import nemuxi.negui.draw.color;
public import nemuxi.negui.draw.icon;
public import nemuxi.negui.draw.canvas;


///
class ImageListException: DrawException {
	mixin MixInNeGuiException;
}

/**
イメージリスト。

イメージリストハンドルのラッパ。

設定するDrawオブジェクトは複製されるので不要な場合は開放可能。
*/
class ImageList: Draw {
	/// イメージリストハンドル。
	protected alias Handle hImageList;
	mixin KillResource!("イメージリスト", hImageList, ImageList_Destroy, 0);

	/**
	History:
		1.00β15:
			[S] ILC -> COLOR_TYPEに名称変更。
	*/
	static enum COLOR_TYPE {
		COLOR    = ILC_COLOR    , /// デフォルトの動作を示す。通常は ILC_COLOR4 が用いられる
		COLOR4   = ILC_COLOR4   , /// 4ビットDIBセクションを使用する
		COLOR8   = ILC_COLOR8   , /// 8ビットDIBセクションを使用する
		COLOR16  = ILC_COLOR16  , /// 16ビットDIBセクションを使用する
		COLOR24  = ILC_COLOR24  , /// 24ビットDIBセクションを使用する
		COLOR32  = ILC_COLOR32  , /// 32ビットDIBセクションを使用する
		COLORDDB = ILC_COLORDDB , /// DDBを使用する
		MASK     = ILC_MASK     , /// マスクを使用する。イメージリストには、通常のビットマップとマスクビットマップがセットで扱われる
	}
	/**
	*/
	this(int Width, int Height, COLOR_TYPE ColorType, size_t InitSize, size_t ExSize, bool Suicide=true) {
		auto hImgList = ImageList_Create(
			Width,
			Height,
			ColorType,
			InitSize,
			ExSize
		);
		this(hImgList, Suicide);
	}
	/**
	*/
	override this(HIMAGELIST hImageList, bool Suicide) {
		super(hImageList, Suicide);
	}

	/**
	描画オブジェクトの追加。

	Params:
		AddIcon = アイコン。

	Return:
		追加オブジェクトのインデックス。

	Exception:
		失敗時にImageListExceptionを投げる。
	*/
	size_t add(in Icon AddIcon) {
		auto Index=ImageList_AddIcon(hImageList , AddIcon());

		enforce(Index != -1, new ImageListException(Text("アイコン追加失敗")));

		return Index;
	}

	/***/
	size_t add(in Bitmap AddBitMap, in Bitmap MaskBitmap) {
		auto Index=ImageList_Add(hImageList , AddBitMap(), MaskBitmap());
		
		enforce(Index != -1, new ImageListException(Text("ビットマップ+マスクビットマップ追加失敗")));

		return Index;
	}
	/***/
	size_t add(in Bitmap AddBitMap, in COLOR MaskColor) {
		auto Index=ImageList_AddMasked(hImageList , AddBitMap(), MaskColor.code);
		
		enforce(Index != -1, new ImageListException(Text("ビットマップ+マスクカラー追加失敗")));

		return Index;
	}
}

