﻿/**

*/
module nemuxi.negui.draw.icon;

debug import std.stdio: wl = writefln, pl = printf;
debug(icon) void main() {}



import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.draw;


///
class IconException: DrawException {
	mixin MixInNeGuiException;
}

enum {
	LR_SHARD = 0x8000,
}

/**
*/
class Icon: Draw {
	/**
	アイコンサイズ。

	Bugs:
		NeGuiがﾈﾑぃから引き継いだ固定サイズに依存しすぎな感じ。

	History:
		1.030:
			[S] 今気づいたけどTYPEって何だよ。FIXEDに変更。
	*/
	enum FIXED {
		SMALL , /// 16*16アイコン。
		NORMAL, /// 32*32アイコン。
	}
	deprecated alias FIXED TYPE;

	/**
	History:
		1.030:
			[S] メソッド名等変更。
	*/
	static int fixedToSize(FIXED Fixed) {
		final switch(Fixed) {
			case FIXED.SMALL:  return 16;
			case FIXED.NORMAL: return 32;
		}
	}
	/**
	History:
		1.030:
			[S] メソッド名等変更。
			[P] 処理変更。
	*/
	static ref SIZE fixedToSizeEx(FIXED Fixed) {
		auto Size=new SIZE;
		Size.cx = Size.cy = fixedToSize(Fixed);

		return *Size;
	}

	/**
	History:
		1.060:
			新規作成。
	*/
	static FIXED sizeToFixed(size_t IconSize) {
		auto FixedSizes=new size_t[FIXED.max+1];

		for(auto i=FIXED.min; i != FIXED.max; i++) {
			FixedSizes[i] = fixedToSize(i);
		}
		for(auto i=FIXED.min; i != FIXED.max; i++) {
			if(FixedSizes[i] < IconSize) {
				continue;
			} else {
				return i;
			}
		}
		return FIXED.max;
	}
	static FIXED sizeToFixed(const ref SIZE Size) {
		return sizeToFixed((Size.cx + Size.cy) / 2);
	}
	debug(icon) unittest {
		SIZE s;
		s.cx=s.cy=16;
		assert(FIXED.SMALL == sizeToFixed(s));
		s.cx=s.cy=32;
		assert(FIXED.NORMAL == sizeToFixed(s));
		s.cx=s.cy=0;
		assert(FIXED.SMALL == sizeToFixed(s));
		s.cx=s.cy=17;
		assert(FIXED.NORMAL == sizeToFixed(s));
		s.cx=s.cy=46;
		assert(FIXED.NORMAL == sizeToFixed(s));
	}
	
	protected alias Handle hIcon;
	mixin KillResource!("アイコン", hIcon, DestroyIcon, 0);

	override this(HANDLE Handle, bool Suicide) {
		super(Handle, Suicide);
	}
	/**
	Bugs:
		何も考えずに適当にあわせたんでたぶん間違ってる。
	*/
	enum STOCK: ushort {
		APPLICATION = OIC_SAMPLE     ,
		ASTERISK    = OIC_INFORMATION       ,
		EXCLAMATION = OIC_WARNING       ,
		HAND        = OIC_HAND    ,
		QUESTION    = OIC_QUES    ,
		WINLOGO     = OIC_WINLOGO,
	}
	this(STOCK Stock, const ref SIZE Size) {
		auto hIcon=LoadImage(
			null,
			MAKEINTRESOURCE(Stock),
			IMAGE_ICON,
			Size.cx, Size.cy,
			LR_SHARD
		);
		if(!hIcon) {
			throw new IconException(Text("STOCK(%s)", Stock));
		}
		this(hIcon, false);
	}
	this(STOCK Stock, FIXED Fixed) {
		SIZE Size=fixedToSizeEx(Fixed);

		this(Stock, Size);
	}

	///
	const Icon dup() {
		assert(hIcon);
		return new Icon(DuplicateIcon(null, hIcon), true);
	}
}

