﻿/**

*/
module nemuxi.negui.draw.cursor;

debug import std.stdio: wl = writefln, pl = printf;

debug(cursor) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.draw;
import nemuxi.negui.negui;

///
class CursorException: DrawException {
	mixin MixInNeGuiException;
}

/**
History:
	1.010:
		[S] マウスカーソルの位置に関するメソッドを移動。
*/
class Cursor: Draw {
	protected alias Handle hCursor;
	mixin KillResource!("カーソル", hCursor, DestroyCursor, 0);

	mixin HandleRaiiClass;

	/// カーソル位置設定。
	deprecated static {
		bool setPos(in int x, in int y) {
			return cast(bool)SetCursorPos(x, y);
		}
		/// ditto
		bool setPos(const ref POINT Point) {
			return setPos(Point.x, Point.y);
		}

		/***/
		ref POINT getPos() {
			auto Point=new POINT;

			enforce(GetCursorPos(Point), new CursorException(ERR.toText));

			return *Point;
		}


		private enum {
			SPI_GETSNAPTODEFBUTTON = 95,
		}
		bool setPosOver(in NeGui gui) {
			try {
				auto Rect=gui.itemRect();

				with(Rect) return Cursor.setPos(
					left + (right  - left) / 2,
					top  + (bottom - top)  / 2
				);
			} catch(Throwable e) {
				return false;
			}
		}
		bool setPosOverAuto(lazy NeGui gui) {
			BOOL Move;
			if(!SystemParametersInfo(SPI_GETSNAPTODEFBUTTON, 0, &Move, 0))
				return false;
			
			if(Move) {
				return setPosOver(gui);
			}
			
			return false;
		}
	}
}



