﻿/**

*/
module nemuxi.negui.draw.bitmap;

debug import std.stdio: wl = writefln, pl = printf;

debug(bitmap) void main() {}

import win32.core;

import nemuxi.negui.system.text;
import nemuxi.negui.system.exception;

import nemuxi.negui.system.raii;
import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.canvas;


///
class BitmapException: DrawException {
	mixin MixInNeGuiException;
}

/**
*/
class Bitmap: Draw {
	protected alias Handle hBitmap;
	mixin KillResource!("ビットマップ", hBitmap, DeleteObject, 0);
	mixin GetImportObject!("ビットマップ", hBitmap, BITMAP, CreateBitmapIndirect);
	
	override this(HANDLE hHandle, bool Suicide) {
		super(hHandle, Suicide);
	}

	/**
	History:
		1.021:
			[s] 引数属性変更。
	*/
	this(in Canvas canvas, const ref SIZE Size) {
		auto hBmp=CreateCompatibleBitmap(canvas(), Size.cx, Size.cy);
		if(!hBmp) {
			throw new BitmapException(Text("ビットマップしっぱーい"));
		}

		this(hBmp, true);
	}
	/**
	History:
		1.021:
			[s] 引数属性変更。
	*/
	this(const ref SIZE Size) {
		auto hDC=GetDC(null);
		scope(exit) DeleteDC(hDC);
		
		this(CreateCompatibleBitmap(hDC, Size.cx, Size.cy), true);
		if(!hBitmap) {
			throw new BitmapException(Text("ビットマップしっぱーい"));
		}
	}
}

