﻿/**
アップダウンコントロール。

スピンコントロールとも。
*/
module nemuxi.negui.control.updown.updown;

debug import std.stdio: wl = writefln, pl = printf;
debug(updown) void main() {}

import std.string;

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;

///
class UpDownException: ControlException {
	mixin MixInNeGuiException;
}

/***/
class UpDown: Control, ICommonControl {
	mixin MixInCommonControl;
	
	///
	static enum POSITION {
		NONE    = 0,
		LEFT    = UDS_ALIGNLEFT , /// コントロールをバディウィンドウの左側に配置します。
		RIGHT   = UDS_ALIGNRIGHT, /// コントロールをバディウィンドウの右側に配置します。
		HORIZON = UDS_HORZ, /// コントロールを横向きに配置します。
	}
	/**
	History:
		1.032:
			[P] 処置内容変更。
	*/
	this(NeGui Owner, ITEM_ID Id, POSITION Position=POSITION.RIGHT) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		
		this(NeGuiInfo, Position);
	}

	/**
	History:
		1.032:
			新規作成。
	*/
	this(ref NEGUIINFO NeGuiInfo, POSITION Position) {
		NeGuiInfo.className = UPDOWN_CLASS;
		NeGuiInfo.style    |= UDS_SETBUDDYINT | UDS_ARROWKEYS | Position;
		
		super(NeGuiInfo);
	}

	Control buddy(in Control ctrl) {
		return cast(Control)NeGui.getGuiObject(cast(HWND)send(UDM_SETBUDDY, cast(WPARAM)(ctrl ? ctrl(): null), NONE));
	}
	const Control buddy() {
		return cast(Control)NeGui.getGuiObject(cast(HWND)send(UDM_GETBUDDY, NONE, NONE));
	}
	bool reBuddy() {
		if(auto Buddy=buddy) {
			buddy = buddy;
			return true;
		} else {
			return false;
		}
	}

	const INT value() {
		LPARAM Err;
		auto Value=send(UDM_GETPOS32, NONE, cast(LPARAM)&Err);
		if(Err) {
			throw new UpDownException(Text("UpDown.value = %s", Err));
		}
		return Value;
	}
	/**
	Return:
		以前の値。
	*/
	INT value(INT Value) {
		return send(UDM_SETPOS32, NONE, Value);
	}
	

	void range(int min, int max) {
		send(UDM_SETRANGE32, min, max);
	}
}

