﻿/**
ツールバー。
*/
module nemuxi.negui.control.toolbar.toolbar;

debug import std.stdio: wl = writefln, pl = printf;

debug(toolbar) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.imagelist;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;

///
class ToolBarException: ControlException {
	mixin MixInNeGuiException;
}


version(Unicode) {
	private alias TBN_GETINFOTIPW TBN_GETINFOTIP;
} else {
	private alias TBN_GETINFOTIPA TBN_GETINFOTIP;
}

/**
History:
	1.00β16:
		[S] イメージリスト周りを改善。
*/
class ToolBar: Control, ICommonControl, IInitialize {
	
	mixin MixInCommonControl;
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner = Owner;
		NeGuiInfo.id    = Id;
		
		this(NeGuiInfo);
	}

	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.className = TOOLBARCLASSNAME;
		
		super(NeGuiInfo);
	}
	
	enum EVENT: MESSAGETYPE {
		DROPDOWN = TBN_DROPDOWN, /// ▼クリック
		INFOTIP  = TBN_GETINFOTIP, /// ツールチップ
	}
	
	mixin(SMixInItemStyleGetSet("flat", q{TBSTYLE_FLAT}, false));
	mixin(SMixInItemStyleGetSet("wrapable", q{TBSTYLE_WRAPABLE}, false));
	mixin(SMixInItemStyleGetSet("toolTips", q{TBSTYLE_TOOLTIPS}, false));

	///
	override void initialize() {
		super.send(TB_BUTTONSTRUCTSIZE, TBBUTTON.sizeof, NONE);
	}
	
	/**
	テキストの表示非表示切り替え。

	Params:
		ListStyle = 表示/非表示。
	*/
	void list(bool ListStyle) {
		auto style=super.getItemInfo(GWL_STYLE);

		if(ListStyle) {
			style |= TBSTYLE_LIST;
		} else {
			style &= ~TBSTYLE_LIST;
		}
		
		super.send(TB_SETSTYLE, NONE, style);
	}
	///
	bool list() {
		return cast(bool)(super.getItemInfo(GWL_STYLE) & TBSTYLE_LIST);
	}


	///
	int buttonCount() {
		return super.send(TB_BUTTONCOUNT, NONE, NONE);
	}
	///
	void buttonClear(int Index) {
		super.send(TB_DELETEBUTTON, Index, NONE);
	}
	///
	void buttonClear() {
		auto Index=this.buttonCount();
		
		for(auto i=0; i < Index; i++) {
			super.send(TB_DELETEBUTTON, 0, NONE);
		}
	}
	///
	bool buttonSet(in TOOLBUTTON[] ToolButtons) {
		return cast(bool)super.send(TB_ADDBUTTONS, ToolButtons.length, cast(LPARAM)ToolButtons.ptr);
	}
	/**
	History:
		1.080:
			[P] 戻り値追加。
	*/
	bool buttonGet(size_t ButtonIndex, ref TOOLBUTTON ToolButton) {
		return cast(bool)super.send(TB_GETBUTTON, ButtonIndex, cast(LPARAM)&ToolButton.TbButton);
	}
	/**
	History:
		1.080:
			新規作成。
	*/
	ref TOOLBUTTON buttonGet(size_t Index) {
		auto ToolButton=new TOOLBUTTON;
		ToolButton.initialize();
		
		///
		class ToolBarButtonGetException: ToolBarException {
			mixin MixInNeGuiException;
		}
		enforce(buttonGet(Index, *ToolButton), new ToolBarButtonGetException(Text("Index = %s", Index)));

		return *ToolButton;
	}
	
	/**
	ツールバーサイズに合わせてボタン位置変更。

	Params:
		hToolbar = ツールバーハンドル。
	*/
	void autoSize() {
		super.send(TB_AUTOSIZE, NONE, NONE);
	}


	bool buttonSize(ref const(SIZE) Size) {
		return cast(bool)send(TB_SETBUTTONSIZE, NONE, MAKELONG(cast(ushort)Size.cx, cast(ushort)Size.cy));
	}
	
	const ref SIZE buttonSize(COMMAND_ID Id) {
		auto Rect=this.buttonRect(Id);
		auto Size=new SIZE;
		
		Size.cx = Rect.right;
		Size.cy = Rect.bottom;

		return *Size;
	}
	
	const ref SIZE buttonSize() {
		auto TempSize=super.send(TB_GETBUTTONSIZE, NONE, NONE);
		auto Size=new SIZE;
		
		Size.cx = LOWORD(TempSize);
		Size.cy = HIWORD(TempSize);

		return *Size;
	}
	
	///
	void setButtonWidth(ushort MinWidth, ushort MaxWidth) {
		super.send(TB_SETBUTTONWIDTH, NONE, MAKELONG(MinWidth, MaxWidth));
	}
	const ref RECT buttonRect(COMMAND_ID Id) {
		auto Rect=new RECT;
		
		super.send(TB_GETRECT, Id, cast(LPARAM)Rect);

		return *Rect;
	}
	
	
	/**
	素っ裸。
	*/
	size_t addBitmap(in HINSTANCE hInstance, in UINT Id, in size_t ButtonLength)
	in {
		assert(Id != -1);
	}
	body {
		TBADDBITMAP TbAddBmp=void;
		TbAddBmp.hInst = hInstance;
		TbAddBmp.nID   = Id;
		return send(TB_ADDBITMAP, ButtonLength, cast(LPARAM)&TbAddBmp);
	}
	enum SYSTEM_IMAGE {
		STANDARD_SMALL  = IDB_STD_SMALL_COLOR,
		VIEW_SMALL      = IDB_VIEW_SMALL_COLOR,
		HISTORY_SMALL   = IDB_HIST_SMALL_COLOR,
		STANDARD_NORAML = IDB_STD_LARGE_COLOR,
		VIEW_NORMAL     = IDB_VIEW_LARGE_COLOR,
		HISTORY_NORMAL  = IDB_HIST_LARGE_COLOR,
	}
	size_t addBitmap(SYSTEM_IMAGE SystemImage) {
		return addBitmap(HINST_COMMCTRL, NONE, SystemImage);
	}
	deprecated alias addBitmap bitmapAdd;
	///
	const int rows() {
		return super.send(TB_GETROWS, NONE, NONE);
	}

	///
	void barStyle(LPARAM lParam) {
		super.send(TB_SETEXTENDEDSTYLE, NONE, lParam);
	}

	private enum IMAGE_TYPE {
		NORMAL,
		HOT,
		DISABLED,
	}
	private pure WPARAM GetImageMessage(bool MessageIsGet, IMAGE_TYPE ImageType) {
		final switch(ImageType) {
			case IMAGE_TYPE.NORMAL:   return MessageIsGet ? TB_GETIMAGELIST:         TB_SETIMAGELIST;
			case IMAGE_TYPE.HOT:      return MessageIsGet ? TB_GETHOTIMAGELIST:      TB_SETHOTIMAGELIST;
			case IMAGE_TYPE.DISABLED: return MessageIsGet ? TB_GETDISABLEDIMAGELIST: TB_SETDISABLEDIMAGELIST;
		}
	}
	private ImageList GetSetImageList(LPARAM ImageID, ImageList NewImage, WPARAM ImageMessage) {
		HIMAGELIST hImageList;

		hImageList = cast(HIMAGELIST)super.send(ImageMessage, ImageID, NewImage ? cast(LPARAM)NewImage(): NONE);

		return hImageList
			? new ImageList(hImageList, false)
			: null
		;
	}
	/**
	イメージリストの設定。

	Params:
		ImageID = イメージリストの番号。

		NewImage = 設定するイメージリスト。

	Return:
		以前に設定されていたイメージリスト(自殺しないタイプ)。
		設定されていなければnullを返す。

	History:
		1.00β20:
			[S] 引数の順番変更。
	*/
	ImageList imageListNormal(ImageList NewImage, LPARAM ImageID=0) {
		return GetSetImageList(ImageID, NewImage, GetImageMessage(false, IMAGE_TYPE.NORMAL));
	}
	ImageList imageListNormal() {
		return GetSetImageList(NONE, null, GetImageMessage(true, IMAGE_TYPE.NORMAL));
	}
	ImageList imageListHot(ImageList NewImage) {
		return GetSetImageList(NONE, NewImage, GetImageMessage(false, IMAGE_TYPE.HOT));
	}
	ImageList imageListHot() {
		return GetSetImageList(NONE, null, GetImageMessage(true, IMAGE_TYPE.HOT));
	}
	ImageList imageListDisabled(ImageList NewImage) {
		return GetSetImageList(NONE, NewImage, GetImageMessage(false, IMAGE_TYPE.DISABLED));
	}
	ImageList imageListDisabled() {
		return GetSetImageList(NONE, null, GetImageMessage(true, IMAGE_TYPE.DISABLED));
	}
	

	/**
	コマンドIDからボタンインデックス取得。

	Params:
		Id = コマンドID。

	Return:
		ボタンのインデックス番号(0基準)。

	Exception:
		範囲外とかならToolBarException。
	*/
	int idToIndex(COMMAND_ID Id) {
		auto Index=super.send(TB_COMMANDTOINDEX, Id, NONE);

		if(Index == -1) {
			throw new ToolBarException(Text("指定されたコマンドIDが無効"));
		}

		return Index;
	}

	bool buttonShow(COMMAND_ID Id, bool Show) {
		return cast(bool)super.send(TB_HIDEBUTTON, id, !Show);
	}
	/**
	History:
		1.00β20:
			新規作成。
	*/
	bool buttonEnable(COMMAND_ID Id, bool Enable) {
		return cast(bool)super.send(TB_ENABLEBUTTON, Id, Enable);
	}
	
}

enum {
	HIST_BACK           = 0,
	HIST_FORWARD        = 1,
	HIST_FAVORITES      = 2,
	HIST_ADDTOFAVORITES = 3,
	HIST_VIEWTREE       = 4,
}

///
struct TOOLBUTTON {
	TBBUTTON TbButton;
	mixin(SMixInStructHiddenOriginal!(TBBUTTON)(`TbButton`));

	void initialize() {
		TbButton.bReserved = 0;
	}

	mixin(SMixInStructGetSet!(size_t)("imageIndex", q{TbButton.iBitmap}));
	void nonImage() {
		TbButton.iBitmap = I_IMAGENONE;
	}
	alias nonImage sepWidth;

	public typedef int IMAGE;

	enum STANDARD: IMAGE {
		CUT        = STD_CUT,
		COPY       = STD_COPY,
		PASTE      = STD_PASTE,
		UNDO       = STD_UNDO,
		REDOW      = STD_REDOW,
		DELETE     = STD_DELETE,
		FILENEW    = STD_FILENEW,
		FILEOPEN   = STD_FILEOPEN,
		FILESAVE   = STD_FILESAVE,
		PRINTPRE   = STD_PRINTPRE,
		PROPERTIES = STD_PROPERTIES,
		HELP       = STD_HELP,
		FIND       = STD_FIND,
		REPLACE    = STD_REPLACE,
		PRINT      = STD_PRINT,
	}
	enum VIEW: IMAGE {
		LARGEICONS    = VIEW_LARGEICONS,
		SMALLICONS    = VIEW_SMALLICONS,
		LIST          = VIEW_LIST,
		DETAILS       = VIEW_DETAILS,
		SORTNAME      = VIEW_SORTNAME,
		SORTSIZE      = VIEW_SORTSIZE,
		SORTDATE      = VIEW_SORTDATE,
		SORTTYPE      = VIEW_SORTTYPE,
		PARENTFOLDER  = VIEW_PARENTFOLDER,
		NETCONNECT    = VIEW_NETCONNECT,
		NETDISCONNECT = VIEW_NETDISCONNECT,
		NEWFOLDER     = VIEW_NEWFOLDER,
	}
	enum HISTORY: IMAGE {
		BACK           = HIST_BACK,
		FORWARD        = HIST_FORWARD,
		FAVORITES      = HIST_FAVORITES,
		ADDTOFAVORITES = HIST_ADDTOFAVORITES,
		VIEWTREE       = HIST_VIEWTREE,
	}
	
	mixin(SMixInStructGetSet!(IMAGE)("systemImage", q{TbButton.iBitmap}));

	mixin(SMixInStructGetSet!(COMMAND_ID)("command", q{TbButton.idCommand}));

	static enum STATE {
		CHECKED       = TBSTATE_CHECKED      , /// ボタンは TBSTYLE_CHECK スタイルを持っていて、押されています。
		PRESSED       = TBSTATE_PRESSED      , /// ボタンは押されています。
		ENABLED       = TBSTATE_ENABLED      , /// ボタンはユーザーからの入力を受け取り可能な状態です。この状態が指定されていない場合はボタンは灰色表示になり、ユーザーからの入力を受け取りません。
		HIDDEN        = TBSTATE_HIDDEN       , /// ボタンは不可視の状態であり、ユーザーからの入力を受け取りません。
		INDETERMINATE = TBSTATE_INDETERMINATE, /// ボタンは灰色表示されています。
		WRAP          = TBSTATE_WRAP         , /// ボタンは次の行に表示されます。 TBSTATE_ENABLED が同時に指定されている必要があります。
		ELLIPSES      = TBSTATE_ELLIPSES     , /// Version 4.70 以上： ボタンのテキストが省略されて、省略記号（...）がつけられます。
		MARKED        = TBSTATE_MARKED       , /// Version 4.71 以上： ボタンがマークされています。マークされているアイテムの意味はアプリケーションによって定義されます。
	}
	mixin(SMixInStructGetSet!(STATE)("state", q{TbButton.fsState}));

	static enum STYLE {
		BUTTON        = TBSTYLE_BUTTON     , /// 標準の押しボタンを作成します。
		SEP           = TBSTYLE_SEP        , /// セパレータ（区切り線）を作成します。セパレータは、各ボタンをグループに分ける役割を持ちます。このスタイルを持つボタンは、ユーザーからの入力を受け付けません。
		CHECK         = TBSTYLE_CHECK      , /// トグル動作をするボタンを作成します。このボタンは、押された状態と押されていない状態の2つの状態を持ち、ユーザーがクリックするたびに状態が切り替わります。
		GROUP         = TBSTYLE_GROUP      , /// グループのほかのボタンが押されるまで、押されたままの状態になるボタンを作成します。
		CHECKGROUP    = TBSTYLE_CHECKGROUP , /// グループのほかのボタンが押されるまで押されたままの状態になるトグルボタンを作成します。この状態は BTNS_CHECK と BTNS_CHECKGROUP を結合したものと同じです。
		DROPDOWN      = TBSTYLE_DROPDOWN   , /// version 4.70 以降： ドロップダウンスタイルボタンを作成します。このスタイルを持つボタンは、ボタンがクリックされたときにリストを表示することができるようになります。通常のボタンは WM_COMMAND メッセージを送りますが、ドロップダウンボタンは TBN_DROPDOWN 通知メッセージを送ります。ツールバーが TBSTYLE_EX_DRAWDDARROWS 拡張スタイルを持つ場合は、ドロップダウンボタンは、右側の区切られたセクションににドロップダウンの矢印ボタンを表示します。この場合、矢印ボタンがクリックされると TBN_DROPDOWN 通知メッセージが送られます。また、関連付けられているボタンが押されると、 WM_COMMAND メッセージが送られます。
		AUTOSIZE      = TBSTYLE_AUTOSIZE   , /// version 4.71 以降： ボタンの幅をイメージのサイズとテキストのサイズの両方をもとにして計算します。
		NOPREFIX      = TBSTYLE_NOPREFIX   , /// version 4.71 以降： ボタンのテキストに含まれるアンパサンド（&）などの文字を、関連付けられているアクセラレータのプレフィックス文字として解釈しないように指定します。
		SHOWTEXT      = BTNS_SHOWTEXT      , /// version 5.81 以降： ボタンテキストを表示するように指定します。すべてのボタンはテキストを持ちますが、このスタイルを持つボタンのみがそれを表示します。このスタイルを持たないボタンでは、カーソルがボタンの上に置かれたときに、テキストが自動的にツールチップとして表示されます。ツールチップが表示されないようにするには、 TBN_GETINFOTIP 通知メッセージを処理する必要があります。このボタンスタイルは TBSTYLE_LIST スタイルおよび TBSTYLE_EX_MIXEDBUTTONS 拡張スタイルを持つツールバーでのみ有効です。
		WHOLEDROPDOWN = BTNS_WHOLEDROPDOWN , /// version 5.80 以降： ドロップダウン矢印ボタンを、区切られたセクションとしてではなく同一のボタンとして表示します。このスタイルを持つボタンは、ツールバーが TBSTYLE_EX_DRAWDDARROWS 拡張スタイルを持っているかどうかに関わらず、同じ振舞いをします。
	}
	mixin(SMixInStructGetSet!(STYLE)("style", q{TbButton.fsStyle}));

	mixin(SMixInStructGetSet!(void*)("data", q{TbButton.dwData}));
	
	mixin(SMixInStructGetSet!(size_t)("stringIndex", q{TbButton.iString}));
	Text text() {
		return Text(cast(wchar*)TbButton.iString);
	}
	void text(Text text) {
		TbButton.iString = cast(INT)text.ptr;
	}
}

