﻿/**
タブ。

History:
	1.000:
		新規作成。
*/
module nemuxi.negui.control.tab.tab;

debug import std.stdio: wl = writefln, pl = printf;
debug(tab) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
import nemuxi.negui.system.type.basic;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.system.type.record;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.brush;
import nemuxi.negui.draw.imagelist;
public import nemuxi.negui.event.event;
import nemuxi.negui.layout.panel.panel;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.group;
import nemuxi.negui.event.subclass;

///
class TabException: ControlException {
	mixin MixInNeGuiException;
}

/**
Bugs:
	nemuxi.negui.control.button.groupと同じ処理なんでtemplateかなんかで統一すべき。
*/
class Tab: Control, ICommonControl, ISubClass {
	alias BUFFER.TEXT TEXTLENGTH;
	
	mixin MixInCommonControl;
	
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.WM_TOP!(Tab));
		
		switch(Message) {
			case WM_DESTROY:    mixin(EVENTLOOP.WM_DESTROY);
			case WM_SIZE:       mixin(EVENTLOOP.WM_SIZE);
			case WM_COMMAND,
			     WM_NOTIFY:     return NeGuiObject.parent.send(Message, wParam, lParam);
			case WM_ERASEBKGND: mixin(EVENTLOOP.WM_ERASEBKGND);
			default:            mixin(EVENTLOOP.WM_LAST!(Tab));
		}
	}
	mixin(TSubClass);

	enum EVENT: MESSAGETYPE {
		KEYDOWN     = TCN_KEYDOWN    ,
		SELCHANGE   = TCN_SELCHANGE  ,
		SELCHANGING = TCN_SELCHANGING,
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.className = WC_TABCONTROL;
		super(NeGuiInfo);
		layoutManager = new TabLayout(parent);
		SubClassOnNeGuiConstructor();
	}
	/**
	History:
		1.032:
			[P] 処理変更。
	*/
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		NeGuiInfo.style     = TCS_TABS;
		
		this(NeGuiInfo);
	}
	
	// ---------------------------------------
	private class TabLayout: LayoutManager {
		override this(NeGui Owner) {
			super(Owner);
			margin  = margin.init;
			padding = padding.init;
		}
		alias LayoutManager.onSize onSize;
		
		override void onSize(in int Width, in int Height) {
			RECT ContentSize;
			ContentSize.right  = Width;
			ContentSize.bottom = Height;

			adjustOwner(ContentSize);

			ContentSize.left += margin.left + padding.left;
			ContentSize.top  += margin.top  + padding.top;

			ContentSize.right  -= margin.right  - padding.right - margin.left + padding.left;
			ContentSize.bottom -= margin.bottom - padding.bottom - margin.top  + padding.top;
			
			onSize(ContentSize);
		}
	}
	private TABVALUE[] TabValues;
	void opAddAssign(TABVALUE TabValue) {
		TabValues ~= TabValue;
	}
	ref TABVALUE opIndex(size_t Index) {
		return TabValues[Index];
	}
	mixin(SMixInClassGetSet!(size_t)("length", q{TabValues.length}, false));
	
	TABVALUE[] values() {
		return TabValues;
	}
	void values(TABVALUE[] TabValues) {
		this.TabValues = TabValues;
		if(this.TabValues.length && isSelect) {
			change(select);
		}
	}
	void change(size_t Index) {
		foreach(i, TabValue; TabValues) {
			immutable Show=(i == Index ? SHOW.SHOWNORMAL: SHOW.HIDE);

			foreach(item; TabValue.inItems) {
				item.setShow(Show);
			}
		}
		layoutManager.basePanel = TabValues[Index].basePanel;
		layoutManager.reLoad;
	}
	// ---------------------------------------

	enum LINESTYLE {
		SINGLE,
		MULTI,
	}
	mixin(SMixInItemStyleGetSetEx!(LINESTYLE, DWORD)(
		"lineStyle", false, [
		q{LINESTYLE.SINGLE}, q{LINESTYLE.MULTI},
		q{TCS_SINGLELINE},   q{TCS_MULTILINE}
	]));

	private {
		enum LARGER {
			OWNER= 0,
			TAB  = 1,
		}
		const void AdjustRect(LARGER Larger, ref RECT Rect) {
			send(TCM_ADJUSTRECT, Larger, cast(LPARAM)&Rect);
		}
	}
	const void adjustOwner(ref RECT Rect) {
		AdjustRect(LARGER.OWNER, Rect);
	}
	const void adjustTab(ref RECT Rect) {
		AdjustRect(LARGER.TAB, Rect);
	}

	bool clear() {
		return cast(bool)send(TCM_DELETEALLITEMS, NONE, NONE);
	}

	bool del(WPARAM Index) {
		return cast(bool)send(TCM_DELETEITEM, Index, NONE);
	}

	const bool isSelect() {
		return send(TCM_GETCURSEL, NONE, NONE) >= 0;
	}
	const size_t select() {
		auto Index=send(TCM_GETCURSEL, NONE, NONE);
		enforce(Index >= 0, new TabException(Text("未選択")));
		return Index;
	}
	size_t select(size_t Index) {
		auto OldPos=send(TCM_SETCURSEL, Index, NONE);

		enforce(OldPos != -1, new TabException(ERR.toText));

		return OldPos;
	}

	const size_t count() {
		return send(TCM_GETITEMCOUNT, NONE, NONE);
	}

	const bool get(size_t Index, ref TABITEM TabItem) {
		return cast(bool)send(TCM_GETITEM, Index, cast(LPARAM)TabItem.ptr);
	}
	const ref TABITEM get(size_t Index) {
		auto TabItem=new TABITEM;

		auto TextBuffer=new wchar[TEXTLENGTH];

		TabItem.mask  = TABITEM.MASK.ALL;
		TabItem.state = TABITEM.STATE.SELECTED | TABITEM.STATE.HILIGHTED;
		TabItem.textLength = TextBuffer.length;
		TabItem.text       = TextBuffer.ptr;

		enforce(get(Index, *TabItem), new TabException(ERR.toText));

		return *TabItem;
	}
	
	bool set(size_t Index, const ref TABITEM TabItem) {
		return cast(bool)send(TCM_SETITEM, Index, cast(LPARAM)TabItem.ptr);
	}
	size_t insert(size_t Index, const ref TABITEM TabItem) {
		auto Pos=send(TCM_INSERTITEM, Index, cast(LPARAM)TabItem.ptr);
		
		enforce(Pos != -1, new TabException(ERR.toText));

		return Pos;
	}

	const ImageList imageList() {
		if(auto hImage=send(TCM_GETIMAGELIST, NONE, NONE)) {
			return new ImageList(cast(HIMAGELIST)hImage, false);
		} else {
			return null;
		}
	}
	ImageList imageList(in ImageList Image) {
		if(auto hImage=send(TCM_SETIMAGELIST, NONE, cast(LPARAM)Image())) {
			return new ImageList(cast(HIMAGELIST)hImage, false);
		} else {
			return null;
		}
	}

	private TUNE.OnSize TuneOnSize;
	mixin(SMixInClassGet!(TUNE.OnSize)("tuneSize", q{TuneOnSize}, false));
	void tuneSize(TUNE.OnSize TuneOnSize) {
		this.TuneOnSize = TuneOnSize;
	}
	protected override {
		void OnDestroy() {
			SubClassOnNeGuiDestructor();
			super.OnDestroy();
		}
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			if(TuneOnSize) {
				TuneOnSize(SizeType, Width, Height);
			}
			return false;
		}
		
		OnEraseBackGroundDg OnEraseBackGround(Canvas canvas) {
			auto dg = {
				scope brush  = new Brush(SYSTEMCOLOR.Frame);
				
				canvas.setBrush = brush;
				RECT Rect;

				auto Size=clientSize();
				Rect.right  = Size.cx;
				Rect.bottom = Size.cy;
				
				canvas.fillRect(Rect);
				
				return true;
			};
			return cast(OnEraseBackGroundDg)dg;
		}
	}
	alias NeGui.font font;
	final override void font(in Font font) {
		super.font(font);
		foreach(child; children) {
			child.font = font;
		}
	}

}

struct TABITEM {
	TCITEM TcItem;
	mixin(SMixInStructHiddenOriginal!(TCITEM)(`TcItem`));

	enum MASK {
		IMAGE      = TCIF_IMAGE,      /// image メンバが有効
		DATA       = TCIF_PARAM,      /// iParam メンバが有効
		RTLREADING = TCIF_RTLREADING, /// タブのテキストを右から左へ表示する。ヘブライ語、またはアラビア語で有効
		STATE      = TCIF_STATE,
		TEXT       = TCIF_TEXT,       /// 文字列
		ALL        = IMAGE | DATA | RTLREADING | STATE | TEXT,        /// 全てのメンバが有効
	}
	mixin(SMixInStructGetSet!(MASK)("mask", q{TcItem.mask}));

	enum STATE {
		SELECTED  = TCIS_BUTTONPRESSED, /// タブコントロールアイテムは選択されています。
		HILIGHTED = TCIS_HIGHLIGHTED,   /// タブコントロールは強調表示されています。
	}
	mixin(SMixInStructGetSet!(STATE)("state", q{TcItem.dwState}));
	mixin(SMixInStructGetSet!(STATE)("stateMask", q{TcItem.dwStateMask}));
	
	
	mixin(SMixInStructGetSet!(int)("textLength", q{TcItem.cchTextMax}));
	///
	void text(wchar* s) {
		TcItem.pszText = s;
	}
	///
	wchar* text(in Text t) {
		auto pText = TcItem.pszText = t.ptr;
		textLength = t.length;
		return pText;
	}
	mixin(SMixInStructGetSet!(int)("imageIndex", q{TcItem.iImage}));
	
	mixin(SMixInStructGetSet!(void*)("data", q{TcItem.lParam}));
}

struct TABVALUE {
	Panel basePanel;
	NeGui[] inItems;
}


