﻿/**
あ
*/
module nemuxi.negui.control.listbox.listbox;

debug import std.stdio: wl = writefln, pl = printf;

debug(listbox) void main() {}

import win32.windows;

import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.group;
import nemuxi.negui.system.type.enumerated;

///
class ListBoxException: ControlException {
	mixin MixInNeGuiException;
}

/**
一人だけ異質だ。
*/
class ListBox: Control, IListBox, INotify, IOwnerDraw {
	///
	enum EVENT: MESSAGETYPE {
		ERRSPACE  = LBN_ERRSPACE,  // メモリの割り当てに失敗した
		SELCHANGE = LBN_SELCHANGE, // 選択状態が変更された
		DBLCLK    = LBN_DBLCLK,    // 項目がダブルクリックされた
		SELCANCEL = LBN_SELCANCEL, // ユーザが選択をキャンセルした
		SETFOCUS  = LBN_SETFOCUS,  // キーボードフォーカスを受け取った
		KILLFOCUS = LBN_KILLFOCUS, // キーボードフォーカスを失った
	}

	protected override this(HWND hWnd) {
		super(hWnd);
	}
	///
	enum SELECT {
		SINGLE   = 0,               /// 
		MULTI    = LBS_MULTIPLESEL, /// 
		READONRY = LBS_NOSEL,       /// 
	}
	enum TYPE {
		LIST   = 0,               /// 
		COLUMN = LBS_MULTICOLUMN, /// 
	}
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	this(NeGui Owner, ITEM_ID Id, SELECT Select=SELECT.SINGLE, TYPE Type=TYPE.LIST) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		
		this(NeGuiInfo, Select, Type);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(NEGUIINFO NeGuiInfo, SELECT Select, TYPE Type) {
		NeGuiInfo.className =  "LISTBOX";
		
		NeGuiInfo.style |= Select;
		if(Select == SELECT.MULTI) {
			NeGuiInfo.style |= LBS_EXTENDEDSEL;
		}
		if(Type) {
			NeGuiInfo.style |= Type | WS_HSCROLL;
		} else {
			NeGuiInfo.style |= WS_VSCROLL;
		}
		NeGuiInfo.style |= LBS_NOINTEGRALHEIGHT | LBS_NOTIFY;
		
		super(NeGuiInfo);

		clientEdge=true;
		border=false;
		reLoad;
	}
	

	mixin(SMixInItemStyleGetSet("standard",  q{LBS_STANDARD},       false));
	mixin(SMixInItemStyleGetSet("notify",    q{LBS_NOTIFY},         false));
	mixin(SMixInItemStyleGetSet("ownerDraw", q{LBS_OWNERDRAWFIXED}, false));
	mixin(SMixInItemStyleGetSet("sort",      q{LBS_SORT},           false));

	void column(int Column) {
		send(LB_SETCOLUMNWIDTH, Column, NONE);
	}
	
	override int add(in Text text) {
		auto Index=super.send(LB_ADDSTRING, NONE, cast(LPARAM)text.ptr);
		switch(Index) {
			case LB_ERRSPACE: throw new ListBoxException(Text("メモリ不足"));
			case LB_ERR:      throw new ListBoxException(Text("何らかのエラー"));
			default:          return Index;
		}
	}
	override int add(in Text[] texts)
	in {
		assert(texts.length);
	}
	body {
		int LastIndex;
		foreach(text; texts) {
			LastIndex = this.add(text);
		}
		return LastIndex;
	}
	override int del(int Index) {
		auto Count=super.send(LB_DELETESTRING, Index, NONE);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}
	override const int find(in Text text, int StartIndex) {
		auto Count=super.send(LB_FINDSTRING, StartIndex, cast(LPARAM)text.ptr);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	override const int count() {
		auto Count=super.send(LB_GETCOUNT, NONE, NONE);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	override const int select() {
		auto Index=super.send(LB_GETCURSEL, NONE, NONE);
		if(Index == LB_ERR) {
			throw new ListBoxException(Text("未選択"));
		}
		return Index;
	}
	override int select(int Index) {
		auto SelectIndex=super.send(LB_SETCURSEL, Index, NONE);
		if(SelectIndex == LB_ERR && Index != -1) {
			throw new ListBoxException(ERR.toText);
		}
		return SelectIndex;
	}
	
	override const int getHeight(int Index) {
		auto Size=super.send(LB_GETITEMHEIGHT, Index, NONE);
		if(Size == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Size;
	}
	override bool setHeight(int Index, int Height) {
		return super.send(LB_SETITEMHEIGHT, Index, Height) != LB_ERR;
	}

	override void setWidth(int Width) {
		super.send(LB_SETHORIZONTALEXTENT, Width, NONE);
	}

	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	override const Text listText(int Index) {
		auto text=new wchar[this.listTextLength(Index) + 1];
		auto Length=super.send(LB_GETTEXT, Index, cast(LPARAM)text.ptr);
		if(Length == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Text(text[0..Length]);
	}
	override bool listText(in Text text, int Index) {
		insert(text, Index);
		
		return cast(bool)del(Index+1);
	}

	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	override const int listTextLength(int Index) {
		auto Length=super.send(LB_GETTEXTLEN, Index, NONE);
		if(Length == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Length;
	}

	override const int topIndex() {
		return super.send(LB_GETTOPINDEX, NONE, NONE);
	}

	override int insert(in Text text, int Index) {
		auto Pos=super.send(LB_INSERTSTRING, Index, cast(LPARAM)text.ptr);
		switch(Pos) {
			case LB_ERRSPACE: throw new ListBoxException(Text("メモリ不足"));
			case LB_ERR:      throw new ListBoxException(Text("何らかのエラー"));
			default:          return Pos;
		}
	}

	override void clear() {
		super.send(LB_RESETCONTENT, NONE, NONE);
	}

	override int search(in Text text, int StartIndex) {
		auto Index=super.send(LB_SELECTSTRING, StartIndex, cast(LPARAM)text.ptr);
		if(Index == LB_ERR) {
			throw new ListBoxException(Text("見つからない"));
		}
		return Index;
	}
	
	//---------------------------------------------------------------------
	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	const bool isSelect() {
		return super.send(LB_GETCURSEL, NONE, NONE) != LB_ERR;
	}
	bool isSelect(int Index) {
		auto Selected=super.send(LB_GETSEL, Index, NONE);
		if(Selected == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Selected ? true: false;
	}
	bool toSelect(int Index, bool Select) {
		auto Success=super.send(LB_SETSEL, Select, Index);
		return Success != LB_ERR;
	}

	int selectedCount() {
		auto Count=super.send(LB_GETSELCOUNT, NONE, NONE);
		if(Count == LB_ERR) {
			throw new ListBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	int caretIndex() {
		return super.send(LB_GETCARETINDEX, NONE, NONE);
	}

	void* getItemData(int Index) {
		return cast(void*)super.send(LB_GETITEMDATA, Index, NONE);
	}
	void setItemData(int Index, void* Data) {
		super.send(LB_SETITEMDATA, Index, cast(LPARAM)Data);
	}

	int folder(in Text Folder, LIST_ATTIBUTE ListAttributes) {
		auto FileNum=send(LB_DIR, ListAttributes, cast(LPARAM)Folder.ptr);
		
		switch(FileNum) {
			case LB_ERRSPACE: throw new ListBoxException(Text("メモリ不足"));
			case LB_ERR:      throw new ListBoxException(Text("何らかのエラー"));
			default:          return FileNum;
		}
	}
	
	mixin ListControlArray!(ListBoxException, "ListBox");
}

/**
Bugs:
	属性とかちゃんとしないと。

History:
	1.061:
		[S] 並びを(文字列, ...)に変更。
*/
interface IListBox {
	/**
	文字列の追加。

	Params:
		text = 追加する文字列。

	Return:
		追加された文字列のインデックス。
	*/
	int add(in Text text);
	/// ditto
	int add(in Text[] texts);
	/**
	項目の削除。

	Params:
		Index = 削除項目のインデックス。

	Return:
		削除後の項目数。
	*/
	int del(int Index);
	/**
	項目の検索。

	Params:
		text = 検索文字列。

		StartIndex = 検索を開始するインデックス。

	Return:
		該当するインデックス。
		該当しなければ-1。

	History:
		1.061:
			[S] 属性変更。
	*/
	const int find(in Text text, int StartIndex);
	/*
	History:
		1.061:
			[S] 属性変更。
	*/
	const int count();
	/**
	History:
		1.00β15:
			[S] 属性変更。
	*/
	const int select();
	int select(int);
	/**
	高さの取得。

	Params:
		Index = 取得するインデックス。

	Return:
		取得した高さ。

	Exception:
		失敗時にNeGuiException。
	
	History:
		1.061:
			[S] 属性変更。
	*/
	const int getHeight(int Index);
	bool setHeight(int, int);
	void setWidth(int);
	/**
	指定項目の文字列取得。

	Params:
		Index = 項目のインデックス。

	Return:
		取得した文字列。

	Exception:
		失敗時にNeGuiException。
	
	History:
		1.00β17:
			[S] 属性変更。
	*/
	const Text listText(int Index);
	bool listText(in Text, int Index);
	/**
	History:
		1.00β17:
			[S] 属性変更。
	*/
	const int listTextLength(int);
	/**
	表示中の最上位項目取得。

	Return:
		現在表示されている最上位項目のインデックス。
	
	History:
		1.00β17:
			[S] 属性変更。
	*/
	const int topIndex();
	int insert(in Text text, int Index);
	void clear();
	int search(in Text text, int StartIndex);

	int folder(in Text Folder, LIST_ATTIBUTE ListAttributes);

	// 配列っぽく
	const Text opIndex(int);
	void opIndexAssign(in Text, int);
	const Text[] opSlice();
	const Text[] opSlice(int, int);
	void opAddAssign(in Text);
}

template ListControlArray(T: NeGuiException, string ListCtrlType) {
	// 配列っぽく===================

	/**
	項目の文字列取得。

	Params:
		Index = 項目のインデックス。

	Exception:
		失敗時にControlExceptionを投げる。
	*/
	const Text opIndex(int Index)
	in {
		assert(Index >= 0, `RangeError`);
	}
	body {
		if(!this.count) {
			throw new ControlException(Text(ListCtrlType ~ ".RangeError(opIndex)"));
		}
		
		return this.listText(Index);
	}
	void opIndexAssign(in Text text, int Index)
	in {
		assert(Index >= 0, `RangeError`);
	}
	body {
		if(!this.count) {
			throw new ControlException(Text(ListCtrlType ~ ".RangeError(opIndexAssign)"));
		}
		
		this.listText(text, Index);
	}
	/// ditto
	const Text[] opSlice() {
		if(!this.count) {
			return null;
		}
		return opSlice(0, this.count());
	}
	const Text[] opSlice(int StartIndex, int EndIndex)
	in {
		assert(StartIndex < EndIndex, `あらら`);
		assert(EndIndex - StartIndex > 0, `わわわ`);
	}
	body {
		if(EndIndex > this.count()) {
			throw new ControlException(Text(ListCtrlType ~ ".RangeError(opSlice)"));
		}
		
		auto texts=new Text[EndIndex - StartIndex];
		for(auto i=StartIndex; i < EndIndex; i++) {
			texts[i] = this.listText(i);
		}

		return texts;
	}
	void opAddAssign(in Text text) {
		add(text);
	}
	
}

class ListBoxGroup: Group!(ListBox) {
	mixin TGroupClass!(ListBox);

	void clear() {
		foreach(Listbox; List) {
			Listbox.clear();
		}
	}

}


