﻿/**
あ
*/
module nemuxi.negui.control.listbox.header;

debug import std.stdio: wl = writefln, pl = printf;
debug(header) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;

///
class HeaderException: ControlException {
	mixin MixInNeGuiException;
}

/***/
class Header: Control, ICommonControl {
	mixin MixInCommonControl;
	override protected this(HWND hWnd) {
		super(hWnd);
	}
	/**
	History:
		1.032:
			[@] 内部処理変更。
	*/
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		
		this(NeGuiInfo);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.className = WC_HEADER;
		super(NeGuiInfo);
	}

	/**
	History:
		1.032:
			[S] 属性変更。
	*/
	const size_t count() {
		auto len = send(HDM_GETITEMCOUNT, NONE, NONE);
		enforce(len != -1, new HeaderException(Text("ヘッダーアイテム数取得失敗")));
		return len;
	}
}

