﻿/**
ホットキー

History:
	1.00β13:
		HOTKEYVALUEをpackage移勁Enemuxi.negui.control.hotkey.hotkey -> nemuxi.negui.input.keyboard.keyboard
*/
module nemuxi.negui.control.hotkey.hotkey;

debug import std.stdio: wl = writefln, pl = printf;
debug(hotkey) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;
public import nemuxi.negui.input.keyboard.keyboard;


/***/
class HotKey: Control, ICommonControl {
	mixin MixInCommonControl;
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		
		this(NeGuiInfo);
	}
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.className = HOTKEY_CLASS;
		NeGuiInfo.style |= ES_CENTER;
		
		super(NeGuiInfo);
	}

	/**
	History:
		1.00β17:
			[B] コントロールから取得するキー情報が壊れていた。
	*/
	HOTKEYVALUE value() {
		auto Value=LOWORD(send(HKM_GETHOTKEY, NONE, NONE));
		
		HOTKEYVALUE Hotkey;
		Hotkey.Mod = cast(HOTKEY)HIBYTE(Value);
		Hotkey.Key = cast(KEY)LOBYTE(Value);
		
		return Hotkey;
	}

	void value(HOTKEYVALUE Value) {
		send(HKM_SETHOTKEY, MAKEWORD(Value.Key, Value.Mod), NONE);
	}

	enum RULE {
		ALT = HKCOMB_A, /// ALTキー
		CONTROL=HKCOMB_C, /// Ctrlキー
		SHIT=HKCOMB_S, /// Shiftキー
		CTRL_ALT=HKCOMB_CA, /// Ctrl + ALTキー
		SHIT_ALT=HKCOMB_SA, /// Shift + ALTキー
		SHIFT_CTRL=HKCOMB_SC, /// Shift + Ctrlキー
		SCA=HKCOMB_SCA, /// Shift + Ctrl + ALTキー
		NONE = HKCOMB_NONE, /// 修飾されてぁE↑ぁEくー
	}
	void rule(RULE Rule, HOTKEY Mod) {
		send(HKM_SETRULES, Rule, MAKELPARAM(Mod, 0));
	}
}



