﻿/**
デイトタイムピッカー。

History:
	1.032:
		package名変更
*/
module nemuxi.negui.control.dtp.datetimepicker;

debug import std.stdio: wl = writefln, pl = printf;
debug(datetimepicker) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
import nemuxi.negui.system.timer;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;

/***/
abstract class DateTimePicker: Control, ICommonControl {
	mixin MixInCommonControl;
	/**
	History:
		1.032:
			[S] 名前変更。
	*/
	static enum EVENT: MESSAGETYPE {
		DATETIMECHANGE = DTN_DATETIMECHANGE,
	}

	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.className = DATETIMEPICK_CLASS;
		
		super(NeGuiInfo);
	}
	
	/// Bugs: エラー処理未実装
	DateTime value() {
		SYSTEMTIME SystemTime=void;
		send(DTM_GETSYSTEMTIME, NONE, cast(LPARAM)&SystemTime);
		auto date=new DateTime(SystemTime);
		return date;
	}
	void value(DateTime Value) {
		send(DTM_SETSYSTEMTIME, GDT_VALID, cast(LPARAM)Value.ptr);
	}
}

/***/
class DatePicker: DateTimePicker {
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		
		this(NeGuiInfo);
	}

	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.style |= DTS_SHORTDATECENTURYFORMAT;
		
		super(NeGuiInfo);
	}
	
	alias DateTimePicker.value value;
	override DateTime value() {
		auto Value=super.value();
		Value.mask = DateTime.MASK.DATE;
		return Value;
	}
}
/***/
class TimePicker: DateTimePicker {
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		
		//this(&NeGuiInfo);
		this(NeGuiInfo);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(NEGUIINFO NeGuiInfo) {
		NeGuiInfo.style |= DTS_TIMEFORMAT;
		
		super(NeGuiInfo);
	}
	alias DateTimePicker.value value;
	override DateTime value() {
		auto Value=super.value();
		Value.mask = DateTime.MASK.TIME;
		return Value;
	}
}

