﻿/**
History
	1.00β17:
		nemuxi.negui.control.combobox.comboboxをpublic importに変更。
		
	1.00β15:
		新規作成。
*/
module nemuxi.negui.control.combobox.excombobox;

debug import std.stdio: wl = writefln, pl = printf;
debug(excombobox) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.imagelist;
import nemuxi.negui.system.type.basic;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.system.type.record;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.editbox.editbox;
public import nemuxi.negui.control.listbox.listbox;
public import nemuxi.negui.control.combobox.combobox;

///
class ExComboBoxException: ComboBoxException {
	mixin MixInNeGuiException;
}

enum COMBOBOXITEM_MASK {
	DI_SETITEM    = CBEIF_DI_SETITEM,    /// CBEN_GETDISINFO通知メッセージを使う時のみ
	IMAGE         = CBEIF_IMAGE,         /// iImageメンバが有効
	INDENT        = CBEIF_INDENT,        /// iIndentメンバが有効
	DATA          = CBEIF_LPARAM,        /// lParamメンバが有効
	OVERLAY       = CBEIF_OVERLAY,       /// iOverlayメンバが有効
	SELECTEDIMAGE = CBEIF_SELECTEDIMAGE, /// iSelectedImageメンバが有効
	TEXT          = CBEIF_TEXT,          /// pszTextメンバが有効
}
struct COMBOBOXITEM {
	private COMBOBOXEXITEM ComboBoxExItem;
	mixin(SMixInStructHiddenOriginal!(COMBOBOXEXITEM)(q{ComboBoxExItem}));

	enum {
		TEXTLENGTH = 1024,
	}

	alias COMBOBOXITEM_MASK MASK;
	mixin(SMixInStructGetSet!(MASK)("mask", q{ComboBoxExItem.mask}));

	/// -1でエディット部分。
	mixin(SMixInStructGetSet!(int)("index", q{ComboBoxExItem.iItem}));
	deprecated alias index itemIndex;
	
	Text text() {
		return Text(cast(wchar*)ComboBoxExItem.pszText);
	}
	void text(wchar* text) {
		ComboBoxExItem.pszText = text;
	}
	wchar* text(Text text) {
		textLength = text.length;
		return ComboBoxExItem.pszText = text.ptr;
	}
	
	mixin(SMixInStructGetSet!(size_t)("textLength", q{ComboBoxExItem.cchTextMax}));

	mixin(SMixInStructGetSet!(size_t)("imageIndex", q{ComboBoxExItem.iImage}));
	mixin(SMixInStructGetSet!(size_t)("imageIndexSelected", q{ComboBoxExItem.iSelectedImage}));
	mixin(SMixInStructGetSet!(size_t)("imageIndexOverlay", q{ComboBoxExItem.iOverlay}));
	
	mixin(SMixInStructGetSet!(size_t)("indent", q{ComboBoxExItem.iIndent}));

	mixin(SMixInStructGetSet!(void*)("data", q{ComboBoxExItem.lParam}));
}

struct EXCOMBOBOX {
	private NMCOMBOBOXEX NmComboBox;
	mixin(SMixInStructHiddenOriginal!(NMCOMBOBOXEX)(q{NmComboBox}));
	const NOTIFY* notify() {
		return cast(NOTIFY*)&NmComboBox.hdr;
	}
	const EXCOMBOBOXITEM* exItem() {
		return cast(EXCOMBOBOXITEM*)&NmComboBox.ceItem;
	}
}
struct EXCOMBOBOXITEM {
	COMBOBOXEXITEM ComboBoxExItem;
	mixin(SMixInStructHiddenOriginal!(COMBOBOXEXITEM)(q{ComboBoxExItem}));
	
	mixin(SMixInStructGetSet!(COMBOBOXITEM.MASK)("mask", q{ComboBoxExItem.mask}));
}
/*

	UINT   mask;
	int    iItem;
	LPWSTR pszText;
	int    cchTextMax;
	int    iImage;
	int    iSelectedImage;
	int    iOverlay;
	int    iIndent;
	LPARAM lParam;


*/


/**
拡張コンボボックス。
*/
class ExComboBox: ComboBox, ICommonControl {
	mixin MixInCommonControl;

	enum EVENT: MESSAGETYPE {
		BEGINEDIT   = CBEN_BEGINEDIT,   /// ユーザーが、ドロップダウン リストを表示したり、コントロールのエディット ボックスをクリックしたりすると送信されます。
		DELETEITEM  = CBEN_DELETEITEM,  /// 項目が削除されると送信されます。
		DRAGBEGIN   = CBEN_DRAGBEGIN,   /// コントロールのエディット領域に表示される項目のイメージのドラッグを開始すると送信されます。
		ENDEDIT     = CBEN_ENDEDIT,     /// ユーザーが、エディット ボックス内の操作を完了するか、コントロールのドロップダウン リストから項目を選択すると、送信されます。
		GETDISPINFO = CBEN_GETDISPINFO, /// コールバック項目に関する表示情報を取得するために送信されます。
		INSERTITEM  = CBEN_INSERTITEM,  /// 新しい項目がコントロールに挿入されると送信されます。
	}
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	this(NeGui Owner, ITEM_ID Id, TYPE Type=TYPE.STANDARD, int Height=0) {
		NEGUIINFO NeGuiInfo;

		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		NeGuiInfo.size.cy   = Height;
		
		
		//this(&NeGuiInfo, Type);
		this(NeGuiInfo, Type);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	this(ref NEGUIINFO NeGuiInfo, TYPE Type) {
		NeGuiInfo.className = WC_COMBOBOXEX;
		
		if(0 >= NeGuiInfo.size.cy) {
			NeGuiInfo.size.cy = 256;
		}
		
		super(NeGuiInfo, Type);

		send(CBEM_SETUNICODEFORMAT, true, NONE);
	}

	ImageList imageList() {
		if(auto hImageList=send(CBEM_GETIMAGELIST, NONE, NONE)) {
			return new ImageList(cast(HIMAGELIST)hImageList, false);
		}

		return null;
	}
	ImageList imageList(ImageList ImgList) {
		enforce(ImgList, new ExComboBoxException(Text("ImgList is null")));
		if(auto hOldImage=send(CBEM_SETIMAGELIST, NONE, cast(LPARAM)ImgList())) {
			return new ImageList(cast(HIMAGELIST)hOldImage, false);
		}

		return null;
	}

	override int del(int Index) {
		auto Count=super.send(CBEM_DELETEITEM, Index, NONE);
		if(Count == CB_ERR) {
			throw new ExComboBoxException(Text("何らかのエラー"));
		}
		return Count;
	}
	
	int insertEx(const ref COMBOBOXITEM ComboBoxItem) {
		return send(CBEM_INSERTITEM, NONE, cast(LPARAM)ComboBoxItem.ptr);
	}
	const bool get(ref COMBOBOXITEM ComboBoxItem) {
		return cast(bool)send(CBEM_GETITEM, NONE, cast(LPARAM)ComboBoxItem.ptr);
	}
	const ref COMBOBOXITEM get(int Index) {
		auto ComboBoxItem=new COMBOBOXITEM;

		with(COMBOBOXITEM.MASK) ComboBoxItem.mask = DI_SETITEM | IMAGE | INDENT | DATA | OVERLAY | SELECTEDIMAGE | TEXT;
		
		ComboBoxItem.index      = Index;
		ComboBoxItem.text       = (new wchar[COMBOBOXITEM.TEXTLENGTH]).ptr;
		ComboBoxItem.textLength = COMBOBOXITEM.TEXTLENGTH;
		
		enforce(get(*ComboBoxItem), new ExComboBoxException(ERR.toText));
		
		return *ComboBoxItem;
	}
	bool set(const ref COMBOBOXITEM ComboBoxItem) {
		return cast(bool)send(CBEM_SETITEM, NONE, cast(LPARAM)ComboBoxItem.ptr);
	}

	alias ComboBox.text text;
	override const Text text() {
		COMBOBOXITEM ComboBoxItem;
		
		// スタイルによってとり方が変わる。
		immutable Style=style;
		if((Style & CBS_DROPDOWNLIST) == CBS_DROPDOWNLIST) {
			if(isSelect) {
				ComboBoxItem.index      = select();
			} else {
				//見選択状態は取得できないので空文字。
				return Text.emptyText;
			}
		} else if((Style & CBS_DROPDOWN) == CBS_DROPDOWN) {
			ComboBoxItem.index      = -1;
		} else {
			return comboBox.text;
		}
		
		ComboBoxItem.mask       = COMBOBOXITEM.MASK.TEXT;
		ComboBoxItem.textLength = COMBOBOXITEM.TEXTLENGTH;
		ComboBoxItem.text       = (new wchar[ComboBoxItem.textLength]).ptr;
		
		enforce(get(ComboBoxItem), new ExComboBoxException(ERR.toText));
		
		return ComboBoxItem.text;
	}

	class OriginalComboBox: ComboBox {
		this(HWND hWnd) {
			super(hWnd);
		}
	}
	const ComboBox comboBox() {
		return new OriginalComboBox(cast(HWND)send(CBEM_GETCOMBOCONTROL, NONE, NONE));
	}
	
	override const EditBox editBox() {
		if(auto hWnd=cast(HWND)send(CBEM_GETEDITCONTROL, NONE, NONE)) {
			return new ComboEdit(hWnd);
		} else if(auto gui=relation(RELATION.CHILD)) {
			return new ComboEdit(gui());
		}
		return null;
	}

}


