﻿/**
コンボボックス。

*/
module nemuxi.negui.control.combobox.combobox;

debug import std.stdio: wl = writefln, pl = printf;
debug(combobox) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.system.type.enumerated;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.editbox.editbox;
public import nemuxi.negui.control.listbox.listbox;

///
class ComboBoxException: ControlException {
	mixin MixInNeGuiException;
}

/**
不慣れなりにもinterface使ってみたよ！
*/
class ComboBox: Control, IEditBox, IListBox {
	invariant() {
		assert(ListHeight >= LIST_HEIGHT);
	}
	enum EVENT: MESSAGETYPE {
		LISTCLOSE    = CBN_CLOSEUP,      /// リストボックスが閉じられた
		DBLCLK       = CBN_DBLCLK,       /// リストボックスの項目をダブルクリック
		LISTDROP     = CBN_DROPDOWN,     /// リストボックスが表示されようとしている
		EDITCHANGE   = CBN_EDITCHANGE,   /// エディットでテキストが変更された可能性がある
		EDITUPDATE   = CBN_EDITUPDATE,   /// エディットのテキストが変更されエディットを表示しようとしている
		ERROR        = CBN_ERRSPACE,     /// 十分なメモリを割り当てられない
		FOCUSKILL    = CBN_KILLFOCUS,    /// キーボードフォーカスを失った
		LISTCHANGE   = CBN_SELCHANGE,    /// リストボックスの選択の変更
		LISTCANCEL   = CBN_SELENDCANCEL, /// アイテムを選択したが、その時に他のコントロールを選択または、ダイアログボックスを閉じた
		LISTSELECTED = CBN_SELENDOK,     /// アイテムを選択し、リストを閉じる
		FOCUSSET     = CBN_SETFOCUS,     /// キーボードフォーカスを得た
	}
	enum TYPE {
		STANDARD = CBS_SIMPLE,
		DROPEDIT = CBS_DROPDOWN,
		DROPLIST = CBS_DROPDOWNLIST,
	}
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	this(NeGui Owner, ITEM_ID Id, TYPE Type=TYPE.STANDARD) {
		NEGUIINFO NeGuiInfo;
		
		NeGuiInfo.owner     = Owner;
		NeGuiInfo.id        = Id;
		
		//this(&NeGuiInfo, Type);
		this(NeGuiInfo, Type);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	this(ref NEGUIINFO NeGuiInfo, TYPE Type) {
		if(!NeGuiInfo.className.length) {
			NeGuiInfo.className = "COMBOBOX";
		}
		NeGuiInfo.style |= CBS_AUTOHSCROLL | CBS_DISABLENOSCROLL | WS_VSCROLL | Type;
		
		super(NeGuiInfo);
		
		reLoad;
	}
	/**
	History:
		1.00β15:
			新規作成。
	*/
	protected this(HWND hWnd) {
		super(hWnd);
	}

	mixin(SMixInItemStyleGetSet("disableNoScroll", q{CBS_DISABLENOSCROLL}));
	mixin(SMixInItemStyleGetSet("noIntegralHeight", q{CBS_NOINTEGRALHEIGHT}));
	 


	// IEditer ------------------------------------------------------------
	
	override int limitLength() {
		assert(false, "can't use this method.");
	}
	override void limitLength(int Limit) {
		return send(CB_LIMITTEXT, Limit, NONE);
	}
	
	
	// IListBox -----------------------------------------------------------

	override int add(in Text text) {
		auto Index=super.send(CB_ADDSTRING, NONE, cast(LPARAM)text.ptr);
		switch(Index) {
			case CB_ERRSPACE: throw new ComboBoxException(Text("メモリ不足"));
			case CB_ERR:      throw new ComboBoxException(Text("何らかのエラー"));
			default:          return Index;
		}
	}
	override int add(in Text[] texts)
	in {
		assert(texts.length);
	}
	body {
		int LastIndex;
		foreach(text; texts) {
			LastIndex = this.add(text);
		}
		return LastIndex;
	}
	
	override int del(int Index) {
		auto Count=super.send(CB_DELETESTRING, Index, NONE);
		if(Count == CB_ERR) {
			throw new ComboBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	/**
	History:
		1.000:
			[S] 発見できなかった場合に例外でなく-1を返す。
	*/
	override const int find(in Text text, int StartIndex) {
		auto Count=super.send(CB_FINDSTRING, StartIndex, cast(LPARAM)text.ptr);
		return Count;
	}
	
	override const int count() {
		auto Count=super.send(CB_GETCOUNT, NONE, NONE);
		if(Count == CB_ERR) {
			throw new ComboBoxException(Text("何らかのエラー"));
		}
		return Count;
	}

	/**
	History:
		1.00β15:
			新規作成。
	*/
	const bool isSelect() {
		return send(CB_GETCURSEL, NONE, NONE) != CB_ERR;
	}

	override const int select() {
		auto Index=super.send(CB_GETCURSEL, NONE, NONE);
		if(Index == CB_ERR) {
			throw new ComboBoxException(Text("未選択"));
		}
		return Index;
	}
	/**
	History:
		1.00β15:
			[B] 未選択状態で落ちていたのを修正。
	*/
	override int select(int Index) {
		auto SelectIndex=super.send(CB_SETCURSEL, Index, NONE);
		if(SelectIndex == CB_ERR && Index != -1) {
			throw new ComboBoxException(Text("未選択"));
		}
		return SelectIndex;
	}
	
	override const int getHeight(int Index) {
		auto Size=super.send(CB_GETITEMHEIGHT, Index, NONE);
		if(Size == CB_ERR) {
			throw new ComboBoxException(Text("何らかのエラー"));
		}
		return Size;
	}
	override bool setHeight(int Index, int Height) {
		return super.send(CB_SETITEMHEIGHT, Index, Height) != CB_ERR;
	}
	override void setWidth(int Width) {
		super.send(CB_SETHORIZONTALEXTENT, Width, NONE);
	}

	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	override const Text listText(int Index) {
		auto text=new wchar[this.listTextLength(Index) + 1];
		auto Length=super.send(CB_GETLBTEXT, Index, cast(LPARAM)text.ptr);
		if(Length == CB_ERR) {
			throw new ComboBoxException(Text("何らかのエラー"));
		}
		return Text(text[0..Length]);
	}
	override bool listText(in Text text, int Index) {
		insert(text, Index);
		
		return cast(bool)del(Index+1);
	}

	/**
	History:
		1.00β17:
			[S] const属性に変更。
	*/
	override const int listTextLength(int Index) {
		auto Length=super.send(CB_GETLBTEXTLEN, Index, NONE);
		if(Length == CB_ERR) {
			throw new ComboBoxException(Text("何らかのエラー"));
		}
		return Length;
	}

	override const int topIndex() {
		return super.send(CB_GETTOPINDEX, NONE, NONE);
	}

	override int insert(in Text text, int Index) {
		auto Pos=super.send(CB_INSERTSTRING, Index, cast(LPARAM)text.ptr);
		switch(Pos) {
			case CB_ERRSPACE: throw new ComboBoxException(Text("メモリ不足"));
			case CB_ERR:      throw new ComboBoxException(Text("何らかのエラー"));
			default:          return Pos;
		}
	}
	
	override void clear() {
		send(CB_RESETCONTENT, NONE, NONE);
	}

	override int search(in Text text, int StartIndex) {
		auto Index=super.send(CB_SELECTSTRING, StartIndex, cast(LPARAM)text.ptr);
		if(Index == CB_ERR) {
			throw new ComboBoxException(Text("見つからない"));
		}
		return Index;
	}
	
	int folder(in Text Folder, LIST_ATTIBUTE ListAttributes) {
		auto FileNum=send(CB_DIR, ListAttributes, cast(LPARAM)Folder.ptr);
		
		switch(FileNum) {
			case CB_ERRSPACE: throw new ComboBoxException(Text("メモリ不足"));
			case CB_ERR:      throw new ComboBoxException(Text("何らかのエラー"));
			default:          return FileNum;
		}
	}

	mixin ListControlArray!(ComboBoxException, "ComboBox");
	
	//---------------------------------------------------------------------

	const bool list() {
		auto Style = super.style();
		return ((Style & CBS_DROPDOWN) == CBS_DROPDOWN) || ((Style & CBS_DROPDOWNLIST) == CBS_DROPDOWNLIST);
	}

	/**
	History:
		1.061:
			[S] 属性変更。
	*/
	const int editerHeight() {
		return super.clientSize().cy;
	}


	/**
	History:
		1.00β15:
			[S] 属性変更。
	*/
	private const ref COMBOBOXINFO ComboBoxInfo() {
		auto ComboInfo=new COMBOBOXINFO;

		ComboInfo.cbSize = ComboInfo.sizeof;
		enforce(GetComboBoxInfo(hWnd, ComboInfo), new ComboBoxException(Text("コンボボックス情報取得失敗")));
		
		return *ComboInfo;
	}

	/**
	コンボボックス内エディットボックス。

	History:
		1.00β15:
			[S] メソッド外に配置。
	*/
		class ComboEdit: EditBox {
			this(HWND hWnd) {
				super(hWnd);
			}
		}
	/**
	エディットボックス部分取得。

	History:
		1.00β15:
			[B] コントロール生成時にAccess Violationしそうだった(未検証)のを修正。
			[S] 属性変更。
	*/
	const EditBox editBox() {
		return new ComboEdit(ComboBoxInfo.hwndItem);
	}
	/**
	コンボボックス内リストボックス。

	History:
		1.00β15:
			[S] メソッド外に配置。
	*/
	class ComboList: ListBox {
		this(HWND hWnd) {
			super(hWnd);
		}
	}
	/**
	リストボックス部分取得。
	
	History:
		1.00β15:
			[B] コントロール生成時にAccess Violationしそうだった(未検証)のを修正。
			[S] 属性変更。
	*/
	const ListBox listBox() {
		return new ComboList(ComboBoxInfo.hwndList);
	}
	/**
	ドロップダウン表示状態。
	
	*/
	bool dropList() {
		enforce(list(), new ComboBoxException(Text("bool dropList()")));
		
		return cast(bool)super.send(CB_GETDROPPEDSTATE, NONE, NONE);
	}
	/// ditto
	void dropList(bool Show) {
		enforce(list(), new ComboBoxException(Text("void dropList(bool Show)")));
		
		super.send(CB_SHOWDROPDOWN, Show, NONE);
	}

	// むりやり。
	private enum LIST_HEIGHT = 128;
	private int ListHeight = LIST_HEIGHT;
	const int listHeight() {
		return ListHeight;
	}
	void listHeight(in int ListHeight) {
		if(ListHeight >= LIST_HEIGHT) {
			this.ListHeight = ListHeight;
		} else {
			this.ListHeight = LIST_HEIGHT;
		}
	}
	// ↑の辻褄合わせ。
	override bool move(int x, int y, int Width, int Height, bool RePaint=true) {
		if(list()) {
			return super.move(x, y, Width, ListHeight + editerHeight, RePaint);
		} else {
			return super.move(x, y, Width, Height, RePaint);
		}
	}
	///
	override bool pos(AFTER After, int x, int y, int Width, int Height, SWP Flags) {
		if(list()) {
			return super.pos(After, x, y, Width, ListHeight + editerHeight, Flags);
		} else {
			return super.pos(After, x, y, Width, Height, Flags);
		}
	}
	
	/**
	*/
	override bool size(in int Width, in int Height) {
		if(list()) {
			return super.size(Width, ListHeight + editerHeight);
		} else {
			return super.size(Width, Height);
		}
	}
	override bool size(ref const(SIZE) Size) {
		return this.size(Size.cx, Size.cy);
	}
}

