﻿/**
あ
*/
module nemuxi.negui.control.button.group;

debug import std.stdio: wl = writefln, pl = printf;

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.brush;
public import nemuxi.negui.negui;
public import nemuxi.negui.event.event;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.group;
public import nemuxi.negui.control.button.button;
public import nemuxi.negui.event.subclass;
import nemuxi.negui.draw.unit;


class GroupBox: Button, ISubClass {
	static alias void delegate(int Width, int Height, int CtrlHeight, ref const(RECT) InSize) SizeTuneType;
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.WM_TOP!(GroupBox));
		
		switch(Message) {
			case WM_SIZE:       mixin(EVENTLOOP.WM_SIZE);
			case WM_DESTROY:    mixin(EVENTLOOP.WM_DESTROY);
			case WM_COMMAND,
			     WM_NOTIFY:     return NeGuiObject.parent.send(Message, wParam, lParam);
			case WM_ERASEBKGND: mixin(EVENTLOOP.WM_ERASEBKGND);
			default:            mixin(EVENTLOOP.WM_LAST!(GroupBox));
		}
	}
	mixin(TSubClass);
	private SizeTuneType TuneSize;
	
	bool tuneSize() {
		return TuneSize is null;
	}
	void tuneSize(SizeTuneType TuneSize) {
		this.TuneSize = TuneSize;
	}
	/**
	History:
		1.061:
			[S] Deprecated修正。
	*/
	override this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = Owner;
		NeGuiInfo.id    = Id;

		this(NeGuiInfo);

		SubClassOnNeGuiConstructor();
	}
	private class GroupLayout: LayoutManager {
		override this(NeGui Owner) {
			super(Owner);
			
			invariant Padding=GetControlPadding();
			
			padding.left   = Padding.cx * 2;
			padding.right  = Padding.cx * 2;
			padding.top    = 0;
			padding.bottom = Padding.cy * 2;
		}
		
		override void onSize(in int Width, in int Height) {
			RECT ContentSize = void;

			padding.top = padding.bottom/2 + minHeight;
			
			ContentSize.left = margin.left + padding.left;
			ContentSize.top  = margin.top  + padding.top;

			ContentSize.right  = Width  -  margin.right  - padding.right;
			ContentSize.bottom = Height -  margin.bottom - padding.bottom;

			onSize(ContentSize);
		}
		
		alias LayoutManager.onSize onSize;
	}
	/**
	History:
		1.061:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.style |= BS_GROUPBOX;
		super(NeGuiInfo);

		layoutManager = new GroupLayout(parent);
	}
	

	alias NeGui.font font;
	final override void font(in Font font) {
		super.font(font);
		foreach(child; children) {
			child.font = font;
		}
	}
	
	protected override {
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			if(TuneSize) {
				scope BaseFont=font;
				if(!BaseFont) {
					BaseFont = new Font(Font.STOCK.SYSTEM);
				}

				invariant Padding=GetControlPadding();
				invariant CtrlHeight=GetDefaultControlHeight(font);

				RECT InSize;
				
				InSize.left  = Padding.cx * 2;
				InSize.right = Width - InSize.left - Padding.cx * 2;

				InSize.top    = CtrlHeight;
				InSize.bottom = Height - InSize.top - Padding.cy * 2;
				
				TuneSize(Width, Height, CtrlHeight, InSize);
			}

			return true;
		}
		void OnDestroy() {
			SubClassOnNeGuiDestructor();
			super.OnDestroy();
		}

		OnEraseBackGroundDg OnEraseBackGround(Canvas canvas) {
			return cast(OnEraseBackGroundDg){
				scope brush  = new Brush(SYSTEMCOLOR.Frame);
				
				canvas.setBrush = brush;
				RECT Rect;

				auto Size=clientSize();
				Rect.right  = Size.cx;
				Rect.bottom = Size.cy;
				
				canvas.fillRect(Rect);
				
				return true;
			};
		}
	}
}

/***/
class RadioGroup: Group!(Radio) {
	mixin TGroupClass!(Radio);

	Radio checked() {
		foreach(radio; List) {
			if(radio.checked) {
				return radio;
			}
		}

		return null;
	}
	int checkIndex() {
		foreach(i, radio; List) {
			if(radio.checked) {
				return i;
			}
		}

		return -1;
	}
	
	void checked(Radio Target) {
		foreach(radio; List) {
			radio.checked = false;
			if(Target is radio) {
				Target.checked =true;
			}
		}
	}
}


