﻿/**
あ
*/
module nemuxi.negui.control.button.button;

debug import std.stdio: wl = writefln, pl = printf;

debug(button) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.icon;
import nemuxi.negui.draw.bitmap;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;

///
class ButtonException: ControlException {
	mixin MixInNeGuiException;
}

///
abstract class Button: Control, IHorizonAlign, IVerticalAlign, INotify, IOwnerDraw {
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	protected this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = Owner;
		NeGuiInfo.id    = Id;
		
		this(NeGuiInfo);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		if(!NeGuiInfo.className.length) {
			NeGuiInfo.className = "BUTTON";
		}
		
		super(NeGuiInfo);
	}

	///
	static enum TYPE {
		PUSH  = BS_PUSHBUTTON,
		CHECK = BS_CHECKBOX,
		RADIO = BS_RADIOBUTTON,
		GROUP = BS_GROUPBOX,
	}
	/***/
	final TYPE type() {
		auto Type=super.getItemInfo(GWL.STYLE);
		
		with(Button.TYPE) {
			if((Type & PUSH) == PUSH) {
				return PUSH;
			} else if((Type & CHECK) == CHECK) {
				return CHECK;
			} else if((Type & RADIO) == RADIO) {
				return RADIO;
			} else if((Type & GROUP) == GROUP) {
				return GROUP;
			} else {
				throw new ButtonException(Text("ボタンタイプ不明"));
			}
		}
	}

	mixin(SMixInItemStyleGetSet("notify", q{BS_NOTIFY}, true));
	mixin(SMixInItemStyleGetSet("ownerDraw", q{BS_OWNERDRAW}, true));

	static enum EVENT: MESSAGETYPE {
		CLICKED      = BN_CLICKED,
		DBLCLK       = BN_DBLCLK,
		DISABLE      = BN_DISABLE,
		DOUBLECLICKED= BN_DOUBLECLICKED,
		HILITE       = BN_HILITE,
		KILLFOCUS    = BN_KILLFOCUS,
		PAINT        = BN_PAINT,
		PUSHED       = BN_PUSHED,
		SETFOCUS     = BN_SETFOCUS,
		UNHILITE     = BN_UNHILITE,
		UNPUSHED     = BN_UNPUSHED,
	}
	
	
	mixin(SMixInItemStyleGetSetEx!(HORIZON_ALIGN, DWORD)(
		"horizonAlign", true, [
		q{HORIZON_ALIGN.RIGHT}, q{HORIZON_ALIGN.CENTER}, q{HORIZON_ALIGN.LEFT},
		q{BS_RIGHT},        q{BS_CENTER},        q{BS_LEFT}
	]));
	
	mixin(SMixInItemStyleGetSetEx!(VERTICAL_ALIGN, DWORD)(
		"verticaAlign", true, [
		q{VERTICAL_ALIGN.TOP}, q{VERTICAL_ALIGN.CENTER}, q{VERTICAL_ALIGN.BOTTOM},
		q{BS_TOP},            q{BS_VCENTER},           q{BS_BOTTOM}
	]));

	mixin(SMixInItemStyleGetSet("flat", q{BS_FLAT}, false));
	

	/// BM_CLICK
	void click() {
		super.send(BM_CLICK, NONE, NONE);
	}

	static enum IMAGE_TYPE {
		ICON   = BS_ICON,
		BITMAP = BS_BITMAP,
	}
	mixin(SMixInItemStyleGetSetEx!(IMAGE_TYPE, DWORD)(
		"imageType", false, [
		q{IMAGE_TYPE.ICON}, q{IMAGE_TYPE.BITMAP},
		q{BS_ICON},         q{BS_BITMAP}
	]));
	//やっつけすぎる
	private Draw ObjectType(HANDLE Handle)
	in {
		assert(Handle);
	}
	body {
		if(GetObjectType(Handle) == OBJ_BITMAP) {
			return new Bitmap(Handle, false);
		} else {
			return new Icon(Handle, false);
		}
	}
	protected Draw Image(IMAGE_TYPE ImageType, Draw draw) {
		int[IMAGE_TYPE] IMAGE = [
			IMAGE_TYPE.BITMAP : IMAGE_BITMAP,
			IMAGE_TYPE.ICON   : IMAGE_ICON
		];
		if(auto Handle=cast(HANDLE)super.send(BM_SETIMAGE, IMAGE[ImageType], cast(WPARAM)(draw ? draw(): null))) {
			return ObjectType(Handle);
		} else {
			return null;
		}
	}
	Icon image(Icon icon) {
		return cast(Icon)Image(IMAGE_TYPE.ICON, icon);
	}
	Bitmap image(Bitmap bmp) {
		return cast(Bitmap)Image(IMAGE_TYPE.BITMAP, bmp);
	}
}


class Push: Button {
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = Owner;
		NeGuiInfo.id    = Id;

		this(NeGuiInfo);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.style |= BS_PUSHBUTTON;

		super(NeGuiInfo);
	}

	mixin(SMixInItemStyleGetSet("def", q{BS_DEFPUSHBUTTON}));

	bool push() {
		return super.send(BM_GETSTATE, NONE, NONE) == BST_PUSHED;
	}
	void push(bool Push) {
		super.send(BM_SETSTATE, Push, NONE);
	}
}

///
abstract class Toggle: Button {
	mixin ControlClass;

	///
	static enum CHECK {
		UNCHECKED     = BST_UNCHECKED,     /// チェックされていない
		CHECKED       = BST_CHECKED,       /// チェックされている
		INDETERMINATE = BST_INDETERMINATE, /// グレー表示
	}
	CHECK check() {
		return cast(CHECK)super.send(BM_GETCHECK, NONE, NONE);
	}
	void check(CHECK Check) {
		send(BM_SETCHECK, Check, NONE);
	}
	bool checked() {
		return check == CHECK.CHECKED;
	}
	void checked(bool Flag) {
		return check = Flag ? CHECK.CHECKED: CHECK.UNCHECKED;
	}
}

class CheckBox: Toggle {
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	override this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = Owner;
		NeGuiInfo.id    = Id;

		this(NeGuiInfo);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.style |= BS_CHECKBOX | BS_AUTOCHECKBOX;

		super(NeGuiInfo);

		autoCheck = true;
	}
	
	mixin(SMixInItemStyleGetSet("tripleState", q{BS_3STATE}));
	mixin(SMixInItemStyleGetSet("autoState", q{BS_AUTO3STATE}));
	mixin(SMixInItemStyleGetSet("autoCheck", q{BS_AUTOCHECKBOX}));
	
}
class Radio: Toggle {
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	override this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = Owner;
		NeGuiInfo.id    = Id;

		this(NeGuiInfo);
	}
	/**
	History:
		1.032:
			新規作成。
	*/
	override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.style |= BS_AUTORADIOBUTTON;

		super(NeGuiInfo);
	}
	enum AUTO {
		NONE = BS_RADIOBUTTON,
		AUTO = BS_AUTORADIOBUTTON,
	}
	mixin(SMixInItemStyleGetSetEx!(AUTO, DWORD)(
		"autoCheck", false, [
		q{AUTO.NONE},      q{AUTO.AUTO},
		q{BS_RADIOBUTTON}, q{BS_AUTORADIOBUTTON}
	]));
}


