﻿/**


*/
module nemuxi.negui.com.ishelllink;

debug import std.stdio: wl = writefln;
debug(ishelllink) void main() {}

public static import shlobj=win32.shlobj;

import nemuxi.negui.com.com;

extern(C) {
	GUID IID_IShellLinkW  = {0x000214F9, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
	GUID IID_IShellLinkA  = {0x000214EE, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
}
version(Unicode) {
	alias IID_IShellLinkW IID_IShellLink;
} else {
	alias IID_IShellLinkA IID_IShellLink;
}

extern(C) {
	CLSID CLSID_ShellLink = {0x00021401, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
}

interface IShellLinkA: IUnknown {
	/+
	HRESULT QueryInterface(REFIID,PVOID*);
	ULONG AddRef();
	ULONG Release();
	+/
	HRESULT GetPath(LPSTR,int,WIN32_FIND_DATAA*,DWORD);
	HRESULT GetIDList(shlobj.LPITEMIDLIST*);
	HRESULT SetIDList(shlobj.LPCITEMIDLIST);
	HRESULT GetDescription(LPSTR,int);
	HRESULT SetDescription(LPCSTR);
	HRESULT GetWorkingDirectory(LPSTR,int);
	HRESULT SetWorkingDirectory(LPCSTR);
	HRESULT GetArguments(LPSTR,int);
	HRESULT SetArguments(LPCSTR);
	HRESULT GetHotkey(PWORD);
	HRESULT SetHotkey(WORD);
	HRESULT GetShowCmd(int*);
	HRESULT SetShowCmd(int);
	HRESULT GetIconLocation(LPSTR,int,int*);
	HRESULT SetIconLocation(LPCSTR,int);
	HRESULT SetRelativePath(LPCSTR ,DWORD);
	HRESULT Resolve(HWND,DWORD);
	HRESULT SetPath(LPCSTR);
}

interface IShellLinkW: IUnknown {
	/+
	HRESULT QueryInterface(REFIID,PVOID*);
	ULONG AddRef();
	ULONG Release();
	+/
	HRESULT GetPath(LPWSTR,int,WIN32_FIND_DATAW*,DWORD);
	HRESULT GetIDList(shlobj.LPITEMIDLIST*);
	HRESULT SetIDList(shlobj.LPCITEMIDLIST);
	HRESULT GetDescription(LPWSTR,int);
	HRESULT SetDescription(LPCWSTR);
	HRESULT GetWorkingDirectory(LPWSTR,int);
	HRESULT SetWorkingDirectory(LPCWSTR);
	HRESULT GetArguments(LPWSTR,int);
	HRESULT SetArguments(LPCWSTR);
	HRESULT GetHotkey(PWORD);
	HRESULT SetHotkey(WORD);
	HRESULT GetShowCmd(int*);
	HRESULT SetShowCmd(int);
	HRESULT GetIconLocation(LPWSTR,int,int*);
	HRESULT SetIconLocation(LPCWSTR,int);
	HRESULT SetRelativePath(LPCWSTR ,DWORD);
	HRESULT Resolve(HWND,DWORD);
	HRESULT SetPath(LPCWSTR);
}
version(Unicode) {
	alias IShellLinkW IShellLink;
} else {
	alias IShellLinkA IShellLink;
}

enum {
	SLR_NO_UI      = 1,
	SLR_ANY_MATCH  = 2,
	SLR_UPDATE     = 4,
	SLR_NOUPDATE   = 8,
	SLR_NOSEARCH   = 16,
	SLR_NOTRACK    = 32,
	SLR_NOLINKINFO = 64,
	SLR_INVOKE_MSI = 128
}

enum SLR {
	ANY_MATCH = SLR_ANY_MATCH, /// リンクを解決し、ユーザーからの情報が必要な場合にはダイアログボックスを表示する
	NO_UI     = SLR_NO_UI,     /// ユーザーからの情報が必要な場合でもダイアログボックスを表示しない（このフラグが指定された場合、fFlagsの上位ワードはタイムアウトまでの時間をミリ秒単位で指定します。これがゼロの時は、デフォルトとして3秒がタイムアウト時間となります。タイムアウト時間中にオブジェクトが見つからなかった場合、そのまま関数から帰ります。）
	UPDATE    = SLR_UPDATE,    /// リンクオブジェクトが変更されていた場合、リンクへのパスとアイテムIDリストを更新します
}

enum {
	SLGP_SHORTPATH   = 0x0001,
	SLGP_UNCPRIORITY = 0x0002,
	SLGP_RAWPATH     = 0x0004,
}
enum SLGP {
	SHORTPATH   = SLGP_SHORTPATH,   /// 短い形式（8.3形式）のファイル名を取得します。
	UNCPRIORITY = SLGP_UNCPRIORITY, /// UNCパス名を取得します。
	RAWPATH     = SLGP_RAWPATH,     /// 変換されていないパス名を取得します。環境変数が指定されている場合に、変換されない形で取得されます。
}



