﻿/**
COM。

win32のcom関係がバグってる可能性があるのでﾈﾑぃで使用する分は(安全と分かるまで)自前で実装。
diで変になるんでwin32\uuid.diをwin32\uuid.dに、中身を
----------------------------------------
module win32.uuid;

import win32.basetyps;

extern(C) {
	const IID GUID_NULL = {0x00000000, 0x0000, 0x0000, [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]};
}
----------------------------------------
だけに変更。

History:
	1.010:
		[S] packageをNeGuiに移動。

	1.00β13:
		[S]新規作成。このpackage以下のmoduleは全てこのmoduleより若いので新規作成は省略。
		
*/
module nemuxi.negui.com.com;

debug import std.stdio: wl = writefln;
debug(com) void main() {}

public import win32.windows;
public static import shlobj=win32.shlobj;

//public import nemuxi.negui.system.raii;
import nemuxi.negui.system.raii;
//public import nemuxi.system.exception;
import nemuxi.system.exception;

/**
History:
	1.020:
		[S] 継承元変更。
*/
class ComException: NeGuiException {
	mixin MixInNeGuiException;
}

void ComInitialize() {
	CoInitialize(null);
}

void ComUnInitialize() {
	CoUninitialize();
}

enum :DWORD {
	CLSCTX_INPROC_SERVER  = 0x01,
	CLSCTX_INPROC_HANDLER = 0x02,
	CLSCTX_LOCAL_SERVER   = 0x04,
	CLSCTX_ALL            = 0x17,
}
enum COM_CONTEXT: DWORD {
	INPROC_SERVER  = CLSCTX_INPROC_SERVER,  /// このクラスのオブジェクトを作成および管理するコードは、呼び出し側と同じプロセスで実行されるDLLです。
	INPROC_HANDLER = CLSCTX_INPROC_HANDLER, /// このクラスのオブジェクトを管理するコードはプロセス内ハンドラです。これはクライアントプロセス内で実行されるDLLで、クラスのインスタンスがリモートでアクセスされる際にこのクラスのクライアントサイド構造を作成します。
	LOCAL_SERVER   = CLSCTX_LOCAL_SERVER,   /// このクラスのオブジェクトを作成および管理するEXEコードは同じマシン上で実行されますが、別のプロセス空間にロードされます。
	ALL            = CLSCTX_ALL,            /// 上記の3つのフラグをすべて含んでいます。
}

abstract class ComBase: Raii {
	protected this(bool Suicide) {
		super(Suicide);
	}
	abstract {
		size_t addRef();
		size_t release();
		
		IUnknown iUnKnow();
	}
}


/**
ラッパー。

これでうまく行くのか非常に心配。
*/
class Com(TKnown: IUnknown): ComBase {
	protected TKnown Known;

	protected override void Kill() {
		if(Known) {
			Known.Release();
		}
	}

	protected this(bool Suicide) {
		super(Suicide);
	}
	
	this(const ref CLSID ClsID, const ref GUID GuID, Com Com, COM_CONTEXT Context, bool Suicide=true) {
		CoCreateInstance(&ClsID, Com ? Com.Known: null, Context, &GuID, cast(void**)&Known);
		this(true);
	}

	final {
		override {
			size_t addRef() {
				return Known.AddRef();
			}
			size_t release() {
				return Known.Release();
			}
		}
		Com!(T) query(T: IUnknown)(const ref GUID GuID) {
			auto com=new Com!(T)(false);
			
			if(Known.QueryInterface(cast(GUID*)&GuID, cast(void**)&com.Known) == S_OK) {
				com.Suicide = true;
				return com;
			}
			
			return null;
		}

		override IUnknown iUnKnow() {
			return Known;
		}
		TKnown opDot() {
			return Known;
		}
	}
}

