﻿/**
Note:
	NeGuiへ移動すべき。
	移動したけど要調整。
*/
module nemuxi.negui.clipboard;

debug import std.stdio: wl = writefln, pl = printf;
debug(clipboard) void main() {}

import std.contracts;

import win32.windows;

//import nemuxi.base;
import nemuxi.negui.system.base;
import nemuxi.negui.window.newindow;

///
class ClipBoardException: NeGuiException {
	mixin MixInNeGuiException;
}

typedef UINT CLIPDATA;

abstract class ClipBoard: Raii, IRaii {
	protected NeWindow window;
	
	override void Kill() {
		enforce(CloseClipboard(), new ClipBoardException(Text("クリップボード")));
	}

	private const void OpenException(string file=__FILE__, int line=__LINE__) {
		enforce(super.Suicide, new ClipBoardException(Text("開いていない？"), null, file, line));
	}
	
	this(NeWindow window) {
		super(false);
		this.window = window;
	}

	bool open() {
		if(super.Suicide) {
			super.kill();
		}
		super.Suicide = OpenClipboard(window())
			? true
			: false
		;

		return super.Suicide;
	}
	alias kill close;
	
	final const bool empty() {
		OpenException();
		
		return EmptyClipboard()
			? true
			: false
		;
	}

	/***/
	static enum TYPE :CLIPDATA {
		BITMAP          = CF_BITMAP,          /// ビットマップ データ（ビットマップ ハンドル）です。 
		DIB             = CF_DIB,             /// BITMAPINFO構造体とビット配列からなるビットマップデータです。 
		DIF             = CF_DIF,             /// Software Arts 社の DIF データ交換形式です。 
		DSPBITMAP       = CF_DSPBITMAP,       /// プライベートな形式のビットマップデータです。 
		DSPENHMETAFILE  = CF_DSPENHMETAFILE,  /// プライベートな形式の拡張メタファイルデータです。 
		DSPMETAFILEPICT = CF_DSPMETAFILEPICT, /// プライベートな形式のメタファイル画像表示形式データです。 
		DSPTEXT         = CF_DSPTEXT,         /// プライベートな形式のテキストデータです。 
		ENHMETAFILE     = CF_ENHMETAFILE,     /// 拡張メタファイルのデータ（enhanced metafile ハンドル）です。 
		GDIOBJFIRST     = CF_GDIOBJFIRST,     /// GDI オブジェクトによって表現される、アプリケーション定義のクリップボード形式です。 
		GDIOBJLAST      = CF_GDIOBJLAST,      /// ditto
		HDROP           = CF_HDROP,           /// ファイルドロップ形式です。 
		LOCALE          = CF_LOCALE,          /// テキストデータのロケール ID ハンドルです。 
		METAFILEPICT    = CF_METAFILEPICT,    /// METAFILEPICT 構造体のメモリオブジェクトです。メタファイル画像形式です。 
		PALETTE         = CF_PALETTE,         /// カラーパレットのハンドルです。 
		PENDATA         = CF_PENDATA,         /// Windows のペン拡張機能のためのデータです。 
		PRIVATEFIRST    = CF_PRIVATEFIRST,    /// プライベートなクリップボード形式です。 
		PRIVATELAST     = CF_PRIVATELAST,     /// ditto
		RIFF            = CF_RIFF,            /// RIFF 形式の音声データです。 
		SYLK            = CF_SYLK,            /// Microsoft シンボリックリンク (SYLK) 形式のデータです。 
		TEXT            = CF_TEXT,            /// テキスト形式のデータです。各行は復帰改行 (CR-LF) コードで終わります。データの終端は NULL 文字です。この形式は、ANSI テキストに使います。 
		WAVE            = CF_WAVE,            /// WAVE 形式の音声データです。 
		TIFF            = CF_TIFF,            /// TIFF 形式の画像データです。 
		UNICODETEXT     = CF_UNICODETEXT,     /// Unicode のテキスト形式です。各行は復帰改行 (CR-LF) コードで終わります。データの終端は NULL 文字です（WindowsNT系OSのみ）。 
	}
	HANDLE setData(CLIPDATA Type, void* Data) {
		OpenException();
		this.empty();
		return SetClipboardData(Type, cast(HANDLE)Data);
	}
}

class TextClipBoard: ClipBoard {
	override this(NeWindow window) {
		super(window);
	}
	
	bool set(in Text text) {
		HANDLE Memory=GlobalAlloc(GHND, text.length * wchar.sizeof + 1);
		if(Memory) {
			lstrcpy(cast(wchar*)GlobalLock(Memory), text.ptr);
			GlobalUnlock(Memory);
			bool Ret=super.open();
			Ret &= cast(bool)setData(TYPE.UNICODETEXT, cast(void*)Memory);
			Ret &= super.close();

			return Ret;
		}

		return false;
	}
}

