﻿/**

History:
	1.00β11:
		新規作成。
*/
module nemuxi.gui.window.nemuxiwindow.ver;

debug import std.stdio: wl = writefln, pl = printf;
debug(ver) void main() {}

//import std.string;
//import dmd=std.compiler; // 実質そうだし。

import win32.core;

import etc.kareki.kareki;

import nemuxi.gui.window.dialog.about.about;
import nemuxi.negui.window.newindow;
import nemuxi.image.icon;
import nemuxi.utility.simple.sysinfo;
import nemuxi.negui.file.file;
import nemuxi.negui.file.exever;

/**
History:
	1.00β18:
		[@] author_environment.txt.datからauthor_comment.txt.datにファイル名変更。
		[P] author_comment.txt.datからBOMを除去。
		[P] やっぱりユーザー環境を表示。
		[@] author_comment.txt.datに色々記述。
		
	1.00β15:
		[P] メッセージ記述ファイルをversion.aki.datからauthor_environment.txt.datに変更。
		
	1.00β13:
		ユーザー環境ではなく作者の環境に変更。
*/
final class NemuxiVersion: AboutDialog {
	this(NeWindow Owner) {
		auto k=new AkiDocument(splitlines(import("version.aki.dat")));
		STATUS Status;

		scope Ver=new Version(PATH.myPath);
		scope lng=Ver.langAndCode[0];

		with(Status) {
			name    = Ver.fileInfo(Version.TYPE.PRODUCTNAME,lng);//k["Name"].get!(string);
			ver     = Ver.fileInfo(Version.TYPE.FILEVERSION,lng);//k["Version"].get!(string);

			website = k["WebSite"].get!(string);
			mail    = k["Mail"].get!(string);

			message ~= import("author_comment.txt.dat");
			message ~= Text.newline;
			message ~= Text.repeat(Text('-'), 40);
			message ~= Text.newline;
			message ~= Text("君の環境");
			message ~= Text.newline;
			message ~= Text.repeat(Text('-'), 40);
			message ~= Text.newline;
			message ~= toTextInformation;
			
			icon    = GetSystemIcon(SYSICON.NEMUXI, Icon.FIXED.NORMAL);
		}
		

		super(Owner, Status);
	}
	/**
	History:
		1.00β19:
			[F] ♪
	*/
	void show() {
		MessageBeep(MB_ICONASTERISK);
		messageLoop(CENTER.WORKAREA);
	}
}

