﻿/**

*/
module nemuxi.gui.window.nemuxiwindow.tasktray;

debug(apptray) import std.stdio: wl = writefln, pl = printf;
debug(apptray) void main() {}

import win32.windows;

/+
import nemuxi.base;
import nemuxi.negui.system.raii;
import nemuxi.image.icon;
public import nemuxi.negui.tasktray;
import nemuxi.negui.window.newindow;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
+/
import nemuxi.negui.system.base;
import nemuxi.negui.tasktray;
import nemuxi.negui.draw.icon;
import nemuxi.image.icon;
import nemuxi.negui.window.newindow;
import nemuxi.system.log;
import nemuxi.system.staticdata;

package:

/**
*/
final class NemuxiTaskTray: TaskTray, IRaii {
	private Icon[] Icons;
	private DWORD  MessageID;
	/**
	History:
		1.032:
			[S] 属性変更。
	*/
	private const NeWindow window;

	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	override protected void Kill() {
		TASKTRAY Tray;
		
		Tray.initialize();
		Tray.window = window;
		
		for(auto i=0; i < Icons.length; i++) {
			Tray.id = i;
			//super.deleteTray(&Tray);
			super.deleteTray(Tray);
			delete Icons[i];
		}
		delete Icons;
	}

	/**
	History:
		1.032:
			[S] 引数属性変更。
	*/
	this(in NeWindow window, DWORD MessageID) {
		this.window    = window;
		this.MessageID = MessageID;

		super(true);

		this.add(GetSystemIcon(SYSICON.TASKTRAY, Icon.FIXED.SMALL));
	}

	/**
	History:
		1.032:
			[S] 上位クラスとの整合性。
	*/
	bool makeTray(size_t Id) {
		mixin(SMixInLog("NemuxiTaskTray", "makeTray"));
		
		assert(Icons);
		
		TASKTRAY Tray;
		
		//Tray.sizeInit;
		Tray.initialize;
		Tray.window  = window;
		Tray.id      = Id;
		//Tray.flags   = TASKTRAY.NIF.MESSAGE | TASKTRAY.NIF.ICON;
		Tray.flags   = TASKTRAY.FLAG.MESSAGE | TASKTRAY.FLAG.ICON;
		Tray.message = MessageID;
		Tray.icon    = Icons[Id];

		try {
			//return super.addTray(&Tray, true);
			return super.addTray(Tray, true, StaticData.taskTrayWait, StaticData.taskTrayRetry);
		} catch(TaskTrayException e) {
			log.write(e);
			return false;
		}
	}
	
	/**
	アイコンの追加。

	Params:
		icon = 追加するアイコン。

	Return:
		追加されたアイコンのインデックス。

	History:
		1.032:
			[P] 処理内容若干変更。
	*/
	size_t add(Icon icon) {
		Icons ~= icon;
		//return Icons.length - 1;
		return Icons.lastIndex;
	}
}

