﻿/**
*/
module nemuxi.gui.window.nemuxiwindow.proccessmenu;

debug import std.stdio: wl = writefln, pl = printf;

debug(proccessmenu) void main() {}

import win32.windows;
/+
import nemuxi.base;
import nemuxi.negui.draw.cursor;
import nemuxi.image.icon;
import nemuxi.negui.window.menu.datamenu;
import nemuxi.negui.window.window;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindowif;
+/
import nemuxi.negui.window.window;
import nemuxi.negui.window.menu.datamenu;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindowif;
import nemuxi.negui.input.mouse.mouse;
import nemuxi.system.exception;


typedef extern(Windows) BOOL function(HWND, LPARAM) EnumWindowsProcType;

final class ProcessListMenu: DataMenu!(OtherWindow) {
	private struct INDEX {
		COMMAND_ID Id;
		ProcessListMenu PLMenu;
	}
	
	this(Icon.FIXED IconFixed) {
		super(IconFixed);
	}
	
	void show(Window Owner) {
		POINT Point=void;
		//Cursor.getPos(Point);
			//Point = Cursor.getPos();
			Point = MOUSE.position();
		
		INDEX Index;
		Index.Id = 1;
		Index.PLMenu = this;
		EnumWindows(&EnumWindowsProc, cast(LPARAM)&Index);
		
		auto id=super.show(
			Owner,
			PopUp.FLAG.NONOTIFY | PopUp.FLAG.RETURNCMD,
			Point,
			null
		);

		if(!id) {
			return;
		}

		if(auto Target=data(id)) {
			if(Target.isAlive()) {
				if(Target.isSmall()) {
					Target.openSmall();
				} else {
					Target.pos(cast(NeGui.AFTER)HWND_TOP, 0 ,0 ,0 ,0, NeGui.SWP.NOMOVE | NeGui.SWP.NOSIZE);
				}
			} else {
				throw new NemuxiException("既に存在しないウィンドウ");
			}
		} else {
			throw new NemuxiException("AppButton_Proc_RButtonDown:ProcessListMenu.get(MENUITEM)");
		}
	}
	private static extern(Windows) BOOL EnumWindowsProc(HWND hWnd , LPARAM lParam)
	in {
		assert(IsWindow(hWnd));
	}
	body {
		auto window=new OtherWindow(hWnd);

		auto Index = cast(INDEX*)lParam;

		// 整理が必要
		if(!window() || !window.isVisible()) {
			return TRUE;
		}
		if(window.relation(NeGui.RELATION.OWNER)) {
			return TRUE;
		}
		auto style=window.getItemInfo(GWL_EXSTYLE);
		if(style & WS_EX_TOOLWINDOW) {
			return TRUE;
		}

		auto WindowText=window.text;
		if(!WindowText.length) {
			return TRUE;
		}

		DRAWMENUITEM DrawMenuItem=void;
		DrawMenuItem.text = WindowText.ptr;

		// ウィンドウから
		// 対応する大きさ
		//DrawMenuItem.icon = window.getIcon(Index.PLMenu.iconSize);
		auto IconSize=Index.PLMenu.iconSize;
		auto IconFixed=Icon.sizeToFixed(IconSize);
		DrawMenuItem.icon = window.getIcon(IconFixed);
		// クラスから
		// 対応する大きさ
		if(!DrawMenuItem.icon()) {
			//DrawMenuItem.icon = new Icon(cast(HICON)window.getClassInfo(Index.PLMenu.iconSize == Icon.FIXED.NORMAL ? GCL_HICON: GCL_HICONSM), false);
			DrawMenuItem.icon = new Icon(cast(HICON)window.getClassInfo(IconFixed == Icon.FIXED.NORMAL ? GCL_HICON: GCL_HICONSM), false);
		}
		// 見つからず
		if(!DrawMenuItem.icon()) {
			//DrawMenuItem.icon = new Icon(Icon.STOCK.APPLICATION, Index.PLMenu.iconSize);
			DrawMenuItem.icon = new Icon(Icon.STOCK.APPLICATION, IconFixed);
		}

		MENUITEM MenuItem;
		MenuItem.initialize();
		MenuItem.mask     = MENUITEM.MASK.ID | MENUITEM.MASK.TYPE | MENUITEM.MASK.DATA;
		MenuItem.type     = MENUITEM.TYPE.OWNERDRAW;
		MenuItem.id       = Index.Id++;
		//MenuItem.itemData = cast(void*)MENUS.PROCCESS;//hWnd;
		MenuItem.data     = cast(void*)MENUS.PROCCESS;//hWnd;
		Index.PLMenu.insert(MenuItem, &DrawMenuItem, window);

		return TRUE;
	}
}

