﻿/**
本体ウィンドウ。

いろいろ管理してるしこのpackageはもはや運命共同体。

*/
module nemuxi.gui.window.nemuxiwindow.nemuxiwindow;

debug import std.stdio: wl = writefln, pl = printf;
debug(nemuxiwindow) void main() {}
debug import std.random;

import core.memory;
import std.contracts;

import win32.windows;
import win32.commctrl;

debug {
	import nemuxi.test.itemdialog;
	import nemuxi.test.layoutdialog;
	import nemuxi.test.tabbbb;
	import nemuxi.test.childdialog;
	import nemuxi.test.debugdialog;
}

import nemuxi.negui.system.base;
import nemuxi.negui.system.controller;
import nemuxi.negui.window.window;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.mainwindow;
import nemuxi.negui.window.adtb;
import nemuxi.negui.window.menu.popup;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.draw.cursor;
import nemuxi.negui.input.keyboard.hotkey;
import nemuxi.negui.input.mouse.mouse;
import nemuxi.negui.environ.system;
import nemuxi.negui.file.file;

import nemuxi.system.application;
import nemuxi.system.exception;
import nemuxi.system.language;
import nemuxi.system.log;
import nemuxi.system.staticdata;
import nemuxi.dll.plugin.hooker.hooker;
import nemuxi.file.folder;
import nemuxi.file.setting;
import nemuxi.gui.window.nemuxiwindow.buttonlauncher;
import nemuxi.gui.window.nemuxiwindow.menulauncher;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindowif;
import nemuxi.gui.window.nemuxiwindow.proccessmenu;
import nemuxi.gui.window.nemuxiwindow.tasktray;
import nemuxi.gui.window.nemuxiwindow.titlebar;
import nemuxi.gui.window.nemuxiwindow.toolbar;
import nemuxi.gui.window.nemuxiwindow.tooltip;
import nemuxi.gui.window.nemuxiwindow.ver;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.gui.window.dialog.commanddialog.commanddialog;
import nemuxi.gui.window.dialog.settingdialog.settingdialog;


/**
History:
	1.00β13:
		[B] 文字列置き換え、問題ありまくり。
		
	1.00β12:
		Applicationを持つように変更中。
		これに伴いpackage、nemuxi.gui.window.nemuxiwindowの各クラス修正。
		全ファイル置き換えて修正しただけなんで多分問題ないはず。
*/
final class NemuxiWindow: MainWindow, IInitialize {
	private {
		static enum CTRL: ITEM_ID {
			BUTTONS=1,
			TITLE,
		}

		static enum HK: HOTKEY_ID {
			COMMAND = 1,
		}

		immutable NW = "NemuxiWindow";
	}
	public Application application;
	private {
		
		ApplicationDesktopToolBar AppDesktopToolbar;
		NemuxiTaskTray Tasktray;
		
		NemuxiToolBar  Toolbar;
		NemuxiToolTip  Tooltip;
		NemuxiTitleBar Titlebar;

		/// ボタン型
		ButtonLauncher Buttons;

		/// メニュー型ランチャーメニュー
		MenuLauncher Menus;

		/// プロセス一覧
		ProcessListMenu PLMenu;

		HotKey Hotkey;

		//フック
		HookerDLL Hooker;

		CommandDialog Command;

	}
	/**
	History:
		1.070:
			[P] システムメニューもういいや。
	
		1.061:
			[S] deprecated修正。
	*/
	this(Application application)
	in {
		assert(application);
	}
	body {
		this.application = application;
		/+
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.ExStyle      = WS_EX_TOOLWINDOW | WS_EX_WINDOWEDGE;
		NeGuiInfo.Style        = WS_THICKFRAME | WS_SYSMENU | WS_MINIMIZEBOX;
		
		super(NeGuiInfo);
		+/
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.exStyle = WS_EX_TOOLWINDOW;// | WS_EX_WINDOWEDGE;
		NeGuiInfo.style   = WS_SIZEBOX;
		super(NeGuiInfo);
		//super();
	}

	/**
	History:
		1.063:
			[P] サイズの取得方法を環境変わっても計算ミスっても取れるように変更。。
	*/
	private void BlockSize(ref SIZE PaddingSize, ref SIZE ButtonSize, ref SIZE TitleSize) {
		//パディング取得
		/+
		PaddingSize.cx = GetSystemMetrics(SM_CXDLGFRAME) * 2;
		PaddingSize.cy = GetSystemMetrics(SM_CYSIZEFRAME) * 2;
		+/
		/+
		PaddingSize=METRIC.frameSize;
		PaddingSize.cx <<= 1;
		PaddingSize.cy <<= 1;
		+/
		auto ItemSize=itemSize;
		auto ClientSize=clientSize;
		PaddingSize.cx = ItemSize.cx - ClientSize.cx;
		PaddingSize.cy = ItemSize.cy - ClientSize.cy;
		
		if(Toolbar.buttonCount) {
			ButtonSize = Toolbar.buttonSize(1);
		} else {
			ButtonSize.cx = GetSystemMetrics(SM_CXSMSIZE);
			ButtonSize.cy = GetSystemMetrics(SM_CYSMSIZE);
		}
		
		// タイトルバーサイズ(有効方向のみ)
		TitleSize.cx = Titlebar.isHorizon() ? Titlebar.getSize(): 0;
		TitleSize.cy = Titlebar.isHorizon() ? 0: Titlebar.getSize();
	}

	/**
	History:
		1.00β19:
			新規作成。
	*/
	private void ObjectDelete() {
		// GUIオブジェクト破棄
		mixin(SMixInLog(NW, "ObjectDelete"));
		/+
		if(Tasktray) {
			delete Tasktray;
		}
		if(Toolbar) {
			Toolbar.destroy();
			delete Toolbar;
		}
		if(Tooltip) {
			Tooltip.destroy();
			delete Tooltip;
		}
		if(Titlebar) {
			Titlebar.destroy();
			delete Titlebar;
		}
		if(Buttons) {
			delete Buttons;
		}

		if(Command && Command.alive) {
			Command.destroy;
		}
		delete Command;
		+/

		if(Tasktray) {
			delete Tasktray;
		}
		if(Toolbar) {
			Toolbar.destroy();
			delete Toolbar;
		}
		if(Tooltip) {
			Tooltip.destroy();
			delete Tooltip;
		}
		if(Titlebar) {
			Titlebar.destroy();
			delete Titlebar;
		}
		if(Buttons) {
			delete Buttons;
		}
		if(Menus) {
			delete Menus;
		}

		if(Command && Command.isAlive) {
			application.setting.exeCommandWidth = Command.clientSize.cx;
			Command.destroy;
		}
		delete Command;


		if(Hotkey) {
			delete Hotkey;
		}
		
		delete AppDesktopToolbar;

		if(Hooker) {
			if(Hooker.isRunning) {
				Hooker.stop;
			}
		}
		delete Hooker;
	}
	/**
	History:
		1.050:
			[P] タスクトレイ周りを若干変更。
		
		1.00β19:
			[S] 一部機能をObjectDeleteに移動。
	
		1.00β13:
			新規作成。
	*/
	void initialize() {
		//Logger.write("%s initialize start...", this.classinfo.name);
		//scope log=Logger.log(this.classinfo.name);
		//log.write("initialize start...");
		mixin(SMixInLog(NW, "initialize"));
		
		assert(application);
		ObjectDelete();
		// タスクトレイ
		Tasktray = new NemuxiTaskTray(this, WM_MY_MSG.TASKTRAY_MESSAGE);
		auto MakedTaskTray=Tasktray.makeTray(0);
		
		// ツールバー
		Toolbar = new NemuxiToolBar(this, CTRL.BUTTONS, application);
		Toolbar.initialize();

		// ツールチップ
		Tooltip = new NemuxiToolTip(this);

		// タイトルバー
		Titlebar = new NemuxiTitleBar(this, CTRL.TITLE);

		// ボタン型
		Buttons = new ButtonLauncher(Toolbar, Tooltip, Titlebar, application);

		// コマンド
		if(application.itemBase.length) {
			// チェックすんの面倒だしアイテム無けりゃ生成しない
			Command = new CommandDialog(this, application);
		}

		
		move(0, 0, 0, 0);
		//Logger.write("%s initialize end.", this.classinfo.name);
		if(!MakedTaskTray) {
			log.write("tasktary retry timer start.");
			if(!startTimer(WM_MY_MSG.TASKTRAY_RETRY, StaticData.taskTrayWait)) {
				log.write("retry state - failure.");
			}
		}
	}
	private bool NotFirst;
	/**
	History:
		1.00β14:
			applicationのnullチェック追加。

		1.00β13:
			[B] applicationによる重大なバグ修正。
	*/
	void dataLoad() {
		mixin(SMixInLog(NW, "dataLoad"));
		//Logger.write("%s dataLoad start...", this.classinfo.name);
		assert(application);
		
		if(NotFirst) {
			initialize;
		} else {
			NotFirst = true;
		}
		
		// ボタン型
		if(application.MainData.baseLength) {
			auto groups=application.initExeButtonGroup;
			if(groups) {
			application.changeMainGroup(groups[0]);
			application.changeSubGroup(groups[1]);
			}
			Buttons.setNowState();
		}

		delete Menus;
		Menus = new MenuLauncher(application);
		if(application.MenuData.baseLength) {
			application.changeMenuGroup(application.initExeMenuGroup());

			Menus.setNowState();
		}
	
		// ホットキー
		auto Keys=application.setting.exeCommandHotkey();
		delete Hotkey;
		Hotkey = new HotKey(this, HK.COMMAND, cast(MOD)Keys[0], cast(KEY)Keys[1]);
		if(!Hotkey.start()) {
			//Logger.write("ホットキー競合？");
			log.write("hotkey?");
		}

		// フック
		if(Hooker && Hooker.isRunning) {
			Hooker.stop;
		}
		delete Hooker;
		if(application.setting.exeMenuDeskTop) {
			log.write("desktop menu.");
			try {
				Hooker = new HookerDLL(this);
				Hooker.start;
			} catch(NemuxiException e) {
				log.write("desktop menu - failure.");
				log.write(e);
				//Logger.write(e);
				Hooker = null;
			}
		}
		
		// ウィンドウ表示方法
		auto pos=application.setting.position;
		delete AppDesktopToolbar;
		SetPosition(pos, false);
		
		// Z位置
		topMost(application.setting.front);
		
		//Logger.write("%s dataLoad end.", this.classinfo.name);
	}
	

	private void SetPosition(in Setting.POSITION NewPosition, bool Save=true) {
		mixin(SMixInLog(NW, "SetPosition"));
		assert(Titlebar);
		
		auto OldPosition=application.setting.position();
		if(application.isAppDeskTopToolBar(OldPosition)) {
			// 現在有効なら一旦登録解除
			delete AppDesktopToolbar;
			log.write("appbar - kill.");
		}
		// 現状を記録
		if(Save) {
			log.write("position - save.");
			auto Rect=itemRect;
			switch(OldPosition) {
				case Setting.POSITION.LEFT, Setting.POSITION.RIGHT:
					application.setting.barSize(OldPosition, Rect.right - Rect.left);
					break;
				case Setting.POSITION.TOP, Setting.POSITION.BOTTOM:
					application.setting.barSize(OldPosition, Rect.bottom - Rect.top);
					break;
				case Setting.POSITION.FLOAT: {
					POINT Point;
					Point.x = Rect.left;
					Point.y = Rect.top;
					SIZE Size;
					Size.cx = Rect.right  - Rect.left;
					Size.cy = Rect.bottom - Rect.top;

					application.setting.floatPos(Point);
					application.setting.floatSize(Size);
					break;
				}
				default:
			}
		}
		
		// 位置設定
		log.write("position - setting start.");
		RECT Rect;
		if(application.isAppDeskTopToolBar(NewPosition)) {
			log.write("window - bar.");
			AppDesktopToolbar = new ApplicationDesktopToolBar(this, WM_MY_MSG.APPDESKTOP_TOOLBAR);

			SIZE  Size;

			auto Bar=application.setting.barSize(NewPosition);
			
			SystemParametersInfo(SPI_GETWORKAREA, 0, &Rect, 0);
			
			switch(NewPosition) {
				case Setting.POSITION.LEFT:
					Rect.right  = Bar;
					break;
				case Setting.POSITION.RIGHT:
					Rect.left   = Rect.right - Bar;
					Rect.right  = Bar;
					break;
				case Setting.POSITION.TOP:
					Rect.bottom = Bar;
					break;
				case Setting.POSITION.BOTTOM:
					Rect.top    = Rect.bottom - Bar;
					Rect.bottom = Bar;
					break;
				default:
					assert(false);
			}
		} else if(NewPosition == Setting.POSITION.FLOAT) {
			log.write("window - float.");
			POINT Point = application.setting.floatPos();
			SIZE  Size  = application.setting.floatSize();

			Rect.left   = Point.x;
			Rect.top    = Point.y;
			Rect.right  = Size.cx;
			Rect.bottom = Size.cy;
		}
		
		log.write("position - %s", NewPosition);
		application.setting.position = NewPosition;
		
		with(ApplicationDesktopToolBar.POSITION) {
			void WindowSetter(TitleBar.POSITION Title) {
				assert(NewPosition != Setting.POSITION.SMALL);
				
				Titlebar.Position = Title;
				
				this.pos(NeGui.AFTER.NONE, Rect.left, Rect.top, Rect.right, Rect.bottom, SWP.DRAWFRAME | SWP.NOZORDER | SWP.FRAMECHANGED);
				this.reLoad();
				this.setShow(SHOW.SHOW);
			}
			void BarSetter(ApplicationDesktopToolBar.POSITION Position, TitleBar.POSITION Title) {
				WindowSetter(Title);
				AppDesktopToolbar.position = Position;
			}
			switch(NewPosition) {
				case Setting.POSITION.LEFT:
					BarSetter(LEFT, TitleBar.POSITION.TOP);
					break;
				case Setting.POSITION.TOP:
					BarSetter(TOP, TitleBar.POSITION.LEFT);
					break;
				case Setting.POSITION.RIGHT:
					BarSetter(RIGHT, TitleBar.POSITION.TOP);
					break;
				case Setting.POSITION.BOTTOM:
					BarSetter(BOTTOM, TitleBar.POSITION.LEFT);
					break;
				case Setting.POSITION.FLOAT:
					WindowSetter(TitleBar.POSITION.LEFT);
					break;
				case Setting.POSITION.SMALL:
					this.setShow(SHOW.HIDE);
					break;
				default:
					assert(false);
			}
		}
		reLoad;
	}

	
	protected override {
		/**
		History:
			1.00β19:
				[P] 破棄機能をObjectDeleteへ。
		*/
		void OnDestroy() {
			mixin(SMixInLog(NW, "OnDestroy"));
			/+
			if(Command && Command.alive) {
				Command.destroy;
			}
			delete Command;
			
			delete Buttons;
			delete Menus;
			
			delete Hotkey;
		
			delete AppDesktopToolbar;
			delete Tasktray;

			/*
			foreach(child; children) {
				child.destroy;
			}
			*/
			
			if(Hooker) {
				if(Hooker.isRunning) {
					Hooker.stop;
				}
			}
			delete Hooker;
			+/
			ObjectDelete();
			
			super.OnDestroy();
		}
		void OnCreate() {
			mixin(SMixInLog(NW, "OnCreate"));
			//Logger.write("%s.OnCreate method start...", this.classinfo.name);
			initialize;

			debug {
				dchar[] s=[
					1578, 1608, 1603, 1608, 1594, 1575, 1608, 1575,   32,
					1573, 1610, 1574, 1607,   45, 1610, 1575, 1587, 1608
				];
				text=Text(s);
			}
			//Logger.write("%s.OnCreate method end.", this.classinfo.name);
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender == Toolbar) {
				try {
					//auto item=Toolbar.buttonGet(Id);
					auto item=Toolbar.getItem(Id);
					application.executeItem(item);
				} catch(Exception e) {
					ShowExceptionDialog(this, e);
				}
				return true;
			}
			return false;
		}
		
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			Titlebar.onSize();

			auto PaddingWidth=Titlebar.getSize();

			try {
				auto Size = clientSize();
				
				if(Titlebar.isHorizon()) {
					Toolbar.move(PaddingWidth, 0, Size.cx - PaddingWidth, Size.cy, true);
				} else {
					Toolbar.move(0, PaddingWidth, Size.cx, Size.cy - PaddingWidth, true);
				}
			} catch(Exception e) {
				throw new NemuxiException("sizeTune:OwnerWnd.clientSize", EC.NONE, e);
			}

			return true;

		}
		void OnSizing(SIDEFLAG Sides, ref RECT Rect) {
			//パディング取得
			SIZE PaddingSize, ButtonSize, TitleSize;
			BlockSize(PaddingSize, ButtonSize, TitleSize);

			//左変更制限
			void SizingLeft() {
				Rect.left = 
				Rect.right - TitleSize.cx - ((Rect.right - Rect.left) / ButtonSize.cx) * ButtonSize.cx - PaddingSize.cx;
			}
			//右変更制限
			void SizingRight() {
				Rect.right =
				Rect.left + TitleSize.cx + ((Rect.right - Rect.left) / ButtonSize.cx) * ButtonSize.cx + PaddingSize.cx;
			}
			//上変更制限
			void SizingTop() {
				Rect.top  =
				Rect.bottom - TitleSize.cy - ((Rect.bottom - Rect.top) / ButtonSize.cy) * ButtonSize.cy-PaddingSize.cy;
			}
			//下変更制限
			void SizingBottom() {
				Rect.bottom =
				Rect.top + TitleSize.cy + ((Rect.bottom - Rect.top) / ButtonSize.cy) * ButtonSize.cy + PaddingSize.cy;
			}
			//
			//判定と計算。計算は内部関数で行う。内部関数の最適化等は後の課題
			final switch(Sides) {
				case SIDEFLAG.LEFT:        //左辺
					SizingLeft();
					break;
				case SIDEFLAG.RIGHT:       //右辺
					SizingRight();
					break;
				case SIDEFLAG.TOP:         //上辺
					SizingTop();
					break;
				case SIDEFLAG.TOPLEFT:     //左上隅
					SizingTop();
					SizingLeft();
					break;
				case SIDEFLAG.TOPRIGHT:    //右上隅
					SizingTop();
					SizingRight();
					break;
				case SIDEFLAG.BOTTOM:      //底辺
					SizingBottom();
					break;
				case SIDEFLAG.BOTTOMLEFT:  //左下隅
					SizingBottom();
					SizingLeft();
					break;
				case SIDEFLAG.BOTTOMRIGHT: //右下隅
					SizingBottom();
					SizingRight();
					break;
				//default: assert(0);
			}
		}

		/**
		Bugs:
			未実装。
		
		History:
			1.031:
				[B] 必要処理までversion(none)。
		*/
		bool OnMinMax(POINT* MaxSize, POINT* MaxPos, POINT* MaxTrack, POINT* MinTrack) {
			//パディング取得
			SIZE PaddingSize, ButtonSize, TitleSize;
			BlockSize(PaddingSize, ButtonSize, TitleSize);
			
			MinTrack.x = PaddingSize.cx + ButtonSize.cx + TitleSize.cx;
			MinTrack.y = PaddingSize.cy + ButtonSize.cy + TitleSize.cy;
			
			version(none) with(Setting.POSITION) switch(application.setting.position) {
				case LEFT:
					break;
				case TOP:
					break;
				case RIGHT:
					break;
				case BOTTOM:
					break;
				case FLOAT:
					break;
				default:
			}
			
			return true;
		}
		
		void OnActive(WINDOW_ACTIVE Active, bool NotSmall, HWND NextWnd) {
			Titlebar.onActive(Active);
			
			if(AppDesktopToolbar) {
				AppDesktopToolbar.onActivate();
			}
			
		}
		void OnHotKey(HOTKEY_ID Id, HOTKEY HotKey, KEY VKey) {
			switch(Id) {
				case HK.COMMAND:
				if(Command && Command.isAlive) {
					auto p=MOUSE.position();
					Command.position(p);
					Command.setShow(SHOW.SHOWNORMAL);
				}
						break;
				default:
					assert(false);
			}
		}
		
		void OnEnable(bool Enable) {
			if(Hotkey) if(Enable) {
				Hotkey.start;
			} else {
				Hotkey.stop;
			}
			if(Hooker) {
				if(Enable) {
					Hooker.start;
				} else {
					Hooker.stop;
				}
			}
		}

		void OnWindowPosChanged(ref WINDOWPOS WindowPos) {
			if(AppDesktopToolbar) {
				AppDesktopToolbar.onWindowPosChanged();
			}
		}
		private void AppDesktopToolbarPosition() {
			if(AppDesktopToolbar) {
				AppDesktopToolbar.position(AppDesktopToolbar.position());
			}
		}
		void OnExitSizeMove() {
			SetPosition(application.setting.position(), true);
			AppDesktopToolbarPosition();
		}
		void OnDisplayChange(int Bits, int Horizontal, int Vertical) {
			AppDesktopToolbarPosition();
		}

		void OnContexMenu(NeGui CatchItem, int x, int y) {
			Buttons.groupMenuSelect(this);
		}
		
		void OnMeasureItem(MEASUREITEM* Measure) {
			switch(cast(MENUS)Measure.data) {
				case MENUS.MENU:
					Menus.Executemenu.measureItem(this, Measure);
					return;
				case MENUS.BUTTON:
					Buttons.Listmenu.measureItem(this, Measure);
					break;
				case MENUS.FILE:
					Buttons.Filemenu.measureItem(this, Measure);
					break;
				case MENUS.PROCCESS:
					PLMenu.measureItem(this, Measure);
					break;
				default:
					assert(false);
			}
		}
		void OnDrawItem(ITEM_ID Id, DRAWITEM* DrawItem) {
			
			switch(DrawItem.type) {
				case CONTROL_TYPE.BUTTON: // アプリボタン
					assert(DrawItem.id == CTRL.TITLE);
					Titlebar.draw(DrawItem);
					return;
				case CONTROL_TYPE.MENU: // メニュー
					switch(cast(MENUS)DrawItem.data) {
						case MENUS.MENU:
							Menus.Executemenu.drawItem(DrawItem);
							return;
						case MENUS.BUTTON:
							Buttons.Listmenu.drawItem(DrawItem);
							return;
						case MENUS.FILE:
							Buttons.Filemenu.drawItem(DrawItem);
							return;
						case MENUS.PROCCESS:
							PLMenu.drawItem(DrawItem);
							return;
						default:
							assert(false);
					}
				default:
					assert(false);
			}
		}

		bool OnInitPupUpMenu(size_t Position, bool SystemFlag, Menu menu) {
			if(Buttons.Filemenu) {
				if(Buttons.Filemenu() == menu()) {
					Buttons.Filemenu.readFolder(ItemMenu.ITEMID.max+1);
				}
				return true;
			} else {
				return false;
			}
		}
		
		bool OnMouseMiddleDown(MOUSE_KEY Keys, int x, int y) {
			//auto Point=Cursor.getPos();
			auto Point=MOUSE.position();
			
			Menus.show(this, Point);

			return true;
		}

		/**
		History:
			1.00β12:
				新規作成。
		*/
		HIT_TEST OnNonClientHitTest(HIT_TEST HitFlag, int x, int y) {
			immutable HIT_TEST[][Setting.POSITION] table = [
				Setting.POSITION.LEFT:   [HIT_TEST.RIGHT,  HIT_TEST.TOPRIGHT,   HIT_TEST.BOTTOMRIGHT],
				Setting.POSITION.RIGHT:  [HIT_TEST.LEFT,   HIT_TEST.TOPLEFT,    HIT_TEST.BOTTOMLEFT],
				Setting.POSITION.TOP:    [HIT_TEST.BOTTOM, HIT_TEST.BOTTOMLEFT, HIT_TEST.BOTTOMRIGHT],
				Setting.POSITION.BOTTOM: [HIT_TEST.TOP,    HIT_TEST.TOPLEFT,    HIT_TEST.TOPRIGHT],
			];
			if(auto p=application.setting.position in table) {

				foreach(value; *p) {
					if(HitFlag == value) {
						return *p[0];
					}
				}

				return HIT_TEST.CLIENT;
			}
			return HitFlag;
		}
		
		/**
		History:
			1.00β12:
				新規作成。
		*/
		bool OnNonClientMouseLeftDown(HIT_TEST HitFlag, int x, int y) {
			if(HitFlag == HIT_TEST.CAPTION) {
				if(application.setting.position != Setting.POSITION.FLOAT) {
					return true;
				}
				assert(application.setting.position != Setting.POSITION.SMALL);
			}
			return false;
		}
		
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) {
			if(Id == CTRL.BUTTONS) {
				switch(Notify.code) {
					case ToolBar.EVENT.DROPDOWN:
						Buttons.itemShow(this, Notify);
						return 0;
					default:
						return 0;
				}
			}

			return 0;
		}

		/**
		History:
			1.032:
				[P] タスクトレイ周りの修正。
				
			1.00β12:
				一部文言修正。
		*/
		bool OnOtherEvent(UINT Message, WPARAM wParam, LPARAM lParam) {
			switch(Message) {
				case WM_MY_MSG.APPDESKTOP_TOOLBAR:
					OnAppDeskTopToolBar(wParam, lParam);
					return true;
				case WM_MY_MSG.TASKTRAY_MESSAGE:
					return OnTasktray(lParam);
				case WM_MY_MSG.BUTTONLIST:
					if(auto item=Buttons.listShow(this)) {
						application.executeItem(item);
					}
					return true;
				case WM_MY_MSG.SYSTEMMENU:
					SystemMenu(Titlebar);
					return true;
				case WM_MY_MSG.HOOKER:
					auto HookData = cast(HOOKDATA*)wParam;
					HookData.Chain = true;
					if(HookData.wParam == WM_MBUTTONDOWN) {
						const MouseHook = cast(MOUSEHOOKSTRUCT*)HookData.lParam;

						auto hWnd=WindowFromPoint(MouseHook.pt);
						const desk=Window.find(Text("Progman"), Text("Program Manager"));
						auto hTemp=hWnd;
						while(cast(bool)(hTemp = GetParent(hWnd))) {
							hWnd = hTemp;
						}
						if(desk == hWnd) {
							scope pause=new Pause(Hooker);
							send(WM_MBUTTONDOWN, NONE, NONE);
						}
					}
					return true;
				//case nemuxi.negui.tasktray.TaskTray.TaskBar:
				case nemuxi.negui.tasktray.TaskTray.WM_TASKBAR_CREATED:
					//Logger.write("タスクバー再登録につきタスクトレイへ再配置");
					mixin(SMixInLog("taskbar created", "WM_TASKBAR_CREATED"));
					
					if(Tasktray) {
						Tasktray.makeTray(0);
					} else {
						//Logger.write("タスクトレイに登録出来なかった？");
						log.write("failure.");
					}
					return true;
				default:
					return false;
			}
		}
		/**
		History:
			1.021:
				新規作成。
		*/
		void OnEndSession(bool ExitSession, END_SESSION EndSession) {
			mixin(SMixInLog(NW, "OnEndSession"));
			SaveApplication(application);
		}

		void OnTimer(in TIMER_ID Id) {
			switch(Id) {
				case WM_MY_MSG.TASKTRAY_RETRY:
					mixin(SMixInLog(NW, "OnTimer"));
					log.write("WM_MY_MSG.TASKTRAY_RETRY");
					if(Tasktray.makeTray(0)) {
						log.write("success - timer stop.");
						stopTimer(WM_MY_MSG.TASKTRAY_RETRY);
					} else {
						log.write("retry.");
					}
					return;
				default:
					break;
			}
		}
		
	}
	private {
		void OnAppDeskTopToolBar(WPARAM wParam, LPARAM lParam) {
			switch(wParam) {
				case ABN_POSCHANGED:
					AppDesktopToolbar.position(AppDesktopToolbar.position());
					break;
				case ABN_FULLSCREENAPP:
					if(lParam) {
						setShow(SHOW.HIDE);
					} else {
						setShow(SHOW.SHOWNORMAL);
					}
					break;
				default:
					break;
			}
		}
		bool OnTasktray(LPARAM lParam) {
			if(lParam == WM_LBUTTONDOWN || lParam == WM_RBUTTONUP || lParam == WM_MBUTTONDOWN) {
				if(enable) {
					foreGround();
					switch(lParam) {
						case WM_LBUTTONDOWN: // メニューーランチャ
							send(WM_MBUTTONDOWN, NONE, NONE);
							break;
						case WM_MBUTTONDOWN: {// プロセス一覧。
							PLMenu = new ProcessListMenu(application.setting.exeMenuIcon());
							PLMenu.show(this);
							delete PLMenu;
							break;
						}
						case WM_RBUTTONUP: // ﾈﾑぃメニュー
							SystemMenu();
							break;
						default:
							assert(false);
					}
					// マナー
					post(WM_NULL, NONE, NONE);
				} else {
					if(auto relation=relation(RELATION.ENABLEDPOPUP))
						relation.foreGround();
				}
				
				return true;
			}
			
			return false;
			
		}
	}

	/**
	History:
		1.060:
			[S] 引数追加。
			[F] 引数を親とするメニュー表示処理の追加。
	
		1.010:
			[F] 本体フォルダと設定フォルダ。
	
		1.00β19:
			[B] 設定ウィンドウ表示でメインウィンドウも表示中。
	
		1.00β11:
			バージョン情報部分修正。
	*/
	private void SystemMenu(NeGui Owner=null) {
		enum SYSMENU: COMMAND_ID {
			WINDOW=1,
			WINDOW_LEFT,
			WINDOW_TOP,
			WINDOW_RIGHT,
			WINDOW_BOTTOM,
			WINDOW_FLOAT,
			//WINDOW_SEP_1,
			WINDOW_TOPMOST,
			//WINDOW_SEP_2,
			WINDOW_SMALL,

			FOLDER,

			FOLDER_NEMUXI_NEMUXI,
			FOLDER_NEMUXI_USER,
			
			FOLDER_USER_DOCUMENT,
			FOLDER_USER_PICTURE,
			FOLDER_USER_MUSIC,
			FOLDER_USER_VIDEO,
			FOLDER_USER_PROFILE,
			
			FOLDER_USER_STARTMENU,
			FOLDER_USER_PROGRAMS,
			FOLDER_USER_STARTUP,
			FOLDER_USER_DESKTOPDIRECTORY,
			FOLDER_USER_RECENT,
			FOLDER_USER_SENDTO,

			FOLDER_COMPUTER,
			FOLDER_CONTROLPANEL,
			FOLDER_TRASH,
			FOLDER_NETWORK,
			
			FOLDER_SYSTEM_WINDOWS,
			FOLDER_SYSTEM_SYSTEM,
			FOLDER_SYSTEM_PROGRAM_FILES,

			FOLDER_ALLUSER,
			FOLDER_ALLUSER_DOCUMENTS,
			FOLDER_ALLUSER_PICTURES,
			FOLDER_ALLUSER_MUSIC,
			FOLDER_ALLUSER_VIDEO,

			FOLDER_ALLUSER_STARTMENU,
			FOLDER_ALLUSER_PROGRAMS,
			FOLDER_ALLUSER_STARTUP,
			FOLDER_ALLUSER_DESKTOPDIRECTORY,
			_FOLDER_END_,
			
			//SEP_1,
			SETTING,
			//SEP_2,
			HELP,
			//SEP_3,
			ABOUT,
			//SEP_4,
			EXIT,

			//---------
			DEBUG_SEP,
			DEBUG_DIALOG,
			CHILD_DIALOG,
			ITEM_DIALOG,
			LAYOUT_DIALOG,
			TAB_DIALOG,
			//---------

			TOOLS,
			
		}

		MENUITEM MenuItem;
		MenuItem.initialize();
		scope MainMenu  =new PopUp();
		scope MenuWindow=new PopUp();
		scope MenuFolder=new PopUp();
		scope MenuFolderAllUser=new PopUp();
		scope MenuTools =new PopUp();

		// ウィンドウ部分
		/+
		MenuWindow.insertText(SYSMENU.WINDOW_LEFT, Text("左部"), true);
		MenuWindow.insertText(SYSMENU.WINDOW_TOP, Text("上部"), true);
		MenuWindow.insertText(SYSMENU.WINDOW_RIGHT, Text("右部"), true);
		MenuWindow.insertText(SYSMENU.WINDOW_BOTTOM, Text("下部"), true);
		MenuWindow.insertText(SYSMENU.WINDOW_FLOAT, Text("フロート"), true);
		MenuWindow.insertSeparator(SYSMENU.WINDOW_SEP_1);
		MenuWindow.insertText(SYSMENU.WINDOW_TOPMOST, Text("最前面"), true);
		MenuWindow.insertSeparator(SYSMENU.WINDOW_SEP_2);
		MenuWindow.insertText(SYSMENU.WINDOW_SMALL, Text("非表示"), true);
		+/
		MenuWindow.insertText(SYSMENU.WINDOW_LEFT,    LanguageData.windowPosition(Setting.POSITION.LEFT),   true);
		MenuWindow.insertText(SYSMENU.WINDOW_TOP,     LanguageData.windowPosition(Setting.POSITION.TOP),    true);
		MenuWindow.insertText(SYSMENU.WINDOW_RIGHT,   LanguageData.windowPosition(Setting.POSITION.RIGHT),  true);
		MenuWindow.insertText(SYSMENU.WINDOW_BOTTOM,  LanguageData.windowPosition(Setting.POSITION.BOTTOM), true);
		MenuWindow.insertText(SYSMENU.WINDOW_FLOAT,   LanguageData.windowPosition(Setting.POSITION.FLOAT),  true);
		MenuWindow.insertSeparator();
		MenuWindow.insertText(SYSMENU.WINDOW_TOPMOST, LanguageData.window(LD.WINDOW.FRONT), true);
		MenuWindow.insertSeparator();
		MenuWindow.insertText(SYSMENU.WINDOW_SMALL,   LanguageData.windowPosition(Setting.POSITION.SMALL),  true);

		// ウィンドウ位置によるマーク付け
		COMMAND_ID PosCheck;
		switch(application.setting.position) {
			case Setting.POSITION.LEFT:   PosCheck = SYSMENU.WINDOW_LEFT;   break;
			case Setting.POSITION.TOP:    PosCheck = SYSMENU.WINDOW_TOP;    break;
			case Setting.POSITION.RIGHT:  PosCheck = SYSMENU.WINDOW_RIGHT;  break;
			case Setting.POSITION.BOTTOM: PosCheck = SYSMENU.WINDOW_BOTTOM; break;
			case Setting.POSITION.FLOAT:  PosCheck = SYSMENU.WINDOW_FLOAT;  break;
			case Setting.POSITION.SMALL:  PosCheck = SYSMENU.WINDOW_SMALL;  break;
			default: assert(false);
		}
		MenuWindow.radio(SYSMENU.WINDOW_LEFT, SYSMENU.WINDOW_SMALL, PosCheck);
		// 最前面設定
		MenuWindow.check(SYSMENU.WINDOW_TOPMOST, application.setting.front);

		/+
		//フォルダ
		MenuFolder.insertText(SYSMENU.FOLDER_NEMUXI, Text("本体フォルダ"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_USER, Text("ユーザーフォルダ"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_1);
		MenuFolder.insertText(SYSMENU.FOLDER_MY_DOCUMENT, Text("マイドキュメント"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_MY_PICTURE, Text("マイピクチャ"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_MY_MUSIC, Text("マイミュージック"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_MY_VIDEO, Text("マイビデオ"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_2);
		MenuFolder.insertText(SYSMENU.FOLDER_DESKTOP, Text("デスクトップ"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_STARTMENU, Text("スタートメニュー"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_STARTUP, Text("スタートアップ"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_SENDTO, Text("送る"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_FAVORITES, Text("お気に入り"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_3);
		MenuFolder.insertText(SYSMENU.FOLDER_COMPUTER, Text("マイコンピュータ"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_CONTROLPANEL, Text("コントロールパネル"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_NETWORK, Text("ネットワーク"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_RECENT, Text("最近使用したファイル"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_PRINTER, Text("プリンタ"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_FONTS, Text("フォント"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_4);
		MenuFolder.insertText(SYSMENU.FOLDER_TEMP, Text("テンポラリ"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_WINDOWS, Text("Windows"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_SYSTEM, Text("System"), true);
		MenuFolder.insertText(SYSMENU.FOLDER_PROGRAMS, Text("プログラムファイル"), true);
		+/
		
		MenuFolder.insertText(SYSMENU.FOLDER_NEMUXI_NEMUXI, LanguageData.nemuxiFolder(LD.NEMUXI_FOLDER.NEMUXI));
		MenuFolder.insertText(SYSMENU.FOLDER_NEMUXI_USER,   LanguageData.nemuxiFolder(LD.NEMUXI_FOLDER.USER));
		MenuFolder.insertSeparator();
		MenuFolder.insertText(SYSMENU.FOLDER_USER_DOCUMENT, LanguageData.systemFolder(SYSTEM_FOLDER.DOCUMENTS));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_PICTURE,  LanguageData.systemFolder(SYSTEM_FOLDER.PICTURES));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_MUSIC,    LanguageData.systemFolder(SYSTEM_FOLDER.MUSIC));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_VIDEO,    LanguageData.systemFolder(SYSTEM_FOLDER.VIDEO));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_PROFILE,  LanguageData.systemFolder(SYSTEM_FOLDER.PROFILE));
		MenuFolder.insertSeparator();
		MenuFolder.insertText(SYSMENU.FOLDER_USER_STARTMENU,        LanguageData.systemFolder(SYSTEM_FOLDER.STARTMENU));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_PROGRAMS,         LanguageData.systemFolder(SYSTEM_FOLDER.PROGRAMS));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_STARTUP,          LanguageData.systemFolder(SYSTEM_FOLDER.STARTUP));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_DESKTOPDIRECTORY, LanguageData.systemFolder(SYSTEM_FOLDER.DESKTOPDIRECTORY));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_RECENT,           LanguageData.systemFolder(SYSTEM_FOLDER.RECENT));
		MenuFolder.insertText(SYSMENU.FOLDER_USER_SENDTO,           LanguageData.systemFolder(SYSTEM_FOLDER.SENDTO));
		MenuFolder.insertSeparator();
		MenuFolder.insertText(SYSMENU.FOLDER_COMPUTER,     LanguageData.systemFolder(SYSTEM_FOLDER.COMPUTER));
		MenuFolder.insertText(SYSMENU.FOLDER_CONTROLPANEL, LanguageData.systemFolder(SYSTEM_FOLDER.CONTROLPANEL));
		MenuFolder.insertText(SYSMENU.FOLDER_TRASH,        LanguageData.systemFolder(SYSTEM_FOLDER.TRASH));
		MenuFolder.insertText(SYSMENU.FOLDER_NETWORK,      LanguageData.systemFolder(SYSTEM_FOLDER.NETWORK));
		MenuFolder.insertSeparator();
		MenuFolder.insertText(SYSMENU.FOLDER_SYSTEM_WINDOWS,       LanguageData.systemFolder(SYSTEM_FOLDER.WINDOWS));
		MenuFolder.insertText(SYSMENU.FOLDER_SYSTEM_SYSTEM,        LanguageData.systemFolder(SYSTEM_FOLDER.SYSTEM));
		MenuFolder.insertText(SYSMENU.FOLDER_SYSTEM_PROGRAM_FILES, LanguageData.systemFolder(SYSTEM_FOLDER.PROGRAM_FILES));
		MenuFolder.insertSeparator();
		MenuFolder.insertSubMenu(SYSMENU.FOLDER_ALLUSER, LanguageData.allUser,  MenuFolderAllUser);
		
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_DOCUMENTS, LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_DOCUMENTS));
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_PICTURES,  LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_PICTURES));
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_MUSIC,     LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_MUSIC));
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_VIDEO,     LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_VIDEO));
		MenuFolderAllUser.insertSeparator();
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_STARTMENU,        LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_STARTMENU));
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_PROGRAMS,         LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_PROGRAMS));
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_STARTUP,          LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_STARTUP));
		MenuFolderAllUser.insertText(SYSMENU.FOLDER_ALLUSER_DESKTOPDIRECTORY, LanguageData.systemFolder(SYSTEM_FOLDER.ALLUSER_DESKTOPDIRECTORY));

		//ツールメニュー
		//MenuTools.insertText

		// 親メニュー
		/+
		MainMenu.insertSubMenu(SYSMENU.WINDOW, Text("ウィンドウ"), MenuWindow, true);
		//MainMenu.insertSubMenu(SYSMENU.FOLDER, Text("フォルダ"), MenuFolder, true);
		MainMenu.insertSubMenu(SYSMENU.TOOLS, Text("ツール"), MenuTools, false);
		MainMenu.insertSeparator(SYSMENU.SEP_1);
		MainMenu.insertText(SYSMENU.SETTING, Text("設定"), true);
		MainMenu.insertSeparator(SYSMENU.SEP_2);
		MainMenu.insertText(SYSMENU.HELP, Text("ヘルプ"), FILE.isExistence(StaticData.help));
		MainMenu.insertSeparator(SYSMENU.SEP_3);
		MainMenu.insertText(SYSMENU.ABOUT, Text("バージョン"), true);
		MainMenu.insertSeparator(SYSMENU.SEP_4);
		MainMenu.insertText(SYSMENU.EXIT, Text("終了"), true);
		+/
		MainMenu.insertSubMenu(SYSMENU.WINDOW, LanguageData.taskTrayMenu(LD.TASKTRAY_MENU.WINDOW),  MenuWindow, true);
		MainMenu.insertSubMenu(SYSMENU.FOLDER, LanguageData.taskTrayMenu(LD.TASKTRAY_MENU.FOLDER),  MenuFolder, true);
		debug MainMenu.insertSubMenu(SYSMENU.TOOLS,  LanguageData.taskTrayMenu(LD.TASKTRAY_MENU.TOOLS),   MenuTools, false);
		MainMenu.insertSeparator();
		MainMenu.insertText(SYSMENU.SETTING, LanguageData.taskTrayMenu(LD.TASKTRAY_MENU.SETTING), true);
		MainMenu.insertSeparator();
		MainMenu.insertText(SYSMENU.HELP,    LanguageData.taskTrayMenu(LD.TASKTRAY_MENU.HELP),    FILE.isExistence(StaticData.help));
		MainMenu.insertSeparator();
		MainMenu.insertText(SYSMENU.ABOUT,   LanguageData.taskTrayMenu(LD.TASKTRAY_MENU.ABOUT),   true);
		MainMenu.insertSeparator();
		MainMenu.insertText(SYSMENU.EXIT,    LanguageData.taskTrayMenu(LD.TASKTRAY_MENU.QUIT),    true);

		
		debug {
			MainMenu.insertSeparator(SYSMENU.DEBUG_SEP);
			MainMenu.insertText(SYSMENU.DEBUG_DIALOG, Text("dialog"), true);
			MainMenu.insertText(SYSMENU.CHILD_DIALOG, Text("child"), true);
			MainMenu.insertText(SYSMENU.ITEM_DIALOG, Text("items"), true);
			MainMenu.insertText(SYSMENU.LAYOUT_DIALOG, Text("layout"), true);
			MainMenu.insertText(SYSMENU.TAB_DIALOG, Text("tab"), true);
		}
		

		COMMAND_ID id;
		if(Owner) {
			id=MainMenu.attach(this, Owner, PopUp.ATTACH.RIGHT, PopUp.MESSAGE.NONE | PopUp.MESSAGE.RETURN);
		} else {
			id=MainMenu.show(this, PopUp.FLAG.RETURNCMD);
		}


		//if(auto id=MainMenu.show(this, PopUp.FLAG.RETURNCMD)) {//}
		if(id) {
			//assert(id != SYSMENU.WINDOW_SEP_1);
			//assert(id != SYSMENU.WINDOW_SEP_2);
			/+
			assert(id != SYSMENU.FOLDER_SEP_1);
			assert(id != SYSMENU.FOLDER_SEP_2);
			assert(id != SYSMENU.FOLDER_SEP_3);
			assert(id != SYSMENU.FOLDER_SEP_4);
			+/
			/+
			assert(id != SYSMENU.SEP_1);
			assert(id != SYSMENU.SEP_2);
			assert(id != SYSMENU.SEP_3);
			assert(id != SYSMENU.SEP_4);
			+/
			if(SYSMENU.FOLDER <= id && id <= SYSMENU._FOLDER_END_) {
				// フォルダ
				switch(cast(SYSMENU)id) {
					case SYSMENU.FOLDER_NEMUXI_NEMUXI            : application.executePath(PATH.myFolder);               break;
					case SYSMENU.FOLDER_NEMUXI_USER              : application.executePath(StaticData.dataFolder);               break;
					
					case SYSMENU.FOLDER_USER_DOCUMENT            : application.executePath(GetSystemFolder(SYSTEM_FOLDER.DOCUMENTS));               break;
					case SYSMENU.FOLDER_USER_PICTURE             : application.executePath(GetSystemFolder(SYSTEM_FOLDER.PICTURES));                break;
					case SYSMENU.FOLDER_USER_MUSIC               : application.executePath(GetSystemFolder(SYSTEM_FOLDER.MUSIC));                   break;
					case SYSMENU.FOLDER_USER_VIDEO               : application.executePath(GetSystemFolder(SYSTEM_FOLDER.VIDEO));                   break;
					case SYSMENU.FOLDER_USER_PROFILE             : application.executePath(GetSystemFolder(SYSTEM_FOLDER.PROFILE));                 break;
					case SYSMENU.FOLDER_USER_STARTMENU           : application.executePath(GetSystemFolder(SYSTEM_FOLDER.STARTMENU));               break;
					case SYSMENU.FOLDER_USER_PROGRAMS            : application.executePath(GetSystemFolder(SYSTEM_FOLDER.PROGRAMS));                break;
					case SYSMENU.FOLDER_USER_STARTUP             : application.executePath(GetSystemFolder(SYSTEM_FOLDER.STARTUP));                 break;
					case SYSMENU.FOLDER_USER_DESKTOPDIRECTORY    : application.executePath(GetSystemFolder(SYSTEM_FOLDER.DESKTOPDIRECTORY));        break;
					case SYSMENU.FOLDER_USER_RECENT              : application.executePath(GetSystemFolder(SYSTEM_FOLDER.RECENT));                  break;
					case SYSMENU.FOLDER_USER_SENDTO              : application.executePath(GetSystemFolder(SYSTEM_FOLDER.SENDTO));                  break;
					case SYSMENU.FOLDER_COMPUTER                 : application.executePath(GetSystemFolder(SYSTEM_FOLDER.COMPUTER));                break;
					case SYSMENU.FOLDER_CONTROLPANEL             : application.executePath(GetSystemFolder(SYSTEM_FOLDER.CONTROLPANEL));            break;
					case SYSMENU.FOLDER_TRASH                    : application.executePath(GetSystemFolder(SYSTEM_FOLDER.TRASH));                   break;
					case SYSMENU.FOLDER_NETWORK                  : application.executePath(GetSystemFolder(SYSTEM_FOLDER.NETWORK));                 break;
					case SYSMENU.FOLDER_SYSTEM_WINDOWS           : application.executePath(GetSystemFolder(SYSTEM_FOLDER.WINDOWS));                 break;
					case SYSMENU.FOLDER_SYSTEM_SYSTEM            : application.executePath(GetSystemFolder(SYSTEM_FOLDER.SYSTEM));                  break;
					case SYSMENU.FOLDER_SYSTEM_PROGRAM_FILES     : application.executePath(GetSystemFolder(SYSTEM_FOLDER.PROGRAM_FILES));           break;
					case SYSMENU.FOLDER_ALLUSER                  : assert(false);
					case SYSMENU.FOLDER_ALLUSER_DOCUMENTS        : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_DOCUMENTS));       break;
					case SYSMENU.FOLDER_ALLUSER_PICTURES         : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_PICTURES));        break;
					case SYSMENU.FOLDER_ALLUSER_MUSIC            : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_MUSIC));           break;
					case SYSMENU.FOLDER_ALLUSER_VIDEO            : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_VIDEO));           break;
					case SYSMENU.FOLDER_ALLUSER_STARTMENU        : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_STARTMENU));       break;
					case SYSMENU.FOLDER_ALLUSER_PROGRAMS         : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_PROGRAMS));        break;
					case SYSMENU.FOLDER_ALLUSER_STARTUP          : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_STARTUP));         break;
					case SYSMENU.FOLDER_ALLUSER_DESKTOPDIRECTORY : application.executePath(GetSystemFolder(SYSTEM_FOLDER.ALLUSER_DESKTOPDIRECTORY));break;
					default: assert(false);
				}
			} else if(SYSMENU.WINDOW_LEFT <= id && id <= SYSMENU.WINDOW_SMALL) {
				// ウィンドウ
				if(id == SYSMENU.WINDOW_TOPMOST) {
					application.setting.front(!application.setting.front);
					this.topMost(application.setting.front);
				} else {
					Setting.POSITION Position;
					switch(id) {
						case SYSMENU.WINDOW_LEFT:   Position = Setting.POSITION.LEFT;   break;
						case SYSMENU.WINDOW_TOP:    Position = Setting.POSITION.TOP;    break;
						case SYSMENU.WINDOW_RIGHT:  Position = Setting.POSITION.RIGHT;  break;
						case SYSMENU.WINDOW_BOTTOM: Position = Setting.POSITION.BOTTOM; break;
						case SYSMENU.WINDOW_FLOAT:  Position = Setting.POSITION.FLOAT;  break;
						case SYSMENU.WINDOW_SMALL:  Position = Setting.POSITION.SMALL;  break;
						default: assert(false);
					}
					SetPosition(Position, true);
					//application.setting.position=SetPosition(window, application.setting.position, Position);
				}
			} else if(SYSMENU.TOOLS <= id) {
				// ツール
			} else {
				// 本体メニュー
				switch(id) {
					case SYSMENU.SETTING: {
						/+
						// モードレスなやつの処理とかをすべき -------
						scope Window[] windows;
						scope bool[]   enables;
						
						if(cast(bool)(windows=getNeGuiWindow)) {
							enables = new bool[windows.length];
							for(auto i=0; i < windows.length; i++) {
								enables[i] = windows[i].enable;
								windows[i].enable =false;;
							}
						}
						void Release() {
							for(auto i=0; i < windows.length; i++) {
								if(windows[i].alive) {
									windows[i].enable = enables[i];
								}
							}
						}
						// ------------------------------------------
						+/
						scope myChildren=getNeGuiWindow;
						myChildren.lock(MyChildren.MODE.ENABLE);
						auto position = application.setting.position;
						SetPosition(application.setting.position, true);
						delete AppDesktopToolbar;
						
						auto Setting = new SettingDialog(this, application);
						if(Setting.select) {
							//Release();
							myChildren.release;
							
							delete application;
							application=MakeApplication;
							dataLoad();
					//SetPosition(application.setting.position, true);
						} else {
							//Release;
							myChildren.release;
						SetPosition(position, true);
							
						}
						break;
					}
					case SYSMENU.HELP:
						application.executePath(StaticData.help);
						break;
					case SYSMENU.ABOUT:
						//MessageDialog.show(Text("1.00β11"));
						scope myChildren=getNeGuiWindow;
						myChildren.lock(MyChildren.MODE.ENABLE);
						auto ver=new NemuxiVersion(this);
						ver.show();
						myChildren.release;
						break;
					case SYSMENU.EXIT:
						this.destroy();
						break;
					debug {
						case SYSMENU.DEBUG_DIALOG:
							auto a=new DebugDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
						case SYSMENU.CHILD_DIALOG:
							auto a=new ChildDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
						case SYSMENU.ITEM_DIALOG:
							auto a=new ItemDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
						case SYSMENU.LAYOUT_DIALOG:
							auto a=new LayoutDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
						case SYSMENU.TAB_DIALOG:
							auto a=new TabDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
					}
					default:
						assert(false);
				}
			}
		}
	}
}

