﻿/**
ボタン型ランチャの心臓
*/
module nemuxi.gui.window.nemuxiwindow.buttonlauncher;

debug(buttonlauncher) import std.stdio: wl = writefln, pl = printf;
debug(buttonlauncher) void main() {}

import std.string;
import std.file;
import std.contracts;

import win32.windows;
import win32.commctrl;

/+
import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.file.file;
import nemuxi.negui.file.find;
import nemuxi.file.exec;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.structure;
import nemuxi.file.items.group;
import nemuxi.negui.window.window;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.menu.ownerdraw;
import nemuxi.negui.window.menu.datamenu;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.draw.cursor;
import nemuxi.image.icon;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindowif;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
import nemuxi.gui.window.nemuxiwindow.toolbar;
import nemuxi.gui.window.nemuxiwindow.titlebar;
import nemuxi.gui.window.nemuxiwindow.tooltip;
import nemuxi.negui.clipboard
import nemuxi.gui.window.dialog.execdialog.execdialog;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
+/

import nemuxi.gui.window.nemuxiwindow.toolbar;
import nemuxi.gui.window.nemuxiwindow.tooltip;
import nemuxi.gui.window.nemuxiwindow.titlebar;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindowif;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.group;
import nemuxi.file.items.structure;
import nemuxi.file.items.item;
import nemuxi.system.application;
import nemuxi.negui.input.mouse.mouse;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.menu.popup;
import nemuxi.negui.window.menu.datamenu;
import nemuxi.negui.draw.cursor;
import nemuxi.negui.control.control;
import nemuxi.negui.file.file;
import nemuxi.negui.file.find;
import nemuxi.system.staticdata;
import nemuxi.system.language;
import nemuxi.image.icon;
import nemuxi.negui.clipboard;
import nemuxi.gui.window.dialog.execdialog.execdialog;
import nemuxi.file.exec;
import nemuxi.system.log;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.negui.environ.variable;


/***/
final class ButtonLauncher {
	GroupMenu Groupmenu;
	
	ButtonListMenu Listmenu;
	ItemMenu       Itemmenu;
	ItemFileMenu   Filemenu;
	
	NemuxiToolBar  Toolbar;
	NemuxiToolTip  Tooltip;
	NemuxiTitleBar Titlebar;
	
	BMITEM[] BMItems;
	Application application;
	
	this(NemuxiToolBar Toolbar, NemuxiToolTip Tooltip, NemuxiTitleBar Titlebar, Application application)
	in {
		assert(Toolbar);
	}
	body {
		this.Toolbar = Toolbar;
		this.Tooltip = Tooltip;
		this.Titlebar = Titlebar;

		this.application = application;
	}
	~this() {
		delete Groupmenu;
		delete Listmenu;
		delete Filemenu;
		delete Itemmenu;
		delete BMItems;
	}

	/**
	History:
		1.00β17:
			[P] アイテムツールチップの変更。
	*/
	void toolTipSet() {
		TOOLINFO ToolInfo;
		ToolInfo.cbSize = ToolInfo.sizeof;
		ToolInfo.hwnd   = Toolbar();
		ToolInfo.hinst  = GetModuleHandle(null);
		ToolInfo.uFlags = TTF_SUBCLASS;
		
		for(COMMAND_ID i=0; i < Toolbar.buttonCount; i++) {
			//auto item=Toolbar.buttonGet(i+1);
			auto item=Toolbar.getItem(i+1);
			ToolInfo.rect = Toolbar.buttonRect(i);
			
			ToolInfo.uId      = i+1;
			ToolInfo.lpszText = item.toTextInfo.ptr;
			
			Tooltip.send(TTM_DELTOOL, Tooltip.NONE, cast(LPARAM)&ToolInfo);
			Tooltip.send(TTM_ADDTOOL, Tooltip.NONE, cast(LPARAM)&ToolInfo);
		}
		Toolbar.send(TB_SETTOOLTIPS, cast(WPARAM)Tooltip(), NeGui.NONE);
	}
	/**
	applicationの設定に基づいて設定。
	*/
	void setNowState() {
		delete Listmenu;
		delete BMItems;
		
		if(application.getMainGroupName.length && application.getSubGroupName.length) {
			BMItems   = application.getExeButtonItems(application.getMainGroupName, application.getSubGroupName);
			Groupmenu = new GroupMenu(application.MainData, application.getMainGroupName, application.getSubGroupName);
		}
		
		Toolbar.buttonSet(BMItems, application.setting.exeButtonText(), application.setting.exeButtonIcon());
		if(BMItems.length)
		Listmenu = new ButtonListMenu(application.setting.exeButtonIcon(), BMItems);
		Toolbar.list(application.setting.exeButtonList());
		Toolbar.buttonWidth(application.setting.exeButtonText(), application.setting.exeButtonList(),application.setting.exeButtonIcon());
		toolTipSet();
	}
	
	void groupMenuSelect(NeWindow Owner) {
		if(!Groupmenu) {
			return;
		}
		
		auto GroupIndex=Groupmenu.show(Owner);
		if(!GroupIndex[0] && !GroupIndex[1]) {
			return;
		}
		Text MainGroupName, SubGroupName;
		application.getButtonGroupName(GroupIndex[0], GroupIndex[1], MainGroupName, SubGroupName);

		assert(MainGroupName.length);
		assert(SubGroupName.length);
		application.changeMainGroup(MainGroupName);
		application.changeSubGroup(SubGroupName);

		setNowState();
	}

	Item listShow(NeWindow Owner) {
		if(!Listmenu) {
			return null;
		}
		
		return Listmenu.show(Owner, Titlebar);
	}

	void itemShow(NeWindow Owner, NOTIFY* Notify) {
		assert(!Itemmenu);
		assert(!Filemenu);
		
		try {
			Itemmenu = new ItemMenu(application.setting.exeButtonIcon(), Toolbar, cast(NMTOOLBAR*)Notify, Filemenu);
			Itemmenu.show(Owner, application);
		} finally {
			Filemenu=null;
			delete Itemmenu;
		}
	}
}

/**
History:
	1.00β19:
		[B] 選択中メイングループに無効サブグループが有効。
*/
final class GroupMenu: PopUp {
	this(Main MainGroup, Text MainGroupName, Text SubGroupName)
	in {
		assert(MainGroup);
		assert(MainGroupName.length);
		assert(SubGroupName.length);
	}
	body {
		super();
		
		MENUITEM MainItem;
		MainItem.initialize();
		
		with(MainItem) {
			mask  = MASK.ID | MASK.STATE | MASK.SUBMENU | MASK.TYPE;
			type  = TYPE.STRING;
		}
		
		// メイングループ
		auto BreakLine=MainGroup.baseLength;
		Sub ViewSubGroup;
		with(MENUITEM) foreach(i, MainName; MainGroup.baseNames) {
			assert(i < short.max-1);
			
			auto NowMain = MainName == MainGroupName;
			
			try {
				// サブグループ。これが有効でなければ例外を出す。
				Sub SubGroup = errnoEnforce(MainGroup.subGroup(MainName), "無害な例外");
				if(NowMain) {
					ViewSubGroup = SubGroup;
				}
				// 先にサブグループ作成
				PopUp SubGroupMenu=null;
				
				//foreach(j, SubName; SubGroup()) {//}
				foreach(j, SubName; SubGroup.baseNames()) {
					assert(j < short.max-1);
					MENUITEM SubItem;
					SubItem.initialize();
					with(SubItem) {
						mask  = MASK.ID | MASK.STATE | MASK.TYPE;
						type  = TYPE.STRING;
					}
					
					if(!j) {
						SubGroupMenu=new PopUp();
					}
					
					auto NowSub=NowMain && (SubName == SubGroupName);
					
					SubItem.id       = cast(COMMAND_ID)(MAKELONG(cast(ushort)(i+1), cast(ushort)(j+1)));
					SubItem.state    = (SubGroup.haveItems(SubName) ? STATE.ENABLED: STATE.GRAYED) | (NowSub ? STATE.CHECKED: cast(STATE)0);
					SubItem.text = Text(SubName);

					SubGroupMenu.insert(SubItem);
				}
				// 有効なメイングループの数値設定
				MainItem.state    = STATE.ENABLED;
				MainItem.subMenu  = SubGroupMenu;
			} catch(Exception e) {
				// 無効なメイングループの数値設定
				MainItem.state    = STATE.GRAYED;
				MainItem.subMenu  = null;
			}
			MainItem.id       = cast(COMMAND_ID)(i+1);
			MainItem.state    = MainItem.state() | (NowMain ? STATE.DEFAULT: cast(STATE)0);

			MainItem.text = MainName;
			
			this.insert(MainItem);
		}
		// 現在メイングループのサブグループ表示。
		with(MENUITEM) if(ViewSubGroup) {
			MainItem.subMenu  = null;
			
			foreach(i, SubName; ViewSubGroup.baseNames) {
				assert(i < short.max-1);
				
				MainItem.id       = cast(COMMAND_ID)(MAKELONG(cast(ushort)0, cast(ushort)(i+1)));
				TYPE Type = TYPE.STRING;
				if(!i) {
					Type |= TYPE.MENUBARBREAK;
				}
				STATE State = (ViewSubGroup.length ? STATE.ENABLED: STATE.GRAYED);
				if(SubName == SubGroupName) {
					State |= STATE.CHECKED;
				}
				State |= (ViewSubGroup.haveItems(SubName) ? STATE.ENABLED: STATE.GRAYED);
				
				MainItem.type  = Type;
				MainItem.state = State | (ViewSubGroup.inBaseName(SubName) ? STATE.ENABLED: STATE.GRAYED);
				MainItem.text = SubName;
				this.insert(MainItem);
			}
		}
	}

	///
	ushort[] show(NeWindow Owner) {
		//auto Point=Cursor.getPos();
		auto Point=MOUSE.position();

		auto id=super.show(
			Owner,
			PopUp.FLAG.CENTERALIGN | PopUp.FLAG.RETURNCMD | PopUp.FLAG.NONOTIFY | PopUp.FLAG.RIGHTBUTTON,
			Point,
			null
		);
		
		return [LOWORD(id), HIWORD(id)];
	}
}

final class ButtonListMenu: DataMenu!(Item) {
	
	this(Icon.FIXED IconFixed, BMITEM[] BMItems)
	in {
		assert(BMItems.length);
	}
	body {
		super(IconFixed);

		MENUITEM MenuItem;
		DRAWMENUITEM DrawMenuItem;

		MenuItem.initialize();
		MenuItem.mask = MENUITEM.MASK.ID | MENUITEM.MASK.STATE | MENUITEM.MASK.TYPE | MENUITEM.MASK.DATA;
		MenuItem.type = MENUITEM.TYPE.OWNERDRAW;
		foreach(i, BMItem; BMItems) {
			DrawMenuItem.text = BMItem.name;
			DrawMenuItem.icon = BMItem.icon;
			DrawMenuItem.key  = BMItem.key;
			
			MenuItem.id    = cast(COMMAND_ID)(i+1);
			MenuItem.state = BMItem.live ? MENUITEM.STATE.DEFAULT: MENUITEM.STATE.DISABLED;
			//MenuItem.itemData = cast(void*)MENUS.BUTTON;
			MenuItem.data = cast(void*)MENUS.BUTTON;
			
			this.insert(MenuItem, &DrawMenuItem, BMItem.item);
		}
	}

	///
	Item show(NeWindow Owner, Control NoHideObject) {
		RECT Rect;
		POINT Point;
		if(NoHideObject && NoHideObject.isAlive) {
			Rect = NoHideObject.itemRect();

			Point.x = Rect.right + 1;
			Point.y = Rect.top;
		} else {
			//Point = Cursor.getPos();
			Point = MOUSE.position();
		}

		auto Id=super.show(Owner, PopUp.FLAG.RETURNCMD | PopUp.FLAG.LEFTBUTTON, Point, &Rect);

		if(Id) {
			return data(Id);
		} else {
			return null;
		}
	}
}

/// 妥協に妥協。
final class ItemFileMenu: DataMenu!(Text*) {
	invariant() {
		assert(PATH.isFolderPath(BaseFolder));
	}
	private Text BaseFolder;
	private size_t StartID;
	private bool OnRead; // むりやり。再読み込み回避。

	/**
	History:
		1.00β11:
			基点フォルダの有効・無効をによる契約の追加。
	*/
	override this(Icon.FIXED IconFixed, Text BaseFolder)
	in {
		assert(BaseFolder.length);
	}
	body {
		super(IconFixed);
		this.BaseFolder = BaseFolder;
		OnRead = false;
	}

	/**
	並び替え情報要素。
	構造体は無理？
	＠いけることが判明。
	*/
	class FileSort {
		Text Address;
		bool Folder;
		Text FileName;
		Text Extension;

		enum POS {
			OWNER,
			FOLDER,
			INITEM
		}
		POS Pos;

		DRAWMENUITEM DrawMenuItem;

		override bool opEquals(Object obj) {
			auto FileInfo = cast(FileSort)obj;
			
			return
				Pos       == FileInfo.Pos
				&& Folder    == FileInfo.Folder
				&& Extension == FileInfo.Extension
				&& FileName  == FileInfo.FileName
			;
		}
		
		/**
		基準が分からん。

		History:
			1.00β11:
				-debug無し時にAccess Violation、_memsetなるエラー。
				正直知らんがなってエラー修正。
		*/
		override int opCmp(Object obj) {
			auto FileInfo = cast(FileSort)obj;
			
			if(Folder && FileInfo.Folder) {
				assert(!(Pos == POS.OWNER && FileInfo.Pos == POS.OWNER), "only POS.OWNER");

				if(Pos == POS.OWNER) {
					return -1;
				}
				if(FileInfo.Pos == POS.OWNER) {
					return 1;
				}
				
				assert(!(Pos == POS.FOLDER && FileInfo.Pos == POS.FOLDER), "only POS.FOLDER");
				if(Pos == POS.FOLDER) {
					return -1;
				}
				if(FileInfo.Pos == POS.FOLDER) {
					return 1;
				}
				assert(Pos == POS.INITEM && FileInfo.Pos == POS.INITEM);
				//return ~icmp(FileName.toString(), FileInfo.FileName.toString())*-1;
				return PATH.cmp(FileName, FileInfo.FileName);
			}
			if(Folder && !FileInfo.Folder) {
				return -1;
			}
			if(!Folder && FileInfo.Folder) {
				return 1;
			}
			assert(!Folder && !FileInfo.Folder);

			if(auto ExtCmp=PATH.cmp(Extension, FileInfo.Extension)) {
				return ExtCmp;
			} else {
				return PATH.cmp(FileName, FileInfo.FileName);
			}
		}
	}


	/**
	フォルダから読み込み。

	親フォルダ・サブフォルダに関しては親ウィンドウにメッセージが来た時点で読み込む。
	※ただしメニュー自体は作成しておく。

	History:
		1.081:
			[P] 配列拡張部分を変更。
			[P] FILEITEM変更に伴う処理の変更。
	
		1.00β20:
			[P] ループ時にstatic.akiの適用。
	
		1.00β11:
			-debug無し時に特定環境内でillegal UTF-16 valueが発生していたバグを修正。
			FileSort.opCmpに通じるものがあるはず。
			insertSeparatorのID問題を暫定対処。
	*/
	bool readFolder(COMMAND_ID StartID)
	in {
		assert(FILE.isFolder(BaseFolder), BaseFolder.toString);
		assert(StartID);
	}
	body {
		scope(success) OnRead = true;
		if(OnRead) return true;

		this.StartID = StartID;
		
		MENUITEM MenuItem;
		MenuItem.initialize();
		with(MenuItem) {
			mask  = MASK.ID | MASK.STATE | MASK.TYPE | MASK.DATA;
			type  = TYPE.OWNERDRAW;
			state = STATE.ENABLED;
		}
		
		invariant COUNT_UNIT = StaticData.loopPlus;
		size_t i;
		auto FileInfos=new FileSort[StaticData.loopInit];
		FILEITEM FileItem;
		scope finder=new Finder(BaseFolder ~ "*");
		while(finder.find(FileItem)) {
			/+
			if(i == FileInfos.length) {
				FileInfos.length = i + COUNT_UNIT;
			}
			+/
			FileInfos.autoIncrement(i, COUNT_UNIT);
			auto FileInfo=new FileSort;
			FileInfo.Folder = FileItem.isFolder();

			
			//if(FileItem.fileName == ".") {//}
			if(FileItem.isParentFolder) {
				FileInfo.Address       = BaseFolder;
				//FileInfo.DrawMenuItem.text = "このフォルダ";
				FileInfo.DrawMenuItem.text = LanguageData.buttonMenuFile(LD.BUTTON_MENU_FILE.THIS);
				FileInfo.Pos           = FileSort.POS.FOLDER;
				assert(FileInfo.Folder);
			//} else if(FileItem.fileName == "..") {//}
			} else if(FileItem.isBaseFolder) {
				FileInfo.Address       = PATH.ownerFolder(BaseFolder);
				//FileInfo.DrawMenuItem.text = "親フォルダ";
				FileInfo.DrawMenuItem.text = LanguageData.buttonMenuFile(LD.BUTTON_MENU_FILE.OWNER);
				FileInfo.Pos           = FileSort.POS.OWNER;
				assert(FileInfo.Folder);
			} else {
				FileInfo.Address           = BaseFolder ~ FileItem.name;
				FileInfo.DrawMenuItem.text = FileItem.name.dup;
				if(FileInfo.Folder) {
					FileInfo.FileName      = FileInfo.DrawMenuItem.text;
				} else {
					FileInfo.FileName      = PATH.getName(FileItem.name);//.dup;
					FileInfo.Extension     = PATH.getExtension(FileItem.name);//.dup;
				}
				FileInfo.Pos = FileSort.POS.INITEM;
			}
			
			//FileInfo.DrawMenuItem.icon = GetFileIcon(FileInfo.Address, 0, super.IconFixed);
			auto IconSize=super.iconSize;
			auto IconFixed=Icon.sizeToFixed(IconSize);
			FileInfo.DrawMenuItem.icon = GetFileIcon(FileInfo.Address, 0, IconFixed);
			
			if(!FileInfo.DrawMenuItem.icon || !FileInfo.DrawMenuItem.icon()) {
				//FileInfo.DrawMenuItem.icon = new Icon(Icon.STOCK.APPLICATION, super.IconFixed);
				FileInfo.DrawMenuItem.icon = new Icon(Icon.STOCK.APPLICATION, IconFixed);
			}

			FileInfo.DrawMenuItem.key = KEY.A;
			
			FileInfos[i++] = FileInfo;
		}
		FileInfos.length = finder.count();
		FileInfos=FileInfos.sort;

		bool PervFolder=true;
		bool FolderSeparator=true;
		for(i=0; i < FileInfos.length; i++) {
			scope(exit) PervFolder = FileInfo.Folder;
			
			auto FileInfo=&FileInfos[i];
			MenuItem.id       = cast(COMMAND_ID)i + StartID;
			//MenuItem.itemData = cast(void*)MENUS.FILE;
			MenuItem.data     = cast(void*)MENUS.FILE;
			if(PervFolder && !FileInfo.Folder) {
				// フォルダとファイルの間。
				super.insertSeparator();
				PervFolder = false;
				FolderSeparator = false;
			}
			super.insert(MenuItem, &FileInfo.DrawMenuItem, &FileInfo.Address);
			if(FolderSeparator && FileInfos[i].Pos == FileSort.POS.FOLDER && (i < FileInfos.length+1 && FileInfos[i+1].Folder)) {
				// フォルダとフォルダ内の間
				super.insertSeparator();
			}
		}
		
		return finder.count ? true: false;
	}
}



final class ItemMenu: PopUp {
	///
	static enum ITEMID: COMMAND_ID {
		EXEC_NORMAL = 1, /// 通常起動
		EXEC_WINDOW, /// 指定して実行
		//EXEC_SEP,
		ADDR_ADDR, /// アドレス
		ADDR_ADDR_OPEN_OWNERFOLDER, /// 親フォルダ表示
		ADDR_ADDR_OPEN_WORKFOLDER, /// 作業フォルダ表示
		//ADDR_ADDR_OPEN_SEP,
		ADDR_ADDR_COPY_ADDRESS, /// アドレスコピー
		ADDR_ADDR_COPY_OWNERFOLDER, /// 親フォルダコピー
		ADDR_ADDR_COPY_WORKFOLDER, /// 作業フォルダコピー
		ADDR_ADDR_COPY_OPTION, /// 引数コピー
		//ADDR_ADDR_COPY_SEP,
		ADDR_ADDR_PROPERTY, /// プロパティ
		ADDR_FILE, /// ファイル
	}

	NemuxiToolBar Toolbar;
	COMMAND_ID Id;
	Item item;
	ItemFileMenu Filemenu;
	/**
	History:
		1.061:
			[P] 環境変数を考慮。
	*/
	this(Icon.FIXED IconFixed, NemuxiToolBar Toolbar, NMTOOLBAR* NMToolbar, ref ItemFileMenu Filemenu)
	in {
		assert(NMToolbar);
	}
	body {
		super();

		this.Toolbar = Toolbar;
		Id = cast(COMMAND_ID)NMToolbar.iItem;
		assert(Id > 0);
		
		//item=cast(Item)Toolbar.buttonGet(Id);
		item=Toolbar.getItem(Id);
		
		Text BaseFolder=void;
		BaseFolder = GetFolder(item);
		/+
		bool NormalAddr =  item.type == Item.TYPE.NORMAL ? FILE.isExistence(item.address): false;
		bool WorkAddr   =  item.workFolder.length ? FILE.isExistence(item.workFolder) ? FILE.isFolder(item.workFolder): false: false;
		+/
		const WorkFolder = GetWorkFolder(item);
		bool NormalAddr =  item.type == Item.TYPE.NORMAL ? FILE.isExistence(toPlain(item.address)): false;
		bool WorkAddr   =  item.workFolder.length ? FILE.isExistence(WorkFolder) ? FILE.isFolder(WorkFolder): false: false;
		if(NormalAddr && WorkAddr) {
			//WorkAddr = PATH.ownerFolder(Text(item.address)) != PATH.addFolderSep(Text(item.workFolder));
			WorkAddr = GetFolder(item) != PATH.addFolderSep(WorkFolder);
		}
		bool Exec = true;
		if(NormalAddr) {
			// アイテムがフォルダの場合に死んじゃう。
			// 原因不明（ExecWindowのOKボタンで死んでるっぽい）
			//Exec=FILE.isExistence(item.address) && FILE.isFile(item.address);
			const Address=toPlain(item.address);
			Exec=FILE.isExistence(Address) && FILE.isFile(Address);
		}
		/+
		this.insertText(ITEMID.EXEC_NORMAL, Text("通常実行"));
		this.insertText(ITEMID.EXEC_WINDOW, Text("指定して実行"), Exec);
		+/
		this.insertText(ITEMID.EXEC_NORMAL, LanguageData.buttonMenu(LD.BUTTON_MENU.NORMAL));
		this.insertText(ITEMID.EXEC_WINDOW, LanguageData.buttonMenu(LD.BUTTON_MENU.EX), Exec);
		this.insertSeparator();


		auto addr=new PopUp();
		with(addr) {
			/+
			insertText(ITEMID.ADDR_ADDR_OPEN_OWNERFOLDER, Text("親フォルダを開く"), NormalAddr);
			insertText(ITEMID.ADDR_ADDR_OPEN_WORKFOLDER,  Text("作業フォルダを開く"), WorkAddr);
			insertSeparator(ITEMID.ADDR_ADDR_OPEN_SEP);
			insertText(ITEMID.ADDR_ADDR_COPY_ADDRESS,     Text("アドレスをコピー"), NormalAddr);
			insertText(ITEMID.ADDR_ADDR_COPY_OWNERFOLDER, Text("親フォルダをコピー"), NormalAddr);
			insertText(ITEMID.ADDR_ADDR_COPY_WORKFOLDER,  Text("作業フォルダをコピー"), WorkAddr);
			insertText(ITEMID.ADDR_ADDR_COPY_OPTION,      Text("オプションをコピー"), item.option.length > 0);
			insertSeparator(ITEMID.ADDR_ADDR_COPY_SEP);
			insertText(ITEMID.ADDR_ADDR_PROPERTY, Text("プロパティ"), NormalAddr);
			+/
			insertText(ITEMID.ADDR_ADDR_OPEN_OWNERFOLDER, LanguageData.buttonMenuAddress(LD.BUTTON_MENU_ADDRESS.OPEN_FOLDER_OWNER), NormalAddr);
			insertText(ITEMID.ADDR_ADDR_OPEN_WORKFOLDER,  LanguageData.buttonMenuAddress(LD.BUTTON_MENU_ADDRESS.OPEN_FOLDER_WORK), WorkAddr);
			insertSeparator();
			insertText(ITEMID.ADDR_ADDR_COPY_ADDRESS,     LanguageData.buttonMenuAddress(LD.BUTTON_MENU_ADDRESS.COPY_ADDRESS), NormalAddr);
			insertText(ITEMID.ADDR_ADDR_COPY_OWNERFOLDER, LanguageData.buttonMenuAddress(LD.BUTTON_MENU_ADDRESS.COPY_OWNER), NormalAddr);
			insertText(ITEMID.ADDR_ADDR_COPY_WORKFOLDER,  LanguageData.buttonMenuAddress(LD.BUTTON_MENU_ADDRESS.COPY_WORK), WorkAddr);
			insertText(ITEMID.ADDR_ADDR_COPY_OPTION,      LanguageData.buttonMenuAddress(LD.BUTTON_MENU_ADDRESS.COPY_OPTION), item.option.length > 0);
			insertSeparator();
			insertText(ITEMID.ADDR_ADDR_PROPERTY,         LanguageData.buttonMenuAddress(LD.BUTTON_MENU_ADDRESS.PROPERTY), NormalAddr);
		}
		//this.insertSubMenu(ITEMID.ADDR_ADDR, Text("アドレス"), addr, NormalAddr || WorkAddr);
		this.insertSubMenu(ITEMID.ADDR_ADDR, LanguageData.buttonMenu(LD.BUTTON_MENU.ADDRESS), addr, NormalAddr || WorkAddr);

		immutable FileMenu=BaseFolder.length && FILE.isExistence(BaseFolder) && FILE.isFolder(BaseFolder);
		if(FileMenu) {
			Filemenu = this.Filemenu=new ItemFileMenu(IconFixed, BaseFolder);
		}
		//this.insertSubMenu(ITEMID.ADDR_FILE, Text("ファイル"), Filemenu, FileMenu && BaseFolder.length > 0);
		this.insertSubMenu(ITEMID.ADDR_FILE, LanguageData.buttonMenu(LD.BUTTON_MENU.FILE), Filemenu, FileMenu && BaseFolder.length > 0);
	}

	/**
	Bugs:
		アイコンサイズ、文字列表示に関するメニュー位置が不完全。

	History:
		1.061:
			[F] アイテムプロパティ表示時に環境変数を考慮。
	*/
	void show(NeWindow Owner, Application application) {
		mixin(SMixInLog("ButtonLauncher", "show"));
		
		//RECT Rect;
		SIZE Size;
		auto Rect = Toolbar.buttonRect(Id);
		Size.cx = Rect.right  - Rect.left;
		Size.cy = Rect.bottom - Rect.top;
		MapWindowPoints(Toolbar(), GetDesktopWindow(), cast(POINT*)&Rect, Rect.sizeof / POINT.sizeof);

		// Bug.1
		PopUp.FLAG Tpm;
		POINT Point;
		with(PopUp.FLAG) switch(application.setting.position()) {
			case application.setting.POSITION.LEFT:
				Point.x = Rect.right;
				Point.y = Rect.top;
				Tpm = LEFTALIGN | TOPALIGN;
				break;
			case application.setting.POSITION.TOP:
				Point.x = Rect.left + Size.cx / 2;
				Point.y = Rect.bottom;
				Tpm = CENTERALIGN | TOPALIGN;
				break;
			case application.setting.POSITION.RIGHT:
				Point.x = Rect.left;
				Point.y = Rect.top;
				Tpm = RIGHTALIGN | TOPALIGN;
				break;
			case application.setting.POSITION.BOTTOM:
				Point.x = Rect.left + Size.cx / 2;
				Point.y = Rect.top;
				Tpm = CENTERALIGN | BOTTOMALIGN;
				break;
			case application.setting.POSITION.FLOAT:
				Point.x = Rect.left;
				Point.y = Rect.bottom;
				Tpm = LEFTALIGN | TOPALIGN;
				break;
			default:
				assert(false);
		}
		auto id=super.show(Owner, Tpm | PopUp.FLAG.RETURNCMD | PopUp.FLAG.LEFTBUTTON, Point, &Rect);
		if(!id) {
			return;
		}
		
		try {
			auto Clip=new TextClipBoard(Owner);

			with(ITEMID) switch(id) {
				case EXEC_NORMAL:
					application.executeItem(item);
					break;
				case EXEC_WINDOW:
					auto exec=new ExecDialog(Owner, item, application);
					exec.select;
					break;
				case ADDR_ADDR_OPEN_OWNERFOLDER:
					application.executePath(Text(GetFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_OPEN_WORKFOLDER:
					application.executePath(Text(GetWorkFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_COPY_ADDRESS:
					Clip.set(Text(item.address));
					break;
				case ADDR_ADDR_COPY_OWNERFOLDER:
					Clip.set(Text(GetFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_COPY_WORKFOLDER:
					Clip.set(Text(GetWorkFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_COPY_OPTION:
					assert(item.option.length);
					Clip.set(Text(item.option));
					break;
				case ADDR_ADDR_PROPERTY:
					//PropertyExecute(Text(item.address), Owner);
					PropertyExecute(toPlain(item.address), Owner);
					break;
				case ADDR_ADDR, ADDR_FILE/*, EXEC_SEP,*/ /*ADDR_ADDR_OPEN_SEP,*/ /*ADDR_ADDR_COPY_SEP*/:
					assert(false);
				default: // 選択ファイル実行。
					application.executePath(*Filemenu.data(id));
			}
		} catch(Exception e) {
			//Logger.write(e);
			log.write(e);
			scope exd=new ExceptionDialog(Owner, e);
			exd.select;
		}
	}
}

