﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.settingdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(settingdialog) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;
/+
import nemuxi.base;
import nemuxi.system.application;
import nemuxi.system.type;
import nemuxi.negui.file.file;
import nemuxi.file.data;
import nemuxi.file.items.item;
//import nemuxi.image.font;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.control.control;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.group;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.control.label.label;
import nemuxi.gui.window.dialog.selectdialog;

import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;

import nemuxi.gui.window.dialog.settingdialog.settingif;
import nemuxi.gui.window.dialog.settingdialog.nemuxidialog;
import nemuxi.gui.window.dialog.settingdialog.itemdialog.itemdialog;
import nemuxi.gui.window.dialog.settingdialog.groupdialog;
import nemuxi.gui.window.dialog.settingdialog.plugindialog;
+/

import nemuxi.system.application;
import nemuxi.system.type;
import nemuxi.system.language;
import nemuxi.system.log;
import nemuxi.system.staticdata;

import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.gui.window.dialog.selectdialog;

import nemuxi.negui.window.dialog.dialog;

import nemuxi.file.data;
import nemuxi.negui.file.file;
import nemuxi.negui.control.toolbar.toolbar;


//version(none) {
import nemuxi.gui.window.dialog.settingdialog.groupdialog;
import nemuxi.gui.window.dialog.settingdialog.plugindialog;
import nemuxi.gui.window.dialog.settingdialog.nemuxidialog;
import nemuxi.gui.window.dialog.settingdialog.settingif;
import nemuxi.gui.window.dialog.settingdialog.itemdialog.itemdialog;


//import nemuxi.system.log;

/**
History:
	1.00β12:
		凄くしょうもない事情によりokとcancelの位置変更。
*/
final class SettingDialog: SelectDialog {
	private {
		enum CTRL: ITEM_ID {
			MENULIST=1, ///
			OK,
			CANCEL,
		}
		enum COMMAND: COMMAND_ID {
			NEMUXI = 1,
			ITEM,
			GROUP,
			COMMAND,
		}

		Push SettingOk, Cancel;
		
		NemuxiDialog NemuxiDlg;
		ItemDialog   ItemDlg;
		GroupDialog  GroupDlg;

		struct DialogGroup {
			ISettingInFrame[] list;
			ISettingInFrame now;
		}
		DialogGroup Dialogs;
	}
	package {
		Application application;
		
		ToolBar Menulist;
		Font Menufont;
		Font CtrlFont;
	}
	
	this(NeWindow Owner, Application application)
	in {
		assert(application);
	}
	body {
		this.application = application;
		
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = Owner;
		super(NeGuiInfo);
		this.Center = CENTER.DESKTOP;
	}
	
	private COMMAND GetSelectedCommand() {
		TOOLBUTTON ToolButton;
		ToolButton.initialize();
		
		invariant LIMIT=Menulist.buttonCount;
		for(auto i=0; i <= COMMAND.max; i++) {
			Menulist.buttonGet(i, ToolButton);
			if((ToolButton.state & TOOLBUTTON.STATE.CHECKED) == TOOLBUTTON.STATE.CHECKED) {
				return cast(COMMAND)ToolButton.command;
			}
		}
		assert(false);
	}
	/**
	History:
		1.00β15:
			アクセラレータ入れ替え処理追加。
	*/
	private void InFrameShow(COMMAND Command)
	in {
		assert(COMMAND.min <= Command && Command <= COMMAND.max);
	}
	body {
		foreach(dialog; Dialogs.list) {
			dialog.hide();
		}
		
		with(COMMAND) switch(Command) {
			case NEMUXI:  Dialogs.now = NemuxiDlg; break;
			case ITEM:    Dialogs.now = ItemDlg;   break;
			case GROUP:   Dialogs.now = GroupDlg;  break;
			default:
				assert(false);
		}
		if(Dialogs.now !is ItemDlg)
		Dialogs.now.iiPairs=ItemDlg.iiPairs;;

		accelerator = Dialogs.now.accelerator;

		Dialogs.now.show();
		FrameReSize(Dialogs.now);
	}
	private void FrameReSize(ISettingInFrame dialog) {
		auto OwnerSize=clientSize();
		auto MenuSize=Menulist.clientSize();
		auto ButtonSize=SettingOk.minContentHeight;
		
		dialog.reSize(0, MenuSize.cy, OwnerSize.cx, OwnerSize.cy - MenuSize.cy - ButtonSize);
	}

	protected override {
		/**
		History:
			1.00β18:
				[B] ItemIconPairsの解放忘れ。
		*/
		void OnDestroy() {
			auto pairs=ItemDlg.iiPairs;
			delete pairs;
			delete Menufont;

			super.OnDestroy();

			// 設定部分実装後に取り除く。
			Owner.setShow = SHOW.SHOWNORMAL;
		}
		void OnCreate() {
			mixin(SMixInLog("SettingDialog", "OnCreate"));
			
			super.OnCreate();
			accelerator = null;

			text = LanguageData.dialog(LD.DIALOG.SETTING);
			
			Owner.setShow = SHOW.HIDE;
			
			caption = true;
			systemMenu = true;
			taskBar = true;
			maxButton = true;
			minButton = true;
			frameSize = true;
			
			Menulist = new ToolBar(this, CTRL.MENULIST);

			alias PAIR!(Text, COMMAND) TOOLBARPAIR;
			TOOLBARPAIR[] ToolBarPair;
			/+
			ToolBarPair ~= TOOLBARPAIR(Text("本体"),     COMMAND.NEMUXI);
			ToolBarPair ~= TOOLBARPAIR(Text("アイテム"), COMMAND.ITEM);
			ToolBarPair ~= TOOLBARPAIR(Text("グループ"), COMMAND.GROUP);
			+/
			ToolBarPair ~= TOOLBARPAIR(LanguageData.setting(LD.SETTING.APPLICATION), COMMAND.NEMUXI);
			ToolBarPair ~= TOOLBARPAIR(LanguageData.setting(LD.SETTING.ITEM),        COMMAND.ITEM);
			ToolBarPair ~= TOOLBARPAIR(LanguageData.setting(LD.SETTING.GROUP),       COMMAND.GROUP);

			/+
			auto texts = Texts(
				"nemuxi",
				"item",
				"group"
			);
			auto commands = [
				COMMAND.NEMUXI,
				COMMAND.ITEM,
				COMMAND.GROUP,
			];
			+/

			SettingOk = new Push(this, CTRL.OK);
			Cancel    = new Push(this, CTRL.CANCEL);
			CtrlFont = new Font(Font.STOCK.MENU);
			SettingOk .font = CtrlFont;
			Cancel    .font = CtrlFont;
			/+
			SettingOk .text = Text("OK");
			Cancel    .text = Text("CANCEL");
			+/
			SettingOk .text = LanguageData.message(LD.MESSAGE.OK);
			Cancel    .text = LanguageData.message(LD.MESSAGE.CANCEL);

			defButton = SettingOk;

			//assert(texts.length == commands.length);

			auto ToolButtons = new TOOLBUTTON[ToolBarPair.length];
			
			foreach(i, ref ToolButton; ToolButtons) {
				ToolButton.initialize();
				ToolButton.nonImage;
				ToolButton.command = ToolBarPair[i].right;
				ToolButton.state   = TOOLBUTTON.STATE.ENABLED;
				// 初期値
				if(ToolButton.command == COMMAND.NEMUXI) {
					ToolButton.state = ToolButton.state | TOOLBUTTON.STATE.CHECKED;
				}
				
				ToolButton.style   = TOOLBUTTON.STYLE.CHECKGROUP | TOOLBUTTON.STYLE.SHOWTEXT;
				
				ToolButton.data    = null;
				ToolButton.text    = ToolBarPair[i].left;
			}
			
			Menulist.initialize;
			Menulist.autoSize;
			Menulist.buttonSet(ToolButtons);
			Menulist.list = true;
			Menulist.font = Menufont = new Font(Font.STOCK.MENU);

			auto items=new ItemIconPairs(application.itemBase, Icon.FIXED.SMALL);

			//
			NemuxiDlg = new NemuxiDialog(this, application.setting, items);
			//
			ItemDlg = new ItemDialog(this, application.itemBase.dup(true), items, application.setting.shortcut);
			//
			GroupDlg = new GroupDialog(this, application.groupBase.dup(true));
			
			Dialogs.list = [
				cast(ISettingInFrame)
				NemuxiDlg,
				ItemDlg,
				GroupDlg
			];
			foreach(dialog; Dialogs.list) {
				dialog.toChild();
			}

			InFrameShow(GetSelectedCommand());
			
			this.adjustSize(512, 512);
			reLoad;
		}
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			Menulist.size(Width, Height);
			FrameReSize(Dialogs.now);

			immutable CtrlWidth = Width / 5;
			immutable CtrlHeight=SettingOk.minContentHeight;

			SettingOk .move(Width - CtrlWidth * 2, Height-CtrlHeight, CtrlWidth, CtrlHeight);
			Cancel    .move(Width - CtrlWidth * 1, Height-CtrlHeight, CtrlWidth, CtrlHeight);

			return true;
		}
		
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender is Menulist) {
				InFrameShow(GetSelectedCommand());
				return true;
			}
			switch(Id) {
				case CTRL.OK:
					try {
						Text[] path=[
							PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.applicationDataFile,
							PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.itemDataFile,
							PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.groupDataFile
						];

						FILE.makeFolder(StaticData.dataFolder);

						for(auto i=0; i < path.length; i++) {
							if(auto aki=Dialogs.list[i].akiDocument) {
								WriteAkiDocument(path[i], aki);
							}
						}
						SelectFlag = true;
						destroy();
					} catch(Throwable e) {
						Logger.write(e);
						ShowThrowables(this, e);
					}
					return true;
				
				case CTRL.CANCEL:
					SelectFlag = false;
					destroy();
					return true;
				
				default:
					return false;
			}
			
			/+
			if(Id <= COMMAND.max) {
				InFrameShow(GetSelectedCommand());
				return true;
			} else if(Id == COMMAND.OK) {
				Text[] path=[
					PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.applicationDataFile,
					PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.itemDataFile,
					PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.groupDataFile
				];

				FILE.makeFolder(StaticData.dataFolder);

				for(auto i=0; i < path.length; i++) {
					if(auto aki=Dialogs.list[i].akiDocument) {
						WriteAkiDocument(path[i], aki);
					}
				}
				SelectFlag = true;
			} else if(Id == COMMAND.CANCEL) {
				SelectFlag = false;
			}
			destroy();
				return true;
			+/
		}
		bool OnAccelerator(COMMAND_ID Id) {
			return Dialogs.now.toAccelerator(Id);
		}
	}
}


//}