﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.groupdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(groupdialog) void main() {}

import std.contracts;
import std.typecons;

import win32.commctrl;

import etc.kareki.kareki;

import nemuxi.gui.window.dialog.settingdialog.settingif;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.window.menu.popup;
import nemuxi.gui.control.listview;
import nemuxi.negui.control.listbox.listview;
import nemuxi.negui.control.listbox.listbox;
import nemuxi.negui.control.treeview.treeview;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.layout.panel.dual;
import nemuxi.negui.draw.unit;
import nemuxi.negui.draw.cursor;
import nemuxi.negui.draw.imagelist;
import nemuxi.negui.system.base;
import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.image.icon;
import nemuxi.file.items.group;
import nemuxi.utility.convert.item;
import nemuxi.negui.event.event;
import nemuxi.system.type;
import nemuxi.system.language;
import nemuxi.system.exception;


/**
History:
	1.00β15:
		[P] アイテム選択部分をリストボックスからコンボボックスへ。

Bugs:
	急ごしらえのツールバー。
*/
class GroupDialog: ModalDialog, ISettingInFrame {
	enum COMMAND: COMMAND_ID {
		ITEM_DELETE = ACCELERATOR_DEFKEY.SAFE_START,
	}
	
	protected enum CTRL: ITEM_ID {
		GROUP = 1,
		ITEM,
		GROUP_MENU,
	}
	protected enum TYPE {
		NONE,
		MENU,
		MAIN,
		SUB,
		ITEM
	}
	enum GROUP_COMMAND: COMMAND_ID {
		NONE=0,
		MOVE_UP=1,
		MOVE_DOWN,
		EDIT,
		DELETE,
		MAIN_ADD,
		MAIN_INSERT,
		SUB_ADD,
		SUB_INSERT,
		ITEM_ADD,
		ITEM_INSERT,
	}
	enum MASK: uint {
		NONE        = 0,
		MOVE_UP     = 0b00000000001,
		MOVE_DOWN   = 0b00000000010,
		EDIT        = 0b00000000100,
		DELETE      = 0b00000001000,
		MAIN_ADD    = 0b00000010000,
		MAIN_INSERT = 0b00000100000,
		SUB_ADD     = 0b00001000000,
		SUB_INSERT  = 0b00010000000,
		ITEM_ADD    = 0b00100000000,
		ITEM_INSERT = 0b01000000000,
	}
	protected {
		TreeView GroupTree;
		ItemListView ItemSelect;
		ToolBar GroupMenu;
	}
	protected {
		Font CtrlFont;
		
		Kareha GroupBase;
	}
	this(NeWindow Owner, Kareha GroupBase) {
		this.GroupBase  = GroupBase;
		
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner  = Owner;
		NeGuiInfo.eventLoop = true;
		
		super(NeGuiInfo, DIALOG_ID.init);
	}

	/**
	History:
		1.00β18:
			[B] 選択アイテムが強制的に最上位に変更される。
	*/
	override void iiPairs(ItemIconPairs Pairs) {
		auto TreeItem=GroupTree.get(GroupTree.nodeCaret());
		ItemSelect.iiPairs = Pairs;
		auto Enable=ItemSelect.enable && cast(TYPE)TreeItem.data == TYPE.ITEM;
		ItemSelect.enable = Enable;
		if(Enable) {
			auto ItemID=Text(TreeItem.text);
			if(ItemID in Pairs)
			ItemSelect.selectID(ItemID);
		}
	}
	override ItemIconPairs iiPairs() {
		return ItemSelect.iiPairs;
	}
	
	mixin MixInSettingInFrame;
	/**
	History:
		1.070:
			[B] 特に設定していないメニューグループ。
	
		1.063:
			[F] 不正なツリーであればExceptionを投げる。
	*/
	override AkiDocument akiDocument() {
		auto aki=new AkiDocument;

		auto BaseException=new SettingException(Text("グループ出力失敗"));
		Throwable e=BaseException;

		string[] MainGroupNames;
		TREE_NODE MainGroupNode=GroupTree.nodeRoot(TREE_NODE.init);
		do {
			auto MainItem=GroupTree.get(MainGroupNode);
			auto MainGroupName=Text(MainItem.text).toString;
			if(cast(TYPE)MainItem.data != TYPE.MENU) {
				MainGroupNames ~= MainGroupName;
			}

			string[] SubGroupNames;
			TREE_NODE SubGroupNode=GroupTree.nodeChild(MainGroupNode);
			if(!SubGroupNode && cast(TYPE)MainItem.data != TYPE.MENU) {
				e.next = new SettingException(Text("[%s]にサブグループ無し", MainGroupName));
				e = e.next;
			}
			while(SubGroupNode) {
				auto SubItem=GroupTree.get(SubGroupNode);
				auto SubGroupName=Text(SubItem.text).toString;
				SubGroupNames ~= SubGroupName;

				string[] ItemIDs;
				TREE_NODE ItemNode=GroupTree.nodeChild(SubGroupNode);
				if(!ItemNode) {
					e.next = new SettingException(Text("[%s/%s]にアイテム無し", MainGroupName, SubGroupName));
					e = e.next;
				}
				while(ItemNode) {
					auto ItemItem=GroupTree.get(ItemNode);
					auto ItemID=Text(ItemItem.text).toString;
					ItemIDs ~= ItemID;
					
					ItemNode = GroupTree.nodeNext(ItemNode);
				}
				aki[`Group`, MainGroupName, SubGroupName] = ItemIDs;

				SubGroupNode = GroupTree.nodeNext(SubGroupNode);
			}
			
			aki[`Group`, MainGroupName] = SubGroupNames;
			
		} while(cast(bool)(MainGroupNode=GroupTree.nodeNext(MainGroupNode)));

		enforce(BaseException is e, BaseException);
		
		aki[`Group`] = MainGroupNames;
		
		return aki;
	}

	protected override {
		void OnDestroy() {
			delete CtrlFont;
			
			super.OnDestroy();
		}
		/**
		History:
			1.00β15:
				[P] layoutManager.basePanelの配置、方向を変更。
				[S] アクセラレータ使用準備。
		*/
		void OnCreate() {
			super.OnCreate();
			AcceleratorClear();
			
			CtrlFont = new Font(Font.STOCK.MESSAGE);
			
			GroupTree = new TreeView(this, CTRL.GROUP);
			GroupTree.font = CtrlFont;

			ItemSelect = new ItemListView(this, CTRL.ITEM);
			ItemSelect.font = CtrlFont;

			alias PAIR!(GROUP_COMMAND, SYSICON) GROUPSYSPAIR;
			auto GroupSysPairs=[
				GROUPSYSPAIR(GROUP_COMMAND.MOVE_UP      , SYSICON.ELEMENT_MOVE_UP   ),
				GROUPSYSPAIR(GROUP_COMMAND.MOVE_DOWN    , SYSICON.ELEMENT_MOVE_DOWN ),
				GROUPSYSPAIR.init,
				GROUPSYSPAIR(GROUP_COMMAND.EDIT         , SYSICON.ELEMENT_EDIT      ),
				GROUPSYSPAIR(GROUP_COMMAND.DELETE       , SYSICON.ELEMENT_DELETE    ),
				GROUPSYSPAIR.init,
				GROUPSYSPAIR(GROUP_COMMAND.MAIN_ADD     , SYSICON.GROUP_MAIN_ADD    ),
				GROUPSYSPAIR(GROUP_COMMAND.MAIN_INSERT  , SYSICON.GROUP_MAIN_INS    ),
				GROUPSYSPAIR(GROUP_COMMAND.SUB_ADD      , SYSICON.GROUP_SUB_ADD     ),
				GROUPSYSPAIR(GROUP_COMMAND.SUB_INSERT   , SYSICON.GROUP_SUB_INS     ),
				GROUPSYSPAIR(GROUP_COMMAND.ITEM_ADD     , SYSICON.GROUP_ITEM_ADD    ),
				GROUPSYSPAIR(GROUP_COMMAND.ITEM_INSERT  , SYSICON.GROUP_ITEM_INS    )
			];

			/+
			auto GroupCommand=[
				GROUP_COMMAND.MOVE_UP,
				GROUP_COMMAND.MOVE_DOWN,
				cast(GROUP_COMMAND)0,
				GROUP_COMMAND.EDIT,
				GROUP_COMMAND.DELETE,
				cast(GROUP_COMMAND)0,
				GROUP_COMMAND.MAIN_ADD,
				GROUP_COMMAND.MAIN_INSERT,
				GROUP_COMMAND.SUB_ADD,
				GROUP_COMMAND.SUB_INSERT,
				GROUP_COMMAND.ITEM_ADD,
				GROUP_COMMAND.ITEM_INSERT
			];
			auto SysIcon=[
				SYSICON.ELEMENT_MOVE_UP,
				SYSICON.ELEMENT_MOVE_DOWN,
				cast(SYSICON)0,
				SYSICON.ELEMENT_EDIT,
				SYSICON.ELEMENT_DELETE,
				cast(SYSICON)0,
				SYSICON.GROUP_MAIN_ADD,
				SYSICON.GROUP_MAIN_INS,
				SYSICON.GROUP_SUB_ADD,
				SYSICON.GROUP_SUB_INS,
				SYSICON.GROUP_ITEM_ADD,
				SYSICON.GROUP_ITEM_INS
			];
			assert(GroupCommand.length == SysIcon.length);
			auto ToolButtons=new TOOLBUTTON[GroupCommand.length];
			+/
			auto ToolButtons=new TOOLBUTTON[GroupSysPairs.length];
			auto IconFixed=Icon.FIXED.SMALL;
			auto IconPx=Icon.fixedToSize(IconFixed);
			SIZE ToolButtonSize=void;
			with(ToolButtonSize) {cx = cy = IconPx;}
			auto ImgList=new ImageList(IconPx, IconPx, ImageList.COLOR_TYPE.COLOR32 | ImageList.COLOR_TYPE.MASK, GroupSysPairs.length, 0, false);
			
			for(auto i=0, j=0; i < GroupSysPairs.length; i++) {
				ToolButtons[i].initialize;
				//ToolButtons[i].state = TOOLBUTTON.STATE.ENABLED;
				if(GroupSysPairs[i] != GROUPSYSPAIR.init) {
					ToolButtons[i].style = TOOLBUTTON.STYLE.BUTTON;
					ToolButtons[i].imageIndex = j++;
					
					//ToolButtons[i].command = GroupCommand[i];
					ToolButtons[i].command = GroupSysPairs[i].left;
					//ImgList.add(GetSystemIcon(SysIcon[i], IconFixed));
					ImgList.add(GetSystemIcon(GroupSysPairs[i].right, IconFixed));
				} else {
					ToolButtons[i].style = TOOLBUTTON.STYLE.SEP;
				}

			}
			assert(ImgList);
			
			GroupMenu = new ToolBar(this, CTRL.GROUP_MENU);
			GroupMenu.initialize;
			GroupMenu.buttonSize(ToolButtonSize);
			GroupMenu.top = true;
			GroupMenu.noDivider = true;
			GroupMenu.noReSize = true;
			GroupMenu.buttonSet(ToolButtons);
			GroupMenu.imageListNormal(ImgList);
			

			auto GroupPanel=new Dual(DIRECTION.VERTICAL);
			GroupPanel.sizeInfo.absolute = GroupMenu.buttonSize.cy;;
			GroupPanel.centerSize = GetControlPadding.cy;
			GroupPanel[0] = GroupMenu;
			GroupPanel[1] = GroupTree;

			auto panel=new Dual(DIRECTION.HORIZON);
			panel.sizeInfo.percent=60;
			panel[0] = GroupPanel;
			panel[1] = ItemSelect;

			layoutManager.basePanel=panel;
		}

		
		/**
		History:
			1.00β15:
				[S] アクセラレータ使用準備。
		*/
		void OnCreated() {
			InitTree;
			ItemSelect.enable=false;

			ACCELERATOR Accels;
			Accels.command = COMMAND.ITEM_DELETE;
			Accels.type    = ACCELERATOR.TYPE.VIRTKEY;
			Accels.key     = KEY.D;

			super.accelerator = new Accelerator(Accels);
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender is GroupMenu) {
				CommandExec(cast(GROUP_COMMAND)Id, GroupTree.nodeCaret);
			}
			
			return false;
		}

		/**
		History:
			1.010:
				[B] GetNowMaskに合わせるべき。
		*/
		void OnContexMenu(NeGui CatchItem, int x, int y) {
			if(CatchItem !is GroupTree) {
				return;
			}
			auto TreeItem=GetTreeItem(x, y);
			if(!TreeItem) {
				TreeItem = new TREEITEM;
				TreeItem.data = cast(void*)TYPE.NONE;
				TreeItem.node = GroupTree.nodeRoot(TREEINSERTITEM.ROOT);
			}
			auto Mask=GetNowMask(TreeItem.node);

			auto menu=new PopUp();

			/+
			menu.insertText(GROUP_COMMAND.MOVE_UP,   LanguageData.settingGroup(LD.SETTING_GROUP.UP),   cast(bool)GroupTree.nodePrevious(TreeItem.item));
			menu.insertText(GROUP_COMMAND.MOVE_DOWN, LanguageData.settingGroup(LD.SETTING_GROUP.DOWN), cast(bool)GroupTree.nodeNext(TreeItem.item));
			menu.insertSeparator();
			menu.insertText(GROUP_COMMAND.EDIT,   LanguageData.message(LD.MESSAGE.EDIT));
			menu.insertText(GROUP_COMMAND.DELETE, LanguageData.message(LD.MESSAGE.DELETE));
			menu.insertSeparator();
			auto DISABLE=cast(MENU_FLAG)(MENU_FLAG.GRAYED | MENU_FLAG.DISABLED);
			with(GROUP_COMMAND) switch(cast(TYPE)TreeItem.data) {
				case TYPE.MAIN:
					menu.insertText(MAIN_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_INSERT));
					menu.insertText(MAIN_ADD,    LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
					menu.insertSeparator();
					menu.insertText(SUB_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_ADD));
					if(!GroupTree.nodeNext(GroupTree.nodeNext(TreeItem.item))) {
						//最後が<Menu>なんでその次がnullだったら×。
						menu.enable(MOVE_DOWN, DISABLE);
					}
					break;
				case TYPE.SUB:
					menu.insertText(SUB_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_INSERT));
					menu.insertText(ITEM_ADD,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_ADD));
					break;
				case TYPE.ITEM:
					menu.insertText(ITEM_INSERT,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_INSERT));
					break;
				case TYPE.MENU:
					menu.insertText(MAIN_ADD,    LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
					menu.insertText(SUB_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_ADD));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DELETE, DISABLE);
					break;
				case TYPE.NONE:
					menu.insertText(MAIN_ADD,    LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DELETE, DISABLE);
					break;
				default:
					assert(false);
			}
			+/

			alias PAIR!(MASK, void delegate()) MASKDGPAIR;
			auto MASKDGPAIR[] MaskDgPairs = [
				MASKDGPAIR(MASK.MOVE_UP, {
					menu.insertText(GROUP_COMMAND.MOVE_UP, LanguageData.settingGroup(LD.SETTING_GROUP.UP), cast(bool)GroupTree.nodePrevious(TreeItem.node));
				}),
				MASKDGPAIR(MASK.MOVE_DOWN, {
					menu.insertText(GROUP_COMMAND.MOVE_DOWN, LanguageData.settingGroup(LD.SETTING_GROUP.DOWN), cast(bool)GroupTree.nodeNext(TreeItem.node));
				}),
				MASKDGPAIR(MASK.NONE, {
					menu.insertSeparator();
				}),
				MASKDGPAIR(MASK.EDIT, {
					menu.insertText(GROUP_COMMAND.EDIT,   LanguageData.message(LD.MESSAGE.EDIT));
				}),
				MASKDGPAIR(MASK.DELETE, {
					menu.insertText(GROUP_COMMAND.DELETE, LanguageData.message(LD.MESSAGE.DELETE));
				}),
				MASKDGPAIR(MASK.NONE, {
					menu.insertSeparator();
				}),
				MASKDGPAIR(MASK.MAIN_ADD, {
					menu.insertText(GROUP_COMMAND.MAIN_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
				}),
				MASKDGPAIR(MASK.MAIN_INSERT, {
					menu.insertText(GROUP_COMMAND.MAIN_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_INSERT));
				}),
				MASKDGPAIR(MASK.NONE, {
					menu.insertSeparator();
				}),
				MASKDGPAIR(MASK.SUB_ADD, {
					menu.insertText(GROUP_COMMAND.SUB_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_ADD));
				}),
				MASKDGPAIR(MASK.SUB_INSERT, {
					menu.insertText(GROUP_COMMAND.SUB_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_INSERT));
				}),
				MASKDGPAIR(MASK.NONE, {
					menu.insertSeparator();
				}),
				MASKDGPAIR(MASK.ITEM_ADD, {
					menu.insertText(GROUP_COMMAND.ITEM_ADD,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_ADD));
				}),
				MASKDGPAIR(MASK.ITEM_INSERT, {
					menu.insertText(GROUP_COMMAND.ITEM_INSERT,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_INSERT));
				})
			];
			bool PrevSep=true;
			void delegate() LastMethod;
			size_t LastNotSep;
			foreach(MaskDgPair; MaskDgPairs) {
				bool MenuIns=true;
				if(MaskDgPair.left && (Mask & MaskDgPair.left) == MaskDgPair.left) {
					PrevSep = false;
				} else if(!PrevSep && !MaskDgPair.left) {
					PrevSep = true;
				} else {
					MenuIns = false;
				}

				if(MenuIns) {
					if(LastMethod) LastMethod();
					LastMethod = MaskDgPair.right;
					LastNotSep = MaskDgPair.left != MASK.NONE;
				}
			}
			if(LastMethod && LastNotSep) {
				LastMethod();
			}
			
			if(cast(TYPE)TreeItem.data != TYPE.NONE) {
				GroupTree.select(TreeItem.node, TreeView.SELECT.CARET);
			}
			if(auto Id=menu.show(this, PopUp.FLAG.RIGHTBUTTON | PopUp.FLAG.NONOTIFY | PopUp.FLAG.RETURNCMD)) {
				CommandExec(cast(GROUP_COMMAND)Id, TreeItem.node);
			}
		}
		/*
		void OnContexMenu(NeGui CatchItem, int x, int y) {
			if(CatchItem !is GroupTree) {
				return;
			}
			
			auto TreeItem=GetTreeItem(x, y);
			if(!TreeItem) {
				TreeItem = new TREEITEM;
				TreeItem.data = cast(void*)TYPE.NONE;
				TreeItem.item = GroupTree.nodeRoot(TREEINSERTITEM.ROOT);
			}

			enum COMMAND: COMMAND_ID {
				MOVE_UP=1,
				MOVE_DOWN,
				EDIT,
				DEL,
				MAIN_ADD,
				MAIN_INSERT,
				SUB_ADD,
				SUB_INSERT,
				ITEM_ADD,
				ITEM_INSERT,
			}
			
			scope menu=new PopUp();
			/+
			menu.insertText(COMMAND.MOVE_UP, Text("上へ"), cast(bool)GroupTree.nodePrevious(TreeItem.item));
			menu.insertText(COMMAND.MOVE_DOWN, Text("下へ"), cast(bool)GroupTree.nodeNext(TreeItem.item));
			menu.insertSeparator();
			menu.insertText(COMMAND.EDIT, Text("編集"));
			menu.insertText(COMMAND.DEL, Text("削除"));
			menu.insertSeparator();
			+/
			menu.insertText(COMMAND.MOVE_UP,   LanguageData.settingGroup(LD.SETTING_GROUP.UP),   cast(bool)GroupTree.nodePrevious(TreeItem.item));
			menu.insertText(COMMAND.MOVE_DOWN, LanguageData.settingGroup(LD.SETTING_GROUP.DOWN), cast(bool)GroupTree.nodeNext(TreeItem.item));
			menu.insertSeparator();
			menu.insertText(COMMAND.EDIT, LanguageData.message(LD.MESSAGE.EDIT));
			menu.insertText(COMMAND.DEL,  LanguageData.message(LD.MESSAGE.DELETE));
			menu.insertSeparator();
			auto DISABLE=cast(MENU_FLAG)(MENU_FLAG.GRAYED | MENU_FLAG.DISABLED);
			
			with(COMMAND) switch(cast(TYPE)TreeItem.data) {
				case TYPE.MAIN:
					/+
					menu.insertText(MAIN_INSERT, Text("メイングループ挿入"));
					menu.insertText(MAIN_ADD, Text("メイングループ追加"));
					+/
					menu.insertText(MAIN_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_INSERT));
					menu.insertText(MAIN_ADD,    LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
					menu.insertSeparator();
					//menu.insertText(SUB_ADD, Text("サブグループ追加"));
					menu.insertText(SUB_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_ADD));
					if(!GroupTree.nodeNext(GroupTree.nodeNext(TreeItem.item))) {
						//最後が<Menu>なんでその次がnullだったら×。
						menu.enable(MOVE_DOWN, DISABLE);
					}
					break;
				case TYPE.SUB:
					/+
					menu.insertText(SUB_INSERT, Text("サブグループ挿入"));
					menu.insertText(ITEM_ADD, Text("アイテム追加"));
					+/
					menu.insertText(SUB_INSERT, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_INSERT));
					menu.insertText(ITEM_ADD,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_ADD));
					break;
				case TYPE.ITEM:
					//menu.insertText(ITEM_INSERT, Text("アイテム挿入"));
					menu.insertText(ITEM_INSERT,   LanguageData.settingGroup(LD.SETTING_GROUP.ITEM_INSERT));
					break;
				case TYPE.MENU:
					//menu.insertText(SUB_ADD, Text("サブグループ追加"));
					menu.insertText(SUB_ADD, LanguageData.settingGroup(LD.SETTING_GROUP.SUB_ADD));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DEL, DISABLE);
					break;
				case TYPE.NONE:
					//menu.insertText(MAIN_ADD, Text("メイングループ追加"));
					menu.insertText(MAIN_ADD,    LanguageData.settingGroup(LD.SETTING_GROUP.MAIN_ADD));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DEL, DISABLE);
					break;
				default:
					assert(false);
			}
			if(cast(TYPE)TreeItem.data != TYPE.NONE) {
				GroupTree.select(TreeItem.item, TreeView.SELECT.CARET);
			}
			if(auto id=menu.show(this, PopUp.FLAG.NONOTIFY | PopUp.FLAG.RETURNCMD)) {
				TREEINSERTITEM TreeInsertItem;
				bool InsertFlag=true;
				
				with(COMMAND) switch(id) {
					case MOVE_UP:
						GroupTree.nodeMove(TreeItem.item, +1);
						InsertFlag = false;
						break;
					case MOVE_DOWN:
						GroupTree.nodeMove(TreeItem.item, -1);
						InsertFlag = false;
						break;
					case EDIT:
						if(cast(TYPE)TreeItem.data == TYPE.ITEM) {
							ItemSelect.setFocus;
						} else {
							InputContent(*TreeItem);
						}
						InsertFlag = false;
						break;
					case DEL:
						GroupTree.del(TreeItem.item);
						InsertFlag = false;
						break;
					case MAIN_ADD:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.MAIN, Text("MainGroup"), false);
						if(cast(TYPE)TreeItem.data != TYPE.NONE) {
							TreeInsertItem.insertAfter = GroupTree.nodePrevious(GroupTree.nodeTail(TreeItem.item));
						} else {
							TreeInsertItem.insertAfter = TREEINSERTITEM.FIRST;
						}
						break;
					case MAIN_INSERT:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.MAIN, Text("Main Group"), true);
						break;
					case SUB_ADD:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.SUB, Text("Sub Group"), false);
						TreeInsertItem.parent = TreeItem.item;
						break;
					case SUB_INSERT:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.SUB, Text("Sub Group"), true);
						break;
					case ITEM_ADD:
						Text Name = "New Item";
						if(ItemSelect.count) {
							//Name = ItemSelect.getItemList[0].itemID;
							Name = ItemSelect.iiPairs[0].left.itemID;
						}
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.ITEM, Name, false);
						TreeInsertItem.parent = TreeItem.item;
						break;
					case ITEM_INSERT:
						Text Name = "New Item";
						if(ItemSelect.count) {
							Name = ItemSelect.iiPairs[0].left.itemID;
						}
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.ITEM, Name, true);
						break;
					default:
						assert(false);
				}

				if(InsertFlag) {
					GroupTree.select(GroupTree.insert(TreeInsertItem), TreeView.SELECT.CARET);
				}
			}
		}
		*/

		/**
		History:
			1.00β15:
				ほいさぁ！
		*/
		bool OnAccelerator(COMMAND_ID Id) {
			return false;
		}

		/**
		History:
			1.00β14:
				[P] ツリービューのダブルクリックを無視。
		*/
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) {
			switch(Id) {
				case CTRL.GROUP:
					switch(Notify.code) {
						case TreeView.EVENT.SELCHANGED:
						auto TreeViewMessage=cast(TREEVIEWMESSAGE*)Notify;
						if(*TreeViewMessage.itemNew != TREEITEM.init) {
							// アイテムの編集可不可 setItemListとの統一が必要。
							auto IsItem=cast(TYPE)TreeViewMessage.itemNew.data == TYPE.ITEM;
							ItemSelect.enable=IsItem;
							if(IsItem) {
								auto CopyItem=GetTreeItem(TreeViewMessage.itemNew.node);
								auto NowID=Text(CopyItem.text);
								if(NowID in ItemSelect)
								ItemSelect.selectID(NowID);
							}
						}
						SetGroupMenuMask(GetNowMask(TreeViewMessage.itemNew.node));
						return 0;
					default:
						return 0;
					}
					assert(false);

				case CTRL.ITEM:
					switch(Notify.code) {
						case ListView.EVENT.ITEMCHANGED:
							auto ListViewMessage=cast(LISTVIEWMESSAGE*)Notify.ptr;
							auto TreeItem=GroupTree.get(GroupTree.nodeCaret());
						
							if(TreeItem.node) if(auto pPair=(cast(size_t)ListViewMessage.data in iiPairs)) {
								TreeItem.text = pPair.left.itemID;
								GroupTree.set=TreeItem;
							}
						
							return 0;
						default:
							return 0;
					}
				
				default:
					return 0;
			}
			assert(false);
		}
	}

	private TREEITEM* GetTreeItem(int x, int y, in size_t TextLength=TreeView.TEXTLENGTH) {
		TREEHITTEST TreeHitTest;
		TreeHitTest.point.x = x;
		TreeHitTest.point.y = y;
		if(GroupTree.pointToClient(TreeHitTest.point)) {
			auto Item = GroupTree.hitTest(TreeHitTest);
			
			if(Item) {
				return GetTreeItem(Item, TextLength);
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	private TREEITEM* GetTreeItem(TREE_NODE Item, in size_t TextLength=TreeView.TEXTLENGTH) {
		auto TreeItem=new TREEITEM;
		auto str=new wchar[TextLength];
		TreeItem.mask = TREEITEM.MASK.HANDLE | TREEITEM.MASK.TEXT | TREEITEM.MASK.USERDATA;
		TreeItem.node = Item;
		TreeItem.text = str.ptr;
		TreeItem.textLength=str.length;
		if(GroupTree.get(*TreeItem)) {
			return TreeItem;
		} else {
			return null;
		}
	}

	// ここから@@@移動系は今度。
	MASK GetNowMask(TREE_NODE TreeNode) {
		auto TreeItem=GetTreeItem(TreeNode);
		MASK MoveUp, MoveDown;

		if(GroupTree.nodePrevious(TreeItem.node)) {
			MoveUp = MASK.MOVE_UP;
		}
		if(cast(bool)GroupTree.nodeNext(TreeItem.node)) {
			MoveDown = MASK.MOVE_DOWN;
		}

		
		with(MASK) final switch(cast(TYPE)TreeItem.data) {
			case TYPE.NONE:
				return MAIN_ADD;
			case TYPE.MENU:
				return MAIN_ADD | SUB_ADD;
			case TYPE.MAIN:
				if(!GroupTree.nodeNext(GroupTree.nodeNext(TreeItem.node))) {
					MoveDown = MASK.init;
				}
				return EDIT | DELETE | MAIN_ADD | MAIN_INSERT | SUB_ADD | MoveUp | MoveDown;
			case TYPE.SUB:
				return EDIT | DELETE | SUB_INSERT | ITEM_ADD | MoveUp | MoveDown;
			case TYPE.ITEM:
				return EDIT | DELETE | ITEM_INSERT | MoveUp | MoveDown;
		}
	}
	void SetGroupMenuMask(MASK Mask) {
		alias PAIR!(GROUP_COMMAND, MASK) GROUPMASKPAIR;
		auto GroupSysPairs=[
			GROUPMASKPAIR(GROUP_COMMAND.MOVE_UP      , MASK.MOVE_UP),
			GROUPMASKPAIR(GROUP_COMMAND.MOVE_DOWN    , MASK.MOVE_DOWN),
			GROUPMASKPAIR(GROUP_COMMAND.EDIT         , MASK.EDIT),
			GROUPMASKPAIR(GROUP_COMMAND.DELETE       , MASK.DELETE),
			GROUPMASKPAIR(GROUP_COMMAND.MAIN_ADD     , MASK.MAIN_ADD),
			GROUPMASKPAIR(GROUP_COMMAND.MAIN_INSERT  , MASK.MAIN_INSERT),
			GROUPMASKPAIR(GROUP_COMMAND.SUB_ADD      , MASK.SUB_ADD),
			GROUPMASKPAIR(GROUP_COMMAND.SUB_INSERT   , MASK.SUB_INSERT),
			GROUPMASKPAIR(GROUP_COMMAND.ITEM_ADD     , MASK.ITEM_ADD),
			GROUPMASKPAIR(GROUP_COMMAND.ITEM_INSERT  , MASK.ITEM_INSERT)
		];
		foreach(GroupSysPair; GroupSysPairs) {
			//wl("%s", (Mask & GroupSysPair.right) == GroupSysPair.right);
			GroupMenu.buttonEnable(GroupSysPair.left, (Mask & GroupSysPair.right) == GroupSysPair.right);
		}
	}

	/**
	History:
		1.000:
			[B] 重複名の登録。
	*/
	bool InputContent(const ref TREEITEM TreeItem) {
		TREEITEM CopyItem=cast(TREEITEM)TreeItem;

		Text[] NowNames;
		/+
		TREE_NODE Node=GroupTree.nodeHead(CopyItem.item);
		while(Node) {
			if(CopyItem.item != Node) {
				NowNames ~= GroupTree.get(Node).text;
			}
			Node = GroupTree.nodeNext(Node);
		}
		+/
		if(auto SiblingItems=GroupTree.getSibling(CopyItem.node)) {
			foreach(SiblingItem; SiblingItems) {
				if(CopyItem.node != SiblingItem.node) {
					NowNames ~= SiblingItem.text;
				}
			}
		}
		
		INPUTSTATUS InputStatus;
		
		with(InputStatus) {
			InputText = true;
			CanselSelect = true;
			InitText  = CopyItem.text;
			InputStatus.filter = cast(F_DelgType)delegate(in Text text) {
				return text.dup.strip;
			};
			InputStatus.convert = delegate(in Text text) {
				enforce(etc.kareki.kareki.Convert.isTreeName(text.toString), new SettingException(text ~ "はむり"));

				foreach(NowName; NowNames) {
					enforce(NowName != text, new SettingException(Text("重複[%s]", text)));
				}
			};
		}
		scope dialog=new InputDialog(cast(NeWindow)parent, InputStatus);

		if(dialog.select) {
			if(dialog.inputText != Text(CopyItem.text)) {
				CopyItem.text = dialog.inputText;
				enforce(GroupTree.set(CopyItem), new NemuxiException(ERR.toString));
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	/**
	History:
		1.010:
			[F] 挿入位置を一般的な位置に変更。
	*/
	ref TREEINSERTITEM GetInsertItem(TREE_NODE BaseNode, TYPE Type, in Text text, bool Insert) {
		auto TreeInsertItem = new TREEINSERTITEM;
		
		TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.DATA;
		TreeInsertItem.item.text = text;
		TreeInsertItem.item.data = cast(void*)Type;
		TreeInsertItem.parent = GroupTree.nodeParent(BaseNode);
		
		if(Insert) {
			if(auto Node=GroupTree.nodePrevious(BaseNode)) {
				TreeInsertItem.insertAfter = Node;
			} else {
				TreeInsertItem.insertAfter = BaseNode;
			}
		} else {
			TreeInsertItem.insertAfter = TREEINSERTITEM.LAST;
		}

		return *TreeInsertItem;
	}


	private void InitTree() {
		
		auto main=new Main(GroupBase);
		auto Groups=main.baseNames ~ Main.menuGroupName;
		foreach(i, MainName; Groups) {
			TREEINSERTITEM TreeInsertItem;
			
			TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.HANDLE | TREEITEM.MASK.USERDATA;
			TreeInsertItem.insertAfter = TREEINSERTITEM.LAST;
			TreeInsertItem.item.text = MainName;
			if(i == Groups.length-1) {
				TreeInsertItem.item.data = cast(void*)TYPE.MENU;
			} else {
				TreeInsertItem.item.data = cast(void*)TYPE.MAIN;
			}
			TreeInsertItem.parent = GroupTree.insert(TreeInsertItem);
			
			if(MainName.toString in GroupBase) {
				auto subs=main.subGroup(MainName);
			
				if(subs) foreach(j, SubName; subs.baseNames) {
					TreeInsertItem.item.text = SubName;
					auto SubParent = TreeInsertItem.parent;
					scope(exit)TreeInsertItem.parent = SubParent;
					TreeInsertItem.item.data = cast(void*)TYPE.SUB;
					TreeInsertItem.parent = GroupTree.insert(TreeInsertItem);
					if(subs.haveItems(SubName)) {
						foreach(ItemName; subs.childNames(SubName)) {
							TreeInsertItem.item.text = ItemName;
							TreeInsertItem.item.data = cast(void*)TYPE.ITEM;
							GroupTree.insert(TreeInsertItem);
						}
					}
				}
			}
		}
	}

	/**
	History:
		1.051:
			[S] 文字列を統一。
	
		1.010:
			[P] MainGroup -> Main Group。
			[B] グループ挿入時の重複。
			[F] メニューグループ選択時のメイングループ追加位置。
	*/
	private void CommandExec(GROUP_COMMAND Command, TREE_NODE NowSelectNode) {
		const Text NEW_MAINGROUP="New MainGroup", NEW_SUBGROUP="New SubGroup", NEW_ITEM="New Item";
		
				TREEINSERTITEM TreeInsertItem;
				bool InsertFlag=true;
		auto TreeItem=GroupTree.get(NowSelectNode);
				
				with(GROUP_COMMAND) switch(Command) {
					case MOVE_UP:
						GroupTree.nodeMove(NowSelectNode, +1);
						InsertFlag = false;
						break;
					case MOVE_DOWN:
						GroupTree.nodeMove(NowSelectNode, -1);
						InsertFlag = false;
						break;
					case EDIT:
						if(cast(TYPE)TreeItem.data == TYPE.ITEM) {
							ItemSelect.setFocus;
						} else {
							InputContent(TreeItem);
						}
						InsertFlag = false;
						break;
					case DELETE:
						GroupTree.del(NowSelectNode);
						InsertFlag = false;
						break;
					case MAIN_ADD:
						TreeInsertItem = GetInsertItem(NowSelectNode, TYPE.MAIN, NEW_MAINGROUP, false);
						/+
						if(cast(TYPE)TreeItem.data != TYPE.NONE && cast(TYPE)TreeItem.data != TYPE.MENU) {
							TreeInsertItem.insertAfter = GroupTree.nodePrevious(GroupTree.nodeTail(NowSelectNode));
						} else {
							TreeInsertItem.insertAfter = TREEINSERTITEM.FIRST;
						}
						+/
						auto Type=cast(TYPE)TreeItem.data;
						if(Type != TYPE.NONE && Type != TYPE.MENU) {
							TreeInsertItem.insertAfter = GroupTree.nodePrevious(GroupTree.nodeTail(NowSelectNode));
						} else if(Type == TYPE.MENU) {
							TreeInsertItem.insertAfter = GroupTree.nodePrevious(NowSelectNode);
							if(!TreeInsertItem.insertAfter) {
								TreeInsertItem.insertAfter = TREEINSERTITEM.FIRST;
							}
						} else {
							TreeInsertItem.insertAfter = TREEINSERTITEM.FIRST;
						}
						break;
					case MAIN_INSERT:
						TreeInsertItem = GetInsertItem(NowSelectNode, TYPE.MAIN, NEW_MAINGROUP, true);
						break;
					case SUB_ADD:
						TreeInsertItem = GetInsertItem(NowSelectNode, TYPE.SUB, NEW_SUBGROUP, false);
						TreeInsertItem.parent = NowSelectNode;
						break;
					case SUB_INSERT:
						TreeInsertItem = GetInsertItem(NowSelectNode, TYPE.SUB, NEW_SUBGROUP, true);
						break;
					case ITEM_ADD:
						Text Name = NEW_ITEM.dup;
						if(ItemSelect.count) {
							//Name = ItemSelect.getItemList[0].itemID;
							Name = ItemSelect.iiPairs[0].left.itemID;
						}
						TreeInsertItem = GetInsertItem(NowSelectNode, TYPE.ITEM, Name, false);
						TreeInsertItem.parent = NowSelectNode;
						break;
					case ITEM_INSERT:
						Text Name = NEW_ITEM.dup;
						if(ItemSelect.count) {
							Name = ItemSelect.iiPairs[0].left.itemID;
						}
						TreeInsertItem = GetInsertItem(NowSelectNode, TYPE.ITEM, Name, true);
						break;
					default:
						assert(false);
				}

				if(InsertFlag) {
					immutable Node=GroupTree.insert(TreeInsertItem);
					if(cast(TYPE)TreeInsertItem.item.data != TYPE.ITEM) {
						auto NowName=TreeInsertItem.item.text;
						if(auto Siblings=GroupTree.getSibling(Node)) {
							if(Siblings.length > 1) {
								foreach(i, Sibling; Siblings) {
									if(Sibling.node == Node) {
										Siblings.erase(i);
										break;
									}
								}
								auto ChangeName=NowName.dup;
								size_t n=1;
								for(auto i=0; i < Siblings.length; i++) {
									if(Siblings[i].text == ChangeName) {
										ChangeName = Text("%s(%s)", NowName, ++n);
										i=-1;
										continue;
									}
								}
								TreeInsertItem.item.mask = TREEITEM.MASK.NODE | TREEITEM.MASK.TEXT;
								TreeInsertItem.item.text = ChangeName;
								TreeInsertItem.item.node = Node;
								GroupTree.set(*TreeInsertItem.item);
							}
						}
					}
					GroupTree.select(Node, TreeView.SELECT.CARET);
				}
	}


}

