﻿/**

Bugs:
	設計が古い。

History:
	1.00β20:
		[F] 初期状態、アクセラレータの変更。

*/
module nemuxi.gui.window.dialog.inputdialog.inputdialog;

debug(inputdialog) void main() {}

import std.string;
import std.uni;

import win32.windows;

/+
import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.file.file;
import nemuxi.file.folder;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.window.window;
import nemuxi.negui.window.dialog.dialog;
//import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.image.icon;
import nemuxi.gui.control.titlebar;
public import nemuxi.negui.window.dialog.system;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.gui.window.dialog.selectdialog;
public import nemuxi.utility.convert.convert;
+/

import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.system;
import nemuxi.gui.window.dialog.selectdialog;
import nemuxi.gui.control.titlebar;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.draw.unit;
import nemuxi.negui.file.file;
import nemuxi.file.folder;
import nemuxi.image.icon;
import nemuxi.negui.system.base;
import nemuxi.system.exception;
import nemuxi.system.log;

///
class InputException: NeWindowException {
	mixin MixInNeGuiException;
}

/***/
struct INPUTSTATUS {
	bool InputText; /// 使用可/不可
	bool FileSelect; /// ditto
	bool FolderSelect; /// ditto
	bool CanselSelect; /// ditto
	Text InitText; /// 初期入力文字
	Text FileTitleText; /// ファイルタイトル文字
	Text FolderTitleText; /// フォルダタイトル文字
	FileDialog.FILTER[] extFilter; /// ファイル選択フィルタ
	Text FolderAddress; /// 両用不初期フォルダ。

	alias Text function(in Text text) F_FuncType;
	alias Text delegate(in Text text) F_DelgType;
	alias void function(in Text text) C_FuncType;
	alias void delegate(in Text text) C_DelgType;

	enum FILTER {
		NONE,
		FUNCTION,
		DELEGATE,
	}
	private FILTER Filter;
	union {
		F_FuncType f_fc;
		F_DelgType f_dg;
	}
	void filter(F_FuncType fc) {
		f_fc = fc;
		if(&f_fc) {
			Filter = FILTER.FUNCTION;
		} else {
			Filter = FILTER.NONE;
		}
	}
	void filter(F_DelgType dg) {
		f_dg = dg;
		if(&f_dg) {
			Filter = FILTER.DELEGATE;
		} else {
			Filter = FILTER.NONE;
		}
	}
	
	enum CONVERT {
		NONE,
		FUNCTION,
		DELEGATE,
	}
	private CONVERT Convert;
	union {
		C_FuncType c_fc;
		C_DelgType c_dg;
	}
	void convert(C_FuncType fc) {
		c_fc = fc;
		if(c_fc) {
			Convert = CONVERT.FUNCTION;
		} else {
			Convert = CONVERT.NONE;
		}
	}
	void convert(C_DelgType dg) {
		c_dg = dg;
		if(c_dg) {
			Convert = CONVERT.DELEGATE;
		} else {
			Convert = CONVERT.NONE;
		}
	}



}


class InputDialog: SelectDialog {
	private {
		Font CtrlFont;
		Icon FileIcon, FolderIcon;

		const INPUTSTATUS InputStatus;
		
		static enum CTRL: ITEM_ID {
			TITLE=short.max / 2 + 1,
			INPUT,
			OK,
			CANCEL,
			FILE,
			FOLDER,
		}
	}
	
	/***/
	int ctrlHeight() {
		return GetDefaultControlHeight(CtrlFont);
	}
	
	package {
		TitleBar Titlebar;
		EditLine InputText;
		Push  FileSelect;
		Push  FolderSelect;
		Push  OkSelect;
		Push  CanselSelect;

		Text input;
		//bool SelectFlag;
	}
	package void setInputText() {
		assert(this.isAlive);
		input = InputText.text;
	}

	/**
	*/
	this(NeWindow OwnerWindow, const ref INPUTSTATUS InputStatus)
	in {
		assert(OwnerWindow);
	}
	body {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = OwnerWindow;
		NeGuiInfo.exStyle      = WS_EX_DLGMODALFRAME | WS_EX_TOOLWINDOW;
		NeGuiInfo.style        = WS_DLGFRAME;

		this.InputStatus = InputStatus;
		super(NeGuiInfo);
	}
	
	/***/
	Text inputText() {
		return input;
	}

	private void SetInputText(Text text) {
		if(InputText.readOnly) {
			InputText.text = text;
		} else {
			int Start;
			int End;
			if(InputText.select(Start, End)) {
				auto str=InputText.text;
				auto StartText=str[0..Start];
				auto EndText=str[End..str.length];
				InputText.text = Text(StartText ~ text ~ EndText);
			} else {
				InputText.text = text;
			}
		}
	}

	void selectFile() {
		scope dialog=new OpenDialog();
		
		dialog.text = InputStatus.FileTitleText;
		dialog.ownerWindow = this;
		dialog.currentFolder = InputStatus.FolderAddress;
		dialog.filter(InputStatus.extFilter);
		
		if(InputStatus.FolderAddress.length && FILE.isExistence(InputStatus.FolderAddress)) {
			dialog.currentFolder = PATH.ownerFolder(InputStatus.FolderAddress);
		} else {
			//dialog.currentFolder = GetSystemFolder(SYS_FOLDER.PERSONAL);
			dialog.currentFolder = GetSystemFolder(SYSTEM_FOLDER.DOCUMENTS);
		}
		with(FileDialog.FLAG) dialog.flags = EXPLORER|FILEMUSTEXIST|HIDEREADONLY|LONGNAMES|PATHMUSTEXIST;

		if(dialog.select()) {
			SetInputText(dialog.fileAddress);
		}
	}
	void selectFolder() {
		scope dialog=new FolderDialog();

		dialog.ownerWindow = this;
		if(InputStatus.FolderAddress.length && FILE.isExistence(InputStatus.FolderAddress) && FILE.isFolder(InputStatus.FolderAddress)) {
			dialog.folderAddress = InputStatus.FolderAddress;
		}
		with(FolderDialog.FLAG) dialog.flags = RETURNSANCESTORS|RETURNNONLYFSDIRS|USENEWUI;
	
		if(dialog.select()) {
			SetInputText(dialog.folderAddress);
		}
	}

	// きたー！
	
	override protected {
		void OnCreate() {
			super.OnCreate();
			
			Titlebar     = new TitleBar(this, CTRL.TITLE);
			InputText    = new EditLine(this, CTRL.INPUT);
			InputText.noHideSelect=true;
			InputText.reLoad;
			FileSelect   = new Push(this, CTRL.FILE);
			FolderSelect = new Push(this, CTRL.FOLDER);
			OkSelect     = new Push(this, CTRL.OK);
			CanselSelect = new Push(this, CTRL.CANCEL);
			
			InputText.readOnly  = !InputStatus.InputText;
			FileSelect.enable   = InputStatus.FileSelect;
			FolderSelect.enable = InputStatus.FolderSelect;
			CanselSelect.enable = InputStatus.CanselSelect;

			InputText.text    = InputStatus.InitText;
			OkSelect.text     = Text("OK");
			CanselSelect.text = Text("キャンセル");

			FileSelect.imageType = Button.IMAGE_TYPE.ICON;
			FolderSelect.imageType = Button.IMAGE_TYPE.ICON;

			FileIcon   = GetSystemIcon(SYSICON.FILE, Icon.FIXED.SMALL);
			FolderIcon = GetSystemIcon(SYSICON.FOLDER, Icon.FIXED.SMALL);
			FileSelect.image(FileIcon);
			FolderSelect.image(FolderIcon);

			// フォント設定
			this.CtrlFont = new Font(Font.STOCK.MESSAGE, true);
			InputText.font    = CtrlFont;
			FileSelect.font   = CtrlFont;
			FolderSelect.font = CtrlFont;
			OkSelect.font     = CtrlFont;
			CanselSelect.font = CtrlFont;

			//super.userData(this);

			SIZE IconFixed;
			//GetIconControlSize(Icon.FIXED.SMALL, IconFixed);
			IconFixed=GetIconControlSize(Icon.FIXED.SMALL);

			SIZE Size;
			Size.cx = 256;
			Size.cy = this.Titlebar.getSize()+this.ctrlHeight()+1+IconFixed.cy;
			super.adjustSize(&Size);

			defButton(OkSelect);
		}
		
		bool OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			SIZE IconFixed;
			//GetIconControlSize(Icon.FIXED.SMALL, IconFixed);
			IconFixed=GetIconControlSize(Icon.FIXED.SMALL);
			auto CtrlHeight = ctrlHeight();
			auto CtrlWidth  = (Width - IconFixed.cx * 2) / 2;
			auto TitleHeight= Titlebar.getSize();

			Titlebar.onSize();
			
			InputText.move(0, TitleHeight, Width, CtrlHeight);
			
			FileSelect.move(0, TitleHeight+CtrlHeight+1, IconFixed.cx, IconFixed.cy, true);
			FolderSelect.move(IconFixed.cx, TitleHeight+CtrlHeight+1, IconFixed.cx, IconFixed.cy, true);
			
			OkSelect.move(IconFixed.cx*2, TitleHeight+CtrlHeight+1, CtrlWidth, IconFixed.cy, true);
			CanselSelect.move(IconFixed.cx*2+CtrlWidth, TitleHeight+CtrlHeight+1, CtrlWidth, IconFixed.cy, true);

			return true;
		}

		void OnDestroy() {
			setInputText();
			delete CtrlFont;
			delete FileIcon;
			delete FolderIcon;
			super.OnDestroy();
		}
		
		void OnDrawItem(ITEM_ID Id, DRAWITEM* DrawItem) {
			switch(DrawItem.type) {
				case CONTROL_TYPE.BUTTON: // タイトルボタン
					assert(DrawItem.id == CTRL.TITLE);
					Titlebar.draw(DrawItem);
					break;
				default:
					assert(false);
			}
		}
		
		void OnActive(WINDOW_ACTIVE Active, bool NotSmall, HWND NextWnd) {
			Titlebar.onActive(Active);
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			try {
				if(MessageType == Button.EVENT.CLICKED) switch(Id) {
					case CTRL.OK:
						try {
							/+
							if(InputStatus.fc) {
								InputStatus.fc(InputText.text);
							}
							if(InputStatus.dg) {
								InputStatus.dg(InputText.text);
							}
							+/
							Text FilterText;
							final switch(InputStatus.Filter) {
								case INPUTSTATUS.FILTER.NONE:
									FilterText = InputText.text;
									break;
								case INPUTSTATUS.FILTER.FUNCTION:
									FilterText = InputStatus.f_fc(InputText.text);
									break;
								case INPUTSTATUS.FILTER.DELEGATE:
									FilterText = InputStatus.f_dg(InputText.text);
									break;
							}
							final switch(InputStatus.Convert) {
								case INPUTSTATUS.CONVERT.NONE:
									break;
								case INPUTSTATUS.CONVERT.FUNCTION:
									InputStatus.c_fc(FilterText);
									break;
								case INPUTSTATUS.CONVERT.DELEGATE:
									InputStatus.c_dg(FilterText);
									break;
							}
							InputText.text = FilterText;
						} catch(Exception e) {
							throw new InputException(Text("ん？"), e);
						}
						SelectFlag = true;
						destroy;
						break;
					case CTRL.CANCEL:
						SelectFlag = false;
						destroy;
						break;
					case CTRL.FILE:
						selectFile();
						break;
					case CTRL.FOLDER:
						selectFolder();
						break;
					default:
						return false;
				}
			} catch(Throwable e) {
				Logger.write(e);
				SelectFlag = false;
				scope exd=new ExceptionDialog(this, e);
				exd.select;
			}
			return false;
		}

		void OnShowWindow(bool Show, SHOW_FLAG Flag) {
			InputText.setFocus;
			InputText.select(0, -1);
		}
		
	}

}

