﻿/**

BUGS:
	フォルダを実行できない。
*/
module nemuxi.gui.window.dialog.execdialog.execdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(execdialog) void main() {}

import std.string;
import std.contracts;

import win32.windows;
import win32.commctrl;

/+
import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.file.file;
import nemuxi.file.folder;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.linkitem;
import nemuxi.file.items.structure;
//import nemuxi.image.font;
import nemuxi.image.icon;
import nemuxi.negui.draw.unit;
import nemuxi.negui.draw.cursor;
import nemuxi.negui.window.newindow;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.combobox.combobox;
import nemuxi.gui.control.combobox;
import nemuxi.utility.simple.his;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.gui.window.dialog.selectdialog;
import nemuxi.gui.gui;

import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.dual;
+/

import nemuxi.file.items.itemfunc;
import nemuxi.file.items.item;
import nemuxi.gui.control.combobox;
import nemuxi.gui.gui;

import nemuxi.negui.system.base;
import nemuxi.system.language;
import nemuxi.system.staticdata;
import nemuxi.system.exception;
import nemuxi.system.log;


import nemuxi.gui.window.dialog.selectdialog;
import nemuxi.file.items.structure;
import nemuxi.system.application;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.combobox.combobox;
import nemuxi.negui.control.button.button;
import nemuxi.negui.window.dialog.system;

import nemuxi.negui.file.file;
import nemuxi.negui.draw.unit;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.dual;
import nemuxi.negui.layout.panel.line;

import nemuxi.negui.event.dropfile;
import nemuxi.negui.window.newindow;

import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.file.folder;
import nemuxi.utility.simple.his;

/**
History:
	1.051:
		[F] ウィンドウの高さを変更負荷に。
*/
class ExecDialog: SelectDialog {
	mixin(import("nemuxi.gui.window.dialog.execdialog.execdialog.d.dat"));
	
	private {
		/+
		enum CTRL: ITEM_ID {
			ADDRESS=1,
			WORK_SELECT,
			WORK_INPUT,
			OPTION_SELECT,
			OPTION_INPUT,
			SHOW,
			EXECUTE,
			CLOSE,
		}
		+/

		BMITEM BMItem;
		//Font CtrlFont;
		//bool SelectFlag;

		Application application;
		/+
		EditLine Address;
		Push WorkSelect, OptionSelect, Execute, Close;
		ComboBox WorkInput, OptionInput;
		ShowComboBox ShowSelect;
		+/

		Text* option;

		SIZE BaseSize;
	}
	/**
	History:
		1.00β13:
			[F] オプション引数を追加。
	*/
	this(NeWindow Owner, Item item, Application application, Text* option=null)
	in {
		assert(Owner);
		assert(item);
		assert(application);
	}
	body {
		this.application = application;
		this.option = option;
		
		BMItem = ItemToButtonMenuItem(item, true, Icon.FIXED.SMALL);
		
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner   = Owner;
		NeGuiInfo.style   = WS_DLGFRAME | WS_CAPTION | WS_THICKFRAME | WS_SYSMENU;

		super(NeGuiInfo);
		
		defButton = Execute;

		this.Center = CENTER.DESKTOP;
	}

	override protected {
		/**
		History:
			1.000:
				[@] 生成と設定がごっちゃなんで試験的に分離。
		
			1.00β19:
				[F] ダイアログの初期横幅を拡張。
		
			1.00β13:
				[S] オプション引数追加によるオプション項目の変更。
		*/
		void OnCreate() {
			super.OnCreate();
			dropFile=true;
			auto item=BMItem.item;
			//text=Text(item.itemID);
			auto TitleText=LanguageData.dialog(LD.DIALOG.EX);
			text = Text(TitleText, item.toTextLine.text);
			//CtrlFont = new Font(Font.STOCK.MESSAGE);
			
			setIcon(Icon.FIXED.SMALL, BMItem.icon);


			
			DATA_ControlCreate();
			DATA_FontCreate();
			DATA_FontSetControl();
			DATA_PanelSetControl();
			

			// アイテムアドレス(Item.TYPE依存)
			//Address=new EditLine(this, CTRL.ADDRESS);
			with(Item.TYPE) switch(item.type()) {
				case NORMAL: Address.text = item.address; break;
				case URI:    Address.text = item.uri;     break;
				case MULTI:  Address.text = nemuxi.negui.system.text.join(item.multi, Text(", ")); break;
				default:     assert(false);
			}
			Address.readOnly=true;
			//Address.font = CtrlFont;

			// 作業フォルダ選択コントロール
			//WorkSelect=new Push(this, CTRL.WORK_SELECT);
			//WorkSelect.font = CtrlFont;
			//WorkSelect.text = Text("作業フォルダ...");
			WorkSelect.text = LanguageData.ex(LD.EX.WORK);

			// 作業フォルダ入力コントロール
			//WorkInput=new ComboBox(this, CTRL.WORK_INPUT, ComboBox.TYPE.DROPEDIT);
			//WorkInput.font = CtrlFont;
			Text WorkText = Text(GetWorkFolder(item));
			if(item.historyWorkFolders.length) {
				WorkInput.add(Texts(item.historyWorkFolders));
			}
			WorkInput.add(WorkText);
			WorkInput.text = WorkText;

			// オプション選択コントロール
			//OptionSelect=new Push(this, CTRL.OPTION_SELECT);
			//OptionSelect.font = CtrlFont;
			//OptionSelect.text = Text("オプション...");
			OptionSelect.text = LanguageData.ex(LD.EX.OPTION);

			// オプション入力コントロール
			//OptionInput=new ComboBox(this, CTRL.OPTION_SELECT, ComboBox.TYPE.DROPEDIT);
			//OptionInput.font = CtrlFont;
			Text OptionText = Text(item.option);
			if(item.historyOptions.length) {
				OptionInput.add(Texts(item.historyOptions));
			}
			if(option) {
				OptionInput.text = *option;
			} else {
				OptionInput.text = OptionText;
			}
			OptionInput.add(OptionText);
			
			// 表示方法選択コントロール
			//ShowSelect=new ShowComboBox(this, CTRL.SHOW);
			//ShowSelect.font = CtrlFont;
			ShowSelect.initialize();
			ShowSelect.select(item.show);

			// 表示方法選択コントロール
			//Execute=new Push(this, CTRL.EXECUTE);
			//Execute.font = CtrlFont;
			//Execute.text = Text("実行");
			Execute.text = LanguageData.message(LD.MESSAGE.EXECUTE);
			Execute.def = true;
			Execute.setFocus;

			// 表示方法選択コントロール
			//Close=new Push(this, CTRL.CLOSE);
			//Close.font = CtrlFont;
			//Close.text = Text("閉じる");
			Close.text = LanguageData.message(LD.MESSAGE.CLOSE);

			/+
			immutable Padding=GetControlPadding();
				
			auto Rows=new Tansu(DIRECTION.VERTICAL);
			Rows.sizeInfo.absolute = WorkInput.editerHeight();
			Rows.padding.bottom = Rows.padding.top    = Padding.cy / 2;
			Rows += Address;
			
			auto Works=new Dual(DIRECTION.HORIZON);
			Works[0] = WorkSelect;
			Works[1] = WorkInput;
			Works.centerSize = Padding.cx;
			Works.sizeInfo.percent = 35;
			Rows += Works;
			
			auto Options=new Dual(DIRECTION.HORIZON);
			Options[0] = OptionSelect;
			Options[1] = OptionInput;
			Options.centerSize = Padding.cx;
			Options.sizeInfo.percent = 35;
			Rows += Options;

			auto Selects=new Dual(DIRECTION.HORIZON);
			Selects[0] = Execute;
			Selects[1] = Close;
			Selects.centerSize = Padding.cx;
			Selects.sizeInfo.percent = 50;
			
			auto Others=new Line(DIRECTION.HORIZON);
			Others += ShowSelect;
			Others += null;
			Others += Selects;
			Others.sizeInfo(0).percent = 30;
			Others.sizeInfo(1).percent = 25;
			Others.sizeInfo(2).absolute = -1;
			Rows += Others;
			
			layoutManager.basePanel = Rows;
			
			SIZE Size=void;
			Size.cx = 412;
			Size.cy = WorkInput.editerHeight() * 4 + Padding.cy/2 * 5*2;

			adjustSize(Size.cx, Size.cy);
			+/
			BaseSize = itemSize;
		}
		void OnDestroy() {
			delete BMItem.icon;
			//delete CtrlFont;
			DATA_FontDelete();
			
			super.OnDestroy();
		}
		HIT_TEST OnNonClientHitTest(HIT_TEST HitFlag, int x, int y) {
			with(HIT_TEST) switch(HitFlag) {
				case TOP, BOTTOM:
					return CLIENT;
				case BOTTOMLEFT, TOPLEFT:
					return LEFT;
				case BOTTOMRIGHT, TOPRIGHT:
					return RIGHT;
				default:
					return HitFlag;
			}
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == Button.EVENT.CLICKED) {
				switch(Id) {
					case CTRL.WORK_SELECT: {
						WorkSelectDialog();
						return true;
					}
					case CTRL.OPTION_SELECT: {
						OptionSelectDialog();
						return true;
					}
					case CTRL.EXECUTE: {
						ExecuteSelect();
						destroy();
						return true;
					}
					case CTRL.CLOSE: {
						destroy();
						return true;
					}
					default:
						return false;
				}
			} else {
				return false;
			}
		}

		void OnDropFiles(DropFile drop) {
			try {
				OptionInput.text = DropFileJoin(drop[], application.setting.shortcut, this);
			} catch(Exception e) {
				ShowExceptionDialog(this, e);
			}
		}

		/**
		History:
			1.051:
				新規作成。
		*/
		bool OnMinMax(POINT* MaxSize, POINT* MaxPos, POINT* MaxTrack, POINT* MinTrack) {
			MaxSize.y = MinTrack.y = BaseSize.cy;
			return true;
		}
		
	}

	private {
		void WorkSelectDialog() {
			auto WorkFolder=WorkInput.text;

			auto Folder=new FolderDialog();
			Folder.ownerWindow = this;
			if(WorkFolder.length && FILE.isExistence(WorkFolder) && FILE.isFolder(WorkFolder)) {
				Folder.folderAddress = WorkFolder;
			}
			with(FolderDialog.FLAG) Folder.flags = RETURNSANCESTORS|RETURNNONLYFSDIRS|USENEWUI;
			
			try {
				if(Folder.select()) {
					WorkInput.text = Folder.folderAddress;
				}
			} catch(Exception e) {
				Logger.write(e);
				ShowExceptionDialog(this, e);
			}
		}

		void OptionSelectDialog() {
			auto OptionFolder=OptionInput.text;

			auto File=new OpenDialog();
			File.ownerWindow = this;
			if(OptionFolder.length && FILE.isExistence(OptionFolder)) {
				File.currentFolder = PATH.ownerFolder(OptionFolder);
			} else {
				//@@@
				//File.currentFolder = GetSystemFolder(SYS_FOLDER.PERSONAL);
				File.currentFolder = GetSystemFolder(SYSTEM_FOLDER.DOCUMENTS);
			}
			File.flags = FileDialog.FLAG.DEFAULT;
			
			OpenDialog.FILTER[] filter;
			auto FiltersList=StaticData.fileFilter;
			foreach(Filters; FiltersList) {
				filter ~= OpenDialog.FILTER(Filters[0], Filters[1..$]);
			}
			
			File.filter = filter;
			
			if(File.select()) {
				OptionInput.text = File.fileAddress;
			}
		}

		/**
		History:
			1.030:
				[S] 内容若干変更。
		*/
		void ExecuteSelect() {
			mixin(SMixInLog("ExecDialog", "ExecuteSelect"));
			log.write("[Item] ID = %s, type = %s.", BMItem.item.itemID, BMItem.item.type);
			
			// 実行
			try {
				OVERRIDEINFO* OverInfo;
				void OverSet() {
					if(OverInfo is null) {
						OverInfo = new OVERRIDEINFO;
					}
				}
				enforce(BMItem.live, new NemuxiException("あれれ"));
				if(WorkInput.text != BMItem.item.workFolder) {
					log.write("override - work folder.");
					
					OverSet();
					//OverInfo.Mask       |= OVERRIDEINFO.MASK.WORK;
					OverInfo.mask       |= OVERRIDEINFO.MASK.WORK;
					//OverInfo.WorkFolder =  WorkInput.text.toString();
					OverInfo.workFolder =  WorkInput.text;
				}
				if(OptionInput.text != BMItem.item.option) {
					log.write("override - option.");
					
					OverSet();
					//OverInfo.Mask   |= OVERRIDEINFO.MASK.OPTION;
					OverInfo.mask   |= OVERRIDEINFO.MASK.OPTION;
					//OverInfo.Option =  OptionInput.text.toString();
					OverInfo.option =  OptionInput.text;
				}
				if(ShowSelect.select != BMItem.item.show) {
					log.write("override - show.");
					
					OverSet();
					/+
					OverInfo.Mask |= OVERRIDEINFO.MASK.SHOW;
					OverInfo.Show =  ShowSelect.select;
					+/
					OverInfo.mask |= OVERRIDEINFO.MASK.SHOW;
					OverInfo.show =  ShowSelect.select;
				}
				/*synchronized(BMItem.item)*/ application.executeItem(BMItem.item, OverInfo);
			} catch(Exception e) {
				//Logger.write(e);
				log.write(e);
				ShowExceptionDialog(this, e);
			}


			// 履歴設定
			invariant HISTORY_MAX=application.setting.historyMax();
			if(!HISTORY_MAX) {
				log.write("history - 0.");
				
				return;
			}

			/// 履歴設定
			void HistoryList(ComboBox Target, void delegate(Text[]) dg) {
				if(Target.count > 1) {
					Text[] TempStrs;
					if(Target.count-1 == 1) {
						// 登録はひとつだけ
						TempStrs=[Target[0]];
					} else {
						TempStrs=Target[0..Target.count-2];
					}
					auto AddStr  =Target.text.strip;

					if(Target[Target.count-1].strip == AddStr) {
						return;
					}
					
					auto TempList=HistorySort(TempStrs, AddStr);
					
					if(TempList.length > HISTORY_MAX) {
						TempList.length = HISTORY_MAX;
					}
					dg(TempList);
				} else if(Target[0] != Target.text) {
					dg([Target.text]);
				}
			}

			log.write("history - work folder[%s].", WorkInput.text);
			HistoryList(WorkInput, &BMItem.item.historyWorkFolders);
			log.write("history - option[%s].", OptionInput.text);
			HistoryList(OptionInput, &BMItem.item.historyOptions);
		}
	}
}

