﻿/**
ふるい・・・
*/
module nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(exceptiondialog) void main() {}

import std.conv;
import std.string;
import std.file: write;

import win32.windows;
/+
import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.window.window;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.gui.window.dialog.selectdialog;
//import nemuxi.negui.proc.exceptionwnd.exceptionwnd;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.label.label;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.treeview.treeview;
import nemuxi.image.icon;
//import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.negui.control.group;
import nemuxi.utility.simple.sysinfo;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.dual;
+/
import nemuxi.system.exception;
import nemuxi.system.language;
import nemuxi.system.log;
import nemuxi.gui.window.dialog.selectdialog;
import nemuxi.negui.system.base;
import nemuxi.negui.system.type.base;
import nemuxi.negui.window.window;
import nemuxi.negui.window.newindow;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.label.label;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.treeview.treeview;
import nemuxi.negui.layout.panel.dual;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.draw.unit;
import nemuxi.negui.draw.icon;
import nemuxi.negui.draw.font;
import nemuxi.negui.control.group;
import nemuxi.negui.window.dialog.system;
import nemuxi.utility.simple.sysinfo;
import nemuxi.negui.clipboard;
import nemuxi.file.folder;
import nemuxi.negui.file.file;

deprecated package enum CTRL {
	WARNIG=1,
	MESSAGE,
	//ERRCODE,
	//DETAILS,
	WEB,
	CLOSE,
	COPY,
	FILE,
	UPLOAD,
	//SELECT_MSG,
	LIST
}
/**
History:
	1.00β19:
		[F] ダイアログサイズを一回り大きく。
*/
final scope class ExceptionDialog: SelectDialog, IText {
	private {
		//Throwable Throwables;
		Throwable FirstThrowable;
		//Window Owner;
		
		Font MessageFont;
		Font CtrlFont;
		Font TreeFont;

		ControlGroup Msgs, Buttons;

		enum CTRL {
			WARNIG=1,
			MESSAGE,
			//ERRCODE,
			//DETAILS,
			WEB,
			CLOSE,
			COPY,
			FILE,
			UPLOAD,
			//SELECT_MSG,
			LIST
		}
	}
	package {
		IconLabel Warnig;
		EditBox Message;
		//EditBox ErrCode;
		Push Web, Close, Copy, File, UpLoad;
		//EditBox SelectMsg;
		TreeView List;

		
	}

	this(Window OwnerWindow, Throwable e) {
		FirstThrowable = e;
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.style        = WS_DLGFRAME | WS_CAPTION | WS_SYSMENU;
		NeGuiInfo.style        |= WS_SIZEBOX;
		NeGuiInfo.owner=OwnerWindow;

		super(NeGuiInfo);
			SIZE Size;
			Size.cx = GetSystemMetrics(SM_CXSCREEN) / 3;
			Size.cy = GetSystemMetrics(SM_CYSCREEN) / 4;
			super.adjustSize(&Size);

		defButton = Close;

		super.Center = CENTER.DESKTOP;
	}

//	private mixin Modal;
	
	override bool select() {
		/+
		try {
			if(Owner) {
				Owner.enable = false;
			}
			SIZE Size;
			Size.cx = GetSystemMetrics(SM_CXSCREEN) / 4;
			Size.cy = GetSystemMetrics(SM_CYSCREEN) / 6;;
			super.adjustSize(&Size);
			super.toCenter(CENTER.DESKTOP, null);
			super.setShow(SW.SHOW);
			SetOverAuto(Close);
			MessageBeep(MB_ICONEXCLAMATION);
			modal;

			return true;
		} catch(Exception e) {
			Logger.write(e);
			return false;
		} finally {
			if(Owner) {
				Owner.enable = true;
				Owner.foreGround();
				Owner.send(WM_NULL, NONE, NONE);
			}
		}
		+/
		try {
			MessageBeep(MB_ICONEXCLAMATION);
			
			return super.select();
		} catch(Throwable e) {
			Logger.write(e);
			return false;
		}
	}
	


	private {
		void CommandWeb() {
		}
		/**
		History:
			1.063:
				[F] 有効化。
		*/
		void CommandCopy() {
			scope clip=new TextClipBoard(this);
			clip.set(toText);
		}
		/**
		History:
			1.070:
				[B] フィルタが異常。
		
			1.063:
				[F] 有効化。
		*/
		void CommandFile() {
			scope dialog=new SaveDialog();
			dialog.initialize;
			dialog.ownerWindow = this;
			dialog.filter = [SaveDialog.FILTER(Text("*.log"), [Text("*.log")])];
			dialog.currentFolder = GetSystemFolder(SYSTEM_FOLDER.DOCUMENTS);
			dialog.flags = SaveDialog.FLAG.DEFAULT;
			
			if(dialog.select) {
				write(PATH.changeExtension(dialog.fileAddress, Text("log")).text8, toText.text8);
			}
		}
		void CommandUpLoad() {
		}
	}
	
	protected override {
		void OnDestroy() {
			delete MessageFont;
			delete CtrlFont;
			delete TreeFont;
			
			super.OnDestroy();
		}
		/*
		History:
			1.070:
				[P] クラス名表示方法変更。
		
			1.051:
				[B] core.exception.AssertError@nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog(349): Assertion failure
		
			1.032:
				[F] NeGuiExceptionとNemuxiExceptionの分離。
		
			1.00β11:
				メッセージ欄にシステム情報の書き出し。
				メッセージ欄のフォントをSYSFONT.MESSAGEへ変更。
		*/
		void OnCreate() {
			super.OnCreate();
			MessageFont = new Font(Font.STOCK.MESSAGE);
			CtrlFont    = new Font(Font.STOCK.MESSAGE);
			TreeFont    = new Font(Font.STOCK.ICON);

			text = LanguageData.dialog(LD.DIALOG.ERROR);
			
			{ // コントロール
				//Warnig=new IconLabel(child(CTRL.WARNIG));
				Warnig=new IconLabel(this, CTRL.WARNIG);
				Warnig.image(new Icon(Icon.STOCK.HAND, Icon.FIXED.NORMAL));
				Warnig.position = PictureLabel.POSITION.CENTER;

				//Message=new TextLabel(child(CTRL.MESSAGE));
				//Message=new TextLabel(this, CTRL.MESSAGE);
				Message=new MultiEdit(this, CTRL.MESSAGE);

				//ErrCode  = new TextLabel(child(CTRL.ERRCODE));
				//ErrCode  = new EditBox(this, CTRL.ERRCODE);

				//
				/+
				Msgs = new ControlGroup(
					Message, ErrCode
				);
				Msgs.font = MessageFont;
				+/
				Message.font = MessageFont;

				/+
				Web    = new Push(child(CTRL.WEB));
				Close  = new Push(child(CTRL.CLOSE));
				Copy   = new Push(child(CTRL.COPY));
				File   = new Push(child(CTRL.FILE));
				UpLoad = new Push(child(CTRL.UPLOAD));
				+/
				Web    = new Push(this, (CTRL.WEB));
				Close  = new Push(this, (CTRL.CLOSE));
				Copy   = new Push(this, (CTRL.COPY));
				File   = new Push(this, (CTRL.FILE));
				UpLoad = new Push(this, (CTRL.UPLOAD));

				Buttons = new ControlGroup(
					Web, File, UpLoad, Copy, Close
				);
				Buttons.font = CtrlFont;
				Close.def = true;

				//SelectMsg = new EditBox(child(CTRL.SELECT_MSG));
				//SelectMsg = new EditBox(this, (CTRL.SELECT_MSG));
				//SelectMsg.font = CtrlFont;

				List = new TreeView(this, CTRL.LIST);
				List.clientEdge = true;
				List.button =true;
				List.rootLine = true;
				List.button = true;
				List.reLoad;
			}

			{ // 固定文字列の設定
				Web   .text = Text("Web");
				//Close .text = Text("閉じる");
				Close .text = LanguageData.message(LD.MESSAGE.CLOSE);
				Copy  .text = LanguageData.message(LD.MESSAGE.COPY);
				File  .text = LanguageData.message(LD.MESSAGE.OUTPUT);
				UpLoad.text = Text("アップロード");
			}

			{ // 未実装部分非表示
				Buttons.setShow(SHOW.HIDE);
				Close.setShow(SHOW.SHOW);
				Copy.setShow(SHOW.SHOW);
				File.setShow(SHOW.SHOW);
			}

			{ // レイアウト設定
				auto MessagePanel=new Dual(DIRECTION.HORIZON);
				MessagePanel[0] = Warnig;
				MessagePanel[1] = Message;
				MessagePanel.sizeInfo.absolute = Icon.fixedToSize(Icon.FIXED.NORMAL);
				auto ButtonsPanel=new Tansu(DIRECTION.HORIZON);
				ButtonsPanel.padding.left = GetControlPadding.cx;
				ButtonsPanel += Web;
				ButtonsPanel += UpLoad;
				ButtonsPanel += File;
				ButtonsPanel += Copy;
				ButtonsPanel += Close;
				ButtonsPanel.sizeInfo.percent = 20;
				auto BasePanel=new Line(DIRECTION.VERTICAL);
				BasePanel += MessagePanel;
				BasePanel += List;
				BasePanel += ButtonsPanel;
				BasePanel.sizeInfo(0).absolute = -1;
				BasePanel.sizeInfo(1).absolute = -1;
				BasePanel.sizeInfo(2).absolute = Close.minContentHeight;
				BasePanel.padding.top = GetControlPadding.cy;

				layoutManager.basePanel = BasePanel;
			}

			{ // リスト構築
				Throwable NowThrowable=FirstThrowable;
				string[] msgs;

				Text ClassName(const Object o) {
					auto name=o.classinfo.name.toText;
					auto dot=name.rfind('.');
					if(dot != -1) {
						return name[name.length-dot .. name.length];
					} else {
						return name;
					}
				}
				
				while(NowThrowable) {
					TREEINSERTITEM TreeInsertItem;
					TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.HANDLE | TREEITEM.MASK.USERDATA;
					
					TreeInsertItem.insertAfter(TREEINSERTITEM.LAST);

					/+
					invariant string[] Title   = [
						"File",
						"Line",
						"Code",
						"Time",
					];
					+/
					// 新規ツリー構築
					//TreeInsertItem.item.text     = Text(NowThrowable.classinfo.name);
					TreeInsertItem.item.text     = ClassName(NowThrowable);
					TreeInsertItem.item.data = cast(void*)NowThrowable;
					TreeInsertItem.parent = List.insert(TreeInsertItem);

					// 詳細の出力
					TreeInsertItem.item.text = Text(NowThrowable.msg);
					List.insert(TreeInsertItem);

					// NemuxiExceptionであれば派生。
					// NeGuiExceptionであれば派生。
					if(auto ne=cast(NeGuiException)NowThrowable) {
						// ファイル・行出力
						/+
						invariant string[] Messages = [
							ne.file,
							to!(string)(ne.line),
							to!(string)(cast(uint)ne.code),
							ne.time.toString
						];
						+/
						string[] Messages, Title;
						if(auto nemuxi=cast(NemuxiException)ne) {
							Messages = [
								nemuxi.file,
								to!(string)(nemuxi.line),
								to!(string)(cast(uint)nemuxi.code),
								nemuxi.time.toString
							];
							Title = [
								"File",
								"Line",
								"Code",
								"Time"
							];
						} else {
							Messages = [
								ne.file,
								to!(string)(ne.line),
								ne.time.toString
							];
							Title = [
								"File",
								"Line",
								"Time"
							];
						}
						assert(Title.length == Messages.length);
						for(auto i=0; i < Title.length; i++) {
							Text msg = format("%s: %s", Title[i], Messages[i]);
							TreeInsertItem.item.text = msg;
							List.insert(TreeInsertItem);
						}
					} else {
						invariant string[] Title   = [
							"File",
							"Line"
						];
						// ファイル・行があれば出力
						if(NowThrowable.file) {
							Text file = format("%s: %s", Title[0], NowThrowable.file);
							TreeInsertItem.item.text = file;
							List.insert(TreeInsertItem);
							if(NowThrowable.line) {
								Text line = format("%s: %s", Title[1], NowThrowable.line);
								TreeInsertItem.item.text = line;
								List.insert(TreeInsertItem);
							}
						}
					}
					
					msgs ~= NowThrowable.msg;
					
					NowThrowable = NowThrowable.next;
				}

				// 上位メッセージ設定。
				//Message.text = std.string.join(msgs, newline).toText ~ Text(newline ~ repeat("-", 50) ~ newline  ~ toTextInformation);
				Message.text = nemuxi.negui.system.text.join(Texts(msgs), Text.newline) ~ Text(Text.newline ~ Text.repeat(Text("-"), 50) ~ Text.newline  ~ toTextInformation);
				Message.readOnly = true;
			}
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == BN_CLICKED) {
				switch(Id) {
					case CTRL.WEB:
						CommandWeb();
				return true;
					case CTRL.CLOSE:
						destroy();
				return true;
					case CTRL.COPY:
						CommandCopy();
				return true;
					case CTRL.FILE:
						CommandFile();
				return true;
					case CTRL.UPLOAD:
						CommandUpLoad();
					return true;
				default:
				}
			}
			
			return super.OnCommand(Id, MessageType, Sender);
		}
	}

	/**
	History:
		1.063:
			新規作成。
	*/
	const Text toText() {
		return Text("%s%s%s%s%s", FirstThrowable, Text.newline, Text('-').repeat(40), Text.newline, toTextInformation);
	}
}

void ShowExceptionDialog(Window Owner, Throwable e) {
	scope Ed=new ExceptionDialog(Owner, e);
	Ed.select;
}
void ShowThrowables(T: Throwable)(Window Owner, T e) {
	scope Ed=new ExceptionDialog(Owner, e);
	Ed.select;
}
alias ShowThrowables ShowError;

alias ShowThrowables!(Error)     ShowErrorDialog;
alias ShowThrowables!(Exception) ShowExceptionDialog;


