﻿/**
ダイアログ表示。

モーダルとモードレスの二通り。
*/
/**

*/
module nemuxi.gui.window.dialog.about.about;

debug import std.stdio: wl = writefln, pl = printf;
debug(about) void main() {}

static import std.algorithm;

import nemuxi.system.language;
import nemuxi.negui.system.base;
//import nemuxi.image.font;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.label.label;
import nemuxi.negui.draw.unit;
import nemuxi.negui.control.button.button;
import nemuxi.negui.layout.panel.dual;
import nemuxi.negui.layout.panel.line;
/**
バージョン表示ダイログ。

History:
	1.00β11:
		新規作成。
		とりあえず作っただけで未完成。
		※ラベルとかサイズとか。
*/
class AboutDialog: ModalDialog {
	/**
	バージョン情報。
	*/
	struct STATUS {
		Text name;
		Text ver;

		/// VersionDialog側でkillするので手放し。32pxで。
		Icon icon;

		Text website;
		Text mail;

		Text message;
	}
	protected STATUS Status;
	
	protected enum CTRL: ITEM_ID {
		NAME=1,
		VER,
		ICON,
		WEB,
		MAIL,
		MESSAGE,
		CLOSE
	}
	protected {
		TextLabel TargetName;
		TextLabel TargetVersion;
		
		IconLabel TargetIcon;

		TextLabel TargetSite;
		TextLabel TargetMail;

		MultiEdit TargetMessage;

		Push Close;
	}
	private {
		Font CtrlFont;
	}
	/**
	History:
		1.061:
			[S] deprecated修正。
	*/
	this(NeGui Owner, ref STATUS Status) {
		NEGUIINFO NeGuiInfo;

		NeGuiInfo.owner = Owner;

		this.Status = Status;
		
		//super(&GuiInfo, DIALOG_ID.init);
		super(NeGuiInfo, DIALOG_ID.init);
	}
	
	protected override {
		/**
		History:
			1.00β18:
				[P] 横スクロールしないように変更。
				[P] サイズ変更可能に。
		
			1.00β11:
				メッセージ欄に横スクロールバー追加。
		*/
		void OnCreate() {
			super.OnCreate();

			CtrlFont = new Font(Font.STOCK.MESSAGE);
			
			caption = true;
			frameSize = true;

			//text = Text("バージョン情報");
			text = LanguageData.dialog(LD.DIALOG.VERSION);

			TargetName    = new TextLabel(this, CTRL.VER);
			TargetVersion = new TextLabel(this, CTRL.NAME);
			TargetIcon    = new IconLabel(this, CTRL.ICON);
			TargetSite    = new TextLabel(this, CTRL.WEB);
			TargetMail    = new TextLabel(this, CTRL.MAIL);
			TargetMessage = new MultiEdit(this, CTRL.MESSAGE, false);
			Close         = new Push(this, CTRL.CLOSE);
			
			TargetMessage.readOnly = true;
			//TargetMessage.hScroll=true;
			
			defButton = Close;
			Close.def = true;

			TargetIcon.position = IconLabel.POSITION.CENTER;

			TargetName    .font = CtrlFont;
			TargetVersion .font = CtrlFont;
			TargetSite    .font = CtrlFont;
			TargetMail    .font = CtrlFont;
			TargetMessage .font = CtrlFont;
			Close         .font = CtrlFont;

			// 値の設定。アイコンはあとで。
			TargetName.text = Status.name;
			TargetVersion.text = Status.ver;
			TargetSite.text = Status.website;
			TargetMail.text = Status.mail;

			TargetMessage.text = Status.message;
			//

			Close.text = LanguageData.message(LD.MESSAGE.CLOSE);

			//DIRECTION.HORIZON
			auto NameVer = new Dual(DIRECTION.VERTICAL);
			NameVer[0] = TargetName;
			NameVer[1] = TargetVersion;
			NameVer.sizeInfo.percent = 50;
			
			auto IconNames = new Line(DIRECTION.HORIZON);
			if(Status.icon) {
				TargetIcon.image = Status.icon;
				IconNames += TargetIcon;
				IconNames.sizeInfo(0).absolute = GetIconControlSize(Icon.FIXED.NORMAL).cx;
			}
			IconNames += NameVer;
			IconNames.sizeInfo(IconNames.length-1).absolute = -1;

			auto Lines = new Line(DIRECTION.VERTICAL);
			Lines += IconNames;
			Lines.sizeInfo(0).absolute = std.algorithm.max(GetIconControlSize(Icon.FIXED.NORMAL).cy, TargetVersion.minHeight * 2);

			Lines += TargetSite;
			Lines.sizeInfo(1).absolute = TargetSite.minContentHeight;
			Lines += TargetMail;
			Lines.sizeInfo(2).absolute = TargetMail.minContentHeight;
			Lines += TargetMessage;
			Lines.sizeInfo(3).absolute = -1;
			
			Lines += null;
			Lines.sizeInfo(4).percent = 8;
			
			Lines += Close;
			Lines.sizeInfo(5).absolute = Close.minContentHeight;

			layoutManager.basePanel = Lines;
			
			adjustSize(324, 256);
		}
		void OnDestroy() {
			delete CtrlFont;
			
			super.OnDestroy();
		}
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender is Close && MessageType == Push.EVENT.CLICKED) {
				destroy;
			}
			return super.OnCommand(Id, MessageType, Sender);
		}
		
	}
}

