﻿/**
ぼったん
*/
module nemuxi.gui.gui;

debug import std.stdio: wl = writefln, pl = printf;
debug(gui) void main() {}

import win32.windows;

import nemuxi.negui.allimport;

//import nemuxi.base;
//public import nemuxi.negui.negui;
import nemuxi.negui.system.base;
import nemuxi.negui.window.window;
import nemuxi.negui.file.file;
//import nemuxi.negui.com.ipersistfile: STGM;
import nemuxi.negui.file.com.shortcut;


///
class NemuxiGuiException: NeGuiException {
	mixin MixInNeGuiException;
}

/**
Params:
	Files = D&Dされたファイル。

	ShortCut = Files[n]がショートカットの場合に展開を行うか。

Return:
	結合された文字列。

History:
	1.00β18:
		新規作成。
*/
Text DropFileJoin(in Text[] Files, bool ShortCut, Window Parent) {
	auto JoinFiles=new Text[Files.length];
	
	for(auto j=0; j < Files.length; j++) {
		if(ShortCut && !PATH.cmp(PATH.getExtension(Files[j]), Text("lnk"))) {
			scope link=new Shortcut(Parent);
			link.fileLoad(Files[j], STGM.READ);
			if(Files.length > 1) {
				JoinFiles[j] = link.address.quot('"');
			} else {
				JoinFiles[0] = link.address;
			}
		} else {
			if(Files.length > 1) {
				JoinFiles[j] = Files[j].quot('"');
			} else {
				JoinFiles[0] = Files[j];
			}
		}
	}

	return nemuxi.negui.system.text.join(JoinFiles, Text(' '));
}








