﻿/**
アイテム入力特化。

すごくやっつけ、取り扱い注意。
*/
module nemuxi.gui.control.iteminput;

debug import std.stdio: wl = writefln, pl = printf;
debug(iteminput) void main() {}

import std.string;
import std.conv;
import std.contracts;

import win32.windows;
/+
import nemuxi.base;
import nemuxi.negui.window.newindow;
public import nemuxi.file.items.item;
public import nemuxi.file.items.items;
public import nemuxi.file.items.linkitem;
import nemuxi.negui.event.subclass;
public import nemuxi.negui.control.editbox.editbox;
public import nemuxi.gui.control.combobox;
public import nemuxi.gui.control.excombobox;
import nemuxi.negui.control.control;
import nemuxi.negui.control.button.button;
import nemuxi.gui.control.editbox;
import nemuxi.negui.window.menu.popup;
import nemuxi.negui.control.updown.updown;
import nemuxi.negui.layout.panel.line;
+/

import nemuxi.file.items.items;
import nemuxi.file.items.item;
import nemuxi.file.items.itemif;
public import nemuxi.gui.control.combobox;
public import nemuxi.gui.control.excombobox;
public import nemuxi.gui.control.itemcontrol;
import nemuxi.negui.system.base;
import nemuxi.negui.draw.font;
import nemuxi.negui.draw.brush;
import nemuxi.negui.draw.canvas;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.editbox.editbox;
public import nemuxi.negui.control.combobox.combobox;
public import nemuxi.negui.control.updown.updown;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.window.menu.popup;
import nemuxi.system.language;

import nemuxi.negui.system.type.basic;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.system.type.record;


/**
なんぞこれー

アイテムを持たせとく設計だったけどやめた。
*/
final class ItemAddress: Control {
	private {
		ITEM_ID Id;
		NeGui     Owner;
		Item.TYPE Type;
		
		ItemIconPairs Pairs;
	}
	union {
		ItemAddress me;
		
		EditLine addr;
		EditLine uri;
		MultiInput multi;
		ItemComboBox link;
	}
	
	private ItemAddress MakeControl(Item.TYPE Type) {
		delete me;
		with(Item.TYPE) switch(Type) {
			case NORMAL:
				addr = new EditLine(Owner, Id);
				break;
			case URI:
				uri = new EditLine(Owner, Id);
				break;
			case MULTI:
				multi = new MultiInput(Owner, Id);
				multi.iiPairs = Pairs;
				break;
			case LINK:
				link = new ItemComboBox(Owner, Id);
				link.iiPairs = Pairs;
				break;
			default:
				assert(false);
		}
		me.Type = Type;
		guiObject = me;
		return me;
	}
	private void SetText(in Item item) {
		if(item) with(Item.TYPE) switch(item.type) {
			case NORMAL:
				text = Text(item.address);
				break;
			case URI:
				text = Text(item.uri);
				break;
			case MULTI:
				multi.setItemId = item.multi;
				break;
			case LINK:
				if(item.link in link) {
					link.selectID(item.link);
				} else {
					link.text = item.link;
				}
				break;
			default:
				assert(false);
		} else  {
			if(Type == Item.TYPE.MULTI) {
				multi.setItemId = null;
			} else {
				text = Text.emptyText;
			}
			return;
		}
	}

	private this(in Item item) {
		MakeControl(item ? item.type: Item.TYPE.NORMAL);
		
		super(me());
		
		SetText(item);
	}
	/***/
	this(NeGui Owner, ITEM_ID Id, ItemIconPairs Pairs, in Item item) {
		this.Id        = Id;
		this.Owner     = Owner;
		this.Pairs  = Pairs;
		this(item);
	}

	override {
		const Font font() {
			if(Type == Item.TYPE.MULTI) {
				return multi.font();
			} else {
				return super.font();
			}
		}
		void font(in Font font) {
			if(Type == Item.TYPE.MULTI) {
				multi.font(font);
			} else {
				super.font(font);
			}
		}
		const Text text() {
			if(Type == Item.TYPE.MULTI) {
				return multi.text();
			} else {
				return super.text();
			}
		}
		bool text(in Text text) {
			return super.text(text);
		}
	}

	private void Change(lazy ItemAddress ItemAddressControl)
	out {
		assert(isAlive);
	}
	body {
		auto OldCtrl=this;

		auto ItemPoint = OldCtrl.clientPosition();
		auto ItemSize=OldCtrl.itemSize();
		auto CtrlFont = OldCtrl.font;
		
		OldCtrl.destroy();
		assert(!OldCtrl.isAlive);
		
		auto NewCtrl = ItemAddressControl;//new ItemAddress(OldCtrl.Owner, OldCtrl.Id, OldCtrl.ItemList, item);
		this.hWnd = NewCtrl.hWnd;
		
		this.me = NewCtrl;
		
		this.Type = NewCtrl.type;
		if(CtrlFont) {
			font = CtrlFont;
		}
		
		move(ItemPoint.x, ItemPoint.y, ItemSize.cx, ItemSize.cy);
	}

	
	void iiPairs(ItemIconPairs Pairs) {
		this.Pairs = Pairs;
	}

	/***/
	void setItem(in Item item) {
		Change(MakeControl(item ? item.type: Item.TYPE.NORMAL));
		SetText(item);
	}
	void changeType(Item.TYPE Type) {
		Change(MakeControl(Type));
		assert(this.Type == Type);
		SetText(null);
	}
	const Item.TYPE type() {
		return Type;
	}
}

/**
複数アイテム。

History:
	1.00β17:
		[B] アイテム未登録時のアイテム未選択例外。

	1.00β15:
		[P] interfaceの置き換え。
Bugs:
	非正常系未チェック。
*/
//final class MultiInput: NeControl, IItemList {//}
final class MultiInput: NeControl {
	private enum CTRL: ITEM_ID {
		PREV=999,
		NEXT,
		SPIN,
		COMMAND,
		ITEM_SELECT
	}
	private {
		UpDown Spin;
		ItemComboBox ItemSelect;
	}
	private {
		//Item[] Itemlist;
		Item[] NowItems;
		size_t NowPos;
	}

	ItemIconPairs iiPairs() {
		return ItemSelect.iiPairs;
	}
	void iiPairs(ItemIconPairs Pairs) {
		ItemSelect.iiPairs = Pairs;
		nowItemList = null;
	}
	

	void nowItemList(Item[] items) {
		if(items.length) {
			auto list=ItemSelect.iiPairs;
			Item[] temp;
			foreach(item; items) {
				if(item) foreach(n; 0 .. list.length) {
					if(list[n].left.itemID == item.itemID) {
						temp ~= item;
						break;
					}
				}
			}
			items = temp;
		}
		NowItems = items;
		NowPos = 0;
		if(NowItems.length) {
			ItemSelect.selectID = NowItems[NowPos].itemID;
		}
		StateReLoad();
	}
	Item[] nowItemList() {
		return NowItems;
	}

	void setItemId(Text[] Id) {
		if(!Id.length) {
			nowItemList = null;
			return;
		}
		
		auto items =new Item[Id.length];
		auto ItemList=ItemSelect.iiPairs;

		for(auto i=0; i < items.length; i++) {
			foreach(j; 0 .. ItemList.length) {
				if(ItemList[j].left.itemID == Id[i]) {
					items[i] = ItemList[j].left;
					break;
				}
			}
		}
		
		nowItemList = items;
	}
	
	const Text[] getItemId() {
		Text[] Ids;

		foreach(item; NowItems) {
			Ids ~= item.itemID;
		}

		return Ids;
	}
	/**
	History:
		1.061:
			[S] deprecated修正。
	*/
	this(NeGui Owner, ITEM_ID Id) {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner = Owner;
		NeGuiInfo.id    = Id;

		super(NeGuiInfo);
	}
	private HFONT hFont;
	override {
		const Font font() {
			return new Font(hFont, false);
		}
		void font(in Font font) {
			hFont = font();
			auto Children=children;
			foreach(child; children) {
				child.font = font;
			}
		}
	}
	override const {
		int minHeight() {
			return ItemSelect.minHeight;
		}
		int minContentHeight() {
			return ItemSelect.minContentHeight;
		}
	}
	int editerHeight() {
		return ItemSelect.editerHeight;
	}
	override {
		const Text text() {
			if(NowItems.length) {
				auto texts=new Text[NowItems.length];
				for(auto i=0; i < texts.length; i++)
				if(NowItems[i])
				texts[i] = NowItems[i].itemID;
				else
				texts[i] = Text.emptyText;
				return Text("%s", texts);
			} else {
				return Text.emptyText;
			}
		}
	}
	protected override {
		void OnCreate() {
			Spin = new UpDown(this, CTRL.SPIN, UpDown.POSITION.HORIZON);
			Spin.range(0,1);
			ItemSelect = new ItemComboBox(this, CTRL.ITEM_SELECT);
			auto line=new Line(DIRECTION.HORIZON);
			line += Spin;
			line.sizeInfo(0).type = SIZEINFO.TYPE.PERCENT;
			line.sizeInfo(0).percent = 25;
			line += ItemSelect;
			line.sizeInfo(1).absolute = -1;
			layoutManager.basePanel=line;
			with(layoutManager.padding) {
				left = right = top = bottom = 0;
			}
		}

		bool OnPaint(Canvas canvas, ref const(RECT) Rect, bool BackReDraw) {
			canvas.fillRect(Rect, new Brush(Brush.STOCK.WHITE));
			return true;
		}
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Id == CTRL.ITEM_SELECT) {
				if(MessageType == ComboBox.EVENT.LISTCHANGE) {
					ItemChange(NowPos, ItemSelect.selectValue.left);
					return true;
				}
			}
			return false;
		}
		void OnContexMenu(NeGui CatchItem, int x, int y) {
			enum COMMAND: COMMAND_ID {
				INSERT=1,
				ADD,
				DEL,
				ALL_DEL
			}
			if(!iiPairs.length) {
				return;
			}
			
			scope menu=new PopUp();
			
			menu.insertText(COMMAND.ADD, LanguageData.message(LD.MESSAGE.ADD));
			if(NowItems.length) {
				menu.insertSeparator();
				menu.insertText(COMMAND.DEL, LanguageData.message(LD.MESSAGE.DELETE));
				//意味が若干違うけどまぁいいや＠元：このアイテム以外全て削除
				menu.insertText(COMMAND.ALL_DEL, LanguageData.message(LD.MESSAGE.DELETE_ALL));
			}

			if(NowItems.length) {
				foreach(i, item; NowItems) {
					MENUITEM MenuItems;
					MenuItems.initialize;
					auto Type = MENUITEM.TYPE.STRING;
					if(!i) {
						Type |= MENUITEM.TYPE.MENUBARBREAK;
					}
					MenuItems.type = Type;
					MenuItems.mask = MENUITEM.MASK.TYPE | MENUITEM.MASK.ID;
					MenuItems.id   = cast(COMMAND_ID)(COMMAND.max + 1 + i);
					MenuItems.text = item.toString.toText;
					menu.insert(MenuItems);
				}
				menu.radio(
					cast(COMMAND_ID)(COMMAND.max + 1),
					cast(COMMAND_ID)(COMMAND.max + 1 + NowItems.length),
					cast(COMMAND_ID)(COMMAND.max + 1 + NowPos)
				);
			}

			if(auto id=menu.attach(this, this, PopUp.ATTACH.BOTTOM, PopUp.MESSAGE.NONE | PopUp.MESSAGE.RETURN)) {
				switch(id) {
					case COMMAND.ADD: {
						NowItems ~= ItemSelect.selectValue.left;
						NowPos = NowItems.length-1;
						StateReLoad();
						break;
					}
					case COMMAND.DEL: {
						if(NowItems.length != 1) {
							if(NowPos == NowItems.length-1) {
								NowItems.length = NowItems.length-1;
							} else if(NowPos) {
								NowItems = NowItems[0..NowPos] ~ NowItems[NowPos+1 .. $];
							} else {
								NowItems = NowItems[1..$];
							}
						} else {
							NowItems = null;
						}
						nowItemList = NowItems;
						break;
					}
					case COMMAND.ALL_DEL: {
						nowItemList = [NowItems[NowPos]];
						break;
					}
						
					default:
						if(COMMAND.max + 1 <= id && COMMAND.max + 1 + NowItems.length) {
							PositionChange(id - COMMAND.max - 1);
						} else {
							assert(false);
						}
				}
			}
		}
		void OnScroll(DIRECTION Direction, SCROLL Scroll, int Position, NeGui Sender) {
			assert(Direction == DIRECTION.HORIZON);
			if(Scroll == SCROLL.THUMB_POSITION) {
				immutable TempPos=NowPos;
				
				if(Position == 0 && NowPos) {
					NowPos--;
				} else if(Position && NowPos != NowItems.length-1) {
					NowPos++;
				}
				
				if(TempPos != NowPos) {
					PositionChange(NowPos);
				}
			}
		}
		
	}
	private {
		void PositionChange(size_t Index)
		in {
			if(NowItems.length)
			assert(0 <= Index && Index < NowItems.length);
		}
		body {
			if(NowItems.length) {
				ItemSelect.selectID = NowItems[Index].itemID;
				NowPos = Index;
			} else {
				NowPos = 0;
			}
			StateReLoad();
		}
		void ItemChange(size_t Index, Item item)
		in {
			assert(item);
		}
		body {
			if(NowItems.length) {
				NowItems[Index] = item;
				NowPos = Index;
			} else {
				NowItems = [item];
				NowPos = 0;
			}
		}
		void StateReLoad() {
			if(NowItems.length) {
				ItemSelect.selectID = NowItems[NowPos].itemID;
				Spin.enable = NowItems.length != 1;
			} else {
				Spin.enable = false;
			}
		}
	}
}


