﻿/**
機能限定コンボボックス。
*/
module nemuxi.gui.control.excombobox;

debug import std.stdio: wl = writefln, pl = printf;

import std.string;
import std.conv;

import win32.windows;
import win32.commctrl;
/+
import nemuxi.base;
import nemuxi.negui.negui;
import nemuxi.file.items.item;
import nemuxi.file.items.items;
import nemuxi.negui.draw.imagelist;
public import nemuxi.negui.control.combobox.combobox;
public import nemuxi.negui.control.combobox.excombobox;
import nemuxi.gui.control.itemcontrol;
import nemuxi.negui.event.subclass;
+/

import nemuxi.file.items.items;
import nemuxi.file.items.item;
public import nemuxi.gui.control.itemcontrol;
public import nemuxi.negui.control.combobox.combobox;
public import nemuxi.negui.control.combobox.excombobox;
import nemuxi.negui.event.subclass;
public import nemuxi.negui.negui;
public import nemuxi.negui.event.event;
import nemuxi.negui.draw.imagelist;
import nemuxi.negui.system.base;
import nemuxi.negui.system.type.basic;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.system.type.record;

/**
History:
	1.00β16:
		[B] コントロール破棄時にイメージリスト破棄処理追加。
*/
final class ItemComboBox: ExComboBox, IItemIconPairList, ISubClass {
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.WM_TOP!(ItemComboBox));
		switch(Message) {
			case WM_DESTROY: mixin(EVENTLOOP.WM_DESTROY());
			default:         mixin(EVENTLOOP.WM_LAST!(ItemComboBox));
		}
	}
	mixin(TSubClass);
	protected override {
		void OnDestroy() {
			if(auto image=imageList) {
				image.kill;
			}
			
			SubClassOnNeGuiDestructor;
			super.OnDestroy();
		}
	}
	
	
	this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id, TYPE.DROPLIST);
		SubClassOnNeGuiConstructor();
	}
	mixin MixInItemIconPairList;

	ItemIconPairs iiPairs() {
		return Pairs;
	}
	void iiPairs(ItemIconPairs Pairs) {
		ImageList OldImage;
		clear;
		this.Pairs=Pairs;

		if(this.Pairs && this.Pairs.length) {
			auto IconPx=Pairs.iconPx;
			auto Image = new ImageList(IconPx, IconPx, ImageList.COLOR_TYPE.COLOR32 | ImageList.COLOR_TYPE.MASK, Pairs.length, 0, false);


			COMBOBOXITEM ComboItem;
			ComboItem.mask = COMBOBOXITEM.MASK.TEXT | COMBOBOXITEM.MASK.IMAGE | COMBOBOXITEM.MASK.SELECTEDIMAGE | COMBOBOXITEM.MASK.DATA;

			foreach(i; 0 .. Pairs.length) {
				Image.add(Pairs[i].right);

				ComboItem.text       = Pairs[i].left.toTextLine;
				ComboItem.imageIndex = i;
				ComboItem.imageIndexSelected = i;
				ComboItem.index = i;
				ComboItem.data = cast(void*)i;
				
				insertEx(ComboItem);
			}
			
			select = 0;
			enable = true;

			OldImage = imageList(Image);
		} else {
			enable = false;
			
			OldImage = imageList();
		}

		if(OldImage) {
			OldImage.kill;
		}
	}

	Text selectID() {
		return Pairs[select].left.itemID;
	}
	void selectID(in Text ItemID) {
		selectValue(&Pairs[ItemID]);
	}
	
	ITEMICONPAIR* selectValue() {
		auto n=super.select();
		if(n < Pairs.length) {
			return &Pairs[n];
		} else {
			return null;
		}
	}
	void selectValue(ITEMICONPAIR* Pair) {
		foreach(i; 0..Pairs.length) {
			if(Pair.left == Pairs[i].left) {
				super.select(i);
				return;
			}
		}
		super.select = -1;
	}
}

