﻿/**
機能限定コンボボックス。
*/
module nemuxi.gui.control.combobox;

debug import std.stdio: wl = writefln, pl = printf;

import std.string;
import std.conv;

import win32.windows;
import win32.commctrl;
/+
import nemuxi.base;
import nemuxi.negui.window.window;
import nemuxi.system.application;
import nemuxi.negui.system.raii;
import nemuxi.system.language;
import nemuxi.negui.negui;
import nemuxi.file.setting;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.items;
import nemuxi.negui.draw.imagelist;
public import nemuxi.negui.control.combobox.combobox;
public import nemuxi.negui.control.combobox.excombobox;
import nemuxi.gui.control.itemcontrol;
import nemuxi.negui.input.keyboard.keyboard;
+/
import nemuxi.file.items.item;
import nemuxi.file.items.itemif;
import nemuxi.file.setting;

public import nemuxi.gui.gui;
import nemuxi.negui.system.base;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.input.keyboard.keyboard;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.combobox.combobox;

import nemuxi.system.language;
import nemuxi.system.log;
import nemuxi.system.exception;

/**
Bugs:
	selectはやめるべき。
*/
abstract class LimitedComboBox(T): ComboBox, IInitialize {
	invariant() {
		assert(ValueString.length);
	}
	private string[] ValueString;
	
	this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id, TYPE.DROPLIST);
	}
	
	abstract protected const int Convert(T Value);
	abstract protected const T   Convert(int Value);

	///
	override void initialize() {
		super.clear();
		super.add(Texts(ValueString));
		super.select = 0;
	}
	/**
	Deprecated:
		exSelect
	*/
	override const T select() {
		//return Convert(super.select());
		return exSelect;
	}
	/**
	Deprecated:
		exSelect
	*/
	T select(T Value) {
		//return Convert(super.select(Convert(Value)));
		return exSelect(Value);
	}
	/**
	Deprecated:
		廃止。
	*/
	deprecated override int select(int Value) {
		throw new NemuxiGuiException(Text("hidden!"));
	}

	///
	const T exSelect() {
		return Convert(super.select());
	}
	///
	T exSelect(T Value) {
		return Convert(super.select(Convert(Value)));
	}
}

final class ShowComboBox: LimitedComboBox!(SHOW) {
	this(NeGui Owner, ITEM_ID Id) {
		/+
		super.ValueString = [
			"通常表示",
			"最小化",
			"最大化",
			"通常表示(非アクティブ)",
			"最小化(非アクティブ)"//,
			//"非指定"
		];
		+/
		with(SHOW) foreach(Show; [SHOWNORMAL, SHOWMINIMIZED, SHOWMAXIMIZED, SHOWNOACTIVATE, SHOWMINNOACTIVE]) {
			super.ValueString ~= LanguageData.show(Show).toString;
		}
		super(Owner, Id);
	}
	protected override const int Convert(SHOW Value) {
		switch(Value) {
			case SHOW.SHOWNORMAL:      return 0;
			case SHOW.SHOWMINIMIZED:   return 1;
			case SHOW.SHOWMAXIMIZED:   return 2;
			case SHOW.SHOWNOACTIVATE:  return 3;
			case SHOW.SHOWMINNOACTIVE: return 4;
//			case SHOW.NONE:            return 5;
			default:
				Logger.write(format("[%s]は指定値以外のため通常表示へ", Value));
				return Convert(SHOW.SHOWNORMAL);
		}
	}
	protected override const SHOW Convert(int ValueNumber) {
		switch(ValueNumber) {
			case 0: return SHOW.SHOWNORMAL;
			case 1: return SHOW.SHOWMINIMIZED;
			case 2: return SHOW.SHOWMAXIMIZED;
			case 3: return SHOW.SHOWNOACTIVATE;
			case 4: return SHOW.SHOWMINNOACTIVE;
//			case 5: return SHOW.NONE;
			default:
				Logger.write(format("[%s]は指定値以外のため通常表示へ", ValueNumber));
				return Convert(0);
		}
	}
}

///
final class TypeComboBox: LimitedComboBox!(Item.TYPE) {
	this(NeGui Owner, ITEM_ID Id) {
		/+
		super.ValueString = [
			"通常",
			"URI",
			"複数",
			"リンク"
		];
		+/
		foreach(Item.TYPE Type; Item.TYPE.min .. cast(Item.TYPE)(Item.TYPE.max+1)) {
			super.ValueString ~= LanguageData.itemType(Type).text8;
		}
		
		super(Owner, Id);
	}
	
	protected override const int Convert(Item.TYPE Value) {
		switch(Value) {
			case Item.TYPE.NORMAL: return 0;
			case Item.TYPE.URI:    return 1;
			case Item.TYPE.MULTI:  return 2;
			case Item.TYPE.LINK:   return 3;
			default:
				Logger.write(format("[%s]は指定値以外のためItem.TYPE.NORMALへ", Value));
				return Convert(Item.TYPE.NORMAL);
		}
	}
	protected override const Item.TYPE Convert(int ValueNumber) {
		switch(ValueNumber) {
			case 0: return Item.TYPE.NORMAL;
			case 1: return Item.TYPE.URI;
			case 2: return Item.TYPE.MULTI;
			case 3: return Item.TYPE.LINK;
			default:
				Logger.write(format("[%s]は指定値以外のため通常表示へ", ValueNumber));
				return Convert(0);
		}
	}
}

/***/
final class WindowPosComboBox: LimitedComboBox!(Setting.POSITION) {
	this(NeGui Owner, ITEM_ID Id) {
		/+
		super.ValueString = [
			"左部",
			"上部",
			"右部",
			"下部",
			"フロート",
			"非表示"
		];
		+/
		foreach(Setting.POSITION Pos; Setting.POSITION.min .. cast(Setting.POSITION)(Setting.POSITION.max+1)) {
			super.ValueString ~= LanguageData.windowPosition(Pos).text8;
		}
		super(Owner, Id);
	}
	protected override const int Convert(Setting.POSITION Value) {
		switch(Value) {
			case Setting.POSITION.LEFT:   return 0;
			case Setting.POSITION.TOP:    return 1;
			case Setting.POSITION.RIGHT:  return 2;
			case Setting.POSITION.BOTTOM: return 3;
			case Setting.POSITION.FLOAT:  return 4;
			case Setting.POSITION.SMALL:  return 5;
			default:
				Logger.write(format("[%s]は指定値以外のためApp.POSITION.FLOATへ", Value));
				return Convert(Setting.POSITION.FLOAT);
		}
	}
	protected override const Setting.POSITION Convert(int ValueNumber) {
		switch(ValueNumber) {
			case 0: return Setting.POSITION.LEFT;
			case 1: return Setting.POSITION.TOP;
			case 2: return Setting.POSITION.RIGHT;
			case 3: return Setting.POSITION.BOTTOM;
			case 4: return Setting.POSITION.FLOAT;
			case 5: return Setting.POSITION.SMALL;
			default:
				Logger.write(format("[%s]は指定値以外のため4へ", ValueNumber));
				return Convert(4);
		}
	}
}
/**
History:
	1.051:
		[P] ちまっと拡張。
*/
final class KeyComboBox: LimitedComboBox!(KEY) {
	this(NeGui Owner, ITEM_ID Id) {
		/+
		foreach(Key; KEY.A .. KEY.Z + 1) {
			super.ValueString ~= to!(string)(cast(KEY)Key);
		}
		+/
		foreach(i, Key; KEYS) {
			if(i) {
				super.ValueString ~= to!(string)(toCharacter(Key));
			} else {
				super.ValueString ~= "";
			}
		}
		
		super(Owner, Id);
	}
	
	protected override const int Convert(KEY Value) {
		/+
		switch(Value) {
			case KEY.A:
			..
			case KEY.Z:
				return Value - KEY.A;

			default:
				Logger.write(format("[%s]は指定値以外のためKEY.Aへ", Value));
				return Convert(KEY.A);
		}
		+/
		auto Index=KEYS.indexOf(Value);
		if(Index != -1) {
			return Index;
		}
		return 0;
	}
	protected override const KEY Convert(int ValueNumber) {
		/+
		switch(ValueNumber) {
			case 0:
			..
			case 27:
			return cast(KEY)(ValueNumber + KEY.A);
			default:
				Logger.write(format("[%s]は指定値以外のため0へ", ValueNumber));
				return Convert(0);
		}
		+/
		if(KEYS.isSafe(ValueNumber)) {
			return KEYS[ValueNumber];
		}
		return KEY.NONE;
	}
}


