﻿/**
ぼったん
*/
module nemuxi.gui.control.button;

debug import std.stdio: wl = writefln, pl = printf;

import win32.windows;

//import nemuxi.base;
import nemuxi.negui.event.subclass;
public import nemuxi.negui.control.button.button;
import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.icon;
import nemuxi.image.icon;
import nemuxi.negui.draw.bitmap;
import nemuxi.negui.draw.unit;

class ImageButton: Push, ISubClass {
	private Draw ImageObject;
	private static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.WM_TOP!(ImageButton));
		switch(Message) {
			case WM_DESTROY:
				mixin(EVENTLOOP.WM_DESTROY);
			default:
				mixin(EVENTLOOP.WM_LAST!(ImageButton));
		}
	}
	mixin(TSubClass);

	private this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id);
		/+
		SubclassObject = new SubClass(this, &SubClass_Proc);
		SubclassObject.start();
		+/
		SubClassOnNeGuiConstructor;
	}
	this(NeGui Owner, ITEM_ID Id, Icon icon) {
		this(Owner, Id);

		imageType = IMAGE_TYPE.ICON;
		ImageObject = icon;
		image = icon;

	}
	this(NeGui Owner, ITEM_ID Id, Bitmap bmp) {
		this(Owner, Id);
		
		imageType = IMAGE_TYPE.BITMAP;
		ImageObject = bmp;
		image = bmp;
	}

	protected override {
		void OnDestroy() {
			delete ImageObject;
			
			SubClassOnNeGuiDestructor;
			super.OnDestroy();
		}
	}
}

final class SystemIconButton: ImageButton {
	private {
		Icon.FIXED IconFixed;
	}
	this(NeGui Owner, ITEM_ID Id, SYSICON SysIcon, Icon.FIXED IconFixed) {
		this.IconFixed = IconFixed;
		super(Owner, Id, GetSystemIcon(SysIcon, IconFixed));
	}

	mixin(SMixInStructGet!(Icon.FIXED)("iconSize", q{IconFixed}));

	const ref SIZE getSize() {
		return GetIconControlSize(IconFixed);
	}
	
	void toDefaultSize() {
		size(getSize());
	}
}


