﻿/**
付箋の親玉。

*/
module nemuxi.file.sticky.stickymanager;

debug import std.stdio: wl = writefln, pl = printf;
debug(stickymanager) void main() {}

import std.string;
import std.contracts;

import etc.kareki.kareki;

import nemuxi.negui.system.base;
import nemuxi.negui.file.file;
import nemuxi.negui.file.find;
import nemuxi.negui.draw.font;
import nemuxi.negui.draw.color;
import nemuxi.system.exception;
import nemuxi.file.setting;
import nemuxi.file.data;
import nemuxi.system.staticdata;
import nemuxi.file.sticky.stickyif;
import nemuxi.file.sticky.sticky;

class StickyManager {
	private static immutable EXT = ".aki";
	private {
		Setting setting;
		Text StickyFolder;
		const STICKYSTYLE BaseStyle;
	}
	this(Setting setting, in Text BaseFolder) {
		this.setting = setting;
		StickyFolder = PATH.addFolderSep(BaseFolder);
		STICKYSTYLE Style;
		with(Style) {
			font = setting.stickyFont;
			alpha = setting.stickyAlpha;
			auto Colors=setting.stickyColor;
			text = Colors[0];
			back = Colors[1];
			BaseStyle=Style;
		}
	}
	mixin(SMixInClassGet!(Text)("folder", q{StickyFolder}, false));
	const Text[] allFiles() {
		auto Files=FIND.list(StickyFolder, Text('*' ~ EXT), FILE.ATTRIBUTE.NONE, StaticData.loopInit, StaticData.loopPlus);
		auto Names=new Text[Files.length];
		foreach(i, File; Files) {
			Names[i] = File.name;
		}
		return Names;
	}
	const Sticky readItem(in Text FileTitle) {
		auto FileName=PATH.join(StickyFolder, FileTitle ~ EXT);
		auto StickyRaw=ReadAkiDocument(FileName, StaticData.loopInit, StaticData.loopPlus);
		
		return new Sticky(FileTitle, StickyRaw, BaseStyle);
	}
	bool saveImte(Sticky sticky) {
		auto FileName=PATH.join(StickyFolder, sticky.title ~ EXT);
		return WriteTextData(FileName, sticky.toString.splitlines);
	}
	
	const Sticky makeItem(in Text FileTitle)
	in {
		assert(FileTitle.length);
	}
	body {
		const FileName = FileTitle ~ EXT;
		auto Files=allFiles();
		foreach(i, File; Files) {
			enforce(FileName != File.name, new StickyException(FileName));
		}
		return new Sticky(FileTitle, new Kareha(), BaseStyle);
	}

}


