﻿/**
ふせん。
*/
module nemuxi.file.sticky.sticky;

debug import std.stdio: wl = writefln, pl = printf;
debug(sticky) void main() {}

import std.contracts;

import etc.kareki.kareki;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.font;
import nemuxi.negui.draw.color;
import nemuxi.system.exception;
import nemuxi.file.data;
import nemuxi.file.sticky.stickyif;

/**
各付箋。

無効な値は親から渡されたSTICKYSTYLEで対処。
*/
class Sticky: Data {
	private enum ITEM {
		NAME,
		TYPE,
		POSITION,
		SIZE,
		FRONT,
		FONT,
		COLOR,
		ALPHA,
	}
	private immutable static struct TREE {
		immutable string

		NAME     = "Name",
		TYPE     = "Type",
		POSITION = "Position",
		SIZE     = "Size",
		FRONT    = "Front",
		FONT     = "Font",
		COLOR    = "Color",
		ALPHA    = "Alpha",

		_NONE_="";
	}
	enum TYPE {
		NORMAL,
	}
	const STICKYSTYLE baseStyle;
	private Text Title;
	mixin(SMixInClassGet!(Text)("title", q{Title}, false));
	this(in Text Title, Kareha Root, const ref STICKYSTYLE BaseStyle) {
		super(Root);
		this.Title = Title;

		// STICKYSTYLEチェック
		with(BaseStyle) {
			enforce(font, new StickyException(Text("BaseStyle.font is null.")));
			enforce(alpha, new StickyException(Text("BaseStyle.alpha == 0.")));
		}
		baseStyle = BaseStyle;
		ks = new Kareha[ITEM.max+1];

		// 形式
		RegistEx!("Sticky")(
			Root,
			TREE.NAME,
			ITEM.NAME,
			ks[ITEM.NAME].have()
			&& ks[ITEM.NAME].type() == HAGATA.String
		);
		
		// 形式
		RegistEx!(TYPE.NORMAL)(
			Root,
			TREE.TYPE,
			ITEM.TYPE,
			ks[ITEM.TYPE].have()
			&& ks[ITEM.TYPE].type() == HAGATA.Integer
			&& (TYPE.min <= ks[ITEM.TYPE].get!(Integer) && ks[ITEM.TYPE].unSafe!(Integer) <= TYPE.max)
		);

		// 位置
		RegistEx!((Integer[]).init)(
			Root,
			TREE.POSITION,
			ITEM.POSITION,
			ks[ITEM.POSITION].have()
			&& ks[ITEM.TYPE].type() == HAGATA.TSV_Integer
		);
		// サイズ
		RegistEx!((Integer[]).init)(
			Root,
			TREE.SIZE,
			ITEM.SIZE,
			ks[ITEM.SIZE].have()
			&& ks[ITEM.SIZE].type() == HAGATA.TSV_Integer
		);
		
		// Z位置
		RegistEx!(false)(
			Root,
			TREE.FRONT,
			ITEM.FRONT,
			ks[ITEM.FRONT].have()
			&& ks[ITEM.FRONT].type() == HAGATA.Integer
		);

		// フォント
		RegistEx!(string.init)(
			Root,
			TREE.FONT,
			ITEM.FONT,
			ks[ITEM.FONT].have()
			&& ks[ITEM.FONT].type() == HAGATA.String
		);

		// 色
		RegistEx!((Binary[]).init)(
			Root,
			TREE.COLOR,
			ITEM.COLOR,
			ks[ITEM.COLOR].have()
			&& ks[ITEM.COLOR].type() == HAGATA.TSV_Binary
		);
		
		// 透明度
		RegistEx!(ubyte.min)(
			Root,
			TREE.ALPHA,
			ITEM.ALPHA,
			ks[ITEM.ALPHA].have()
			&& ks[ITEM.ALPHA].type() == HAGATA.Integer
			&& (ubyte.min <= ks[ITEM.ALPHA].get!(Integer) && ks[ITEM.ALPHA].unSafe!(Integer) <= ubyte.max)
		);
	}

	const Text message() {
		return Root.comment.toText;
	}
	void message(in Text Message) {
		Root.comment = Message.str;
	}

	const Text name() {
		return GetText(ITEM.NAME);
	}
	void name(in Text Name) {
		ks[ITEM.NAME] = Name.str;
	}

	const TYPE type() {
		return cast(TYPE)ks[ITEM.TYPE].unSafe!(Integer);
	}
	void type(TYPE Type) {
		ks[ITEM.TYPE] = Type;
	}

	const ref POINT position() {
		auto Value=GetDefaultTSV!(Integer[])(ITEM.POSITION, [0, 0]);
		
		auto Result=new POINT;
		
		Result.x = Value[0];
		Result.y = Value[1];
		
		return *Result;
	}
	void position(const ref POINT Value) {
		SetDefaultTSV!(Integer[])(ITEM.POSITION, null, [Value.tupleof]);
	}
	const ref SIZE size() {
		auto Value=GetDefaultTSV!(Integer[])(ITEM.SIZE, [0, 0]);
		
		auto Result=new SIZE;
		
		Result.cx = Value[0];
		Result.cy = Value[1];
		
		return *Result;
	}
	void size(const ref SIZE Value) {
		SetDefaultTSV!(Integer[])(ITEM.SIZE, null, [Value.tupleof]);
	}

	const bool front() {
		return GetBool(ITEM.FRONT);
	}
	void front(bool Value) {
		ks[ITEM.FRONT] = Value;
	}

	const const(Font) font() {
		try {
			if(auto FontTexts=GetTexts(ITEM.FONT)) {
				return new Font(FontTexts);
			}
		} catch(Exception e) {
			// ログに記述するべき。
		}
		return baseStyle.font;
	}
	void font(in Font font) {
		if(font) {
			ks[ITEM.FONT] = Strings(font.toTexts);
		} else {
			ks[ITEM.FONT] = (string[]).init;
		}
	}

	const COLOR[] color() {
		auto Value=GetDefaultTSV!(Binary[])(ITEM.COLOR, [cast(Binary)baseStyle.text.toRGBArray, baseStyle.back.toRGBArray]);
		auto Colors=new COLOR[2];
		Colors[0] = COLOR(Value[0]);
		Colors[1] = COLOR(Value[1]);
		return Colors;
	}
	void color(in COLOR[] Colors) {
		auto Values=new Binary[Colors.length];
		foreach(i, ref Value; Values) {
			Value = cast(Binary)Colors[i].toRGBArray;
		}
		SetDefaultTSV!(Binary[])(ITEM.POSITION, [cast(Binary)baseStyle.text.toRGBArray, baseStyle.back.toRGBArray], Values);
	}

	const ubyte alpha() {
		if(auto Alpha=ks[ITEM.ALPHA].unSafe!(Integer)) {
			return cast(ubyte)Alpha;
		}
		return baseStyle.alpha;
	}
	void alpha(ubyte Alpha) {
		ks[ITEM.ALPHA] = Alpha == baseStyle.alpha ? ubyte.init: Alpha;
	}
}


