﻿/**
History:
	1.061:
		[S] module変更予定(app -> setting)。
*/
module nemuxi.file.setting;

debug import std.stdio: wl = writefln, pl = printf;
debug(setting) void main() {}

debug import std.string;
debug import std.conv;
import std.uni;
import std.math;

import win32.windows;

import etc.kareki.kareki;

import nemuxi.negui.system.base;
import nemuxi.file.data;
import nemuxi.negui.window.adtb;
import nemuxi.file.exec;
import nemuxi.negui.draw.icon;
import nemuxi.negui.draw.font;
import nemuxi.negui.draw.color;
import nemuxi.negui.input.keyboard.keyboard;
import nemuxi.system.log;
import nemuxi.system.type;
/+
import nemuxi.negui.negui;

//import nemuxi.base;

import nemuxi.file.items.item;
//import nemuxi.image.font;
//import nemuxi.negui.proc.proc;
import nemuxi.system.language;
+/

private enum {
	COMMAND_FONT_SIZE = 7,
}
/**
アプリケーションの設定データ。

History:
	1.061:
		[P] TREE.WINDOWの初期値をPOSITION.FLOATからPOSITION.BOTTOMへ。

	1.00β19:
		[P] 言語ファイル用項目追加。

	1.00β18:
		[P] 消滅時間を0から3000に。てか-1って何だ。

	1.00β13:
		ショートカット使用の判定値を追加。
*/
class Setting: Data {
	debug invariant() {
		assert(ks[ITEM.WINDOW].get!(Integer) >= POSITION.min && ks[ITEM.WINDOW].get!(Integer) <= POSITION.max);
		assert(ks[ITEM.WINDOW_FRONT].type == HAGATA.Integer);

		/+
		assert(ks[ITEM.WINDOW_LEFT].get!(Integer)   >= MIN_SIZE);
		assert(ks[ITEM.WINDOW_TOP].get!(Integer)    >= MIN_SIZE);
		assert(ks[ITEM.WINDOW_RIGHT].get!(Integer)  >= MIN_SIZE);
		assert(ks[ITEM.WINDOW_BOTTOM].get!(Integer) >= MIN_SIZE);
		+/
		
		assert(ks[ITEM.WINDOW_FLOAT_POS].get!(Integer[]).length == 2);
		assert(ks[ITEM.WINDOW_FLOAT_SIZE].get!(Integer[]).length == 2);
		/+
		foreach(n; ks[ITEM.WINDOW_FLOAT_SIZE].get!(Integer[])) {
			assert(n >= MIN_SIZE);
		}
		+/
		assert(ks[ITEM.FOLDER].get!(Integer) >= FOLDER.min && ks[ITEM.FOLDER].get!(Integer) <= FOLDER.max);
		assert(ks[ITEM.FOLDER_PROGRAM].type() == HAGATA.String);
		//assert(ks[ITEM.FOLDER_PROGRAM_OPTION].type() == HAGATA.String);

		assert(ks[ITEM.LAUNCHER_HISTORY].get!(Integer) >= 0);

		assert(ks[ITEM.LAUNCHER_BUTTON_TEXT].type() == HAGATA.Integer);
		assert(ks[ITEM.LAUNCHER_BUTTON_LIST].type() == HAGATA.Integer);
		if(super.GetBool(ITEM.LAUNCHER_BUTTON_LIST)) {
			assert(super.GetBool(ITEM.LAUNCHER_BUTTON_TEXT));
		}
		assert(ks[ITEM.LAUNCHER_BUTTON_ICON].get!(Integer) >= Icon.FIXED.min && ks[ITEM.LAUNCHER_BUTTON_ICON].get!(Integer) <= Icon.FIXED.max, to!(string)(ks[ITEM.LAUNCHER_BUTTON_ICON].get!(Integer)));
		
		assert(ks[ITEM.LAUNCHER_MENU_TEXT].get!(Integer) >= 0);
		assert(ks[ITEM.LAUNCHER_MENU_ICON].get!(Integer) >= Icon.FIXED.min && ks[ITEM.LAUNCHER_MENU_ICON].get!(Integer) <= Icon.FIXED.max);
		assert(ks[ITEM.LAUNCHER_MENU_DESKTOP].type() == HAGATA.Integer);
		
		assert(ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].type() == HAGATA.String);
		assert(ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].type() == HAGATA.Integer);

		assert(ks[ITEM.LAUNCHER_COMMAND_ICON].get!(Integer) >= Icon.FIXED.min && ks[ITEM.LAUNCHER_COMMAND_ICON].get!(Integer) <= Icon.FIXED.max);
		
		//assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_NORMAL].tsvLength == 2);
		/+
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_ITEM].tsvLength == 2);
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_ADDRESS].tsvLength == 2);
		+/
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_ID].tsvLength     == 2);
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_NAME].tsvLength   == 2);
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_TAG].tsvLength    == 2);
		
		assert(ks[ITEM.LAUNCHER_COMMAND_TIMER].get!(Integer) == Integer.min || ks[ITEM.LAUNCHER_COMMAND_TIMER].get!(Integer) >= -1);

		assert(ks[ITEM.APP_SHORTCUT].type() == HAGATA.Integer);
	}
	private static enum ITEM {
		WINDOW,
		WINDOW_FRONT,
		WINDOW_LEFT,
		WINDOW_TOP,
		WINDOW_RIGHT,
		WINDOW_BOTTOM,
		WINDOW_FLOAT_POS,
		WINDOW_FLOAT_SIZE,
		
		FOLDER,
		FOLDER_PROGRAM,
		//FOLDER_PROGRAM_OPTION,
		
		LAUNCHER_HISTORY,
		
		LAUNCHER_BUTTON_TEXT,
		LAUNCHER_BUTTON_LIST,
		LAUNCHER_BUTTON_ICON,
		LAUNCHER_BUTTON_DROP,
		
		LAUNCHER_MENU_TEXT,
		LAUNCHER_MENU_ICON,
		LAUNCHER_MENU_DESKTOP,

		LAUNCHER_COMMAND_KEYS,
		LAUNCHER_COMMAND_ICON,
		LAUNCHER_COMMAND_FONT_NAME,
		LAUNCHER_COMMAND_FONT_SIZE,
		//LAUNCHER_COMMAND_COLOR_NORMAL,
		/+
		LAUNCHER_COMMAND_COLOR_ITEM,
		LAUNCHER_COMMAND_COLOR_ADDRESS,
		+/
		LAUNCHER_COMMAND_COLOR_ID,
		LAUNCHER_COMMAND_COLOR_NAME,
		LAUNCHER_COMMAND_COLOR_TAG,
		LAUNCHER_COMMAND_TIMER,
		LAUNCHER_COMMAND_WIDTH,

		APP_SHORTCUT,
		APP_LANGUAGE,

		STICKY_COLOR,
		STICKY_FONT,
		STICKY_ALPHA,
		STICKY_ITEMS,
	}
	/+
	private enum TREE: string {
		WINDOW = "Window",
		WINDOW_FRONT  = "Front",
		WINDOW_LEFT   = "Left",
		WINDOW_TOP    = "Top",
		WINDOW_RIGHT  = "Right",
		WINDOW_BOTTOM = "Bottom",
		WINDOW_FLOAT  = "Float",
		WINDOW_FLOAT_POS  = "Pos",
		WINDOW_FLOAT_SIZE = "Size",
		
		FOLDER = "Folder",
		FOLDER_PROGRAM = "Program",
		//FOLDER_PROGRAM_OPTION = "Option",
		
		HOTKEY = "HotKey",
		HOTKEY_KEYS = "Keys",
		
		
		LAUNCHER = "Launcher",
		
		LAUNCHER_BUTTON = "Button",
		LAUNCHER_BUTTON_TEXT = "Text",
		LAUNCHER_BUTTON_LIST = "List",
		LAUNCHER_BUTTON_ICON = "Icon",
		
		LAUNCHER_MENU = "Menu",
		LAUNCHER_MENU_TEXT = "Text",
		LAUNCHER_MENU_ICON = "Icon",
		
		LAUNCHER_COMMAND = "Command",
		LAUNCHER_COMMAND_FONT = "Font",
		LAUNCHER_COMMAND_FONT_NAME = "Name",
		LAUNCHER_COMMAND_FONT_SIZE = "Size",
		LAUNCHER_COMMAND_COLOR = "Color",
		LAUNCHER_COMMAND_COLOR_NORMAL  = "Normal",
		LAUNCHER_COMMAND_COLOR_ITEM    = "Item",
		LAUNCHER_COMMAND_COLOR_ADDRESS = "Address",
		LAUNCHER_COMMAND_TIMER = "Timer",
	
	}
	+/
	static invariant struct TREE {
		string WINDOW = "Window";
		string WINDOW_FRONT  = "Front";
		string WINDOW_LEFT   = "Left";
		string WINDOW_TOP    = "Top";
		string WINDOW_RIGHT  = "Right";
		string WINDOW_BOTTOM = "Bottom";
		string WINDOW_FLOAT  = "Float";
		string WINDOW_FLOAT_POS  = "Pos";
		string WINDOW_FLOAT_SIZE = "Size";
		
		string FOLDER = "Folder";
		string FOLDER_PROGRAM = "Program";
		//string FOLDER_PROGRAM_OPTION = "Option";
		
		string LAUNCHER = "Launcher";
		
		string LAUNCHER_HISTORY = "History";
		
		string LAUNCHER_BUTTON = "Button";
		string LAUNCHER_BUTTON_TEXT = "Text";
		string LAUNCHER_BUTTON_LIST = "List";
		string LAUNCHER_BUTTON_ICON = "Icon";
		string LAUNCHER_BUTTON_DROP = "D&D";
		
		string LAUNCHER_MENU = "Menu";
		string LAUNCHER_MENU_TEXT = "Text";
		string LAUNCHER_MENU_ICON = "Icon";
		string LAUNCHER_MENU_DESKTOP = "Desktop";
		
		string LAUNCHER_COMMAND = "Command";
		string LAUNCHER_COMMAND_KEYS = "Keys";
		string LAUNCHER_COMMAND_ICON = "Icon";
		string LAUNCHER_COMMAND_FONT = "Font";
		string LAUNCHER_COMMAND_FONT_NAME = "Name";
		string LAUNCHER_COMMAND_FONT_SIZE = "Size";
		string LAUNCHER_COMMAND_COLOR = "Color";
		//string LAUNCHER_COMMAND_COLOR_NORMAL = "Normal";
		string LAUNCHER_COMMAND_COLOR_ID     = "ID";
		string LAUNCHER_COMMAND_COLOR_NAME   = "Name";
		string LAUNCHER_COMMAND_COLOR_TAG    = "Tag";
		/+
		string LAUNCHER_COMMAND_COLOR_ITEM    = "Item";
		string LAUNCHER_COMMAND_COLOR_ADDRESS = "Address";
		+/
		string LAUNCHER_COMMAND_TIMER = "Timer";
		string LAUNCHER_COMMAND_WIDTH = "Width";

		string APP = "Application";
		string APP_SHORTCUT = "Shortcut";
		string APP_LANGUAGE = "Language";

		string STICKY = "Sticky";
		string STICKY_COLOR = "Color";
		string STICKY_FONT = "Font";
		string STICKY_ALPHA = "Alpha";
		string STICKY_ITEMS = "Items";
	}

	///
	static enum POSITION {
		LEFT   = ApplicationDesktopToolBar.POSITION.LEFT,
		TOP    = ApplicationDesktopToolBar.POSITION.TOP,
		RIGHT  = ApplicationDesktopToolBar.POSITION.RIGHT,
		BOTTOM = ApplicationDesktopToolBar.POSITION.BOTTOM,
		FLOAT,
		SMALL,
	}

	/// 最低サイズ
	static invariant MIN_SIZE = 0;
	enum HIST_MIN = 16;

	/**
	生成と構築！
	*/
	this(Kareha data)
	in {
		assert(data);
	}
	body {
		super(data);
		ks = new Kareha[ITEM.max + 1];

		// ウィンドウ表示方法
		/+
		if(!data(TREE.WINDOW)) {
			data.plus(TREE.WINDOW, super.EmptyInteger(cast(Integer)POSITION.FLOAT));
		}
		ks[ITEM.WINDOW] = data[TREE.WINDOW];
		if(
			!ks[ITEM.WINDOW].have()
			|| ks[ITEM.WINDOW].type() != HAGATA.Integer
			|| (ks[ITEM.WINDOW].unSafe!(Integer) < POSITION.min || ks[ITEM.WINDOW].unSafe!(Integer) > POSITION.max)
			|| ks[ITEM.WINDOW].unSafe!(Integer) < MIN_SIZE
		) {
			ks[ITEM.WINDOW] = cast(Integer)POSITION.FLOAT;
		}
		+/
		RegistEx!(POSITION.BOTTOM)(
			data,
			TREE.WINDOW,
			ITEM.WINDOW,
			ks[ITEM.WINDOW].have()
			&& ks[ITEM.WINDOW].type() == HAGATA.Integer
			&& (POSITION.min <= ks[ITEM.WINDOW].unSafe!(Integer) && ks[ITEM.WINDOW].unSafe!(Integer) <= POSITION.max)
		);

		// 前面表示方法
		/+
		if(!(TREE.WINDOW_FRONT in ks[ITEM.WINDOW])) {
			ks[ITEM.WINDOW].plus(TREE.WINDOW_FRONT, super.EmptyInteger());
		}
		ks[ITEM.WINDOW_FRONT] = ks[ITEM.WINDOW][TREE.WINDOW_FRONT];
		if(
			!ks[ITEM.WINDOW_FRONT].have
			|| ks[ITEM.WINDOW_FRONT].type() != HAGATA.Integer
		) {
			ks[ITEM.WINDOW_FRONT] = 0;
		}
		+/
		/+
		if(!(TREE.WINDOW_FRONT in ks[ITEM.WINDOW])) {
			ks[ITEM.WINDOW].plus(TREE.WINDOW_FRONT, super.EmptyInteger());
		}
		+/
		auto front=DefaultParent(ITEM.WINDOW, ITEM.WINDOW_FRONT, TREE.WINDOW_FRONT, EmptyInteger());
		RegistEx!(false)(
			ks[ITEM.WINDOW],
			TREE.WINDOW_FRONT,
			ITEM.WINDOW_FRONT,
			ks[ITEM.WINDOW_FRONT].have()
			&& ks[ITEM.WINDOW_FRONT].type() == HAGATA.Integer
		);


		{ // 上下左右の判定と保持・修正
			auto Trees = [TREE.WINDOW_LEFT, TREE.WINDOW_TOP, TREE.WINDOW_RIGHT, TREE.WINDOW_BOTTOM];
			auto Items = [ITEM.WINDOW_LEFT, ITEM.WINDOW_TOP, ITEM.WINDOW_RIGHT, ITEM.WINDOW_BOTTOM];

			for(auto i=0; i < Trees.length; i++) {
				/+
				if(!(Trees[i] in ks[ITEM.WINDOW])) {
					ks[ITEM.WINDOW].plus(Trees[i], super.EmptyInteger());
				}
				ks[Items[i]] = ks[ITEM.WINDOW][Trees[i]];
				if(
					!ks[Items[i]].have()
					|| ks[Items[i]].type() != HAGATA.Integer
					|| ks[Items[i]].unSafe!(Integer) < MIN_SIZE
				) {
					ks[Items[i]] = MIN_SIZE;
				}
				+/
				auto Bar=DefaultParent(ITEM.WINDOW, Items[i], Trees[i], EmptyInteger());
				RegistEx!(0)(
					ks[ITEM.WINDOW],
					Trees[i],
					Items[i],
					Bar.have()
					&& Bar.type() == HAGATA.Integer
				);
			}
		}
		{ // フロート表示
			auto Trees = [TREE.WINDOW_FLOAT_POS, TREE.WINDOW_FLOAT_SIZE];
			auto Items = [ITEM.WINDOW_FLOAT_POS, ITEM.WINDOW_FLOAT_SIZE];

			/+
			if(!(TREE.WINDOW_FLOAT in ks[ITEM.WINDOW])) {
				ks[ITEM.WINDOW].plus(TREE.WINDOW_FLOAT, super.Empty());
			}
			auto Float=ks[ITEM.WINDOW][TREE.WINDOW_FLOAT];
			+/
			auto Float=DefaultParent(ITEM.WINDOW, -1, TREE.WINDOW_FLOAT, Empty());

			// 座標・サイズ
			for(auto i=0; i < Trees.length; i++) {
				/+
				// 座標
				if(!(Trees[i] in Float)) {
					Float.plus(Trees[i], super.EmptyTsvInteger());
				}
				ks[Items[i]] = Float[Trees[i]];
				if(
					!ks[Items[i]].have()
					|| ks[Items[i]].type() != HAGATA.TSV_Integer
					|| ks[Items[i]].tsvLength() != 2
				) {
					if(!i) {
						ks[Items[i]] = [0, 0];
					} else {
						ks[Items[i]] = [MIN_SIZE , MIN_SIZE];
					}
				}
				ks[Items[i]].tsvLength = 2;
				if(i) foreach(ref n; ks[Items[i]].get!(Integer[])) {
					if(n < MIN_SIZE) {
						n = MIN_SIZE;
					}
				}
				+/
				auto Params=DefaultParent(Float, Items[i], Trees[i], EmptyTsvInteger());
				RegistEx!([0, 0])(
					Float,
					Trees[i],
					Items[i],
					Params.have()
					&& Params.type() == HAGATA.TSV_Integer
					&& Params.tsvLength() >= 2
				);
			}
		}

		// フォルダオープン動作
		/+
		if(!(TREE.FOLDER in data)) {
			data.plus(TREE.FOLDER, super.EmptyInteger(0));
		}
		ks[ITEM.FOLDER] = data[TREE.FOLDER];
		if(
			!ks[ITEM.FOLDER].have()
			|| ks[ITEM.FOLDER].type() != HAGATA.Integer
			|| (ks[ITEM.FOLDER].unSafe!(Integer) < FOLDER.min || ks[ITEM.FOLDER].unSafe!(Integer) > FOLDER.max)
		) {
			ks[ITEM.FOLDER] = cast(Integer)FOLDER.NORMAL;
		}
		+/
		DefaultParent(data, -1, TREE.FOLDER, EmptyInteger());
		RegistEx!(FOLDER.NORMAL)(
			data,
			TREE.FOLDER,
			ITEM.FOLDER,
			ks[ITEM.FOLDER].have()
			&& ks[ITEM.FOLDER].type() == HAGATA.Integer
			&& (FOLDER.min <= ks[ITEM.FOLDER].unSafe!(Integer) && ks[ITEM.FOLDER].unSafe!(Integer) <= FOLDER.max)
		);
		

		// フォルダをプラグラムから開く
		/+
		if(!(TREE.FOLDER_PROGRAM in ks[ITEM.FOLDER])) {
			ks[ITEM.FOLDER].plus(TREE.FOLDER_PROGRAM, super.EmptyString());
		}
		ks[ITEM.FOLDER_PROGRAM] = ks[ITEM.FOLDER][TREE.FOLDER_PROGRAM];
		if(
			!ks[ITEM.FOLDER_PROGRAM].have()
			|| ks[ITEM.FOLDER_PROGRAM].type() != HAGATA.String
		) {
			ks[ITEM.FOLDER_PROGRAM] = string.init;
		}
		+/
		DefaultParent(ITEM.FOLDER, ITEM.FOLDER_PROGRAM, TREE.FOLDER_PROGRAM, EmptyString());
		RegistEx!(string.init)(
			ks[ITEM.FOLDER],
			TREE.FOLDER_PROGRAM,
			ITEM.FOLDER_PROGRAM,
			ks[ITEM.FOLDER_PROGRAM].have()
			&& ks[ITEM.FOLDER_PROGRAM].type() == HAGATA.String
		);
		
		/+
		// オプション
		super.Regist!(string.init)(
			ks[ITEM.FOLDER_PROGRAM],
			TREE.FOLDER_PROGRAM_OPTION,
			ITEM.FOLDER_PROGRAM_OPTION,
			!ks[ITEM.FOLDER_PROGRAM_OPTION].have
			|| ks[ITEM.FOLDER_PROGRAM_OPTION].type() != HAGATA.String
		);
		+/

		{ // ランチャー
			/+
			if(!(TREE.LAUNCHER in data)) {
				data.plus(TREE.LAUNCHER, super.Empty());
			}
			auto Launcher=data[TREE.LAUNCHER];
			+/
			auto Launcher=DefaultParent(data, -1, TREE.LAUNCHER, Empty());

			// 履歴数
			RegistEx!(HIST_MIN)(
				Launcher,
				TREE.LAUNCHER_HISTORY,
				ITEM.LAUNCHER_HISTORY,
				ks[ITEM.LAUNCHER_HISTORY].have
				&& ks[ITEM.LAUNCHER_HISTORY].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_HISTORY].get!(Integer) >= 0
			);
			
			
			// ボタン
			/+
			if(!(TREE.LAUNCHER_BUTTON in Launcher)) {
				Launcher.plus(TREE.LAUNCHER_BUTTON, super.Empty());
			}
			auto Button=Launcher[TREE.LAUNCHER_BUTTON];
			+/
			auto Button=DefaultParent(Launcher, -1, TREE.LAUNCHER_BUTTON, Empty());

			// ボタンテキスト
			/+
			super.Regist!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_TEXT,
				ITEM.LAUNCHER_BUTTON_TEXT,
				!ks[ITEM.LAUNCHER_BUTTON_TEXT].have
				|| ks[ITEM.LAUNCHER_BUTTON_TEXT].type() != HAGATA.Integer
			);
			+/
			super.RegistEx!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_TEXT,
				ITEM.LAUNCHER_BUTTON_TEXT,
				ks[ITEM.LAUNCHER_BUTTON_TEXT].have
				&& ks[ITEM.LAUNCHER_BUTTON_TEXT].type() == HAGATA.Integer
			);
			
			// リスト表示
			/+
			super.Regist!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_LIST,
				ITEM.LAUNCHER_BUTTON_LIST,
				!ks[ITEM.LAUNCHER_BUTTON_LIST].have
				|| ks[ITEM.LAUNCHER_BUTTON_LIST].type() != HAGATA.Integer
			);
			+/
			super.RegistEx!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_LIST,
				ITEM.LAUNCHER_BUTTON_LIST,
				ks[ITEM.LAUNCHER_BUTTON_LIST].have
				&& ks[ITEM.LAUNCHER_BUTTON_LIST].type() == HAGATA.Integer
			);
			
			// アイコンサイズ
			/+
			super.Regist!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_ICON,
				ITEM.LAUNCHER_BUTTON_ICON,
				!ks[ITEM.LAUNCHER_BUTTON_ICON].have
				|| ks[ITEM.LAUNCHER_BUTTON_ICON].type() != HAGATA.Integer
				|| (ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) < Icon.FIXED.min || ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) > Icon.FIXED.max)
			);
			+/
			super.RegistEx!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_ICON,
				ITEM.LAUNCHER_BUTTON_ICON,
				ks[ITEM.LAUNCHER_BUTTON_ICON].have
				&& ks[ITEM.LAUNCHER_BUTTON_ICON].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) >= Icon.FIXED.min && ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) <= Icon.FIXED.max
			);
			// ダイアログ
			super.RegistEx!(true)(
				Button,
				TREE.LAUNCHER_BUTTON_DROP,
				ITEM.LAUNCHER_BUTTON_DROP,
				ks[ITEM.LAUNCHER_BUTTON_DROP].have()
				&& ks[ITEM.LAUNCHER_BUTTON_DROP].type() == HAGATA.Integer
			);
			
			//メニュー
			/+
			if(!(TREE.LAUNCHER_MENU in Launcher)) {
				Launcher.plus(TREE.LAUNCHER_MENU, super.Empty());
			}
			auto Menu=Launcher[TREE.LAUNCHER_MENU];
			+/
			auto Menu=DefaultParent(Launcher, -1, TREE.LAUNCHER_MENU, Empty());
			// ボタンテキスト
			/+
			super.Regist!(0)(
				Menu,
				TREE.LAUNCHER_MENU_TEXT,
				ITEM.LAUNCHER_MENU_TEXT,
				!ks[ITEM.LAUNCHER_MENU_TEXT].have
				|| ks[ITEM.LAUNCHER_MENU_TEXT].type() != HAGATA.Integer
				|| ks[ITEM.LAUNCHER_MENU_TEXT].unSafe!(Integer) < 0
			);
			+/
			super.RegistEx!(0)(
				Menu,
				TREE.LAUNCHER_MENU_TEXT,
				ITEM.LAUNCHER_MENU_TEXT,
				ks[ITEM.LAUNCHER_MENU_TEXT].have
				&& ks[ITEM.LAUNCHER_MENU_TEXT].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_MENU_TEXT].get!(Integer) >= 0
			);
			
			// アイコンサイズ
			/+
			super.Regist!(0)(
				Menu,
				TREE.LAUNCHER_MENU_ICON,
				ITEM.LAUNCHER_MENU_ICON,
				!ks[ITEM.LAUNCHER_MENU_ICON].have
				|| ks[ITEM.LAUNCHER_MENU_ICON].type() != HAGATA.Integer
				|| (ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) < Icon.FIXED.min || ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) > Icon.FIXED.max)
			);
			+/
			super.RegistEx!(0)(
				Menu,
				TREE.LAUNCHER_MENU_ICON,
				ITEM.LAUNCHER_MENU_ICON,
				ks[ITEM.LAUNCHER_MENU_ICON].have
				&& ks[ITEM.LAUNCHER_MENU_ICON].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) >= Icon.FIXED.min && ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) <= Icon.FIXED.max
			);
			// アイコンサイズ
			/+
			super.Regist!(0)(
				Menu,
				TREE.LAUNCHER_MENU_DESKTOP,
				ITEM.LAUNCHER_MENU_DESKTOP,
				!ks[ITEM.LAUNCHER_MENU_DESKTOP].have
				|| ks[ITEM.LAUNCHER_MENU_DESKTOP].type() != HAGATA.Integer
			);
			+/
			super.RegistEx!(0)(
				Menu,
				TREE.LAUNCHER_MENU_DESKTOP,
				ITEM.LAUNCHER_MENU_DESKTOP,
				ks[ITEM.LAUNCHER_MENU_DESKTOP].have
				&& ks[ITEM.LAUNCHER_MENU_DESKTOP].type() == HAGATA.Integer
			);
			
			// コマンド
			/+
			if(!(TREE.LAUNCHER_COMMAND in Launcher)) {
				Launcher.plus(TREE.LAUNCHER_COMMAND, super.Empty());
			}
			auto Command=Launcher[TREE.LAUNCHER_COMMAND];
			+/
			auto Command=DefaultParent(Launcher, -1, TREE.LAUNCHER_COMMAND, Empty());

			// キー
			/+
			super.Regist!([cast(Integer)MOD.ALT, KEY.N])(
				Command,
				TREE.LAUNCHER_COMMAND_KEYS,
				ITEM.LAUNCHER_COMMAND_KEYS,
				!ks[ITEM.LAUNCHER_COMMAND_KEYS].have
				|| ks[ITEM.LAUNCHER_COMMAND_KEYS].type() != HAGATA.TSV_Integer
				|| ks[ITEM.LAUNCHER_COMMAND_KEYS].tsvLength >= 2
			);
			+/
			super.RegistEx!([cast(Integer)MOD.ALT, KEY.N])(
				Command,
				TREE.LAUNCHER_COMMAND_KEYS,
				ITEM.LAUNCHER_COMMAND_KEYS,
				ks[ITEM.LAUNCHER_COMMAND_KEYS].have
				&& ks[ITEM.LAUNCHER_COMMAND_KEYS].type() == HAGATA.TSV_Integer
				&& ks[ITEM.LAUNCHER_COMMAND_KEYS].tsvLength >= 2
			);
			
			// アイコン

			// アイコンサイズ
			/+
			super.Regist!(0)(
				Command,
				TREE.LAUNCHER_COMMAND_ICON,
				ITEM.LAUNCHER_COMMAND_ICON,
				!ks[ITEM.LAUNCHER_COMMAND_ICON].have
				|| ks[ITEM.LAUNCHER_COMMAND_ICON].type() != HAGATA.Integer
				|| (ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) < Icon.FIXED.min || ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) > Icon.FIXED.max)
			);
			+/
			super.RegistEx!(0)(
				Command,
				TREE.LAUNCHER_COMMAND_ICON,
				ITEM.LAUNCHER_COMMAND_ICON,
				ks[ITEM.LAUNCHER_COMMAND_ICON].have
				&& ks[ITEM.LAUNCHER_COMMAND_ICON].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) >= Icon.FIXED.min && ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) <= Icon.FIXED.max
			);


			// フォント
			/+
			if(!(TREE.LAUNCHER_COMMAND_FONT in Command)) {
				Command.plus(TREE.LAUNCHER_COMMAND_FONT, super.Empty());
			}
			auto Font=Command[TREE.LAUNCHER_COMMAND_FONT];
			+/
			auto Font=DefaultParent(Launcher, -1, TREE.LAUNCHER_COMMAND_FONT, Empty());
			// フォント名
			/+
			super.Regist!(string.init)(
				Font,
				TREE.LAUNCHER_COMMAND_FONT_NAME,
				ITEM.LAUNCHER_COMMAND_FONT_NAME,
				!ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].have()
				|| ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].type() != HAGATA.String
			);
			+/
			super.RegistEx!(string.init)(
				Font,
				TREE.LAUNCHER_COMMAND_FONT_NAME,
				ITEM.LAUNCHER_COMMAND_FONT_NAME,
				ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].have()
				&& ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].type() && HAGATA.String
			);
			// フォントサイズ
			super.RegistEx!(Integer.min)(
				Font,
				TREE.LAUNCHER_COMMAND_FONT_SIZE,
				ITEM.LAUNCHER_COMMAND_FONT_SIZE,
				ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].have()
				&& ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].unSafe!(Integer) >= COMMAND_FONT_SIZE
			);
			
			{// 色
				/+
				if(!(TREE.LAUNCHER_COMMAND_COLOR in Command)) {
					Command.plus(TREE.LAUNCHER_COMMAND_COLOR, super.Empty());
				}
				auto Colors=Command[TREE.LAUNCHER_COMMAND_COLOR];
				+/
				auto Colors=DefaultParent(Command, -1, TREE.LAUNCHER_COMMAND_COLOR, Empty());
				/+
				auto Trees = [TREE.LAUNCHER_COMMAND_COLOR_NORMAL, TREE.LAUNCHER_COMMAND_COLOR_ITEM, TREE.LAUNCHER_COMMAND_COLOR_ADDRESS];
				auto Items = [ITEM.LAUNCHER_COMMAND_COLOR_NORMAL, ITEM.LAUNCHER_COMMAND_COLOR_ITEM, ITEM.LAUNCHER_COMMAND_COLOR_ADDRESS];
				+/
				auto Trees = [/+TREE.LAUNCHER_COMMAND_COLOR_NORMAL,+/ TREE.LAUNCHER_COMMAND_COLOR_ID, TREE.LAUNCHER_COMMAND_COLOR_NAME, TREE.LAUNCHER_COMMAND_COLOR_TAG];
				auto Items = [/+ITEM.LAUNCHER_COMMAND_COLOR_NORMAL,+/ ITEM.LAUNCHER_COMMAND_COLOR_ID, ITEM.LAUNCHER_COMMAND_COLOR_NAME, ITEM.LAUNCHER_COMMAND_COLOR_TAG];
				
				for(auto i=0; i < Trees.length; i++) {
					super.RegistEx!((Binary[]).init)(
						Colors,
						Trees[i],
						Items[i],
						ks[Items[i]].have()
						&& ks[Items[i]].type() == HAGATA.TSV_Binary
						&& ks[Items[i]].tsvLength() >= 2
					);
					ks[Items[i]].tsvLength = 2;
				}
			}
			// 消滅タイマー
			super.RegistEx!(3000)(
				Command,
				TREE.LAUNCHER_COMMAND_TIMER,
				ITEM.LAUNCHER_COMMAND_TIMER,
				ks[ITEM.LAUNCHER_COMMAND_TIMER].have()
				&& ks[ITEM.LAUNCHER_COMMAND_TIMER].type() == HAGATA.Integer
				&& (/*ks[ITEM.LAUNCHER_COMMAND_TIMER].unSafe!(Integer) != Integer.min ||*/ ks[ITEM.LAUNCHER_COMMAND_TIMER].unSafe!(Integer) > -1)
			);
			// 横幅
			RegistEx!(100)(
				Command,
				TREE.LAUNCHER_COMMAND_WIDTH,
				ITEM.LAUNCHER_COMMAND_WIDTH,
				ks[ITEM.LAUNCHER_COMMAND_WIDTH].have()
				&& ks[ITEM.LAUNCHER_COMMAND_WIDTH].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_COMMAND_WIDTH].unSafe!(Integer) >= 100
			);
		}

		{ // アプリケーション
			/+
			if(!(TREE.APP in data)) {
				data.plus(TREE.APP, super.Empty());
			}
			auto App=data[TREE.APP];
			+/
			auto App=DefaultParent(data, -1, TREE.APP, Empty());
			
			// ショートカット
			RegistEx!(true)(
				App,
				TREE.APP_SHORTCUT,
				ITEM.APP_SHORTCUT,
				ks[ITEM.APP_SHORTCUT].have()
				&& ks[ITEM.APP_SHORTCUT].type() == HAGATA.Integer
			);
			
			// 言語
			RegistEx!("日本語.aki")(
				App,
				TREE.APP_LANGUAGE,
				ITEM.APP_LANGUAGE,
				ks[ITEM.APP_LANGUAGE].have()
				&& ks[ITEM.APP_LANGUAGE].type() == HAGATA.String
			);
		}
		{ // 付箋
			auto Sticky=DefaultParent(data, -1, TREE.STICKY, Empty());
			// 標準色
			RegistEx!((Binary[]).init)(
				Sticky,
				TREE.STICKY_COLOR,
				ITEM.STICKY_COLOR,
				ks[ITEM.STICKY_COLOR].have()
				&& ks[ITEM.STICKY_COLOR].type() == HAGATA.TSV_Binary
				&& ks[ITEM.STICKY_COLOR].tsvLength() >= 2
			);

			// フォント
			RegistEx!((string[]).init)(
				Sticky,
				TREE.STICKY_FONT,
				ITEM.STICKY_FONT,
				ks[ITEM.STICKY_FONT].have()
				&& ks[ITEM.STICKY_FONT].type() == HAGATA.TSV_String
			);
			
			// 透明度
			RegistEx!(ubyte.max)(
				Sticky,
				TREE.STICKY_ALPHA,
				ITEM.STICKY_ALPHA,
				ks[ITEM.STICKY_ALPHA].have()
				&& 0 < ks[ITEM.STICKY_ALPHA].get!(Integer) && ks[ITEM.STICKY_ALPHA].get!(Integer) <= ubyte.max
			);
			
			// 表示中の付箋。
			RegistEx!((string[]).init)(
				Sticky,
				TREE.STICKY_ITEMS,
				ITEM.STICKY_ITEMS,
				ks[ITEM.STICKY_ITEMS].have()
				&& ks[ITEM.STICKY_ITEMS].type() == HAGATA.TSV_String
			);
			
		}

		// 正規化
		if(!super.GetBool(ITEM.LAUNCHER_BUTTON_TEXT) && super.GetBool(ITEM.LAUNCHER_BUTTON_LIST)) {
			Logger.write("ボタン型テキスト表示設定が不正");
			ks[ITEM.LAUNCHER_BUTTON_LIST] = 0;
		}
	}
	debug(app) unittest {
		auto app=newApp;
	}

	/// 表示位置
	const POSITION position() {
		return cast(POSITION)ks[ITEM.WINDOW].unSafe!(Integer);
	}
	/// ditto
	void position(POSITION Pos) {
		ks[ITEM.WINDOW] = Pos;
	}

	/// 最前面表示
	const bool front() {
		return GetBool(ITEM.WINDOW_FRONT);
	}
	/// ditto
	void front(bool Front) {
		ks[ITEM.WINDOW_FRONT] = Front;
	}

	/// バー状態のサイズ
	const Integer barSize(POSITION Pos)
	out(r) {
		//assert(r > 0);
	}
	body {
		with(POSITION) switch(Pos) {
			case LEFT:   return ks[ITEM.WINDOW_LEFT].unSafe!(Integer);
			case TOP:    return ks[ITEM.WINDOW_TOP].unSafe!(Integer);
			case RIGHT:  return ks[ITEM.WINDOW_RIGHT].unSafe!(Integer);
			case BOTTOM: return ks[ITEM.WINDOW_BOTTOM].unSafe!(Integer);
			default:     assert(false, "だめ");
		}
	}
	/// ditto
	void barSize(POSITION Pos, Integer Size)
	in {
		//assert(Size > 0);
	}
	body {
		with(POSITION) switch(Pos) {
			case LEFT:   ks[ITEM.WINDOW_LEFT]   = Size; break;
			case TOP:    ks[ITEM.WINDOW_TOP]    = Size; break;
			case RIGHT:  ks[ITEM.WINDOW_RIGHT]  = Size; break;
			case BOTTOM: ks[ITEM.WINDOW_BOTTOM] = Size; break;
			default:     assert(false, "だめだって");
		}
	}

	/// フロートサイズ
	const SIZE floatSize() {
		SIZE Size=void;
		
		auto size=ks[ITEM.WINDOW_FLOAT_SIZE].unSafe!(Integer[]);
		Size.cx = size[0];
		Size.cy = size[1];
		
		return Size;
	}
	/// ditto
	void floatSize(SIZE Size) {
		if(Size.cx < MIN_SIZE) Size.cx = MIN_SIZE;
		if(Size.cy < MIN_SIZE) Size.cy = MIN_SIZE;
		ks[ITEM.WINDOW_FLOAT_SIZE] = [Size.cx, Size.cy];
	}
	
	/// フロート位置
	const POINT floatPos() {
		POINT Pos=void;
		
		auto pos=ks[ITEM.WINDOW_FLOAT_POS].unSafe!(Integer[]);
		Pos.x = pos[0];
		Pos.y = pos[1];
		
		return Pos;
	}
	/// ditto
	void floatPos(POINT Pos) {
		ks[ITEM.WINDOW_FLOAT_POS] = [Pos.x, Pos.y];
	}

	/// フォルダ表示方法
	const FOLDER folder() {
		return cast(FOLDER)ks[ITEM.FOLDER].get!(Integer);
	}
	/// ditto
	void folder(FOLDER Folder) {
		ks[ITEM.FOLDER] = Folder;
	}

	/// フォルダ表示プログラム
	const Text folderProgram() {
		//return ks[ITEM.FOLDER_PROGRAM].unSafe!(string);
		return GetText(ITEM.FOLDER_PROGRAM);
	}
	/// ditto
	void folderProgram(in Text Program) {
		//ks[ITEM.FOLDER_PROGRAM] = Program;
		ks[ITEM.FOLDER_PROGRAM] = Program.text8;
	}
	/+
	/// フォルダ表示オプション。
	string folderOption() {
		return ks[ITEM.FOLDER_PROGRAM_OPTION].unSafe!(string);
	}
	/// ditto
	void folderOption(string Option) {
		ks[ITEM.FOLDER_PROGRAM_OPTION] = Option;
	}
	+/


	// 履歴数
	const Integer historyMax() {
		return ks[ITEM.LAUNCHER_HISTORY].unSafe!(Integer);
	}

	/// ボタン型の文字列表示。
	const bool exeButtonText() {
		return GetBool(ITEM.LAUNCHER_BUTTON_TEXT);
	}
	/// ditto
	void exeButtonText(bool ShowText) {
		ks[ITEM.LAUNCHER_BUTTON_TEXT] = ShowText;
	}
	///
	const bool exeButtonList() {
		return GetBool(ITEM.LAUNCHER_BUTTON_LIST);
	}
	///
	void exeButtonList(bool ListStyle) {
		ks[ITEM.LAUNCHER_BUTTON_LIST] = ListStyle;
	}
	
	/// ボタン型アイコンサイズ。
	const Icon.FIXED exeButtonIcon() {
		return cast(Icon.FIXED)ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer);
	}
	/// ditto
	void exeButtonIcon(Icon.FIXED IconFixed) {
		ks[ITEM.LAUNCHER_BUTTON_ICON] = IconFixed;
	}

	/// メニュー型表示文字列長。
	const Integer exeMenuText()
	out(r) {
		assert(r >= 0);
	}
	body {
		return ks[ITEM.LAUNCHER_MENU_TEXT].unSafe!(Integer);
	}
	/// ditto
	void exeMenuText(Integer TextLength)
	in {
		assert(TextLength >= 0);
	}
	body {
		ks[ITEM.LAUNCHER_MENU_TEXT] = TextLength;
	}
	/// メニュー型アイコンサイズ。
	const Icon.FIXED exeMenuIcon() {
		return cast(Icon.FIXED)ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer);
	}
	/// ditto
	void exeMenuIcon(Icon.FIXED IconFixed) {
		ks[ITEM.LAUNCHER_MENU_ICON] = IconFixed;
	}
	const bool exeMenuDeskTop() {
		return GetBool(ITEM.LAUNCHER_MENU_DESKTOP);
	}
	void exeMenuDeskTop(bool Use) {
		ks[ITEM.LAUNCHER_MENU_DESKTOP] = Use;
	}

	///  コマンド型ホットキー。
	const Integer[] exeCommandHotkey() {
		return ks[ITEM.LAUNCHER_COMMAND_KEYS].unSafe!(Integer[]);
	}
	/// ditto
	void exeCommandHotkey(Integer[] Keys)
	in {
		assert(Keys.length >= 2);
	}
	body {
		ks[ITEM.LAUNCHER_COMMAND_KEYS] = Keys;
	}

	/// コマンド型アイコンサイズ。
	const Icon.FIXED exeCommandIcon() {
		return cast(Icon.FIXED)ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer);
	}
	/// ditto
	void exeCommandIcon(Icon.FIXED IconFixed) {
		ks[ITEM.LAUNCHER_COMMAND_ICON] = IconFixed;
	}

	/**
	History:
		1.00β19:
			新規作成。
	*/
	private const Font CommandDefaultFont() {
		return new Font(Font.STOCK.MESSAGE);
	}

	/**
	コマンド型使用フォント。

	History:
		1.00β19:
			[P] 負数の場合に絶対値を取るように変更。
	*/
	const Font exeCommandFont() {
		auto font=CommandDefaultFont();
		
		auto text=GetText(ITEM.LAUNCHER_COMMAND_FONT_NAME);
		if(text.length) {
			font.faceName = text;
		}
		auto height=std.math.abs(ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].unSafe!(Integer));
		if(height >= COMMAND_FONT_SIZE) {
			font.height   = height;
		}
		font.weight = Font.WEIGHT.NORMAL;

		return font;
	}
	/**
	コマンド型使用フォント。

	History:
		1.00β19:
			[F] システムと同等であれば空で保持。
	*/
	void exeCommandFont(in Font font) {
		if(font) {
			/+
			ks[ITEM.LAUNCHER_COMMAND_FONT_NAME] = font.faceName.toString();
			ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE] = font.height;
			+/
			scope DefFont=CommandDefaultFont;
			string FaceName;
			if(DefFont.faceName != font.faceName) {
				FaceName = font.faceName.text8;
			}
			Integer Height=Integer.min;
			if(DefFont.height != font.height) {
				Height = std.math.abs(font.height);
			}
			ks[ITEM.LAUNCHER_COMMAND_FONT_NAME] = FaceName;
			ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE] = Height;
		} else {
			ks[ITEM.LAUNCHER_COMMAND_FONT_NAME] = string.init;
			ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE] = Integer.min;
		}
	}

	/// コマンド型文字色
	static enum COMMANDCOLOR {
		ID,      /// ID。
		NAME,    /// 名前
		TAG,     /// タグ
	}
	/**
	History:
		1.00β18:
			新規作成。
	*/
	static immutable(COLOR[]) exeCommandRawColor(COMMANDCOLOR Color) {
		final switch(Color) {
			case COMMANDCOLOR.ID:   return [cast(COLOR)SYSTEMCOLOR.WindowText,  cast(COLOR)SYSTEMCOLOR.WindowBack];
			case COMMANDCOLOR.NAME: return [cast(COLOR)SYSTEMCOLOR.CaptionText, cast(COLOR)SYSTEMCOLOR.ActiveCaptionGradation];
			case COMMANDCOLOR.TAG:  return [cast(COLOR)SYSTEMCOLOR.ToolTipText, cast(COLOR)SYSTEMCOLOR.ToolTipBack];
		}
	}
	/**
	コマンド型文字色取得

	History:
		1.070:
			[S] final switch適用。
	*/
	const COLOR[] exeCommandColor(COMMANDCOLOR color)
	out(r) {
		assert(r.length >= 2);
	}
	body {
		Binary[] RawColors;
		final switch(color) {
			case COMMANDCOLOR.ID:      RawColors = ks[ITEM.LAUNCHER_COMMAND_COLOR_ID].unSafe!(Binary[]);   break;
			case COMMANDCOLOR.NAME:    RawColors = ks[ITEM.LAUNCHER_COMMAND_COLOR_NAME].unSafe!(Binary[]); break;
			case COMMANDCOLOR.TAG:     RawColors = ks[ITEM.LAUNCHER_COMMAND_COLOR_TAG].unSafe!(Binary[]);  break;
		}
		return [
			RawColors[0].length ? COLOR(RawColors[0].dup): exeCommandRawColor(color)[0],
			RawColors[1].length ? COLOR(RawColors[1].dup): exeCommandRawColor(color)[1]
		];
	}
	/**
	コマンド型文字色取得。
	
	History:
		1.070:
			[S] final switch適用。
	
		1.00β19:
			[F] システムと同等であれば空で保持。
	*/
	void exeCommandColor(COMMANDCOLOR color, COLOR ForeColor, COLOR BackColor) {
		/+
		Kareha ColorTree;
		switch(color) {
			case COMMANDCOLOR.ID:      ColorTree = ks[ITEM.LAUNCHER_COMMAND_COLOR_ID];   break;
			case COMMANDCOLOR.NAME:    ColorTree = ks[ITEM.LAUNCHER_COMMAND_COLOR_NAME]; break;
			case COMMANDCOLOR.TAG:     ColorTree = ks[ITEM.LAUNCHER_COMMAND_COLOR_TAG];  break;
			default: assert(false);
		}
		ColorTree = cast(Binary[])[
			Colors[0] ? Colors[0].toRGBArray: null,
			Colors[1] ? Colors[1].toRGBArray: null
		];
		+/
		auto DefColors=exeCommandRawColor(color);
		Binary[] Colors;
		Colors ~= cast(Binary)(ForeColor != DefColors[0] ? ForeColor.toRGBArray: null);
		Colors ~= cast(Binary)(BackColor != DefColors[1] ? BackColor.toRGBArray: null);
		final switch(color) {
			case COMMANDCOLOR.ID:      ks[ITEM.LAUNCHER_COMMAND_COLOR_ID]   = Colors; break;
			case COMMANDCOLOR.NAME:    ks[ITEM.LAUNCHER_COMMAND_COLOR_NAME] = Colors; break;
			case COMMANDCOLOR.TAG:     ks[ITEM.LAUNCHER_COMMAND_COLOR_TAG]  = Colors; break;
			//default: assert(false);
		}
	}
	
	///
	const Integer exeCommandTimer()
	out(r) {
		assert(r >= -1);
	}
	body {
		return ks[ITEM.LAUNCHER_COMMAND_TIMER].unSafe!(Integer);
	}
	/// ditto
	void exeCommandTimer(Integer Time)
	in {
		assert(Time >= -1);
	}
	body {
		ks[ITEM.LAUNCHER_COMMAND_TIMER] = Time;
	}
	const Integer exeCommandWidth() {
		return ks[ITEM.LAUNCHER_COMMAND_WIDTH].unSafe!(Integer);
	}
	void exeCommandWidth(Integer Width) {
		ks[ITEM.LAUNCHER_COMMAND_WIDTH] = Width;
	}

	/**
	ショートカット使用判定値。

	この項目が真であればショートカットのリンク先を使用。
	偽であればショートカットファイルそのものを使用。
	*/
	const bool shortcut() {
		return super.GetBool(ITEM.APP_SHORTCUT);
	}
	/// ditto
	void shortcut(bool Shortcut) {
		ks[ITEM.APP_SHORTCUT] = Shortcut;
	}
	/**
	ファイルドロップ時ダイアログ使用判定値。

	この項目が真であれば本体ウィンドウへD&Dされた際に実行ダイアログを表示する。
	偽であればそのまんま起動する。
	*/
	const bool exeButtonDialog() {
		return super.GetBool(ITEM.LAUNCHER_BUTTON_DROP);
	}
	/// ditto
	void exeButtonDialog(bool ExecDialog) {
		ks[ITEM.LAUNCHER_BUTTON_DROP] = ExecDialog;
	}
	
	const Text language() {
		return GetText(ITEM.APP_LANGUAGE);
	}
	/// ditto
	void language(in Text Language) {
		ks[ITEM.APP_LANGUAGE] = Language.toString;
	}

	static COLOR[] stickyRawColor() {
		return [
			cast(COLOR)SYSTEMCOLOR.ToolTipText,
			cast(COLOR)SYSTEMCOLOR.ToolTipBack
		];
	}
	const COLOR[] stickyColor() {
		COLOR[] Colors = stickyRawColor();
		auto ColorBins=ks[ITEM.STICKY_COLOR].unSafe!(Binary[]);
		if(ColorBins.length >= 2) {
			if(ColorBins[0] != Colors[0].toRGBArray) {
				Colors[0] = COLOR(ColorBins[0]);
			}
			if(ColorBins[1] != Colors[1].toRGBArray) {
				Colors[1] = COLOR(ColorBins[1]);
			}
		}
		
		return Colors;
	}
	void stickyColor(COLOR[] Colors)
	in {
		assert(Colors.length >= 2);
	}
	body {
		const RawColors=stickyRawColor;
		Binary[] ColorBins;
		ColorBins ~= cast(Binary)(Colors[0] == RawColors[0] ? null: Colors[0].toRGBArray);
		ColorBins ~= cast(Binary)(Colors[1] == RawColors[1] ? null: Colors[1].toRGBArray);
		ks[ITEM.STICKY_COLOR] = ColorBins;
	}
	
	const Font stickyFont() {
		auto FontTexts=GetTexts(ITEM.STICKY_FONT);
		if(FontTexts.length) {
			try {
				return new Font(FontTexts);
			} catch(Exception e) {
				Logger.write("stickyFont [%s], %s", FontTexts, e);
			}
		}
		return new Font(Font.STOCK.MESSAGE);
	}
	void stickyFont(in Font font) {
		if(font && font.toTexts == (new Font(Font.STOCK.MESSAGE)).toTexts) {
			ks[ITEM.STICKY_FONT] = Strings(font.toTexts);
		} else {
			ks[ITEM.STICKY_FONT] = string.init;
		}
	}
	const ubyte stickyAlpha() {
		return cast(ubyte)ks[ITEM.STICKY_ALPHA].unSafe!(Integer);
	}
	void stickyAlpha(ubyte Alpha) {
		ks[ITEM.STICKY_ALPHA] = Alpha;
	}
	
	const Text[] stickyItems() {
		return Texts(ks[ITEM.STICKY_ITEMS].unSafe!(string[]));
	}
	void stickyItems(in Text[] Stickys) {
		ks[ITEM.STICKY_ITEMS] = Strings(Stickys);
	}
	/+
	const Text[] stickyAllItems() {
	}
	+/
}

debug AkiDocument newApp() {
	return new AkiDocument(`
;ウィンドウ表示方法
Window:0
;前面表示
Window/Front:0
;左部サイズ
Window/Left:1
;上部サイズ
Window/Top:1
;右部サイズ
Window/Right:1
;下部サイズ
Window/Bottom:-1
;XY座標
Window/Float/Pos=0	0
;ウィンドウの大きさ
Window/Float/Size=1	1

;フォルダを開く方法
Folder:0
;↑の指定プログラム(アイテム)
Folder/Program\\e
;↑のオプション
Folder/Program/Option\\e

;ホットキーの使用フラグ
;[0] 使用しない(未指定)
;[1] 使用する
HotKey:0
;キー
;[第一要素] キー
;[第二要素] 修飾キー
HotKey/Keys=*


;ボタン型の文字列は表示させるか
;[0] 表示させない(通常)
;[1] 表示させる
Launcher/Button/Text:0
;ボタン型のアイコンサイズ
;[0] 16*16(通常)
;[1] 32*32
Launcher/Button/Icon:0

;メニュー型のテキスト文字数(0ですべて表示)
Launcher/Menu/Text:0
;メニュー型のアイコンサイズ
;[0] 16*16(通常)
;[1] 32*32
Launcher/Menu/Icon:0

;コマンド型のアイコンサイズ
;[*] 非表示
;[0] 16*16(通常)
;[1] 32*32
Launcher/Command/Icon:0
;コマンド型で使用するフォント名
;空でシステム
Launcher/Command/Font/Name\\e
;コマンド型で使用するフォントサイズ
;空でシステム
Launcher/Command/Font/Size:*
;コマンド型リスト表示における通常の前背景色(空ならシステム色)
Launcher/Command/Color/Normal!*	*
;コマンド型リスト表示におけるアイテムの場合の前背景色(空ならシステム色)
Launcher/Command/Color/Item!000000	ffffff
;コマンド型リスト表示におけるパスの場合の前背景色(空ならシステム色)
Launcher/Command/Color/Address!000000	ffffff
;コマンド入力ウィンドウが非アクティブになってから非表示までの秒数
;msで指定。(0なら即消滅)
Launcher/Command/Timer:200

			
		`.splitlines);
}


