﻿/**
ランチャ的なアイテム。

時期を見てからmixinの予定。
*/
module nemuxi.file.items.structure;

debug import std.stdio: wl = writefln, pl = printf;

debug(structure) void main() {}

import std.file;
import std.string;
import std.conv;
//import std.contracts;
version(unittest) static import std.regexp;

import etc.kareki.kareki;


import nemuxi.file.items.itemfunc;
import nemuxi.file.items.item;

import nemuxi.negui.system.base;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.input.keyboard.keyboard;
//import nemuxi.negui.negui;
import nemuxi.negui.draw.icon;

import nemuxi.negui.file.file;

//public import nemuxi.negui.system.timer;
//import nemuxi.system.exception;
import nemuxi.system.type;
//import nemuxi.system.log;
//import nemuxi.base;
//import nemuxi.file.data;
//import nemuxi.file.setting;
//import nemuxi.system.language;
import nemuxi.negui.environ.variable;
;
//import nemuxi.image.icon;
//import nemuxi.file.items.itemif;

struct BMITEM {
	Item item; /// アイテム。
	Text name; /// アイテム名称。
	Icon icon; /// アイコン。
	bool live; /// アイテム選択可不可。
	KEY key; /// アクセスキー。
}

alias PAIR!(size_t, size_t) HITRANGEPAIR;
/**
ID > NAME > TAG
*/
struct CITEM {
	///
	Item item;
	///
	Icon icon;
	

	///
	static enum TYPE {
		ID,/// 
		NAME, /// 
		TAG, /// 
	}

	
	///
	TYPE type;

	//string typeString;
	Text ShowName;

	HITRANGEPAIR Hit;
	
	debug static pure nothrow TypeToString(TYPE Type) {
		switch(Type) {
			case TYPE.ID:   return "<I>";
			case TYPE.NAME: return "<N>";
			case TYPE.TAG:  return "<T>";
			default:        assert(false);
		}
	}

	debug string toString() {
		return Text("%s:%s, %s", TypeToString(type), item.itemID.toString, item.name.toString).toString;
	}

	const bool opEquals(const ref CITEM CItem) {
		return ShowName == CItem.ShowName;
	}
	int opCmp(CITEM* CItem) {
		return ShowName.cmpi(CItem.ShowName);
	}
}

/**
ボタン・メニュー表示項目作成。

最低限の項目を作るだけ。
コマンド型はタグとかもあるんで一応外す。

Params:
	item = アイテム。

	ShowIcon = アイコンを表示させるか。

	IconFixed = アイコンの大きさ。
	           ShowIconが偽の場合はどうでもいい。

Return:
	項目。

Bugs:
	アイコン取得部分が重複、nemuxi.file.items.itemfunc.GetIconに置き換えるべき。
	Item.TYPEは受け付けない設計なので現在の引数で対応可能なはず。

History:
	1.00β19:
		[P] アイコン取得部分をGetIconに統合。
		
	1.00β14:
		[F] Item.TYPE.NORMAL時にアドレスが環境変数を含んでいた際の対処。
*/
BMITEM ItemToButtonMenuItem(Item item, bool ShowIcon, Icon.FIXED IconFixed)
in {
	assert(item);
	assert(item.type != Item.TYPE.LINK);
}
out(r) {
	if(ShowIcon)
		assert(r.icon);
	else
		assert(!r.icon);
}
body {
	BMITEM BMItem;
	BMItem.item = item;
	
	switch(item.type()) {
		case Item.TYPE.NORMAL: {
			const Address=Text(toPlain(Text(item.address())));
			BMItem.live = FILE.isExistence(Address);

			if(ShowIcon) {
				/+
				Text IconAddress=toPlain(Text(item.iconAddress()));
				if(!FILE.isExistence(IconAddress)) {
					if(BMItem.live) {
						IconAddress = Address;
					} else {
						IconAddress = IconAddress.emptyText();
					}
				}
				if(IconAddress.length) {
					BMItem.icon = GetFileIcon(IconAddress, item.iconIndex(), IconFixed);
				} else {
					BMItem.icon = GetSystemIcon(SYSICON.EXCLAMATION, IconFixed);
				}
				+/
			}

			if(BMItem.live) {
				BMItem.name = item.name.length
					? item.name
					: item.itemID;
			} else {
				BMItem.name = item.itemID;
			}
			
			break;
		}
		case Item.TYPE.URI, Item.TYPE.MULTI: {
			if(item.type() == Item.TYPE.URI) {
				BMItem.live = true;
			} else {
				BMItem.live = item.multi().length != 0 ? true: false;
			}
			/+
			if(ShowIcon) {
				Text IconAddress=toPlain(Text(item.iconAddress()));
				if(FILE.isExistence(IconAddress)) {
					BMItem.icon = GetFileIcon(IconAddress, item.iconIndex(), IconFixed);
				} else {
					BMItem.icon = GetSystemIcon(item.type() == Item.TYPE.URI ? SYSICON.URI:SYSICON.MULTI, IconFixed);
				}
			}
			+/
			BMItem.name = item.name.length ? item.name: item.itemID();
			
			break;
		}
		default:
			assert(false, item.name.toString);
	}
	
	BMItem.icon = GetIcon(item, IconFixed);
	
	return BMItem;
}
debug(item) unittest {
	auto aki=newItem();
	auto item=new Item(Text("ie"), aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, Icon.FIXED.SMALL).live);
	item=new Item(Text("test"), aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, Icon.FIXED.SMALL).live);
	item=new Item(Text("URI"), aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, Icon.FIXED.SMALL).live);
	item=new Item(Text("MULTI"), aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, Icon.FIXED.SMALL).live);

}
/**
History:
	1.030:
		[P] stringをTextに変更。
		[S] メンバ名を小文字に。
*/
struct OVERRIDEINFO {
	enum MASK {
		NONE   = 0b0000,
		WORK   = 0b0001,
		OPTION = 0b0010,
		SHOW   = 0b0100,
	}
	MASK mask;
	deprecated alias mask Mask;
	
	Text workFolder;
	deprecated alias workFolder WorkFolder;
	Text option;
	deprecated alias option Option;
	SHOW show;
	deprecated alias show Show;
}



