﻿/**

*/
module nemuxi.file.items.items;

debug import std.stdio: wl = writefln, pl = printf;
debug(items) void main() {}

import str = std.string;
import std.utf;

import std.contracts;
import std.regex;
import std.algorithm;

import etc.kareki.kareki;
/+
import nemuxi.base;
import nemuxi.negui.system.timer;
import nemuxi.negui.file.file;
import nemuxi.file.items.itemif;
import nemuxi.file.items.item;
import nemuxi.file.items.structure;
import nemuxi.file.items.linkitem;
import nemuxi.file.items.itemfunc;
import nemuxi.system.application;
import nemuxi.negui.draw.icon;
import nemuxi.system.type;
import nemuxi.negui.environ.variable;
;
+/

import nemuxi.file.items.itemif;
import nemuxi.file.items.structure;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.negui.draw.icon;
import nemuxi.system.type;
import nemuxi.negui.system.base;
import nemuxi.system.exception;
import nemuxi.system.application;
import nemuxi.system.staticdata;
import nemuxi.negui.file.file;
import nemuxi.negui.environ.variable;
;

/**
アイテム・アイコンペア。

<ul>
	<li>L:アイテム</li>
	<li>R:アイコン</li>
</ul>
*/
alias PAIR!(Item, Icon) ITEMICONPAIR;

/**
アイテム・アイコンペア統括。

推奨用途は読み取り。
*/
final class ItemIconPairs {
	immutable Icon.FIXED iconSize;
	const int iconPx() {
		return Icon.fixedToSize(iconSize);
	}
	
	private {
		size_t[wstring] index;
		ITEMICONPAIR[] pairs;
	}

	/**
	History:
		1.021:
			[F] 順序変更。
		
		1.00β17:
			[P] 事前条件の追加。
	*/
	this(Kareha ItemTree, Icon.FIXED IconFixed)
	in {
		assert(ItemTree);
	}
	body {
		iconSize = IconFixed;

		pairs = new ITEMICONPAIR[ItemTree.length];

		/+
		foreach(i, key; ItemTree.keys) {
			const ItemID=key.toText;
			index[ItemID.text] = i;
			pairs[i].left  = new Item(ItemID, ItemTree);
			pairs[i].right = GetIcon(pairs[i].left, IconFixed, ItemTree);
		}
		+/
		auto items=new Item[ItemTree.length];
		foreach(i, key; ItemTree.keys) {
			items[i] = new Item(key.toText, ItemTree);
		}
		foreach(i, item; items.sort) {
			index[item.itemID.text] = i;
			pairs[i].left  = item;
			pairs[i].right = GetIcon(item, IconFixed, ItemTree);
		}
	}
	/**
	History:
		1.00β17:
			[B] アイコンじゃなくてアイテムを解放していた不具合の修正。
	*/
	~this() {
		if(pairs) {
			foreach(ref pair; pairs) {
				delete pair.right;
			}
			delete pairs;
		}
		index = null;
	}
	
	const size_t length() {
		return pairs.length;
	}

	size_t keyToIndex(in Text Key) {
		if(auto pIndex = (Key.text in index)) {
			return *pIndex;
		} else {
			throw new NemuxiException("あ～あ");
		}
	}

	ITEMICONPAIR* opIn_r(size_t Index) {
		if(0 <= Index && Index < pairs.length) {
			return &pairs[Index];
		}

		return null;
	}
	ITEMICONPAIR* opIn_r(in Text Key) {
		if(auto pIndex = (Key.text in index)) {
			return opIn_r(*pIndex);
		}
		return null;
	}
	ref ITEMICONPAIR opIndex(size_t Index) {
		return pairs[Index];
	}
	ref ITEMICONPAIR opIndex(in Text Key) {
		return pairs[*(Key.text in index)];
	}

	void addItem(Item item, Kareha ItemTree) {
		ITEMICONPAIR Pair;
		Pair.left = item;
		Pair.right= GetIcon(item, iconSize, ItemTree);

		index[item.itemID.text] = pairs.length;
		pairs ~= Pair;
	}
	
	void changeItem(in Text SrcID, Item NewItem, Kareha ItemTree)
	in {
		if(SrcID != NewItem.itemID)
		assert((NewItem.itemID.text in index) is null);
	}
	body {
		auto Index=*(SrcID.text in index);
		index.remove(cast(immutable)SrcID.text);
		assert((SrcID.text in index) is null, "aaaa");
		index[NewItem.itemID.text] = Index;
		pairs[Index].left  = NewItem;
		pairs[Index].right = GetIcon(NewItem, iconSize, ItemTree);
	}

	/**
	History:
		1.021:
			[P] 配列部分の処理簡易化。
	*/
	bool del(in Text ItemID) {
		foreach(i; 0 .. pairs.length) {
			if(pairs[i].left.itemID == ItemID) {
				if(pairs.length != 1) {
					/+
					if(i) {
						pairs = pairs[0..i] ~ pairs[i+1 .. pairs.length];
					} else {
						pairs = pairs[1 .. pairs.length];
					}
					
					+/
					pairs.erase(i);
					foreach(j; 0 .. pairs.length) {
						index[pairs[j].left.itemID.text] = j;
					}
				} else {
					pairs = null;
					index = null;
				}

				return true;
			}
		}

		return false;
	}
}
/+
debug(items) unittest {
	auto a=MakeApplication();
	auto iip=new ItemIconPairs(a.itemBase, Icon.FIXED.SMALL);
}
+/

debug(items) ItemSearcher ISR() {
	auto a=MakeApplication();
	return new ItemSearcher(a.itemBase,a.setting.exeCommandIcon);
}
/**

*/
final class ItemSearcher {
	private {
		ItemIconPairs Pairs;
	}
	ItemIconPairs pairs() {
		return Pairs;
	}

	this(Kareha ItemBase, Icon.FIXED IconFixed)
	in {
		assert(ItemBase);
	}
	body {
		Pairs = new ItemIconPairs(ItemBase, IconFixed);
	}
	~this() {
		delete Pairs;
	}


	enum FLAGS {
		ID   = 0b000001,
		NAME = 0b000010,
		TAG  = 0b000100,

		ALL  = ID | NAME | TAG,
	}
	pure CITEM.TYPE flagToType(FLAGS Flag) {
		switch(Flag) {
			case FLAGS.ID:   return CITEM.TYPE.ID;
			case FLAGS.NAME: return CITEM.TYPE.NAME;
			case FLAGS.TAG:  return CITEM.TYPE.TAG;
			default:         assert(false);
		}
	}
	/**
	History:
		1.063:
			[F] 同一アイテムの重複部分選択。
	*/
	CITEM[] find(in Text Pattern, bool Capital, FLAGS Flags, bool Smart=true)
	in {
		assert(Pattern.length);
		assert(Flags);
	}
	body {
		struct FLAGCASE {
			FLAGS flag;
			Text text;
		}
		
		auto CItems=new CITEM[StaticData.loopInit];
		size_t i=0, j=0;
		auto Reg = regex(Pattern.dummy, Capital ? "": "i");
		
		do {
			auto Pair=Pairs[i];
			FLAGCASE[] FlagCases;

			//取得する分だけ配列に。
			with(Pair.left) {
				/+
				FLAGCASE FlagCase;
				
				if(Flags & FLAGS.ID) {
					FlagCase.flag = FLAGS.ID;
					FlagCase.text = itemID;
					
					FlagCases ~= FlagCase;
				}

				if(Flags & FLAGS.NAME) {
					FlagCase.flag = FLAGS.NAME;
					FlagCase.text = name;
					
					FlagCases ~= FlagCase;
				}

				if(Flags & FLAGS.TAG) {
					auto Tags=tags;
					foreach(Tag; Tags) {
						FlagCase.flag = FLAGS.TAG;
						FlagCase.text = Tag;
						
						FlagCases ~= FlagCase;
					}
				}
				+/
				FLAGCASE FlagCase;
				FLAGCASE[] TempCase;
				if(Flags & FLAGS.ID) {
					FlagCase.flag = FLAGS.ID;
					FlagCase.text = itemID;
					
					TempCase ~= FlagCase;
				}

				if(Flags & FLAGS.NAME) {
					FlagCase.flag = FLAGS.NAME;
					FlagCase.text = name;
					
					TempCase ~= FlagCase;
				}

				if(Flags & FLAGS.TAG) {
					auto Tags=tags;
					foreach(Tag; Tags) {
						FlagCase.flag = FLAGS.TAG;
						FlagCase.text = Tag;
						
						TempCase ~= FlagCase;
					}
				}
				
				// 重複があれば削る。
				if(Smart && TempCase.length > 1) {
					for(auto l=0; l < TempCase.length-1; l++) {
						if(TempCase[l].text.length && TempCase[l].text == TempCase[l+1].text) {
							TempCase[l+1].text = Text.emptyText;
						}
					}
					for(auto l=0; l < TempCase.length;) {
						if(!TempCase[l].text.length) {
							TempCase.erase(l);
						} else {
							l++;
						}
					}
				}
				if(TempCase.length) {
					FlagCases ~= TempCase;
				}
			}

			
			foreach(FlagCase; FlagCases) {
				foreach(Match; match(FlagCase.text.dummy, Reg)) {
					if(Pair.left.type == Item.TYPE.NORMAL) {
						if(!FILE.isExistence(toPlain(Pair.left.address))) {
							break;
						}
					}
					
					if(CItems.length == j) {
						CItems.length = CItems.length + StaticData.loopPlus;
					}
					
					CITEM CItem;
					CItem.item     = Pair.left;
					CItem.icon     = Pair.right;
					CItem.type     = flagToType(FlagCase.flag);
					CItem.ShowName = FlagCase.text;
					
					CItem.Hit.left  = Match.pre.length;
					CItem.Hit.right = Match.pre.length + Match.hit.length;
					assert(Match.hit.length == CItem.Hit.right-CItem.Hit.left);
					
					CItems[j++] = CItem;
					break;
				}
			}
			
		} while(++i < Pairs.length);

		if(j && CItems.length > j) {
			CItems.length = j;
		} else if(!j) {
			delete CItems;
		}

		return CItems;
	}
	CITEM[] findPlain(in Text Pattern) {
		return find(Text("^%s", Pattern.text), false, FLAGS.ALL);
	}
	debug(items) unittest {
		auto isr=ISR;
		scope _=new DTimer;
		auto aa=isr.find(Text("[1-4]+"), true, FLAGS.ID | FLAGS.NAME);
		foreach(a; aa){
			wl("%s [%s]", a.ShowName.toString, a.ShowName[a.Hit.left .. a.Hit.right].toString);
		}
		aa=isr.findPlain(Text("i"));
		foreach(a; aa){
			//wl(a.ShowName.toString);
		}
	}
}

